/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.views;

import com.aptana.scripting.model.EnvironmentElement;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.scripting.ui.views.BaseNode;
import com.aptana.scripting.ui.views.IPropertyInformation;
import com.aptana.scripting.ui.views.Messages;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

class EnvNode
extends BaseNode<Property> {
    private static final Image ENV_ICON = ScriptingUIPlugin.getImage("icons/template.png");
    private EnvironmentElement env;

    EnvNode(EnvironmentElement env) {
        this.env = env;
    }

    @Override
    public Image getImage() {
        return ENV_ICON;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    @Override
    public String getLabel() {
        return this.env.getDisplayName();
    }

    static enum Property implements IPropertyInformation<EnvNode>
    {
        NAME(Messages.EnvNode_Env_Name){

            @Override
            public Object getPropertyValue(EnvNode node) {
                return node.env.getDisplayName();
            }
        }
        ,
        PATH(Messages.EnvNode_Env_Path){

            @Override
            public Object getPropertyValue(EnvNode node) {
                return node.env.getPath();
            }
        }
        ,
        SCOPE(Messages.EnvNode_Env_Scope){

            @Override
            public Object getPropertyValue(EnvNode node) {
                String scope = node.env.getScope();
                return scope != null && scope.length() > 0 ? scope : Messages.EnvNode_All_Scopes;
            }
        };

        private String header;

        private Property(String header) {
            this.header = header;
        }

        @Override
        public String getHeader() {
            return this.header;
        }
    }
}

