/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.views;

import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.scripting.ui.views.BaseNode;
import com.aptana.scripting.ui.views.BuildPathsNode;
import com.aptana.scripting.ui.views.CommandsNode;
import com.aptana.scripting.ui.views.EnvsNode;
import com.aptana.scripting.ui.views.FileTemplatesNode;
import com.aptana.scripting.ui.views.IPropertyInformation;
import com.aptana.scripting.ui.views.MenusNode;
import com.aptana.scripting.ui.views.Messages;
import com.aptana.scripting.ui.views.ProjectSamplesNode;
import com.aptana.scripting.ui.views.ProjectTemplatesNode;
import com.aptana.scripting.ui.views.SnippetCategoriesNode;
import com.aptana.scripting.ui.views.SnippetsNode;
import java.io.File;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

class BundleNode
extends BaseNode<Property> {
    private static final Image BUNDLE_ICON = ScriptingUIPlugin.getImage("icons/bundle_directory.png");
    private BundleElement bundle;

    BundleNode(BundleElement bundle) {
        this.bundle = bundle;
    }

    private void addNode(List<Object> items, BaseNode<?> node) {
        if (node != null && node.hasChildren()) {
            items.add(node);
        }
    }

    @Override
    public Object[] getChildren() {
        LinkedList<Object> items = new LinkedList<Object>();
        this.addNode(items, new CommandsNode(this.bundle));
        this.addNode(items, new SnippetsNode(this.bundle));
        this.addNode(items, new SnippetCategoriesNode(this.bundle));
        this.addNode(items, new FileTemplatesNode(this.bundle));
        this.addNode(items, new MenusNode(this.bundle));
        this.addNode(items, new BuildPathsNode(this.bundle));
        this.addNode(items, new EnvsNode(this.bundle));
        this.addNode(items, new ProjectTemplatesNode(this.bundle));
        this.addNode(items, new ProjectSamplesNode(this.bundle));
        return items.toArray(new Object[items.size()]);
    }

    @Override
    public Image getImage() {
        return BUNDLE_ICON;
    }

    @Override
    public String getLabel() {
        File file = new File(this.bundle.getPath());
        return file.getAbsolutePath();
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    @Override
    public boolean hasChildren() {
        return this.bundle.hasChildren();
    }

    static enum Property implements IPropertyInformation<BundleNode>
    {
        NAME(Messages.BundleNode_Bundle_Name){

            @Override
            public Object getPropertyValue(BundleNode node) {
                return node.bundle.getDisplayName();
            }
        }
        ,
        PATH(Messages.BundleNode_Bundle_Path){

            @Override
            public Object getPropertyValue(BundleNode node) {
                return node.bundle.getPath();
            }
        }
        ,
        VISIBLE(Messages.BundleNode_Bundle_Visible){

            @Override
            public Object getPropertyValue(BundleNode node) {
                return node.bundle.isVisible();
            }
        }
        ,
        REFERENCE(Messages.BundleNode_Bundle_Reference){

            @Override
            public Object getPropertyValue(BundleNode node) {
                return node.bundle.isReference();
            }
        }
        ,
        PRECEDENCE(Messages.BundleNode_Bundle_Precedence){

            @Override
            public Object getPropertyValue(BundleNode node) {
                return node.bundle.getBundlePrecedence();
            }
        }
        ,
        AUTHOR(Messages.BundleNode_Bundle_Author){

            @Override
            public Object getPropertyValue(BundleNode node) {
                return node.bundle.getAuthor();
            }
        }
        ,
        COPYRIGHT(Messages.BundleNode_Bundle_Copyright){

            @Override
            public Object getPropertyValue(BundleNode node) {
                return node.bundle.getCopyright();
            }
        }
        ,
        DESCRIPTION(Messages.BundleNode_Bundle_Description){

            @Override
            public Object getPropertyValue(BundleNode node) {
                return node.bundle.getDescription();
            }
        }
        ,
        LICENSE(Messages.BundleNode_Bundle_License){

            @Override
            public Object getPropertyValue(BundleNode node) {
                return node.bundle.getLicense();
            }
        }
        ,
        LICENSE_URL(Messages.BundleNode_Bundle_License_URL){

            @Override
            public Object getPropertyValue(BundleNode node) {
                return node.bundle.getLicenseUrl();
            }
        }
        ,
        REPOSITORY(Messages.BundleNode_Bundle_Repository){

            @Override
            public Object getPropertyValue(BundleNode node) {
                return node.bundle.getRepository();
            }
        };

        private String header;

        private Property(String header) {
            this.header = header;
        }

        @Override
        public String getHeader() {
            return this.header;
        }
    }
}

