/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.scripting.ScriptLogger;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.Messages;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.ParseException;

public class KeyBindingUtil {
    private static final KeySequence[] NO_BINDINGS = new KeySequence[0];
    private static final Pattern CONTROL_PLUS = Pattern.compile("control" + Pattern.quote("+"), 2);
    private static final String CTRL_PLUS = Matcher.quoteReplacement("CTRL+");
    private static final Pattern OPTION_PLUS = Pattern.compile("option" + Pattern.quote("+"), 2);
    private static final String ALT_PLUS = Matcher.quoteReplacement("ALT+");

    public static KeySequence[] getKeySequences(CommandElement command) {
        Object[] bindings = command.getKeyBindings();
        if (ArrayUtil.isEmpty((Object[])bindings)) {
            return NO_BINDINGS;
        }
        ArrayList<KeySequence> result = new ArrayList<KeySequence>(bindings.length);
        Object[] objectArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            Object binding = objectArray[n2];
            try {
                String normalizedKeyBinding = KeyBindingUtil.normalizeKeyBinding((String)binding);
                KeySequence sequence = KeySequence.getInstance((String)normalizedKeyBinding);
                result.add(sequence);
            }
            catch (ParseException e) {
                String message = MessageFormat.format(Messages.CommandElement_Invalid_Key_Binding, binding, command.getDisplayName(), command.getPath(), e.getMessage());
                ScriptLogger.logError((String)message);
                IdeLog.logError((Plugin)ScriptingUIPlugin.getDefault(), (String)message);
            }
            ++n2;
        }
        return result.toArray(new KeySequence[result.size()]);
    }

    private static String normalizeKeyBinding(String keyBinding) {
        String result = null;
        if (keyBinding != null) {
            result = CONTROL_PLUS.matcher(keyBinding).replaceAll(CTRL_PLUS);
            result = OPTION_PLUS.matcher(result).replaceAll(ALT_PLUS);
        }
        return result;
    }
}

