/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.sass.contentassist;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.css.contentassist.CSSContentAssistProcessor;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class SassContentassistProcessor
extends CSSContentAssistProcessor {
    private static final String[] SASS_CHARS = new String[]{"-", "@"};
    private static final String[] LESS_CHARS = new String[]{"-", "@"};
    private boolean isSass = false;
    private static final Set<String> SASS_KEYWORDS_SET = new HashSet<String>();

    static {
        SASS_KEYWORDS_SET.add("@extend");
        SASS_KEYWORDS_SET.add("@import");
        SASS_KEYWORDS_SET.add("@mixin");
        SASS_KEYWORDS_SET.add("@include");
        SASS_KEYWORDS_SET.add("@charset");
        SASS_KEYWORDS_SET.add("@media");
        SASS_KEYWORDS_SET.add("@page");
        SASS_KEYWORDS_SET.add("@font-face");
        SASS_KEYWORDS_SET.add("@namespace");
        SASS_KEYWORDS_SET.add("@for");
        SASS_KEYWORDS_SET.add("@function");
        SASS_KEYWORDS_SET.add("@return");
    }

    public SassContentassistProcessor(AbstractThemeableEditor editor) {
        super(editor);
    }

    protected ICompletionProposal[] doComputeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        this.isSass = false;
        ICompletionProposal[] result = null;
        try {
            String fileName = this.getFilename();
            fileName = StringUtil.isNotBlank((String)fileName) ? fileName.toLowerCase() : "";
            if (fileName.endsWith(".sass") || fileName.endsWith(".scss")) {
                this.isSass = true;
            }
            IDocument document = viewer.getDocument();
            if (fileName.endsWith(".sass")) {
                return this.computeWordCompletionProposals(offset, PROPERTY_ICON, SASS_CHARS);
            }
            if (fileName.endsWith(".scss") && this.needComputeWord(offset, SASS_CHARS, activationChar, document, new String[]{"$", "@"})) {
                return this.computeWordCompletionProposals(offset, PROPERTY_ICON, SASS_CHARS);
            }
            if (fileName.endsWith(".less") && this.needComputeWord(offset, LESS_CHARS, activationChar, document, new String[]{"$", "@"})) {
                return this.computeWordCompletionProposals(offset, PROPERTY_ICON, LESS_CHARS);
            }
            result = super.doComputeCompletionProposals(viewer, offset, activationChar, autoActivated);
            if (result == null || result.length < 1) {
                result = this.computeWordCompletionProposals(offset, PROPERTY_ICON, SASS_CHARS);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private boolean needComputeWord(int offset, String[] chars, char activationChar, IDocument document, String[] specChar) {
        if (StringUtil.contains((String[])specChar, (String)String.valueOf(activationChar))) {
            return true;
        }
        String prefix = this.getWordPrefix(offset, chars, document);
        if (StringUtil.isNotBlank((String)prefix)) {
            String[] stringArray = specChar;
            int n = specChar.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if (prefix.startsWith(str)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected IRange getLexemeRange(IDocument document, int offset) {
        int endOffset;
        int startOffset;
        block9: {
            startOffset = 0;
            try {
                int testOffset = document.get(0, offset).lastIndexOf(125, offset);
                startOffset = testOffset < 0 ? 0 : testOffset + 1;
            }
            catch (BadLocationException badLocationException) {}
            endOffset = offset;
            try {
                ITypedRegion region = document.getPartition(offset);
                if (region == null) break block9;
                if (region.getType().equals("__css_multiline_comment") || region.getType().equals("__sass_multiline_comment")) {
                    return new Range(region.getOffset(), region.getOffset() + region.getLength());
                }
                String sassPrefix = "__sass_";
                String cssPrefix = "__css_";
                String defaultType = "__dftl_partition_content_type";
                if (!(region.getType().startsWith(cssPrefix) || region.getType().startsWith(sassPrefix) || region.getType().equals(defaultType))) {
                    region = document.getPartition(offset - 1);
                }
                if (region.getType().startsWith(cssPrefix) || region.getType().startsWith(sassPrefix) || region.getType().equals(defaultType)) {
                    ITypedRegion nextRegion;
                    String type;
                    int start = region.getOffset() - 1;
                    if (!(start <= 0 || (type = document.getContentType(start)) != null && (type.equals(defaultType) || type.startsWith(cssPrefix) || type.startsWith(sassPrefix)))) {
                        startOffset = region.getOffset();
                    }
                    if (document.get(region.getOffset(), region.getLength()).trim().endsWith(":") && (nextRegion = document.getPartition(region.getOffset() + region.getLength())) != null) {
                        region = nextRegion;
                    }
                    endOffset = Math.max(startOffset, region.getOffset() + region.getLength() - 1);
                    break block9;
                }
                return null;
            }
            catch (BadLocationException badLocationException) {}
        }
        return new Range(startOffset, endOffset);
    }

    protected Set<String> computeSpecialWords() {
        if (this.isSass) {
            return SASS_KEYWORDS_SET;
        }
        return Collections.emptySet();
    }

    protected String getPreferenceNodeQualifier() {
        return "com.aptana.editor.sass";
    }
}

