/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.OpenSearchDialogAction;
import org.eclipse.search.internal.ui.ScopePart;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPageDescriptor;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search.internal.ui.util.ExtendedDialogWindow;
import org.eclipse.search.ui.IReplacePage;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.part.MultiPageEditorPart;

public class SearchDialog
extends ExtendedDialogWindow
implements ISearchPageContainer,
IPageChangeProvider {
    private static final int SEARCH_ID = 1025;
    private static final int REPLACE_ID = 1026;
    private static final int CUSTOMIZE_ID = 1027;
    private ISearchPage fCurrentPage;
    private String fInitialPageId;
    private int fCurrentIndex;
    private List fDescriptors;
    private Point fMinSize;
    private ScopePart[] fScopeParts;
    private boolean fLastEnableState;
    private Button fCustomizeButton;
    private Button fReplaceButton;
    private ListenerList fPageChangeListeners;
    private final IWorkbenchWindow fWorkbenchWindow;
    private ISelection fCurrentSelection;
    private final String[] fCurrentEnclosingProject;
    private String searchType;
    private String searchText;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SearchDialog(IWorkbenchWindow window, String pageId) {
        super(window.getShell());
        this.fWorkbenchWindow = window;
        this.fCurrentSelection = window.getSelectionService().getSelection();
        this.fCurrentEnclosingProject = SearchDialog.evaluateEnclosingProject(this.fCurrentSelection, this.getActiveEditor());
        this.fDescriptors = this.filterByActivities(SearchPlugin.getDefault().getEnabledSearchPageDescriptors(pageId));
        this.fInitialPageId = pageId;
        this.fPageChangeListeners = null;
        this.setUseEmbeddedProgressMonitorPart(false);
        this.setShellStyle(this.getShellStyle() ^ 0x10000);
    }

    public SearchDialog(IWorkbenchWindow window, String pageId, String searchType, String searchText) {
        this(window, pageId);
        this.searchType = searchType;
        this.searchText = searchText;
        if (this.searchText != null && this.searchText != "") {
            this.fCurrentSelection = new TextSelection((IDocument)new Document(searchText), 0, searchText.length());
        }
    }

    public static String evaluateEnclosingProject(IAdaptable adaptable) {
        IProject project;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((project = (IProject)adaptable.getAdapter((Class)clazz)) == null) {
            IResource resource;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)adaptable.getAdapter((Class)clazz2)) != null) {
                project = resource.getProject();
            }
        }
        if (project != null && project.isAccessible()) {
            return project.getName();
        }
        return null;
    }

    public static String[] evaluateEnclosingProject(ISelection selection, IEditorPart activeEditor) {
        if (activeEditor != null) {
            String name = SearchDialog.evaluateEnclosingProject((IAdaptable)activeEditor.getEditorInput());
            if (name != null) {
                return new String[]{name};
            }
        } else if (selection instanceof IStructuredSelection) {
            HashSet<String> res = new HashSet<String>();
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                String name;
                Object curr = iter.next();
                if (curr instanceof IWorkingSet) {
                    int i;
                    IWorkingSet workingSet = (IWorkingSet)curr;
                    if (workingSet.isAggregateWorkingSet() && workingSet.isEmpty()) {
                        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        i = 0;
                        while (i < projects.length) {
                            IProject proj = projects[i];
                            if (proj.isOpen()) {
                                res.add(proj.getName());
                            }
                            ++i;
                        }
                        continue;
                    }
                    IAdaptable[] elements = workingSet.getElements();
                    i = 0;
                    while (i < elements.length) {
                        String name2 = SearchDialog.evaluateEnclosingProject(elements[i]);
                        if (name2 != null) {
                            res.add(name2);
                        }
                        ++i;
                    }
                    continue;
                }
                if (!(curr instanceof IAdaptable) || (name = SearchDialog.evaluateEnclosingProject((IAdaptable)curr)) == null) continue;
                res.add(name);
            }
            if (!res.isEmpty()) {
                return res.toArray(new String[res.size()]);
            }
        }
        return new String[0];
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return SearchPlugin.getDefault().getDialogSettingsSection("DialogBounds_SearchDialog");
    }

    protected Point getInitialSize() {
        Point requiredSize = this.getShell().computeSize(-1, -1, true);
        Point lastSize = super.getInitialSize();
        if (requiredSize.x > lastSize.x || requiredSize.y > lastSize.y) {
            return requiredSize;
        }
        return lastSize;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(SearchMessages.SearchDialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.search.search_dialog_context");
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.fWorkbenchWindow;
    }

    public ISelection getSelection() {
        return this.fCurrentSelection;
    }

    public IEditorPart getActiveEditor() {
        IWorkbenchPage activePage = this.fWorkbenchWindow.getActivePage();
        if (activePage != null) {
            IEditorPart activeEditor = activePage.getActiveEditor();
            if ("1".equals(this.searchType)) {
                return activeEditor;
            }
            IWorkbenchPart activePart = activePage.getActivePart();
            if (activeEditor == activePart || SearchDialog.isOldSearchView(activePart)) {
                return activeEditor;
            }
        }
        return null;
    }

    private static boolean isOldSearchView(IWorkbenchPart part) {
        return "org.eclipse.search.SearchResultView".equals(part.getSite().getId());
    }

    public void create() {
        super.create();
        if (this.fCurrentPage != null) {
            this.fCurrentPage.setVisible(true);
        }
    }

    private void handleCustomizePressed() {
        List input = SearchPlugin.getDefault().getSearchPageDescriptors();
        input = this.filterByActivities(input);
        final ArrayList createdImages = new ArrayList(input.size());
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof SearchPageDescriptor) {
                    return LegacyActionTools.removeMnemonics((String)((SearchPageDescriptor)element).getLabel());
                }
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof SearchPageDescriptor) {
                    ImageDescriptor imageDesc = ((SearchPageDescriptor)element).getImage();
                    if (imageDesc == null) {
                        return null;
                    }
                    Image image = imageDesc.createImage();
                    if (image != null) {
                        createdImages.add(image);
                    }
                    return image;
                }
                return null;
            }
        };
        String message = SearchMessages.SearchPageSelectionDialog_message;
        ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), input, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)labelProvider, message){

            public void create() {
                super.create();
                CheckboxTableViewer viewer = this.getViewer();
                Button okButton = this.getOkButton();
                viewer.addCheckStateListener(new ICheckStateListener(this, okButton, viewer){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ Button val$okButton;
                    private final /* synthetic */ CheckboxTableViewer val$viewer;
                    {
                        this.this$1 = var1_1;
                        this.val$okButton = button;
                        this.val$viewer = checkboxTableViewer;
                    }

                    public void checkStateChanged(CheckStateChangedEvent event) {
                        this.val$okButton.setEnabled(this.val$viewer.getCheckedElements().length > 0);
                    }
                });
                SelectionAdapter listener = new SelectionAdapter(this, okButton, viewer){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ Button val$okButton;
                    private final /* synthetic */ CheckboxTableViewer val$viewer;
                    {
                        this.this$1 = var1_1;
                        this.val$okButton = button;
                        this.val$viewer = checkboxTableViewer;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.val$okButton.setEnabled(this.val$viewer.getCheckedElements().length > 0);
                    }
                };
                this.getButton(18).addSelectionListener((SelectionListener)listener);
                this.getButton(19).addSelectionListener((SelectionListener)listener);
            }
        };
        dialog.setTitle(SearchMessages.SearchPageSelectionDialog_title);
        dialog.setInitialSelections(SearchPlugin.getDefault().getEnabledSearchPageDescriptors(this.fInitialPageId).toArray());
        if (dialog.open() == 0) {
            SearchPageDescriptor.setEnabled(dialog.getResult());
            Display display = this.getShell().getDisplay();
            this.close();
            if (display != null && !display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        new OpenSearchDialogAction().run();
                    }
                });
            }
        }
        this.destroyImages(createdImages);
    }

    private List filterByActivities(List input) {
        ArrayList<SearchPageDescriptor> filteredList = new ArrayList<SearchPageDescriptor>(input.size());
        Iterator descriptors = input.iterator();
        while (descriptors.hasNext()) {
            SearchPageDescriptor descriptor = (SearchPageDescriptor)descriptors.next();
            if (WorkbenchActivityHelper.filterItem((Object)descriptor)) continue;
            filteredList.add(descriptor);
        }
        return filteredList;
    }

    private void destroyImages(List images) {
        Iterator iter = images.iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            if (image == null || image.isDisposed()) continue;
            image.dispose();
        }
    }

    protected Control createPageArea(Composite parent) {
        int numPages = this.fDescriptors.size();
        this.fScopeParts = new ScopePart[numPages];
        if (numPages == 0) {
            Label label = new Label(parent, 0x1000040);
            label.setText(SearchMessages.SearchDialog_noSearchExtension);
            return label;
        }
        this.fCurrentIndex = this.getPreferredPageIndex();
        SearchPageDescriptor currentDesc = this.getDescriptorAt(this.fCurrentIndex);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(4, 4, true, true));
        folder.setFont(composite.getFont());
        int i = 0;
        while (i < numPages) {
            SearchPageDescriptor descriptor = this.getDescriptorAt(i);
            if (!WorkbenchActivityHelper.filterItem((Object)descriptor)) {
                final TabItem item = new TabItem(folder, 0);
                item.setData("descriptor", (Object)descriptor);
                item.setText(descriptor.getLabel());
                item.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        item.setData("descriptor", null);
                        if (item.getImage() != null) {
                            item.getImage().dispose();
                        }
                    }
                });
                ImageDescriptor imageDesc = descriptor.getImage();
                if (imageDesc != null) {
                    item.setImage(imageDesc.createImage());
                }
                if (i == this.fCurrentIndex) {
                    Control pageControl = this.createPageControl((Composite)folder, descriptor);
                    pageControl.setLayoutData((Object)new GridData(4, 4, true, true));
                    item.setControl(pageControl);
                    this.fCurrentPage = currentDesc.getPage();
                }
            }
            ++i;
        }
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SearchDialog.this.turnToPage(event);
            }
        });
        folder.setSelection(this.fCurrentIndex);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        if (this.isHelpAvailable()) {
            this.createHelpControl(composite);
        }
        this.fCustomizeButton = this.createButton(composite, 1027, SearchMessages.SearchDialog_customize, true);
        Label filler = new Label(composite, 0);
        filler.setLayoutData((Object)new GridData(768));
        ++layout.numColumns;
        this.fReplaceButton = this.createActionButton(composite, 1026, SearchMessages.SearchDialog_replaceAction, true);
        this.fReplaceButton.setVisible(this.fCurrentPage instanceof IReplacePage);
        Button searchButton = this.createActionButton(composite, 1025, SearchMessages.SearchDialog_searchAction, true);
        searchButton.setEnabled(this.fDescriptors.size() > 0);
        super.createButtonsForButtonBar(composite);
        return composite;
    }

    protected boolean performAction(int actionID) {
        switch (actionID) {
            case 1027: {
                this.handleCustomizePressed();
                return false;
            }
            case 1: {
                return true;
            }
            case 1025: {
                if (this.fCurrentPage != null) {
                    return this.fCurrentPage.performAction();
                }
                return true;
            }
            case 1026: {
                boolean isAutoBuilding = SearchPlugin.setAutoBuilding(false);
                try {
                    this.fCustomizeButton.setEnabled(false);
                    boolean bl = ((IReplacePage)((Object)this.fCurrentPage)).performReplace();
                    return bl;
                }
                finally {
                    this.fCustomizeButton.setEnabled(true);
                    SearchPlugin.setAutoBuilding(isAutoBuilding);
                }
            }
        }
        return false;
    }

    private SearchPageDescriptor getDescriptorAt(int index) {
        return (SearchPageDescriptor)this.fDescriptors.get(index);
    }

    private Point getMinSize() {
        if (this.fMinSize != null) {
            return this.fMinSize;
        }
        int x = 0;
        int y = 0;
        int length = this.fDescriptors.size();
        int i = 0;
        while (i < length) {
            Point size = this.getDescriptorAt(i).getPreferredSize();
            if (size.x != -1) {
                x = Math.max(x, size.x);
            }
            if (size.y != -1) {
                y = Math.max(y, size.y);
            }
            ++i;
        }
        this.fMinSize = new Point(x, y);
        return this.fMinSize;
    }

    private void turnToPage(SelectionEvent event) {
        Control pageControl;
        TabItem item = (TabItem)event.item;
        TabFolder folder = item.getParent();
        SearchPageDescriptor descriptor = (SearchPageDescriptor)item.getData("descriptor");
        if (item.getControl() == null) {
            item.setControl(this.createPageControl((Composite)folder, descriptor));
        }
        Control oldControl = folder.getItem(this.fCurrentIndex).getControl();
        Point oldSize = oldControl.getSize();
        Control newControl = item.getControl();
        Point newSize = newControl.computeSize(-1, -1, true);
        this.resizeDialogIfNeeded(oldSize, newSize);
        ISearchPage oldPage = this.fCurrentPage;
        if (oldPage != null) {
            oldPage.setVisible(false);
        }
        this.fCurrentPage = descriptor.getPage();
        this.fCurrentIndex = folder.getSelectionIndex();
        this.setPerformActionEnabled(this.fCurrentPage != null);
        if (this.fCurrentPage != null) {
            this.fCurrentPage.setVisible(true);
        }
        if ((pageControl = this.fCurrentPage.getControl()) instanceof Composite) {
            ((Composite)pageControl).layout(false, true);
        }
        this.fReplaceButton.setVisible(this.fCurrentPage instanceof IReplacePage);
        this.notifyPageChanged();
    }

    private int getPreferredPageIndex() {
        Object element = null;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            element = ((IStructuredSelection)selection).getFirstElement();
        }
        if (element == null) {
            element = this.getActiveEditorInput();
        }
        int result = 0;
        int level = 0;
        int size = this.fDescriptors.size();
        int i = 0;
        while (i < size) {
            SearchPageDescriptor descriptor = (SearchPageDescriptor)this.fDescriptors.get(i);
            if (this.fInitialPageId != null && this.fInitialPageId.equals(descriptor.getId())) {
                return i;
            }
            int newLevel = descriptor.computeScore(element);
            if (newLevel > level) {
                level = newLevel;
                result = i;
            }
            ++i;
        }
        return result;
    }

    public IRunnableContext getRunnableContext() {
        return this;
    }

    public int getSelectedScope() {
        if (this.fScopeParts[this.fCurrentIndex] == null) {
            return 0;
        }
        return this.fScopeParts[this.fCurrentIndex].getSelectedScope();
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        if (this.fScopeParts[this.fCurrentIndex] == null) {
            return null;
        }
        return this.fScopeParts[this.fCurrentIndex].getSelectedWorkingSets();
    }

    public String[] getEnclosingProjectNames() {
        return this.fCurrentEnclosingProject;
    }

    public String[] getSelectedProjectNames() {
        if (this.getSelectedScope() == 3) {
            return this.getEnclosingProjectNames();
        }
        return null;
    }

    public void setSelectedScope(int scope) {
        if (this.fScopeParts[this.fCurrentIndex] != null) {
            this.fScopeParts[this.fCurrentIndex].setSelectedScope(scope);
        }
    }

    public void setActiveEditorCanProvideScopeSelection(boolean state) {
        if (this.fScopeParts[this.fCurrentIndex] != null) {
            this.fScopeParts[this.fCurrentIndex].setActiveEditorCanProvideScopeSelection(state);
        }
    }

    public IEditorInput getActiveEditorInput() {
        IEditorPart editor = this.getActiveEditor();
        if (editor == null) {
            return null;
        }
        if (editor instanceof MultiPageEditorPart) {
            Object page = ((MultiPageEditorPart)editor).getSelectedPage();
            if (page instanceof IEditorPart) {
                editor = (IEditorPart)page;
            } else {
                return null;
            }
        }
        return editor.getEditorInput();
    }

    public boolean hasValidScope() {
        return this.getSelectedScope() != 2 || this.getSelectedWorkingSets() != null;
    }

    public void setSelectedWorkingSets(IWorkingSet[] workingSets) {
        if (this.fScopeParts[this.fCurrentIndex] != null) {
            this.fScopeParts[this.fCurrentIndex].setSelectedWorkingSets(workingSets);
        }
    }

    public void setPerformActionEnabled(boolean state) {
        this.fLastEnableState = state;
        super.setPerformActionEnabled(state && this.hasValidScope());
    }

    public void notifyScopeSelectionChanged() {
        this.setPerformActionEnabled(this.fLastEnableState);
    }

    private Control createPageControl(Composite parent, final SearchPageDescriptor descriptor) {
        final Composite pageWrapper = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageWrapper.setLayout((Layout)layout);
        SearchDialog.applyDialogFont((Control)pageWrapper);
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(this, descriptor, pageWrapper){
                    final /* synthetic */ 8 this$1;
                    private final /* synthetic */ SearchPageDescriptor val$descriptor;
                    private final /* synthetic */ Composite val$pageWrapper;
                    {
                        this.this$1 = var1_1;
                        this.val$descriptor = searchPageDescriptor;
                        this.val$pageWrapper = composite;
                    }

                    public void run() throws Exception {
                        ISearchPage page = this.val$descriptor.createObject(8.access$0(this.this$1));
                        if (page != null) {
                            page.createControl(this.val$pageWrapper);
                        }
                    }

                    public void handleException(Throwable ex) {
                        if (ex instanceof CoreException) {
                            ExceptionHandler.handle((CoreException)ex, 8.access$0(this.this$1).getShell(), SearchMessages.Search_Error_createSearchPage_title, Messages.format(SearchMessages.Search_Error_createSearchPage_message, this.val$descriptor.getLabel()));
                        } else {
                            ExceptionHandler.displayMessageDialog(ex, 8.access$0(this.this$1).getShell(), SearchMessages.Search_Error_createSearchPage_title, Messages.format(SearchMessages.Search_Error_createSearchPage_message, this.val$descriptor.getLabel()));
                        }
                    }
                });
            }

            static /* synthetic */ SearchDialog access$0(8 var0) {
                return var0.SearchDialog.this;
            }
        });
        ISearchPage page = descriptor.getPage();
        if (page == null || page.getControl() == null) {
            Composite container = new Composite(parent, 0);
            Label label = new Label(container, 64);
            label.setText(Messages.format(SearchMessages.SearchDialog_error_pageCreationFailed, descriptor.getLabel()));
            container.setLayout((Layout)new GridLayout());
            label.setLayoutData((Object)new GridData());
            return container;
        }
        page.getControl().setLayoutData((Object)new GridData(4, 1, true, false));
        boolean showScope = descriptor.showScopeSection();
        if (showScope) {
            Composite c = new Composite(pageWrapper, 0);
            c.setLayoutData((Object)new GridData(4, 1, true, false));
            c.setLayout((Layout)new GridLayout());
            int index = this.fDescriptors.indexOf(descriptor);
            this.fScopeParts[index] = new ScopePart(this, descriptor.canSearchInProjects());
            Composite part = this.fScopeParts[index].createPart(c);
            SearchDialog.applyDialogFont((Control)part);
            part.setLayoutData((Object)new GridData(4, 1, true, false));
            this.fScopeParts[index].setVisible(true);
        }
        return pageWrapper;
    }

    private void resizeDialogIfNeeded(Point oldSize, Point newSize) {
        if (oldSize == null || newSize == null) {
            return;
        }
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        if (this.mustResize(oldSize, newSize)) {
            if (newSize.x > oldSize.x) {
                shellSize.x += newSize.x - oldSize.x;
            }
            if (newSize.y > oldSize.y) {
                shellSize.y += newSize.y - oldSize.y;
            }
            shell.setSize(shellSize);
            shell.layout(true);
        }
    }

    private boolean mustResize(Point currentSize, Point newSize) {
        return currentSize.x < newSize.x || currentSize.y < newSize.y;
    }

    public boolean close() {
        int i = 0;
        while (i < this.fDescriptors.size()) {
            SearchPageDescriptor desc = (SearchPageDescriptor)this.fDescriptors.get(i);
            desc.dispose();
            ++i;
        }
        return super.close();
    }

    public Object getSelectedPage() {
        return this.fCurrentPage;
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        if (this.fPageChangeListeners == null) {
            this.fPageChangeListeners = new ListenerList();
        }
        this.fPageChangeListeners.add((Object)listener);
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        this.fPageChangeListeners.remove((Object)listener);
    }

    private void notifyPageChanged() {
        if (this.fPageChangeListeners != null && !this.fPageChangeListeners.isEmpty()) {
            final PageChangedEvent event = new PageChangedEvent((IPageChangeProvider)this, this.getSelectedPage());
            Object[] listeners = this.fPageChangeListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final IPageChangedListener l = (IPageChangedListener)listeners[i];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l.pageChanged(event);
                    }
                });
                ++i;
            }
        }
    }

    public int getScope() {
        if ("1".equals(this.searchType)) {
            return 4;
        }
        return -1;
    }

    private class TabFolderLayout
    extends Layout {
        private TabFolderLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            int x = 0;
            int y = 0;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Point size = children[i].computeSize(-1, -1, flushCache);
                x = Math.max(x, size.x);
                y = Math.max(y, size.y);
                ++i;
            }
            Point minSize = SearchDialog.this.getMinSize();
            x = Math.max(x, minSize.x);
            y = Math.max(y, minSize.y);
            if (wHint != -1) {
                x = wHint;
            }
            if (hHint != -1) {
                y = hHint;
            }
            return new Point(x, y);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle rect = composite.getClientArea();
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].setBounds(rect);
                ++i;
            }
        }
    }
}

