/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchDialog;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.WorkingSetComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class ScopePart {
    private static final String DIALOG_SETTINGS_KEY = "SearchDialog.ScopePart";
    private static final String STORE_SCOPE = "scope";
    private static final String STORE_LRU_WORKING_SET_NAME = "lastUsedWorkingSetName";
    private static final String STORE_LRU_WORKING_SET_NAMES = "lastUsedWorkingSetNames";
    private IDialogSettings fSettingsStore;
    private Group fPart;
    private Button fUseWorkspace;
    private Button fUseSelection;
    private Button fUseProject;
    private Button fUseCurrentEditor;
    private int fScope;
    private boolean fCanSearchEnclosingProjects;
    private IWorkingSet[] fWorkingSets;
    private SearchDialog fSearchDialog;
    private boolean fActiveEditorCanProvideScopeSelection;

    public ScopePart(SearchDialog searchDialog, boolean searchEnclosingProjects) {
        this.fSearchDialog = searchDialog;
        this.fCanSearchEnclosingProjects = searchEnclosingProjects;
        this.fSettingsStore = SearchPlugin.getDefault().getDialogSettingsSection(DIALOG_SETTINGS_KEY);
        int sc = searchDialog.getScope();
        this.fScope = sc != -1 ? sc : ScopePart.getStoredScope(this.fSettingsStore, searchEnclosingProjects);
        this.fWorkingSets = this.getStoredWorkingSets();
    }

    private static int getStoredScope(IDialogSettings settingsStore, boolean canSearchEnclosingProjects) {
        int scope;
        try {
            scope = settingsStore.getInt(STORE_SCOPE);
        }
        catch (NumberFormatException ex) {
            scope = 0;
        }
        if (scope != 2 && scope != 1 && scope != 3 && scope != 0 && scope != 4) {
            scope = 0;
        }
        if (!canSearchEnclosingProjects && scope == 3) {
            scope = 0;
        }
        return scope;
    }

    private IWorkingSet getWorkingSet(IWorkingSetManager workingSetManager, String storedName) {
        if (storedName.length() == 0) {
            IWorkbenchPage page = this.fSearchDialog.getWorkbenchWindow().getActivePage();
            if (page != null) {
                return page.getAggregateWorkingSet();
            }
            return null;
        }
        return workingSetManager.getWorkingSet(storedName);
    }

    private IWorkingSet[] getStoredWorkingSets() {
        String[] lruWorkingSetNames = this.fSettingsStore.getArray(STORE_LRU_WORKING_SET_NAMES);
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        if (lruWorkingSetNames != null) {
            HashSet<IWorkingSet> existingWorkingSets = new HashSet<IWorkingSet>(lruWorkingSetNames.length);
            int i = 0;
            while (i < lruWorkingSetNames.length) {
                IWorkingSet workingSet = this.getWorkingSet(workingSetManager, lruWorkingSetNames[i]);
                if (workingSet != null) {
                    existingWorkingSets.add(workingSet);
                }
                ++i;
            }
            if (!existingWorkingSets.isEmpty()) {
                return existingWorkingSets.toArray(new IWorkingSet[existingWorkingSets.size()]);
            }
        } else {
            IWorkingSet workingSet;
            String workingSetName = this.fSettingsStore.get(STORE_LRU_WORKING_SET_NAME);
            if (workingSetName != null && (workingSet = this.getWorkingSet(workingSetManager, workingSetName)) != null) {
                return new IWorkingSet[]{workingSet};
            }
        }
        return null;
    }

    public int getSelectedScope() {
        return this.fScope;
    }

    public void setSelectedScope(int scope) {
        Assert.isLegal((scope >= 0 && scope <= 4 ? 1 : 0) != 0);
        Assert.isNotNull((Object)this.fUseWorkspace);
        Assert.isNotNull((Object)this.fUseSelection);
        Assert.isNotNull((Object)this.fUseProject);
        Assert.isNotNull((Object)this.fUseCurrentEditor);
        this.fSettingsStore.put(STORE_SCOPE, scope);
        if (scope == 3) {
            if (!this.fCanSearchEnclosingProjects) {
                SearchPlugin.log((IStatus)new Status(2, "org.eclipse.search", 2, "Enclosing projects scope set on search page that does not support it", null));
                scope = 0;
            } else if (!this.fUseProject.isEnabled()) {
                scope = 0;
            }
        } else if (scope == 1 && !this.fUseSelection.isEnabled()) {
            scope = this.fUseProject.isEnabled() ? 3 : 0;
        }
        this.fScope = scope;
        this.fUseCurrentEditor.setSelection(scope == 4);
        this.fUseWorkspace.setSelection(scope == 0);
        this.fUseSelection.setSelection(scope == 1);
        this.fUseProject.setSelection(scope == 3);
        this.updateSearchPageContainerActionPerformedEnablement();
    }

    public void setActiveEditorCanProvideScopeSelection(boolean state) {
        this.fActiveEditorCanProvideScopeSelection = state;
        this.fUseSelection.setEnabled(this.canSearchInSelection());
        this.fScope = ScopePart.getStoredScope(this.fSettingsStore, this.fCanSearchEnclosingProjects);
        this.setSelectedScope(this.fScope);
    }

    private void updateSearchPageContainerActionPerformedEnablement() {
        this.fSearchDialog.notifyScopeSelectionChanged();
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        if (this.getSelectedScope() == 2) {
            return this.fWorkingSets;
        }
        return null;
    }

    public void setSelectedWorkingSets(IWorkingSet[] workingSets) {
        Assert.isNotNull((Object)workingSets);
        this.setSelectedScope(2);
        this.fWorkingSets = null;
        HashSet<IWorkingSet> existingWorkingSets = new HashSet<IWorkingSet>(workingSets.length);
        int i = 0;
        while (i < workingSets.length) {
            String name = workingSets[i].getName();
            IWorkingSet workingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(name);
            if (workingSet != null) {
                existingWorkingSets.add(workingSet);
            }
            ++i;
        }
        if (!existingWorkingSets.isEmpty()) {
            this.fWorkingSets = existingWorkingSets.toArray(new IWorkingSet[existingWorkingSets.size()]);
        }
        this.saveState();
    }

    private void saveState() {
        if (this.fWorkingSets != null && this.fWorkingSets.length > 0) {
            String[] existingWorkingSetNames = new String[this.fWorkingSets.length];
            int i = 0;
            while (i < this.fWorkingSets.length) {
                IWorkingSet curr = this.fWorkingSets[i];
                existingWorkingSetNames[i] = curr.isAggregateWorkingSet() ? "" : curr.getName();
                ++i;
            }
            this.fSettingsStore.put(STORE_LRU_WORKING_SET_NAMES, existingWorkingSetNames);
        }
    }

    public Composite createPart(Composite parent) {
        this.fPart = new Group(parent, 0);
        this.fPart.setText(SearchMessages.ScopePart_group_text);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.fPart.setLayout((Layout)layout);
        this.fPart.setLayoutData((Object)new GridData(768));
        this.fUseCurrentEditor = new Button((Composite)this.fPart, 16);
        this.fUseCurrentEditor.setData((Object)new Integer(4));
        this.fUseCurrentEditor.setText("\u5f53\u524d\u7f16\u8f91\u5668");
        this.fUseProject = new Button((Composite)this.fPart, 16);
        this.fUseProject.setData((Object)new Integer(3));
        this.fUseProject.setText(SearchMessages.ScopePart_enclosingProjectsScope_text);
        this.fUseProject.setEnabled(this.fSearchDialog.getEnclosingProjectNames().length > 0);
        GridData gd = new GridData(32);
        gd.horizontalIndent = 8;
        this.fUseProject.setLayoutData((Object)gd);
        if (!this.fCanSearchEnclosingProjects) {
            this.fUseProject.setVisible(false);
        }
        this.fUseSelection = new Button((Composite)this.fPart, 16);
        this.fUseSelection.setData((Object)new Integer(1));
        this.fUseSelection.setText(SearchMessages.ScopePart_selectedResourcesScope_text);
        boolean canSearchInSelection = this.canSearchInSelection();
        this.fUseSelection.setEnabled(canSearchInSelection);
        gd = new GridData(32);
        gd.horizontalIndent = 8;
        this.fUseSelection.setLayoutData((Object)gd);
        this.fUseWorkspace = new Button((Composite)this.fPart, 16);
        this.fUseWorkspace.setData((Object)new Integer(0));
        this.fUseWorkspace.setText(SearchMessages.ScopePart_workspaceScope_text);
        gd = new GridData(32);
        gd.horizontalIndent = 8;
        gd.widthHint = new PixelConverter((Control)this.fUseWorkspace).convertWidthInCharsToPixels(30);
        this.fUseWorkspace.setLayoutData((Object)gd);
        SelectionAdapter scopeChangedLister = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopePart.this.handleScopeChanged(e);
            }
        };
        this.fUseCurrentEditor.addSelectionListener((SelectionListener)scopeChangedLister);
        this.fUseWorkspace.addSelectionListener((SelectionListener)scopeChangedLister);
        this.fUseSelection.addSelectionListener((SelectionListener)scopeChangedLister);
        this.fUseProject.addSelectionListener((SelectionListener)scopeChangedLister);
        this.setSelectedScope(this.fScope);
        return this.fPart;
    }

    private boolean canSearchInSelection() {
        ISelection selection = this.fSearchDialog.getSelection();
        return selection instanceof IStructuredSelection && !selection.isEmpty() || this.fActiveEditorCanProvideScopeSelection && this.fSearchDialog.getActiveEditorInput() != null;
    }

    private void handleScopeChanged(SelectionEvent e) {
        Button button;
        Object source = e.getSource();
        if (source instanceof Button && (button = (Button)source).getSelection()) {
            this.setSelectedScope((Integer)button.getData());
        }
    }

    void setVisible(boolean state) {
        if (state) {
            this.fPart.layout();
        }
        this.fPart.setVisible(state);
    }

    public static String toString(IWorkingSet[] workingSets) {
        String result = "";
        if (workingSets != null && workingSets.length > 0) {
            Arrays.sort(workingSets, new WorkingSetComparator());
            boolean firstFound = false;
            int i = 0;
            while (i < workingSets.length) {
                String workingSetName = workingSets[i].getLabel();
                if (firstFound) {
                    result = Messages.format(SearchMessages.ScopePart_workingSetConcatenation, new String[]{result, workingSetName});
                } else {
                    result = workingSetName;
                    firstFound = true;
                }
                ++i;
            }
        }
        return result;
    }
}

