/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby.formatter;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.ruby.RubyEditorPlugin;
import com.aptana.editor.ruby.formatter.Messages;
import com.aptana.editor.ruby.formatter.RubyFormatterPlugin;
import com.aptana.editor.ruby.formatter.internal.RubyFormatterContext;
import com.aptana.editor.ruby.formatter.internal.RubyFormatterNodeBuilder;
import com.aptana.editor.ruby.formatter.internal.RubyFormatterNodeRewriter;
import com.aptana.formatter.AbstractScriptFormatter;
import com.aptana.formatter.FormatterDocument;
import com.aptana.formatter.FormatterIndentDetector;
import com.aptana.formatter.FormatterUtils;
import com.aptana.formatter.FormatterWriter;
import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.formatter.ui.FormatterException;
import com.aptana.formatter.ui.FormatterMessages;
import com.aptana.ruby.core.NullParserResult;
import com.aptana.ruby.core.RubySourceParser;
import com.aptana.ui.util.StatusLineMessageTimerManager;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jrubyparser.CompatVersion;
import org.jrubyparser.ast.CommentNode;
import org.jrubyparser.parser.ParserResult;

public class RubyFormatter
extends AbstractScriptFormatter {
    protected static final String[] INDENTING = new String[]{"ruby.formatter.indent.class", "ruby.formatter.indent.module", "ruby.formatter.indent.method", "ruby.formatter.indent.blocks", "ruby.formatter.indent.if", "ruby.formatter.indent.case", "ruby.formatter.indent.when"};
    protected static final String[] BLANK_LINES = new String[]{"ruby.formatter.line.file.require.after", "ruby.formatter.line.file.module.between", "ruby.formatter.line.file.class.between", "ruby.formatter.line.file.method.between", "ruby.formatter.line.first.before", "ruby.formatter.line.module.before", "ruby.formatter.line.class.before", "ruby.formatter.line.method.before"};

    public RubyFormatter(String lineSeparator, Map<String, String> preferences, String mainContentType) {
        super(preferences, mainContentType, lineSeparator);
    }

    public int detectIndentationLevel(IDocument document, int offset, boolean isSelection, IFormattingContext formattingContext) {
        try {
            ITypedRegion partition = document.getPartition(offset);
            if (partition != null && partition.getOffset() == offset) {
                return super.detectIndentationLevel(document, offset);
            }
            String source = document.get();
            RubySourceParser sourceParser = this.getSourceParser();
            ParserResult result = sourceParser.parse(source);
            if (!(result instanceof NullParserResult)) {
                RubyFormatterNodeBuilder builder = new RubyFormatterNodeBuilder();
                FormatterDocument fDocument = this.createDocument(source);
                IFormatterContainerNode root = builder.build(result, (IFormatterDocument)fDocument);
                new RubyFormatterNodeRewriter(result).rewrite(root);
                RubyFormatterContext context = new RubyFormatterContext(0);
                FormatterIndentDetector detector = new FormatterIndentDetector(offset);
                try {
                    root.accept((IFormatterContext)context, (IFormatterWriter)detector);
                    return detector.getLevel();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable t) {
            IdeLog.logError((Plugin)RubyFormatterPlugin.getDefault(), (Throwable)t, (String)"com.aptana.formatter.epl/debug");
        }
        return 0;
    }

    public int getIndentSize() {
        return this.getInt("ruby.formatter.formatter.indentation.size", 1);
    }

    public String getIndentType() {
        return this.getString("ruby.formatter.formatter.tabulation.char");
    }

    public int getTabSize() {
        return this.getInt("ruby.formatter.formatter.tabulation.size", this.getEditorSpecificTabWidth());
    }

    public int getEditorSpecificTabWidth() {
        return EditorUtil.getSpaceIndentSize((String)RubyEditorPlugin.getDefault().getBundle().getSymbolicName());
    }

    public boolean isEditorInsertSpacesForTabs() {
        return FormatterUtils.isInsertSpacesForTabs((IPreferenceStore)RubyEditorPlugin.getDefault().getPreferenceStore());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TextEdit format(String source, int offset, int length, int indent, boolean isSelection, IFormattingContext context, String indentSufix) throws FormatterException {
        String input = source.substring(offset, offset + length);
        if (this.isSlave()) {
            if (input.startsWith("<%=")) {
                input = input.substring(3);
                offset += 3;
                length -= 3;
            } else if (input.startsWith("<%")) {
                input = input.substring(2);
                offset += 2;
                length -= 2;
            }
            if (input.endsWith("%>")) {
                input = input.substring(0, input.length() - 2);
                length -= 2;
            }
            int toTrim = 0;
            int i = 0;
            while (i < input.length()) {
                char c = input.charAt(i);
                if (c != '\n' && c != '\r') break;
                ++toTrim;
                ++i;
            }
            if (toTrim > 0) {
                input = input.substring(toTrim);
                offset += toTrim;
                length -= toTrim;
            }
        }
        RubySourceParser sourceParser = this.getSourceParser();
        ParserResult result = sourceParser.parse(input);
        try {
            if (!(result instanceof NullParserResult)) {
                String output = this.format(input, result, indent, isSelection);
                if (output == null) return null;
                output = RubyFormatter.trimLeft(output);
                if (offset > 0) {
                    output = String.valueOf(' ') + output;
                }
                if (input.equals(output)) return new MultiTextEdit();
                if (!this.isValidation() || this.equalLinesIgnoreBlanks(new StringReader(input), new StringReader(output))) {
                    return new ReplaceEdit(offset, length, output);
                }
                this.logError(input, output);
                return null;
            } else {
                StatusLineMessageTimerManager.setErrorMessage((String)NLS.bind((String)FormatterMessages.Formatter_formatterParsingErrorStatus, (Object)Messages.RubyFormatter_rubyParserError), (long)3000L, (boolean)true);
            }
            return null;
        }
        catch (Throwable t) {
            StatusLineMessageTimerManager.setErrorMessage((String)FormatterMessages.Formatter_formatterErrorStatus, (long)3000L, (boolean)true);
            IdeLog.logError((Plugin)RubyFormatterPlugin.getDefault(), (Throwable)t, (String)"com.aptana.formatter.epl/debug");
        }
        return null;
    }

    private static String trimLeft(String output) {
        int offset = 0;
        while (offset < output.length()) {
            if (!Character.isWhitespace(output.charAt(offset))) break;
            ++offset;
        }
        if (offset != 0) {
            return output.substring(offset);
        }
        return output;
    }

    protected RubySourceParser getSourceParser() {
        return new RubySourceParser(CompatVersion.BOTH);
    }

    protected boolean isValidation() {
        return !this.getBoolean("ruby.formatter.wrap.comments");
    }

    private String format(String input, ParserResult result, int indent, boolean isSelection) throws Exception {
        int spacesCount = -1;
        if (isSelection) {
            spacesCount = RubyFormatter.countLeftWhitespaceChars((String)input);
        }
        RubyFormatterNodeBuilder builder = new RubyFormatterNodeBuilder();
        FormatterDocument document = this.createDocument(input);
        IFormatterContainerNode root = builder.build(result, (IFormatterDocument)document);
        new RubyFormatterNodeRewriter(result).rewrite(root);
        RubyFormatterContext context = new RubyFormatterContext(indent);
        FormatterWriter writer = new FormatterWriter((IFormatterDocument)document, this.lineSeparator, this.createIndentGenerator());
        writer.setWrapLength(this.getInt("ruby.formatter.wrap.comments.length"));
        writer.setLinesPreserve(this.getInt("ruby.formatter.lines.preserve"));
        root.accept((IFormatterContext)context, (IFormatterWriter)writer);
        writer.flush((IFormatterContext)context);
        String output = writer.getOutput();
        List offOnRegions = builder.getOffOnRegions();
        if (offOnRegions != null && !offOnRegions.isEmpty()) {
            List<IRegion> outputOnOffRegions = this.getOutputOnOffRegions(output, this.getString("ruby.formatter.formatter.off"), this.getString("ruby.formatter.formatter.on"), (IFormatterDocument)document);
            output = FormatterUtils.applyOffOnRegions((String)input, (String)output, (List)offOnRegions, outputOnOffRegions);
        }
        if (isSelection) {
            output = RubyFormatter.leftTrim((String)output, (int)spacesCount);
        }
        return output;
    }

    private FormatterDocument createDocument(String input) {
        String key;
        FormatterDocument document = new FormatterDocument(input);
        String[] stringArray = INDENTING;
        int n = INDENTING.length;
        int n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            document.setBoolean(key, this.getBoolean(key));
            ++n2;
        }
        stringArray = BLANK_LINES;
        n = BLANK_LINES.length;
        n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            document.setInt(key, this.getInt(key));
            ++n2;
        }
        document.setInt("ruby.formatter.formatter.tabulation.size", this.getInt("ruby.formatter.formatter.tabulation.size"));
        document.setBoolean("ruby.formatter.wrap.comments", this.getBoolean("ruby.formatter.wrap.comments"));
        document.setBoolean("ruby.formatter.formatter.on.off.enabled", this.getBoolean("ruby.formatter.formatter.on.off.enabled"));
        document.setString("ruby.formatter.formatter.on", this.getString("ruby.formatter.formatter.on"));
        document.setString("ruby.formatter.formatter.off", this.getString("ruby.formatter.formatter.off"));
        return document;
    }

    private List<IRegion> getOutputOnOffRegions(String output, String formatterOffPattern, String formatterOnPattern, IFormatterDocument document) {
        RubySourceParser sourceParser = this.getSourceParser();
        ParserResult result = sourceParser.parse(output);
        if (result != null && !(result instanceof NullParserResult)) {
            return RubyFormatter.collectOffOnRegions(result.getCommentNodes(), document);
        }
        return null;
    }

    public static List<IRegion> collectOffOnRegions(List<CommentNode> commentNodes, IFormatterDocument document) {
        if (!document.getBoolean("ruby.formatter.formatter.on.off.enabled") || commentNodes == null) {
            return null;
        }
        LinkedHashMap<Integer, String> commentsMap = new LinkedHashMap<Integer, String>(commentNodes.size());
        for (CommentNode comment : commentNodes) {
            int start = comment.getPosition().getStartOffset();
            commentsMap.put(start, comment.getContent());
        }
        if (!commentsMap.isEmpty()) {
            Pattern onPattern = Pattern.compile(Pattern.quote(document.getString("ruby.formatter.formatter.on")));
            Pattern offPattern = Pattern.compile(Pattern.quote(document.getString("ruby.formatter.formatter.off")));
            return FormatterUtils.resolveOnOffRegions(commentsMap, (Pattern)onPattern, (Pattern)offPattern, (int)(document.getLength() - 1));
        }
        return null;
    }
}

