/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.svg.parsing;

import com.aptana.editor.xml.parsing.XMLParser;
import com.aptana.editor.xml.parsing.ast.XMLElementNode;
import com.aptana.editor.xml.parsing.lexer.XMLTokenType;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;

public class SVGParser
extends XMLParser {
    private void advanceToCloseTag(String elementName) {
        String closeTagStart = "</" + elementName;
        int length = closeTagStart.length();
        try {
            this.advance();
            while (this.fCurrentLexeme.getType() != XMLTokenType.EOF) {
                char c;
                String text;
                if (this.fCurrentLexeme.getType() != XMLTokenType.END_TAG || !(text = this.fCurrentLexeme.getText()).startsWith(closeTagStart) || (c = text.charAt(length)) != '>' && !Character.isWhitespace(c)) {
                    this.advance();
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {}
    }

    private void processLanguage(String language, String elementName) {
        int startingOffset = this.fCurrentLexeme.getEndingOffset() + 1;
        this.advanceToCloseTag(elementName);
        int endingOffset = this.fCurrentLexeme.getStartingOffset() - 1;
        String source = this.getSource(startingOffset, endingOffset - startingOffset + 1);
        try {
            IParseRootNode result = ParserPoolFactory.parse((String)language, (String)source, (int)startingOffset).getRootNode();
            this.fCurrentElement.addChild((IParseNode)result);
        }
        catch (Exception exception) {}
        this.processEndTag();
    }

    protected void processStartTag() {
        XMLElementNode element;
        super.processStartTag();
        if (this.fCurrentElement instanceof XMLElementNode && !(element = (XMLElementNode)this.fCurrentElement).isSelfClosing()) {
            String elementName = element.getName();
            if ("script".equals(elementName)) {
                this.processLanguage("com.aptana.contenttype.js", elementName);
            } else if ("style".equals(elementName)) {
                this.processLanguage("com.aptana.contenttype.css", elementName);
            }
        }
    }
}

