/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.widgets;

import com.aptana.ui.UIPlugin;
import com.aptana.ui.widgets.Messages;
import java.util.regex.Pattern;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class SearchComposite
extends Composite {
    private static final String CASE_SENSITIVE_ICON_PATH = "icons/full/elcl16/casesensitive.png";
    private static final String REGULAR_EXPRESSION_ICON_PATH = "icons/full/elcl16/regularexpression.png";
    private static final String INITIAL_TEXT = Messages.SingleProjectView_InitialFileFilterText;
    private Text searchText;
    private ToolItem caseSensitiveMenuItem;
    private ToolItem regularExressionMenuItem;
    private boolean searchOnEnter = true;
    private String initialText = INITIAL_TEXT;
    private String lastSearch = "";
    private boolean lastCaseSensitiveState;
    private boolean lastRegularExpressionState;
    private Client client;

    public SearchComposite(Composite parent, Client client) {
        this(parent, 0, client);
    }

    public SearchComposite(Composite parent, int style, Client client) {
        this(parent, style, true, client);
    }

    public SearchComposite(Composite parent, int style, boolean showSearchIcon, Client client) {
        this(parent, style, showSearchIcon, true, client);
    }

    public SearchComposite(Composite parent, int style, boolean showSearchIcon, boolean showMenuItem, Client client) {
        super(parent, style);
        this.client = client;
        GridLayout searchGridLayout = new GridLayout(showMenuItem ? 2 : 1, false);
        searchGridLayout.marginWidth = 2;
        searchGridLayout.marginHeight = 0;
        this.setLayout((Layout)searchGridLayout);
        int searchTextStyle = 2436;
        if (showSearchIcon) {
            searchTextStyle |= 0x200;
        }
        this.searchText = new Text((Composite)this, searchTextStyle);
        this.searchText.setText(this.initialText);
        this.searchText.setToolTipText(Messages.SingleProjectView_Wildcard);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.widthHint = 225;
        this.searchText.setLayoutData((Object)layoutData);
        this.searchText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (SearchComposite.this.searchText.getText().length() == 0) {
                    SearchComposite.this.searchText.setText(SearchComposite.this.initialText);
                }
            }

            public void focusGained(FocusEvent e) {
                if (SearchComposite.this.searchText.getText().equals(SearchComposite.this.initialText)) {
                    SearchComposite.this.searchText.setText("");
                }
            }
        });
        this.searchText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (!e.doit) {
                    return;
                }
                if (SearchComposite.this.searchOnEnter && e.character == '\r') {
                    SearchComposite.this.searchText();
                    e.doit = false;
                }
            }
        });
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!SearchComposite.this.searchOnEnter) {
                    SearchComposite.this.searchText();
                }
            }
        });
        if (showMenuItem) {
            ToolBar toolbar = new ToolBar((Composite)this, 0);
            toolbar.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.caseSensitiveMenuItem = new ToolItem(toolbar, 32);
            this.caseSensitiveMenuItem.setImage(UIPlugin.getImage(CASE_SENSITIVE_ICON_PATH));
            this.caseSensitiveMenuItem.setToolTipText(Messages.SingleProjectView_CaseSensitive);
            this.caseSensitiveMenuItem.setSelection(this.lastCaseSensitiveState);
            this.caseSensitiveMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SearchComposite.this.searchText.setFocus();
                    if (!SearchComposite.this.searchOnEnter) {
                        SearchComposite.this.searchText();
                    }
                }
            });
            this.regularExressionMenuItem = new ToolItem(toolbar, 32);
            this.regularExressionMenuItem.setImage(UIPlugin.getImage(REGULAR_EXPRESSION_ICON_PATH));
            this.regularExressionMenuItem.setToolTipText(Messages.SingleProjectView_RegularExpression);
            this.regularExressionMenuItem.setSelection(this.lastRegularExpressionState);
            this.regularExressionMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SearchComposite.this.searchText.setFocus();
                    if (!SearchComposite.this.searchOnEnter) {
                        SearchComposite.this.searchText();
                    }
                }
            });
        }
    }

    public void setSearchOnEnter(boolean searchOnEnter) {
        this.searchOnEnter = searchOnEnter;
    }

    public void setInitialText(String initialText) {
        if (this.searchText.getText().equals(this.initialText)) {
            this.initialText = initialText;
            this.searchText.setText(initialText);
        }
        this.initialText = initialText;
    }

    public boolean setFocus() {
        return this.searchText.setFocus();
    }

    public Text getTextControl() {
        return this.searchText;
    }

    private void searchText() {
        String text = this.searchText.getText();
        if (this.initialText.equals(text)) {
            text = "";
        }
        if (this.client != null && (this.searchOnEnter || !text.equals(this.lastSearch) || this.caseSensitiveMenuItem != null && this.caseSensitiveMenuItem.getSelection() != this.lastCaseSensitiveState || this.regularExressionMenuItem != null && this.regularExressionMenuItem.getSelection() != this.lastRegularExpressionState)) {
            this.lastSearch = text;
            if (this.caseSensitiveMenuItem != null) {
                this.lastCaseSensitiveState = this.caseSensitiveMenuItem.getSelection();
            }
            if (this.regularExressionMenuItem != null) {
                this.lastRegularExpressionState = this.regularExressionMenuItem.getSelection();
            }
            this.client.search(text, this.lastCaseSensitiveState, this.lastRegularExpressionState);
        }
    }

    public Pattern createSearchPattern() {
        return PatternConstructor.createPattern((String)this.searchText.getText(), (boolean)this.lastCaseSensitiveState, (boolean)this.lastRegularExpressionState);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.searchText.setForeground(color);
    }

    public static interface Client {
        public void search(String var1, boolean var2, boolean var3);
    }
}

