/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.util;

import com.aptana.ui.util.UIUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class SWTUtils {
    private static final String SMALL_FONT = "com.aptana.ui.small_font";
    private static Color backgroundErrorColor;
    private static Color errorColor;
    private static ModifyListener modifyListener;

    static {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ColorRegistry cm = JFaceResources.getColorRegistry();
                RGB errorRGB = new RGB(255, 255, 180);
                cm.put("error", errorRGB);
                backgroundErrorColor = cm.get("error");
            }
        });
        errorColor = UIUtils.getDisplay().getSystemColor(3);
    }

    public static void centerAndPack(Shell shell, Shell parent) {
        SWTUtils.center(shell, parent);
        shell.pack();
    }

    public static void center(Shell shell, Shell parent) {
        Rectangle parentSize = parent.getBounds();
        Rectangle mySize = shell.getBounds();
        int locationX = (parentSize.width - mySize.width) / 2 + parentSize.x;
        int locationY = (parentSize.height - mySize.height) / 2 + parentSize.y;
        shell.setLocation(new Point(locationX, locationY));
    }

    public static Font getDefaultSmallFont() {
        Font small = JFaceResources.getFontRegistry().get(SMALL_FONT);
        if (small != null) {
            return small;
        }
        Font f = JFaceResources.getDefaultFont();
        FontData[] smaller = SWTUtils.resizeFont(f, -2);
        JFaceResources.getFontRegistry().put(SMALL_FONT, smaller);
        return JFaceResources.getFontRegistry().get(SMALL_FONT);
    }

    public static Image getImage(AbstractUIPlugin plugin, String path) {
        return SWTUtils.getImage(plugin.getBundle(), path);
    }

    public static Image getImage(Bundle bundle, String path) {
        String computedName;
        Image image;
        if (path.charAt(0) != '/') {
            path = "/" + path;
        }
        if ((image = JFaceResources.getImage((String)(computedName = String.valueOf(bundle.getSymbolicName()) + path))) != null) {
            return image;
        }
        ImageDescriptor id = AbstractUIPlugin.imageDescriptorFromPlugin((String)bundle.getSymbolicName(), (String)path);
        if (id != null) {
            JFaceResources.getImageRegistry().put(computedName, id);
            return JFaceResources.getImage((String)computedName);
        }
        return null;
    }

    public static FontData[] resizeFont(Font font, int size) {
        FontData[] datas;
        FontData[] fontDataArray = datas = font.getFontData();
        int n = datas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setHeight(data.getHeight() + size);
            ++n2;
        }
        return datas;
    }

    public static FontData[] resizeFont(FontData[] fontData, int size) {
        FontData[] fontDataArray = fontData;
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setHeight(data.getHeight() + size);
            ++n2;
        }
        return fontData;
    }

    public static FontData[] boldFont(Font font) {
        return SWTUtils.styleFont(font, 1);
    }

    public static FontData[] styleFont(Font font, int fontStyle) {
        FontData[] datas;
        FontData[] fontDataArray = datas = font.getFontData();
        int n = datas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setStyle(data.getStyle() | fontStyle);
            ++n2;
        }
        return datas;
    }

    public static FontData[] italicizedFont(Font font) {
        return SWTUtils.styleFont(font, 2);
    }

    public static Color getErrorColor() {
        return errorColor;
    }

    public static boolean validateCombo(Combo combo, int validSelectionIndex) {
        int selectionIndex = Math.max(validSelectionIndex, 0);
        String text = combo.getText();
        if (text == null || text.length() == 0 || combo.getSelectionIndex() < selectionIndex) {
            combo.setBackground(backgroundErrorColor);
            return false;
        }
        combo.setBackground(null);
        return true;
    }

    public static boolean testWidgetValue(Text widget) {
        if (widget.getText() == null || "".equals(widget.getText())) {
            widget.setBackground(backgroundErrorColor);
            if (modifyListener == null) {
                modifyListener = new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Text t = (Text)e.widget;
                        if (t.getText() != null && !"".equals(t.getText())) {
                            t.setBackground(null);
                        } else {
                            t.setBackground(backgroundErrorColor);
                        }
                    }
                };
                widget.addModifyListener(modifyListener);
            }
            return false;
        }
        return true;
    }

    public static void resizeControlWidthInGrid(Collection<Control> controls) {
        int largestWidth = -1;
        ArrayList<GridData> gridDatas = new ArrayList<GridData>();
        for (Control control : controls) {
            Object layoutData = control.getLayoutData();
            if (!(layoutData instanceof GridData)) continue;
            GridData gridData = (GridData)layoutData;
            gridDatas.add(gridData);
            if (gridData.widthHint > largestWidth) {
                largestWidth = gridData.widthHint;
                continue;
            }
            int preferredX = control.computeSize((int)-1, (int)-1).x;
            if (preferredX <= largestWidth) continue;
            largestWidth = preferredX;
        }
        for (GridData gridData : gridDatas) {
            gridData.widthHint = largestWidth;
        }
    }

    public static void updateErrorLabelWidth(Label label, Font errorFont) {
        Object layoutData = label.getLayoutData();
        if (layoutData instanceof GridData) {
            Font currentFont = label.getFont();
            label.setFont(errorFont);
            ((GridData)layoutData).widthHint = label.computeSize((int)-1, (int)-1).x;
            label.setFont(currentFont);
        }
    }

    public static void updateLabelStatus(Label label, Font errorFont, Color errorColor, boolean isValid) {
        label.setForeground(isValid ? null : errorColor);
        label.setFont(isValid ? null : errorFont);
    }

    public static void setVisiblity(Control control, boolean visible) {
        if (control == null) {
            return;
        }
        control.setVisible(visible);
        Object layoutData = control.getLayoutData();
        if (layoutData instanceof GridData) {
            ((GridData)layoutData).exclude = !visible;
        }
    }
}

