/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.util;

import com.aptana.core.IURIMapper;
import com.aptana.core.io.efs.EFSUtils;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.BrowserUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IBrowserUtil;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.IPropertyDialog;
import com.aptana.ui.PropertyDialogsRegistry;
import com.aptana.ui.UIPlugin;
import com.aptana.ui.browser.BrowserManager;
import com.aptana.ui.util.UIUtils;
import com.aptana.webserver.core.AliasServer;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.IServerManager;
import com.aptana.webserver.core.SimpleWebServer;
import com.aptana.webserver.core.WebServerCorePlugin;
import com.aptana.webserver.core.WorkspaceResolvingURIMapper;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;
import org.osgi.service.prefs.BackingStoreException;

public class RunInBrowserUtil {
    private static final String DONT_ALERT_EXT_SERVER = "dontAlertExtServer";
    public static final String LAST_BROWSER_NATURE = "LAST_BROWSER_NATURE";
    public static boolean hasAlertCreateExtServer = false;

    public static String getLastBrowserNature() {
        String last = UIPlugin.getDefault().getPreferenceStore().getString(LAST_BROWSER_NATURE);
        if (StringUtil.isBlank((String)last)) {
            IBrowserUtil.BrowserInfo brower = BrowserManager.getInstance().getDefaultBrowserInfo("Chrome");
            if (brower == null) {
                if (PlatformUtil.isWindows()) {
                    if (BrowserUtil.isEdgeExist()) {
                        return "Edge";
                    }
                    return "Internet Explorer";
                }
                if (PlatformUtil.isMac()) {
                    return "Safari";
                }
                return "Firefox";
            }
            return "Chrome";
        }
        return last;
    }

    public static void saveLastBrowserNature(String nature) {
        if (StringUtil.isNotBlank((String)nature)) {
            IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.aptana.ui");
            prefs.put(LAST_BROWSER_NATURE, nature);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
            }
        }
    }

    public static boolean runInEnableRunner(String brower) {
        IEvaluationService evaluationService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        if (evaluationService != null) {
            Object object;
            IEvaluationContext currentState = evaluationService.getCurrentState();
            Object selection = currentState.getVariable("selection");
            if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile && RunInBrowserUtil.runInEnableRunner(brower, (IResource)((IFile)object))) {
                return true;
            }
            Object editorInput = currentState.getVariable("activeEditorInput");
            if (editorInput instanceof IEditorInput) {
                IResource file = (IResource)((IEditorInput)editorInput).getAdapter(IResource.class);
                if (file != null) {
                    if (RunInBrowserUtil.runInEnableRunner(brower, file)) {
                        return true;
                    }
                } else {
                    IPath path = (IPath)((IEditorInput)editorInput).getAdapter(IPath.class);
                    return RunInBrowserUtil.runInEnableRunner(brower, path);
                }
            }
        }
        return false;
    }

    public static boolean runInEnableRunner(String brower, IPath path) {
        return RunInBrowserUtil.runInEnableRunner(brower, null, path);
    }

    public static boolean runInEnableRunner(String brower, IResource resource) {
        return RunInBrowserUtil.runInEnableRunner(brower, resource, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean runInEnableRunner(String brower, IResource resource, IPath path) {
        if (resource == null && path == null) {
            return false;
        }
        if (StringUtil.isBlank((String)brower)) {
            brower = RunInBrowserUtil.getLastBrowserNature();
        }
        try {
            String browserCmdLine;
            String browserExecutable = null;
            String browserId = UIPlugin.getDefault().getPreferenceStore().getString(brower);
            IBrowserUtil.BrowserInfo info = null;
            if (StringUtil.isNotBlank((String)browserId)) {
                info = BrowserManager.getInstance().findBrowserInfoByID(browserId);
            }
            if (info == null || !new File(info.getLocation()).exists()) {
                info = BrowserManager.getInstance().getDefaultBrowserInfo(brower);
            }
            if (info != null) {
                browserExecutable = info.getLocation();
            }
            if (StringUtil.isBlank(browserExecutable)) {
                info = BrowserManager.showBrowserInfoNotFoundDialog(brower, true);
                if (info == null) {
                    return false;
                }
                browserExecutable = info.getLocation();
                if (StringUtil.isBlank((String)browserExecutable)) {
                    return false;
                }
                UIPlugin.getDefault().getPreferenceStore().setValue(brower, info.getId());
            }
            String fileName = resource != null ? resource.getName() : path.toFile().getName();
            URI uri = null;
            if (RunInBrowserUtil.isRunnable(fileName)) {
                if (resource != null) {
                    IServer server;
                    RunInBrowserUtil.checkAndAlertCreateServer("\u6d4f\u89c8\u5668\u8fd0\u884c", fileName);
                    IURIMapper urlMapper = RunInBrowserUtil.getRunnableServerMapper(fileName);
                    if (urlMapper != null) {
                        uri = urlMapper.resolve(EFSUtils.getFileStore((IResource)resource));
                    }
                    if (uri != null && (server = RunInBrowserUtil.getRunnableServer(fileName)) != null && server.getState() != IServer.State.STARTED && server.getState() != IServer.State.STARTING) {
                        try {
                            server.start("run", (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (Throwable e) {
                            IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
                        }
                    }
                } else if (path != null) {
                    uri = path.toFile().toURI();
                }
            }
            if (uri == null) {
                return false;
            }
            String launchPage = uri.toURL().toExternalForm();
            boolean hasURLArg = false;
            ArrayList<String> browserArgs = new ArrayList<String>();
            String string = browserCmdLine = info != null ? info.getParameters() : null;
            if (browserCmdLine != null && browserCmdLine.length() > 0) {
                String[] stringArray = browserCmdLine.split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String arg = stringArray[n2];
                    if (arg.trim().length() > 0) {
                        if ((arg = arg.trim()).contains("%URL%")) {
                            arg = arg.replace("%URL%", launchPage);
                            hasURLArg = true;
                        }
                        browserArgs.add(arg);
                    }
                    ++n2;
                }
            }
            ArrayList<String> args = new ArrayList<String>();
            try {
                if ("macosx".equals(Platform.getOS())) {
                    args.add("/usr/bin/open");
                    args.add("-b");
                    args.add(PlatformUtil.getApplicationInfo((String)browserExecutable, (String)"CFBundleIdentifier"));
                    args.addAll(browserArgs);
                    if (!hasURLArg) {
                        args.add(launchPage);
                    }
                } else {
                    args.add(browserExecutable);
                    args.addAll(browserArgs);
                    if (!hasURLArg) {
                        args.add(launchPage);
                    }
                }
                Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.ui", 0, "\u542f\u52a8\u8fc7\u7a0b\u4e2d\u7684\u9519\u8bef", (Throwable)e));
            }
            RunInBrowserUtil.saveLastBrowserNature(brower);
            return false;
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
        }
        return false;
    }

    private static AliasServer getAliasServer(String fileName) {
        if (fileName == null) {
            return null;
        }
        ArrayList aliasServers = new ArrayList(WebServerCorePlugin.getDefault().getServerManager().getAllAliasServers());
        int i = aliasServers.size() - 1;
        while (i >= 0) {
            AliasServer aliasServer = (AliasServer)aliasServers.get(i);
            String contentTypeStr = aliasServer.getContentType();
            IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeStr);
            if (contentType != null && contentType.isAssociatedWith(fileName)) {
                return aliasServer;
            }
            --i;
        }
        return null;
    }

    public static boolean isRunnable(String fileName) {
        if (fileName == null) {
            return false;
        }
        AliasServer aliasServer = RunInBrowserUtil.getAliasServer(fileName);
        return aliasServer != null;
    }

    public static IServer getRunnableServer(String fileName) {
        AliasServer aliasServer = RunInBrowserUtil.getAliasServer(fileName);
        if (aliasServer == null) {
            return null;
        }
        IServerManager serverManager = WebServerCorePlugin.getDefault().getServerManager();
        IContentType contentType = Platform.getContentTypeManager().getContentType(aliasServer.getContentType());
        if (contentType != null && contentType.isAssociatedWith(fileName)) {
            IServer server = serverManager.findAndCheckServerByAlias(aliasServer.getAlias());
            ((SimpleWebServer)server).setDocumentRoot(EFSUtils.getFileStore((IResource)ResourcesPlugin.getWorkspace().getRoot()).toURI());
            return server;
        }
        return null;
    }

    public static void checkAndAlertCreateServer(final String title, String fileName) {
        if (!hasAlertCreateExtServer) {
            boolean dontAlertExtServer = UIPlugin.getDefault().getPreferenceStore().getBoolean(DONT_ALERT_EXT_SERVER);
            if (dontAlertExtServer) {
                return;
            }
            final AliasServer aliasServer = RunInBrowserUtil.getAliasServer(fileName);
            if (aliasServer == null) {
                return;
            }
            IServerManager serverManager = WebServerCorePlugin.getDefault().getServerManager();
            IContentType contentType = Platform.getContentTypeManager().getContentType(aliasServer.getContentType());
            if (contentType != null && contentType.isAssociatedWith(fileName)) {
                IServer server = serverManager.findAndCheckServerByAlias(aliasServer.getAlias());
                if (!aliasServer.isEnableBuildin() && StringUtil.isBlank((String)server.getId()) && serverManager.getServers().isEmpty() && !aliasServer.isEnableBuildin()) {
                    UIUtils.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = UIUtils.getActiveShell();
                            MessageDialogWithToggle dialog = new MessageDialogWithToggle(shell, String.valueOf(title) + "Web\u670d\u52a1\u5668\u8bbe\u7f6e", null, "\u5f53\u524d\u4f7f\u7528\u7684\u662fHBuilder\u5185\u7f6eWeb\u670d\u52a1\u5668\uff0c\u7531\u4e8eHBuilder\u5185\u7f6eWeb\u670d\u52a1\u5668\u4e0d\u652f\u6301" + aliasServer.getAlias() + "\u6587\u4ef6\uff0c\u5efa\u8bae\u4f7f\u7528\u5916\u7f6eWeb\u670d\u52a1\u5668\uff0c\u662f\u5426\u7acb\u5373\u521b\u5efa\u5916\u7f6eWeb\u670d\u52a1\u5668\uff1f", 5, new String[]{"\u521b\u5efa\u5916\u7f6eWeb\u670d\u52a1\u5668", "\u7ee7\u7eed\u4f7f\u7528\u5185\u7f6eWeb\u670d\u52a1\u5668"}, 0, "\u4e0d\u518d\u63d0\u9192 (\u53ef\u5728\u5de5\u5177->\u9009\u9879->Web\u670d\u52a1\u5668\u4e2d\u6253\u5f00\u914d\u7f6e\u754c\u9762)", false);
                            if (dialog.open() == 256) {
                                try {
                                    IServer newServer = WebServerCorePlugin.getDefault().getServerManager().createServer("com.aptana.webserver.external");
                                    Dialog dlg = PropertyDialogsRegistry.getInstance().createPropertyDialog(newServer, (IShellProvider)new SameShellProvider((Control)shell));
                                    if (dlg != null) {
                                        if (dlg instanceof IPropertyDialog) {
                                            ((IPropertyDialog)dlg).setPropertySource(newServer);
                                        }
                                        if (dlg.open() == 0) {
                                            WebServerCorePlugin.getDefault().getServerManager().add(newServer);
                                            WebServerCorePlugin.getDefault().getServerManager().setServerByAlias(aliasServer.getAlias(), newServer.getName());
                                        } else {
                                            WebServerCorePlugin.getDefault().getServerManager().remove(newServer);
                                        }
                                    }
                                }
                                catch (Throwable e) {
                                    UIUtils.showErrorMessage("\u521b\u5efa\u5916\u7f6eWeb\u670d\u52a1\u5668\u5931\u8d25", e);
                                }
                            }
                            if (dialog.getToggleState()) {
                                UIPlugin.getDefault().getPreferenceStore().setValue(RunInBrowserUtil.DONT_ALERT_EXT_SERVER, true);
                            }
                            hasAlertCreateExtServer = true;
                        }
                    });
                }
            }
        }
    }

    public static IURIMapper getRunnableServerMapper(String name) {
        if (name != null) {
            IServer server = RunInBrowserUtil.getRunnableServer(name);
            if (server != null && server.getId() != null) {
                return new WorkspaceResolvingURIMapper((IURIMapper)server);
            }
            return server;
        }
        return null;
    }
}

