/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.util;

import com.aptana.ui.epl.UIEplPlugin;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class ImageDecoratorUtil {
    private static final String IMG_WIZBAN_DEFAULT = "icons/full/wizban/defaultWizard.png";

    public static ImageDescriptor getCompositeDescriptor(ImageDescriptor baseImageDescriptor, ImageDescriptor overlayImageDescriptor) {
        return new CenteredCompositeImageDescriptor(baseImageDescriptor, overlayImageDescriptor);
    }

    public static ImageDescriptor getCompositeWizbanDescriptor(ImageDescriptor overlayImage) {
        return ImageDecoratorUtil.getCompositeDescriptor(UIEplPlugin.imageDescriptorFromPlugin((String)"com.aptana.ui.epl", (String)IMG_WIZBAN_DEFAULT), overlayImage);
    }

    private static class CenteredCompositeImageDescriptor
    extends CompositeImageDescriptor {
        private ImageData baseImageData;
        private ImageData overlayImageData;
        private Point size;

        CenteredCompositeImageDescriptor(ImageDescriptor baseImage, ImageDescriptor overlayImage) {
            this.baseImageData = baseImage.getImageData();
            this.overlayImageData = overlayImage.getImageData();
            this.size = new Point(this.baseImageData.width, this.baseImageData.height);
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.baseImageData, 0, 0);
            int x = (this.size.x - Math.min(this.size.x, this.overlayImageData.width)) / 2;
            int y = (this.size.y - Math.min(this.size.y, this.overlayImageData.height)) / 2;
            this.drawImage(this.overlayImageData, x, y);
        }

        protected Point getSize() {
            return this.size;
        }

        protected int getTransparentPixel() {
            return this.baseImageData.transparentPixel;
        }
    }
}

