/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.UIPlugin;
import com.aptana.ui.preferences.IAccountPageProvider;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;

public abstract class AbstractAccountPageProvider
implements IAccountPageProvider,
IExecutableExtension {
    private static final String ATTR_PRIORITY = "priority";
    private int priority = 50;
    private Set<IAccountPageProvider.IValidationListener> validationListeners = new LinkedHashSet<IAccountPageProvider.IValidationListener>();
    private IProgressMonitor progressMonitor;

    public AbstractAccountPageProvider() {
        this((IProgressMonitor)new NullProgressMonitor());
    }

    public AbstractAccountPageProvider(IProgressMonitor progressMonitor) {
        this.setProgressMonitor(progressMonitor);
    }

    @Override
    public void addValidationListener(IAccountPageProvider.IValidationListener listener) {
        this.validationListeners.add(listener);
    }

    @Override
    public void removeValidationListener(IAccountPageProvider.IValidationListener listener) {
        this.validationListeners.remove(listener);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String priorityStr = config.getAttribute(ATTR_PRIORITY);
        if (!StringUtil.isEmpty((String)priorityStr)) {
            try {
                this.priority = Integer.parseInt(priorityStr);
            }
            catch (NumberFormatException numberFormatException) {
                IdeLog.logWarning((Plugin)UIPlugin.getDefault(), (String)MessageFormat.format("Unable to parse the priority value ({0}) for the account page provider as an integer; defaulting to 50", priorityStr));
            }
        }
    }

    @Override
    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor == null ? new NullProgressMonitor() : progressMonitor;
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    protected void firePreValidationStartEvent() {
        for (IAccountPageProvider.IValidationListener listener : this.validationListeners) {
            listener.preValidationStart();
        }
    }

    protected void firePostValidationEndEvent() {
        for (IAccountPageProvider.IValidationListener listener : this.validationListeners) {
            listener.postValidationEnd();
        }
    }
}

