/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.launchings;

import com.aptana.core.util.IBrowserUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.UIPlugin;
import com.aptana.ui.dialogs.BrowserDescriptorDialog;
import com.aptana.ui.launchings.Messages;
import com.aptana.ui.util.SWTUtils;
import java.util.List;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.browser.BrowserManager;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;

public abstract class AbstractLaunchBrowserSettingsTab
extends AbstractLaunchConfigurationTab {
    protected Combo fBrowserExeCombo;
    protected Button createNewBrowser;
    protected Button configureBrowser;

    protected void createBrowserSection(Composite parent) {
        Group group = new Group(parent, 0x800004);
        group.setText(Messages.AbstractLaunchBrowserSettingsTab_Group);
        group.setFont(parent.getFont());
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(4).margins(10, 3).create());
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.AbstractLaunchBrowserSettingsTab_Browser_Exe);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        BrowserWidgetListener browserListener = new BrowserWidgetListener();
        this.fBrowserExeCombo = new Combo((Composite)group, 12);
        this.fBrowserExeCombo.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        this.fBrowserExeCombo.addSelectionListener((SelectionListener)browserListener);
        this.createNewBrowser = this.createPushButton((Composite)group, null, SWTUtils.getImage(UIPlugin.getDefault(), "/icons/add.gif"));
        this.createNewBrowser.setToolTipText(Messages.AbstractLaunchBrowserSettingsTab_Browser_New);
        this.createNewBrowser.addSelectionListener((SelectionListener)browserListener);
        Object gd = this.createNewBrowser.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = -1;
        }
        this.configureBrowser = this.createPushButton((Composite)group, null, SWTUtils.getImage(UIPlugin.getDefault(), "/icons/configure.gif"));
        this.configureBrowser.setToolTipText(Messages.AbstractLaunchBrowserSettingsTab_Browser_Configure);
        this.configureBrowser.addSelectionListener((SelectionListener)browserListener);
        gd = this.configureBrowser.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = -1;
        }
    }

    public void updateBrowsers(String browserName) {
        this.fBrowserExeCombo.removeAll();
        List browsers = com.aptana.ui.browser.BrowserManager.getInstance().getBrowserInfos();
        if (browsers != null && !browsers.isEmpty()) {
            IBrowserUtil.BrowserInfo initBrowser = null;
            for (IBrowserUtil.BrowserInfo browser : browsers) {
                if (browser.getName().equals(browserName)) {
                    initBrowser = browser;
                }
                this.fBrowserExeCombo.add(browser.getName());
                this.fBrowserExeCombo.setData(browser.getName(), (Object)browser.getId());
            }
            if (browserName != null && initBrowser != null) {
                this.fBrowserExeCombo.setText(browserName);
            } else {
                this.fBrowserExeCombo.setText("");
            }
        }
        this.handleBrowserExeComboSelected();
    }

    protected void handleBrowserExeComboSelected() {
        if (this.configureBrowser != null) {
            if (StringUtil.isBlank((String)this.fBrowserExeCombo.getText())) {
                this.configureBrowser.setEnabled(false);
            } else {
                this.configureBrowser.setEnabled(true);
            }
        }
    }

    protected void handleNewBrowserButtonSelected() {
        BrowserDescriptorDialog dialog = new BrowserDescriptorDialog(this.getShell());
        if (dialog.open() == 0) {
            final IBrowserDescriptor browser = dialog.getBrowser();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractLaunchBrowserSettingsTab.this.updateBrowsers(browser.getName());
                }
            });
        }
    }

    protected void handleConfigureBrowserButtonSelected() {
        BrowserDescriptorDialog dialog;
        String browserName = this.fBrowserExeCombo.getText();
        final IBrowserDescriptor browser = this.getBrowserDescriptorByName(browserName);
        if (browser != null && (dialog = new BrowserDescriptorDialog(this.getShell(), browser)).open() == 0) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractLaunchBrowserSettingsTab.this.updateBrowsers(browser.getName());
                }
            });
        }
    }

    private IBrowserDescriptor getBrowserDescriptorByName(String name) {
        if (name == null) {
            return null;
        }
        List browsers = BrowserManager.getInstance().getWebBrowsers();
        if (browsers != null) {
            for (IBrowserDescriptor browser : browsers) {
                if (!browser.getName().equals(name)) continue;
                return browser;
            }
        }
        return null;
    }

    protected void initializeBrowser(boolean autoDefault, String name, String id) {
        IBrowserUtil.BrowserInfo info;
        this.updateBrowsers(name);
        if (name != null) {
            this.fBrowserExeCombo.setText(name);
        }
        if (id != null) {
            this.fBrowserExeCombo.setData(name, (Object)id);
        }
        if (StringUtil.isBlank((String)name) && autoDefault && (info = com.aptana.ui.browser.BrowserManager.getInstance().getDefaultBrowserInfo(null)) != null) {
            this.fBrowserExeCombo.setText(info.getName());
            this.fBrowserExeCombo.setData(info.getName(), (Object)info.getId());
        }
        this.handleBrowserExeComboSelected();
    }

    protected boolean isBrowserValid() {
        String value = this.fBrowserExeCombo.getText();
        if (StringUtil.isBlank((String)value)) {
            this.setErrorMessage(Messages.AbstractLaunchBrowserSettingsTab_Error_No_Exe);
            return false;
        }
        return true;
    }

    protected void saveWebBrowserId(ILaunchConfigurationWorkingCopy configuration, String configurationKey) {
        if (StringUtil.isNotBlank((String)this.fBrowserExeCombo.getText())) {
            String id = (String)this.fBrowserExeCombo.getData(this.fBrowserExeCombo.getText());
            configuration.setAttribute(configurationKey, id);
        } else {
            configuration.setAttribute(configurationKey, "");
        }
    }

    protected class BrowserWidgetListener
    extends SelectionAdapter {
        protected BrowserWidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == AbstractLaunchBrowserSettingsTab.this.createNewBrowser) {
                AbstractLaunchBrowserSettingsTab.this.handleNewBrowserButtonSelected();
            } else if (source == AbstractLaunchBrowserSettingsTab.this.configureBrowser) {
                AbstractLaunchBrowserSettingsTab.this.handleConfigureBrowserButtonSelected();
            } else if (source == AbstractLaunchBrowserSettingsTab.this.fBrowserExeCombo) {
                AbstractLaunchBrowserSettingsTab.this.handleBrowserExeComboSelected();
            }
            AbstractLaunchBrowserSettingsTab.this.updateLaunchConfigurationDialog();
        }
    }
}

