/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.keybinding;

import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.keys.BindingService;
import org.eclipse.ui.internal.keys.WorkbenchKeyboard;
import org.eclipse.ui.keys.IBindingService;

public class KeyBindingHelper {
    public static boolean matchesKeybinding(KeyEvent event, String commandId) {
        int keyCode = event.keyCode;
        int stateMask = event.stateMask;
        return KeyBindingHelper.matchesKeybinding(keyCode, stateMask, commandId);
    }

    public static boolean matchesKeybinding(int keyCode, int stateMask, String commandId) {
        TriggerSequence[] activeBindingsFor;
        IBindingService bindingSvc = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence[] triggerSequenceArray = activeBindingsFor = bindingSvc.getActiveBindingsFor(commandId);
        int n = activeBindingsFor.length;
        int n2 = 0;
        while (n2 < n) {
            TriggerSequence seq = triggerSequenceArray[n2];
            if (seq instanceof KeySequence && KeyBindingHelper.matchesKeybinding(keyCode, stateMask, seq)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean matchesKeybinding(int keyCode, int stateMask, TriggerSequence seq) {
        int upperCase = Character.toUpperCase(keyCode);
        if (upperCase == keyCode) {
            return KeyBindingHelper.internalMatchesKeybinding(keyCode, stateMask, seq);
        }
        return KeyBindingHelper.internalMatchesKeybinding(upperCase, stateMask, seq) || KeyBindingHelper.internalMatchesKeybinding(keyCode, stateMask, seq);
    }

    private static boolean internalMatchesKeybinding(int keyCode, int stateMask, TriggerSequence seq) {
        KeySequence keySequence = (KeySequence)seq;
        KeyStroke[] keyStrokes = keySequence.getKeyStrokes();
        if (keyStrokes.length > 1) {
            return false;
        }
        KeyStroke[] keyStrokeArray = keyStrokes;
        int n = keyStrokes.length;
        int n2 = 0;
        while (n2 < n) {
            KeyStroke keyStroke = keyStrokeArray[n2];
            if (keyStroke.getNaturalKey() == keyCode && keyStroke.getModifierKeys() == stateMask) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isKeyEventComplete(Event event) {
        return SWTKeySupport.convertAcceleratorToKeyStroke((int)SWTKeySupport.convertEventToUnmodifiedAccelerator((Event)event)).isComplete();
    }

    public static void handleEvent(Event e) {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        WorkbenchKeyboard.KeyDownFilter keyDownFilter = ((BindingService)bindingService).getKeyboard().getKeyDownFilter();
        boolean enabled = bindingService.isKeyFilterEnabled();
        Control focusControl = e.display.getFocusControl();
        try {
            bindingService.setKeyFilterEnabled(true);
            keyDownFilter.handleEvent(e);
        }
        finally {
            if (focusControl == e.display.getFocusControl()) {
                bindingService.setKeyFilterEnabled(enabled);
            }
        }
    }
}

