/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.diagnostic;

import com.aptana.core.diagnostic.IDiagnosticLog;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.UIPlugin;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;

public class DiagnosticManager {
    private static final String EXTENSION_NAME = "diagnostic";
    private static final String ELEMENT_LOG = "diagnosticLog";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_PRIORITY = "priority";
    private static final int DEFAULT_PRIORITY = 50;
    private static DiagnosticManager instance;
    private List<IDiagnosticLog> logs = new ArrayList<IDiagnosticLog>();

    public static synchronized DiagnosticManager getInstance() {
        if (instance == null) {
            instance = new DiagnosticManager();
        }
        return instance;
    }

    private DiagnosticManager() {
        this.loadExtensions();
    }

    public List<IDiagnosticLog> getLogs() {
        return Collections.unmodifiableList(this.logs);
    }

    private void loadExtensions() {
        final ArrayList result = new ArrayList();
        EclipseUtil.processConfigurationElements((String)"com.aptana.ui", (String)EXTENSION_NAME, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

            public void processElement(IConfigurationElement element) {
                String classStr = element.getAttribute(DiagnosticManager.ATTR_CLASS);
                if (StringUtil.isEmpty((String)classStr)) {
                    return;
                }
                IDiagnosticLog logClass = null;
                try {
                    Object clazz = element.createExecutableExtension(DiagnosticManager.ATTR_CLASS);
                    if (clazz instanceof IDiagnosticLog) {
                        logClass = (IDiagnosticLog)clazz;
                    } else {
                        IdeLog.logError((Plugin)UIPlugin.getDefault(), (String)MessageFormat.format("The class {0} does not implement IDiagnosticLog.", classStr));
                    }
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
                }
                if (logClass == null) {
                    return;
                }
                int priority = 50;
                String priorityStr = element.getAttribute(DiagnosticManager.ATTR_PRIORITY);
                if (!StringUtil.isEmpty((String)priorityStr)) {
                    try {
                        priority = Integer.parseInt(priorityStr);
                    }
                    catch (NumberFormatException e) {
                        IdeLog.logWarning((Plugin)UIPlugin.getDefault(), (String)"The priority for diagnosticLog needs to be an integer.", (Throwable)e);
                    }
                }
                result.add(new DiagnosticLog(logClass, priority));
            }

            public Set<String> getSupportElementNames() {
                return CollectionsUtil.newSet((Object[])new String[]{DiagnosticManager.ELEMENT_LOG});
            }
        });
        Collections.sort(result, new Comparator<DiagnosticLog>(){

            @Override
            public int compare(DiagnosticLog arg0, DiagnosticLog arg1) {
                return arg0.priority - arg1.priority;
            }
        });
        for (DiagnosticLog log : result) {
            this.logs.add(log.logClass);
        }
    }

    private static class DiagnosticLog {
        public final IDiagnosticLog logClass;
        public final int priority;

        private DiagnosticLog(IDiagnosticLog logClass, int priority) {
            this.logClass = logClass;
            this.priority = priority;
        }
    }
}

