/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.UIPlugin;
import com.aptana.ui.util.RunInBrowserUtil;
import com.pandora.core.mobile.IRunInDeviceLauncher;
import com.pandora.core.utils.ProjectUtils;
import com.pandora.core.utils.RegistryUtils;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;

public class RunInBrowser
extends AbstractHandler {
    public static final String POINT_ID = "com.pandora.core.runInDeviceLauncher";
    public static final String ID = "com.aptana.ui.run.browser";
    public static final String PARAM = "com.aptana.ui.run.type";
    private static List<IRunInDeviceLauncher> list;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String browser = event.getParameter(PARAM);
        try {
            if (StringUtil.isBlank((String)browser)) {
                IProject project = ProjectUtils.getCurrentProject();
                RunInBrowser.initIRunInDeviceLaunchers();
                if (project != null && RunInBrowser.runInDeviceLauncher(project)) {
                    return null;
                }
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
        }
        RunInBrowserUtil.runInEnableRunner(browser);
        return null;
    }

    private static void initIRunInDeviceLaunchers() {
        if (list == null) {
            try {
                list = RegistryUtils.getEp(IRunInDeviceLauncher.class, (String)POINT_ID, (String)"runner", (String)"class");
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
            }
        }
    }

    private static boolean runInDeviceLauncher(IProject project) {
        if (list != null) {
            for (IRunInDeviceLauncher runner : list) {
                if (!runner.runInDeviceLauncher(project, "run")) continue;
                return true;
            }
        }
        return false;
    }
}

