/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui;

import com.aptana.core.util.EclipseUtil;
import com.aptana.ui.Messages;
import com.aptana.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.progress.UIJob;
import org.osgi.service.prefs.BackingStoreException;

public class PerspectiveChangeResetListener
extends PerspectiveAdapter {
    String pluginId;
    String preferenceId;
    String perspectiveId;
    int perspectiveVersion;

    public PerspectiveChangeResetListener(String perspectiveId, String pluginId, String preferenceId, int perspectiveVersion) {
        this.perspectiveId = perspectiveId;
        this.pluginId = pluginId;
        this.preferenceId = preferenceId;
        this.perspectiveVersion = perspectiveVersion;
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        int version = Platform.getPreferencesService().getInt(this.pluginId, this.preferenceId, 0, null);
        if (this.perspectiveVersion > version) {
            this.resetPerspective(page);
            IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(this.pluginId);
            prefs.putInt(this.preferenceId, this.perspectiveVersion);
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    private void resetPerspective(final IWorkbenchPage page) {
        UIJob job = new UIJob("Resetting Studio perspective..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (MessageDialog.openQuestion((Shell)UIUtils.getActiveShell(), (String)Messages.UIPlugin_ResetPerspective_Title, (String)Messages.UIPlugin_ResetPerspective_Description)) {
                    page.resetPerspective();
                }
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.setPriority(10);
        job.schedule();
    }
}

