/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.keys.ui.views;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.ObjectUtil;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.keys.ui.views.BindingCategoryElement;
import com.aptana.keys.ui.views.BindingElement;
import com.aptana.keys.ui.views.BindingsFilter;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.snippets.ui.views.Messages;
import com.aptana.theme.ColorManager;
import com.aptana.theme.IControlThemerFactory;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import com.aptana.ui.util.UIUtils;
import com.aptana.ui.widgets.SearchComposite;
import com.aptana.workbench.WorkbenchPlugin;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.BindingManagerEvent;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.keys.BindingService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

public class BindingsView
extends ViewPart {
    private static final String ICONS_FULL_ELCL16_EXPANDALL_GIF = "icons/full/elcl16/expandall.gif";
    public static final String ID = "com.pandora.ui.views.Bindings";
    public static final String OTHER_CATEGORIE = "\u5176\u4ed6";
    private BindingManager bindingManager;
    private Map<String, ExpandItem> expandItems = new HashMap<String, ExpandItem>();
    private ScrolledComposite scrolledComposite;
    private ExpandBar expandBar;
    private SearchComposite search;
    private BindingsFilter filter;
    private List<BindingCategoryElement> configBindingCategorieElements = new ArrayList<BindingCategoryElement>();
    private Map<BindingCategoryElement, List<BindingElement>> configCategorysAndBindingElementMap = new HashMap<BindingCategoryElement, List<BindingElement>>();
    private List<BindingElement> configBindingElements = new ArrayList<BindingElement>();
    private Map<BindingElement, BindingData> bindingElementBindingDataBindingMap = new HashMap<BindingElement, BindingData>();
    private List<Binding> activeBindingsDisregardingContextBindings;
    private HashMap<String, List<BindingData>> sortedBindings = new LinkedHashMap<String, List<BindingData>>();
    private Map<BindingData, BindingItem> bindingsItems = new HashMap<BindingData, BindingItem>();
    private ColorManager colorManager;
    private Color themeBgColor;
    private Color themeFgColor;
    private IControlThemerFactory themeFactory;
    private IEclipsePreferences.IPreferenceChangeListener themeListener;
    private List<Control> themedControls = new ArrayList<Control>();
    private List<String> collapsedCategories = new ArrayList<String>();
    private BindingListener bindingsListener;
    private Combo schemesCombo;
    FilterBindingsJob filterSnippetsJob = null;

    public BindingsView() {
        this.setPartName("\u5feb\u6377\u952e\u5217\u8868");
        this.colorManager = new ColorManager();
        this.themeFactory = ThemePlugin.getDefault().getControlThemerFactory();
        this.bindingsListener = new BindingListener();
    }

    private void updateThemeColors() {
        if (ThemePlugin.applyToViews()) {
            this.themeBgColor = ThemePlugin.getDefault().getColorManager().getColor(ThemePlugin.getDefault().getThemeManager().getCurrentTheme().getBackground());
            this.themeFgColor = ThemePlugin.getDefault().getColorManager().getColor(ThemePlugin.getDefault().getThemeManager().getCurrentTheme().getForeground());
        } else {
            this.themeBgColor = null;
            this.themeFgColor = null;
        }
        this.updateThemeColor();
        for (BindingItem item : this.bindingsItems.values()) {
            item.applyVisualEnablement();
        }
        this.updateBindingDrawers();
    }

    protected Font getFont() {
        Font font = JFaceResources.getFont((String)"com.aptana.explorer.font");
        if (font == null) {
            font = JFaceResources.getTextFont();
        }
        return font;
    }

    public void createPartControl(Composite parent) {
        this.filter = new BindingsFilter();
        this.themeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                String key = event.getKey();
                if ("THEME_CHANGED".equals(key) || "enable_invasive_themes".equals(key) || "enable_invasive_font".equals(key)) {
                    BindingsView.this.updateThemeColors();
                }
            }
        };
        parent.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 1).spacing(0, 0).create());
        this.search = new SearchComposite(parent, 0, false, false, new SearchComposite.Client(){

            public void search(String text, boolean isCaseSensitive, boolean isRegularExpression) {
                Pattern pattern = PatternConstructor.createPattern((String)text, (boolean)isCaseSensitive, (boolean)isRegularExpression);
                BindingsView.this.filter.setPattern(pattern);
                ArrayList<BindingData> snippets = new ArrayList<BindingData>();
                for (List list : BindingsView.this.sortedBindings.values()) {
                    for (BindingData data : list) {
                        snippets.add(data);
                    }
                }
                Object[] filtered = BindingsView.this.filter.filter(null, null, snippets.toArray(new BindingData[snippets.size()]));
                ArrayList<BindingData> snippetDatas = new ArrayList<BindingData>();
                Object[] objectArray = filtered;
                int n = filtered.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    snippetDatas.add((BindingData)object);
                    ++n2;
                }
                if (BindingsView.this.filterSnippetsJob != null) {
                    BindingsView.this.filterSnippetsJob.cancel();
                }
                BindingsView.this.filterSnippetsJob = new FilterBindingsJob(snippetDatas);
                BindingsView.this.filterSnippetsJob.schedule(750L);
            }
        });
        this.search.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.search.setSearchOnEnter(false);
        this.search.setInitialText("\u641c\u7d22\u5feb\u6377\u952e");
        this.scrolledComposite = new ScrolledComposite(parent, 2816);
        this.scrolledComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.scrolledComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        this.scrolledComposite.getVerticalBar().setIncrement(6);
        this.expandBar = new ExpandBar((Composite)this.scrolledComposite, 0);
        Font font = null;
        font = PlatformUtil.isWindows() ? new Font((Device)this.expandBar.getDisplay(), "\u5fae\u8f6f\u96c5\u9ed1", 8, 0) : new Font((Device)this.expandBar.getDisplay(), "consolas", 12, 0);
        this.expandBar.setFont(font);
        this.expandBar.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.scrolledComposite.setBackground(this.getBackgroundColor());
        this.scrolledComposite.setForeground(this.themeFgColor);
        this.scrolledComposite.setContent((Control)this.expandBar);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.expandBar.addExpandListener(new ExpandListener(){

            public void itemExpanded(ExpandEvent e) {
                BindingsView.this.expandDrawer((String)((ExpandItem)e.item).getData(), false);
                BindingsView.this.updateScrollMinSize((ExpandItem)e.item, true);
                BindingsView.this.collapsedCategories.remove((String)e.item.getData());
            }

            public void itemCollapsed(ExpandEvent e) {
                BindingsView.this.updateScrollMinSize((ExpandItem)e.item, false);
                BindingsView.this.collapsedCategories.add((String)e.item.getData());
            }
        });
        this.initConfigBindings();
        this.createBindingsDrawers();
        this.initializeToolBar();
        this.updateThemeColors();
    }

    private void updateScrollMinSize(ExpandItem item, boolean expanded) {
        if (item == null) {
            Point size = this.expandBar.computeSize(-1, -1);
            this.scrolledComposite.setMinSize(size.x, size.y);
        } else {
            int minHeight = this.scrolledComposite.getMinHeight();
            minHeight = expanded ? minHeight + item.getHeight() : minHeight - item.getHeight();
            this.scrolledComposite.setMinHeight(minHeight);
        }
    }

    protected void showBindings(List<BindingData> bindings) {
        HashMap<String, Integer> localSnippets = new HashMap<String, Integer>();
        for (BindingData bindingData : bindings) {
            String category = bindingData.getCategory();
            Integer size = (Integer)localSnippets.get(category);
            if (size == null) {
                size = 0;
            }
            size = size + 1;
            localSnippets.put(category, size);
        }
        HashMap<String, ArrayList<BindingItem>> changedBindings = new HashMap<String, ArrayList<BindingItem>>();
        for (String category : this.sortedBindings.keySet()) {
            List<BindingData> datas = this.sortedBindings.get(category);
            for (BindingData data : datas) {
                ExpandItem expandItem;
                BindingItem item = this.bindingsItems.get(data);
                boolean newExclude = !bindings.contains(data);
                boolean oldExclude = data.filtered;
                data.filtered = newExclude;
                boolean itemChanged = false;
                if (item != null) {
                    if (newExclude != oldExclude) {
                        itemChanged = true;
                    }
                    item.setFiltered(newExclude);
                } else if (!newExclude && (expandItem = this.expandItems.get(category)).getExpanded()) {
                    this.expandDrawer(category, false);
                    itemChanged = true;
                    item = this.bindingsItems.get(data);
                    if (item != null) {
                        item.setFiltered(newExclude);
                    }
                }
                if (!itemChanged) continue;
                ArrayList<BindingItem> list = (ArrayList<BindingItem>)changedBindings.get(category);
                if (list == null) {
                    list = new ArrayList<BindingItem>();
                    changedBindings.put(category, list);
                }
                list.add(item);
            }
        }
        for (String category : this.expandItems.keySet()) {
            int size = localSnippets.get(category) == null ? 0 : (Integer)localSnippets.get(category);
            ExpandItem expandItem = this.expandItems.get(category);
            expandItem.setText(MessageFormat.format(Messages.SnippetsView_Snippet_drawer_title, category != null ? category : Messages.SnippetsView_Snippet_drawer_other, String.valueOf(size)));
            List list = (List)changedBindings.get(category);
            if (CollectionsUtil.isEmpty((Collection)list)) continue;
            ((Composite)expandItem.getControl()).layout(list.toArray(new Control[list.size()]));
            expandItem.setHeight(expandItem.getControl().computeSize((int)-1, (int)-1).y);
        }
        this.updateScrollMinSize(null, false);
    }

    protected void createBindingsDrawers() {
        this.disposeThemers();
        this.themedControls.clear();
        EclipseUtil.instanceScope().getNode("com.aptana.theme").removePreferenceChangeListener(this.themeListener);
        ArrayList<String> expandedDrawers = new ArrayList<String>();
        for (ExpandItem item : this.expandItems.values()) {
            if (item.isDisposed()) continue;
            if (item.getExpanded()) {
                expandedDrawers.add((String)item.getData());
            }
            item.getControl().dispose();
            item.dispose();
        }
        this.expandItems.clear();
        this.updateCategoriesAndSnippets(expandedDrawers);
        this.updateScrollMinSize(null, false);
        this.scrolledComposite.layout(true, true);
        this.updateBindingDrawers();
        EclipseUtil.instanceScope().getNode("com.aptana.theme").addPreferenceChangeListener(this.themeListener);
    }

    private void expandDrawer(String category, boolean shouldExpand) {
        ExpandItem expandItem = this.expandItems.get(category);
        if (expandItem != null) {
            boolean adjustHeight = false;
            Composite composite = (Composite)expandItem.getControl();
            List<BindingData> elements = this.sortedBindings.get(category);
            if (!CollectionsUtil.isEmpty(elements)) {
                for (BindingData element : elements) {
                    if (this.bindingsItems.get(element) != null) continue;
                    this.bindingsItems.put(element, new BindingItem(composite, element));
                    adjustHeight = true;
                }
            }
            if (adjustHeight) {
                expandItem.setHeight(composite.computeSize((int)-1, (int)-1).y);
            }
            if (shouldExpand) {
                expandItem.setExpanded(true);
            }
        }
    }

    private void updateCategoriesAndSnippets(List<String> expandedDrawers) {
        this.sortedBindings.clear();
        this.bindingsItems.clear();
        this.bindingElementBindingDataBindingMap.clear();
        for (BindingCategoryElement category : this.configCategorysAndBindingElementMap.keySet()) {
            this.sortedBindings.put(category.getDisplayName(), new ArrayList());
        }
        this.activeBindingsDisregardingContextBindings = new ArrayList<Binding>(this.getBindingManager().getActiveBindingsDisregardingContextFlat());
        String scheme = this.getBindingManager().getActiveScheme().getId();
        for (BindingCategoryElement category : this.configCategorysAndBindingElementMap.keySet()) {
            List<BindingElement> bindingElements = this.configCategorysAndBindingElementMap.get(category);
            List<BindingData> bindingDataList = this.sortedBindings.get(category.getDisplayName());
            for (BindingElement bindingElement : bindingElements) {
                for (Binding binding : this.activeBindingsDisregardingContextBindings) {
                    try {
                        if (binding.getParameterizedCommand() == null || !binding.getParameterizedCommand().getId().equals(bindingElement.getCommandId()) || !binding.getParameterizedCommand().getParameterMap().isEmpty() && bindingElement.getParameterId() == null || ObjectUtil.areNotEqual(binding.getParameterizedCommand().getParameterMap().get(bindingElement.getParameterId()), (Object)bindingElement.getParameterValue())) continue;
                        String name = binding.getParameterizedCommand().getName();
                        if (StringUtil.isNotBlank((String)bindingElement.getDisplayName())) {
                            name = bindingElement.getDisplayName();
                        }
                        BindingData data = new BindingData(name, binding.getTriggerSequence().format(), category.getDisplayName(), binding.getSchemeId(), bindingElement.getParameterId(), bindingElement.getParameterValue());
                        BindingData savedData = this.bindingElementBindingDataBindingMap.get(bindingElement);
                        if (savedData != null && !savedData.getScheme().equals(scheme) && data.getScheme().equals(scheme)) {
                            bindingDataList.remove(savedData);
                            this.bindingElementBindingDataBindingMap.put(bindingElement, data);
                            bindingDataList.add(data);
                            continue;
                        }
                        if (savedData != null) continue;
                        this.bindingElementBindingDataBindingMap.put(bindingElement, data);
                        bindingDataList.add(data);
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)WorkbenchPlugin.getDefault(), (Throwable)e);
                    }
                }
            }
        }
        List<BindingData> otherBindingDataList = this.sortedBindings.get(OTHER_CATEGORIE);
        for (Binding binding : this.activeBindingsDisregardingContextBindings) {
            try {
                Object key;
                if (binding.getSchemeId() == null || binding.getParameterizedCommand() == null) continue;
                ParameterizedCommand command = binding.getParameterizedCommand();
                BindingData data = null;
                String parameterId = null;
                String parameterValue = null;
                BindingElement bindingElement = null;
                if (!command.getParameterMap().isEmpty() && (key = command.getParameterMap().keySet().iterator().next()) instanceof String) {
                    Object value = command.getParameterMap().get(key);
                    parameterId = (String)key;
                    parameterValue = (String)value;
                    bindingElement = new BindingElement(command.getId(), parameterId, parameterValue);
                }
                if (bindingElement == null) {
                    bindingElement = new BindingElement(command.getId(), parameterId, parameterValue);
                }
                if (this.configBindingElements.contains(bindingElement)) continue;
                data = new BindingData(command.getName(), binding.getTriggerSequence().format(), OTHER_CATEGORIE, binding.getSchemeId(), parameterId, parameterValue);
                BindingData savedData = this.bindingElementBindingDataBindingMap.get(bindingElement);
                if (savedData != null && !savedData.getScheme().equals(scheme)) {
                    otherBindingDataList.remove(savedData);
                    this.bindingElementBindingDataBindingMap.put(bindingElement, data);
                    otherBindingDataList.add(data);
                    continue;
                }
                if (savedData != null) continue;
                this.bindingElementBindingDataBindingMap.put(bindingElement, data);
                otherBindingDataList.add(data);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)WorkbenchPlugin.getDefault(), (Throwable)e);
            }
        }
        Collections.sort(otherBindingDataList, new Comparator<BindingData>(){

            @Override
            public int compare(BindingData o1, BindingData o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (BindingCategoryElement category : this.configBindingCategorieElements) {
            List<BindingData> snippetList;
            ExpandItem expandItem = this.createBindingDrawer(this.expandBar, category, snippetList = this.sortedBindings.get(category.getDisplayName()));
            if (!expandedDrawers.contains(expandItem.getData())) continue;
            this.expandDrawer((String)expandItem.getData(), true);
        }
    }

    private void addThemedControl(Control control, int fontStyle, int alpha) {
        this.themedControls.add(control);
        Color defaultBg = UIUtils.getDisplay().getSystemColor(1);
        if (fontStyle != 0) {
            this.themeFactory.applyWithFontStyle(control, fontStyle, defaultBg);
        } else if (alpha > -1) {
            this.themeFactory.applyWithAlpha(control, alpha, defaultBg);
        } else {
            this.themeFactory.apply(control, defaultBg);
        }
    }

    private void disposeThemers() {
        for (Control control : this.themedControls) {
            this.themeFactory.dispose(control);
        }
    }

    private void updateThemeColor() {
        if (this.getBackgroundColor() != null) {
            if (this.scrolledComposite != null) {
                this.scrolledComposite.setBackground(this.getBackgroundColor());
            }
            if (this.expandBar != null) {
                this.expandBar.setBackground(this.getBackgroundColor());
            }
        }
    }

    private Color getBackgroundColor() {
        return this.themeBgColor != null ? this.themeBgColor : UIUtils.getDisplay().getSystemColor(1);
    }

    private void updateBindingDrawers() {
        for (ExpandItem item : this.expandItems.values()) {
            Composite control = (Composite)item.getControl();
            control.layout(true, true);
            item.setHeight(control.computeSize((int)-1, (int)-1).y);
        }
    }

    protected ExpandItem createBindingDrawer(ExpandBar expandBar, BindingCategoryElement category, List<BindingData> snippets) {
        Composite composite = new Composite((Composite)expandBar, 0);
        composite.setForeground(this.themeFgColor != null ? this.themeFgColor : UIUtils.getDisplay().getSystemColor(23));
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        ExpandItem expandItem = new ExpandItem(expandBar, 0);
        int size = 0;
        if (snippets != null) {
            size = snippets.size();
        }
        expandItem.setText(MessageFormat.format(Messages.SnippetsView_Snippet_drawer_title, category.getDisplayName(), String.valueOf(size)));
        expandItem.setControl((Control)composite);
        expandItem.setData((Object)(category != null ? category.getDisplayName() : null));
        expandItem.setHeight(composite.computeSize((int)-1, (int)-1).y);
        this.expandItems.put(category != null ? category.getDisplayName() : null, expandItem);
        return expandItem;
    }

    private void initializeToolBar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.add((IContributionItem)new ControlContribution("change.schemes"){

            protected Control createControl(Composite parent) {
                Scheme[] schemes;
                Composite c = new Composite(parent, 0);
                c.setLayout((Layout)new FillLayout());
                BindingsView.this.schemesCombo = new Combo(c, 2056);
                int height = 9;
                if (PlatformUtil.isMac()) {
                    height = 14;
                }
                BindingsView.this.schemesCombo.setFont(new Font((Device)parent.getDisplay(), "consolas", height, 0));
                final BindingManager bindingManager = BindingsView.this.getBindingManager();
                Scheme[] schemeArray = schemes = bindingManager.getDefinedSchemes();
                int n = schemes.length;
                int n2 = 0;
                while (n2 < n) {
                    Scheme scheme = schemeArray[n2];
                    try {
                        BindingsView.this.schemesCombo.add(scheme.getName());
                        BindingsView.this.schemesCombo.setData(scheme.getName(), (Object)scheme.getId());
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)WorkbenchPlugin.getDefault(), (Throwable)e);
                    }
                    ++n2;
                }
                BindingsView.this.schemesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            if (!BindingsView.this.schemesCombo.getData(BindingsView.this.schemesCombo.getText()).equals(bindingManager.getActiveScheme().getId())) {
                                boolean result = MessageDialog.openConfirm((Shell)BindingsView.this.getSite().getShell(), (String)"\u63d0\u793a", (String)("\u662f\u5426\u786e\u8ba4\u5207\u6362\u5230\"" + BindingsView.this.schemesCombo.getText() + "\"\u5feb\u6377\u952e\u65b9\u6848?"));
                                if (result) {
                                    Scheme[] schemes = bindingManager.getDefinedSchemes();
                                    String id = (String)BindingsView.this.schemesCombo.getData(BindingsView.this.schemesCombo.getText());
                                    Scheme[] schemeArray = schemes;
                                    int n = schemes.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Scheme scheme = schemeArray[n2];
                                        if (scheme.getId().equals(id)) {
                                            bindingManager.setActiveScheme(scheme);
                                            return;
                                        }
                                        ++n2;
                                    }
                                } else {
                                    BindingsView.this.schemesCombo.setText(bindingManager.getActiveScheme().getName());
                                }
                            }
                        }
                        catch (NotDefinedException ex) {
                            IdeLog.logError((Plugin)WorkbenchPlugin.getDefault(), (Throwable)ex);
                        }
                    }
                });
                try {
                    BindingsView.this.schemesCombo.setText(bindingManager.getActiveScheme().getName());
                }
                catch (NotDefinedException e) {
                    IdeLog.logError((Plugin)WorkbenchPlugin.getDefault(), (Throwable)e);
                }
                BindingsView.this.schemesCombo.setToolTipText("\u5207\u6362\u5feb\u6377\u952e\u65b9\u6848");
                return c;
            }
        });
        Action collapseAll = new Action(){

            public void run() {
                for (ExpandItem item : BindingsView.this.expandItems.values()) {
                    boolean expanded = item.getExpanded();
                    item.setExpanded(false);
                    if (!expanded) continue;
                    BindingsView.this.updateScrollMinSize(item, false);
                }
            }
        };
        collapseAll.setText(Messages.SnippetsView_Collapse_All_Action);
        collapseAll.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_COLLAPSEALL"));
        toolbarManager.add((IAction)collapseAll);
        Action expandAll = new Action(){

            public void run() {
                for (ExpandItem item : BindingsView.this.expandItems.values()) {
                    boolean expanded = item.getExpanded();
                    BindingsView.this.expandDrawer((String)item.getData(), true);
                    if (expanded) continue;
                    BindingsView.this.updateScrollMinSize(item, true);
                }
            }
        };
        expandAll.setText(Messages.SnippetsView_Expand_All_Action);
        expandAll.setImageDescriptor(ScriptingUIPlugin.getImageDescriptor((String)ICONS_FULL_ELCL16_EXPANDALL_GIF));
        toolbarManager.add((IAction)expandAll);
    }

    public void dispose() {
        EclipseUtil.instanceScope().getNode("com.aptana.theme").removePreferenceChangeListener(this.themeListener);
        this.bindingsListener.dispose();
        super.dispose();
        this.colorManager.dispose();
        this.disposeThemers();
    }

    public void setFocus() {
        this.expandBar.setFocus();
    }

    private BindingManager getBindingManager() {
        if (this.bindingManager == null) {
            return ((BindingService)PlatformUI.getWorkbench().getService(IBindingService.class)).getBindingManager();
        }
        return this.bindingManager;
    }

    private void initConfigBindings() {
        block9: {
            this.configBindingElements.clear();
            this.configCategorysAndBindingElementMap.clear();
            this.configBindingCategorieElements.clear();
            InputStream in = null;
            try {
                try {
                    Bundle bundle = WorkbenchPlugin.getDefault().getBundle();
                    Path path = new Path("/config/bindings.xml");
                    URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
                    in = url.openStream();
                    SAXReader saxReader = new SAXReader();
                    saxReader.setEncoding("utf-8");
                    Document doc = saxReader.read(in);
                    List categorys = doc.selectNodes("//category");
                    boolean hasOther = false;
                    for (Element category : categorys) {
                        String name = category.attributeValue("name");
                        if (name.equals(OTHER_CATEGORIE)) {
                            hasOther = true;
                        }
                        List bindings = category.selectNodes("binding");
                        ArrayList<BindingElement> idList = new ArrayList<BindingElement>();
                        for (Element binding : bindings) {
                            String id = binding.attributeValue("id");
                            if (!StringUtil.isNotBlank((String)id)) continue;
                            BindingElement bindingElement = new BindingElement(id, binding.attributeValue("name"), binding.attributeValue("parameterId"), binding.attributeValue("parameterValue"));
                            this.configBindingElements.add(bindingElement);
                            idList.add(bindingElement);
                        }
                        BindingCategoryElement categoryElement = new BindingCategoryElement(name, category.attributeValue("icon"));
                        this.configCategorysAndBindingElementMap.put(categoryElement, idList);
                        this.configBindingCategorieElements.add(categoryElement);
                    }
                    if (!hasOther) {
                        BindingCategoryElement otherCategory = new BindingCategoryElement(OTHER_CATEGORIE, null);
                        this.configCategorysAndBindingElementMap.put(otherCategory, new ArrayList());
                        this.configBindingCategorieElements.add(otherCategory);
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)WorkbenchPlugin.getDefault(), (Throwable)e);
                    IOUtils.closeQuietly(in);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    class BindingData {
        private String name;
        private String keys;
        private String category;
        private String scheme;
        private boolean visuallyEnabled = true;
        private boolean filtered = false;
        private String parameterId;
        private String parameterValue;

        public BindingData(String name, String keys, String category, String scheme, String parameterId, String parameterValue) {
            this.name = name;
            this.keys = keys;
            this.category = category;
            this.scheme = scheme;
            this.parameterId = parameterId;
            this.parameterValue = parameterValue;
        }

        public String getName() {
            return this.name;
        }

        public String getKeys() {
            return this.keys;
        }

        public String getCategory() {
            return this.category;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getParameterId() {
            return this.parameterId;
        }

        public void setParameterId(String parameterId) {
            this.parameterId = parameterId;
        }

        public String getParameterValue() {
            return this.parameterValue;
        }

        public void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }
    }

    private class BindingItem
    extends Composite {
        private BindingData bindingData;
        private Composite textComposite;
        private CLabel nameLabel;
        private CLabel keysLabel;
        final int BINDING_MARGIN = 5;

        BindingItem(Composite parent, BindingData bindingData) {
            super(parent, 0);
            this.BINDING_MARGIN = 5;
            this.bindingData = bindingData;
            this.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(5, 5, 1, 5).spacing(2, 0).numColumns(3).create());
            GridData gridData = GridDataFactory.fillDefaults().grab(true, false).create();
            gridData.exclude = bindingData.filtered;
            this.setLayoutData(gridData);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Color foreground = e.gc.getForeground();
                    e.gc.setForeground(BindingsView.this.colorManager.getColor(Theme.alphaBlend((RGB)BindingItem.this.getBackground().getRGB(), (RGB)BindingItem.this.getForeground().getRGB(), (int)100)));
                    Rectangle clientArea = BindingItem.this.getClientArea();
                    e.gc.drawLine(clientArea.x - 5, clientArea.y + clientArea.height - 2, clientArea.x + clientArea.width + 5, clientArea.y + clientArea.height - 2);
                    e.gc.drawLine(clientArea.x, clientArea.y, clientArea.x, clientArea.y + clientArea.height - 1);
                    e.gc.drawLine(clientArea.x + clientArea.width - 1, clientArea.y, clientArea.x + clientArea.width - 1, clientArea.y + clientArea.height - 1);
                    Point newPoint = UIUtils.getDisplay().map((Control)BindingItem.this, (Control)BindingItem.this.getParent(), new Point(clientArea.x, clientArea.y));
                    if (newPoint.y == 0) {
                        e.gc.drawLine(clientArea.x - 5, clientArea.y, clientArea.x + clientArea.width + 5, clientArea.y);
                    }
                    e.gc.setForeground(foreground);
                }
            });
            BindingsView.this.addThemedControl((Control)this, 0, -1);
            this.addNameAndKeysForBinding(bindingData, this);
            this.applyVisualEnablement();
            this.setBackground(BindingsView.this.getBackgroundColor());
        }

        protected void setFiltered(boolean filtered) {
            this.bindingData.filtered = filtered;
            this.applyFiltered();
        }

        protected void applyFiltered() {
            this.setVisible(!this.bindingData.filtered);
            ((GridData)this.getLayoutData()).exclude = this.bindingData.filtered;
        }

        protected void applyVisualEnablement() {
            if (this.bindingData.visuallyEnabled) {
                this.nameLabel.setForeground(BindingsView.this.themeFgColor);
            } else {
                this.nameLabel.setForeground(this.keysLabel.getForeground());
            }
        }

        private void addNameAndKeysForBinding(BindingData binding, Composite itemComposite) {
            this.textComposite = new Composite(itemComposite, 0);
            this.textComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(3, 0).numColumns(2).create());
            this.textComposite.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 0x1000000).grab(true, false).create());
            this.textComposite.setBackground(BindingsView.this.getBackgroundColor());
            BindingsView.this.addThemedControl((Control)this.textComposite, 0, -1);
            this.nameLabel = new CLabel(this.textComposite, 0);
            this.nameLabel.setText(binding.name);
            this.nameLabel.setToolTipText(binding.keys);
            this.nameLabel.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).create());
            this.nameLabel.setBackground(BindingsView.this.getBackgroundColor());
            BindingsView.this.addThemedControl((Control)this.nameLabel, 1, -1);
            this.keysLabel = new CLabel(this.textComposite, 0);
            String descText = binding.keys;
            this.keysLabel.setText(descText);
            this.keysLabel.setToolTipText(descText);
            this.keysLabel.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 0x1000000).grab(true, false).create());
            this.keysLabel.setBackground(BindingsView.this.getBackgroundColor());
            BindingsView.this.addThemedControl((Control)this.keysLabel, 0, 128);
        }
    }

    class BindingListener
    implements IBindingManagerListener {
        private final Job job = new Job("Force reconcile on keys change"){

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (BindingsView.this.schemesCombo != null && !BindingsView.this.schemesCombo.isDisposed()) {
                                BindingsView.this.schemesCombo.setText(BindingsView.this.getBindingManager().getActiveScheme().getName());
                            }
                        }
                        catch (Throwable e) {
                            IdeLog.logError((Plugin)WorkbenchPlugin.getDefault(), (Throwable)e);
                        }
                        if (BindingsView.this.scrolledComposite != null && !BindingsView.this.scrolledComposite.isDisposed()) {
                            BindingsView.this.createBindingsDrawers();
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };

        public BindingListener() {
            BindingsView.this.getBindingManager().addBindingManagerListener((IBindingManagerListener)this);
        }

        public void dispose() {
            BindingsView.this.getBindingManager().removeBindingManagerListener((IBindingManagerListener)this);
        }

        public void bindingManagerChanged(BindingManagerEvent event) {
            if (event.isActiveSchemeChanged()) {
                this.job.cancel();
                EclipseUtil.setSystemForJob((Job)this.job);
                this.job.schedule(750L);
            }
        }
    }

    private class FilterBindingsJob
    extends Job {
        List<BindingData> bindings;

        public FilterBindingsJob(List<BindingData> newSnippets) {
            super("\u8fc7\u6ee4\u5feb\u6377\u952e");
            this.bindings = new ArrayList<BindingData>();
            this.bindings.addAll(newSnippets);
        }

        protected IStatus run(IProgressMonitor monitor) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BindingsView.this.showBindings(FilterBindingsJob.this.bindings);
                }
            });
            return Status.OK_STATUS;
        }
    }
}

