/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.viewer;

import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class CommonSourceViewerDecorationSupport
extends SourceViewerDecorationSupport {
    private ISourceViewer fSourceViewer = null;

    public CommonSourceViewerDecorationSupport(ISourceViewer sourceViewer, IOverviewRuler overviewRuler, IAnnotationAccess annotationAccess, ISharedTextColors sharedTextColors) {
        super(sourceViewer, overviewRuler, annotationAccess, sharedTextColors);
        this.fSourceViewer = sourceViewer;
    }

    protected ISourceViewer getSourceViewer() {
        return this.fSourceViewer;
    }

    protected AnnotationPainter createAnnotationPainter() {
        AnnotationPainter painter = super.createAnnotationPainter();
        painter.addDrawingStrategy((Object)"BOX", (AnnotationPainter.IDrawingStrategy)new CornerDrawingStrategy());
        return painter;
    }

    private class CornerDrawingStrategy
    implements AnnotationPainter.IDrawingStrategy {
        private CornerDrawingStrategy() {
        }

        public void draw(Annotation annotation, GC gc, StyledText textWidget, int offset, int length, Color color) {
            if (length < 1) {
                return;
            }
            int startOffset = CommonSourceViewerDecorationSupport.this.fSourceViewer.getTopIndexStartOffset();
            int endOffset = CommonSourceViewerDecorationSupport.this.fSourceViewer.getBottomIndexEndOffset();
            if (offset + length <= startOffset || offset >= endOffset) {
                return;
            }
            Rectangle clientArea = textWidget.getClientArea();
            Point left = textWidget.getLocationAtOffset(offset);
            int x1 = left.x;
            int y1 = left.y;
            if (!clientArea.contains(left)) {
                return;
            }
            Point right = textWidget.getLocationAtOffset(offset + length);
            int x2 = right.x;
            if (!clientArea.contains(right)) {
                return;
            }
            annotation.setText("");
            int lineHeight = textWidget.getLineHeight(offset);
            if (gc != null) {
                gc.setForeground(color);
                gc.drawRoundRectangle(x1, y1, x2 - x1, lineHeight - 1, 4, 4);
            } else {
                textWidget.redraw(x1 - 1, y1, x2 - x1 + 2, lineHeight, true);
            }
        }
    }
}

