/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.rules;

import com.aptana.editor.common.text.rules.ResumableMultiLineRule;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.Token;

public class TagRule
extends ResumableMultiLineRule {
    private static final IToken singleQuoteStringTOKEN = new Token((Object)"SQS");
    private static final IPredicateRule singleQuoteStringRule = new MultiLineRule("'", "'", singleQuoteStringTOKEN, '\\');
    private static final IPredicateRule singleQuoteStringEOLRule = new EndOfLineRule("'", singleQuoteStringTOKEN, '\\');
    private static final IToken doubleQuoteStringTOKEN = new Token((Object)"DQS");
    private static final IPredicateRule doubleQuoteStringRule = new MultiLineRule("\"", "\"", doubleQuoteStringTOKEN, '\\');
    private static final IPredicateRule doubleQuoteStringEOLRule = new EndOfLineRule("\"", doubleQuoteStringTOKEN, '\\');
    private final boolean fIgnoreCase;

    public TagRule(IToken token) {
        this("", token);
    }

    public TagRule(String tag, IToken token) {
        this(tag, token, false);
    }

    public TagRule(String tag, IToken token, boolean ignoreCase) {
        this("<" + tag, ">", token, ignoreCase);
    }

    protected TagRule(String startSequence, String endSequence, IToken token, boolean ignoreCase) {
        super(startSequence, endSequence, token, '\u0000', true);
        this.fIgnoreCase = ignoreCase;
    }

    protected boolean sequenceDetected(ICharacterScanner scanner, char[] sequence, boolean eofAllowed) {
        int i = 1;
        while (i < sequence.length) {
            int c = scanner.read();
            if (c == -1 && eofAllowed) break;
            if (this.fIgnoreCase && Character.toLowerCase(c) != Character.toLowerCase(sequence[i]) || !this.fIgnoreCase && c != sequence[i]) {
                scanner.unread();
                int j = i - 1;
                while (j > 0) {
                    scanner.unread();
                    --j;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected boolean doDetectEndSequence(ICharacterScanner scanner) {
        int c;
        while ((c = scanner.read()) != -1) {
            IToken token;
            if (c == 39) {
                scanner.unread();
                token = singleQuoteStringRule.evaluate(scanner);
                if (!token.isUndefined()) continue;
                token = singleQuoteStringEOLRule.evaluate(scanner);
                continue;
            }
            if (c == 34) {
                scanner.unread();
                token = doubleQuoteStringRule.evaluate(scanner);
                if (!token.isUndefined()) continue;
                token = doubleQuoteStringEOLRule.evaluate(scanner);
                continue;
            }
            if ((c != this.fEndSequence[0] || !this.sequenceDetected(scanner, this.fEndSequence, this.fBreaksOnEOF)) && c != this.fStartSequence[0]) continue;
            if (c != this.fStartSequence[0]) break;
            scanner.unread();
            break;
        }
        return true;
    }
}

