/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.rules;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public abstract class ExtendedWordRule
extends WordRule {
    private final StringBuffer buffer = new StringBuffer();
    private final boolean ignoreCase;

    protected ExtendedWordRule(IWordDetector detector, IToken defaultToken, boolean ignoreCase) {
        super(detector, defaultToken, ignoreCase);
        this.ignoreCase = ignoreCase;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (c != -1 && this.fDetector.isWordStart((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            this.buffer.setLength(0);
            do {
                this.buffer.append((char)c);
            } while ((c = scanner.read()) != -1 && this.fDetector.isWordPart((char)c));
            scanner.unread();
            String word = this.buffer.toString();
            if (this.ignoreCase) {
                word = word.toLowerCase();
            }
            if (!this.wordOK(word, scanner)) {
                this.unreadBuffer(scanner);
                return Token.UNDEFINED;
            }
            IToken token = this.getWordToken(word);
            if (token == null) {
                token = (IToken)this.fWords.get(word);
            }
            if (token != null) {
                return token;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.fDefaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    protected boolean wordOK(String word, ICharacterScanner scanner) {
        return true;
    }

    protected IToken getWordToken(String word) {
        return null;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        int i = this.buffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }
}

