/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.hyperlink;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.URLEncoder;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.text.hyperlink.Messages;
import com.aptana.editor.common.util.EditorUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.URLHyperlink;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class URIHyperlink
extends URLHyperlink {
    private URI uri;
    private boolean wrapped;

    public URIHyperlink(IRegion region, URI uri) {
        super(region, uri.toString());
        this.uri = uri;
    }

    public URIHyperlink(URLHyperlink hyperlink) throws URISyntaxException, MalformedURLException {
        this(hyperlink.getHyperlinkRegion(), URLEncoder.encode((URL)new URL(hyperlink.getURLString())).toURI());
        this.wrapped = true;
    }

    public void open() {
        block6: {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (EditorUtil.hackedJavaScriptEditor(page, this.uri) != null) {
                    return;
                }
                IEditorDescriptor desc = this.getEditorDescriptor();
                if (desc == null) {
                    if (this.wrapped) {
                        super.open();
                        return;
                    }
                    IDE.openEditor((IWorkbenchPage)page, (URI)this.uri, (String)"org.eclipse.ui.systemExternalEditor", (boolean)true);
                    return;
                }
                File file = new File(this.uri);
                if (file.exists()) {
                    IDE.openEditor((IWorkbenchPage)page, (URI)this.uri, (String)desc.getId(), (boolean)true);
                }
            }
            catch (Exception e) {
                IdeLog.logInfo((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Unable to open the url ''{0}'' in an editor", this.uri), (Throwable)e, (String)"com.aptana.editor.common/debug");
                if (!this.wrapped) break block6;
                super.open();
            }
        }
    }

    public boolean hasAssociatedEditor() {
        return this.getEditorDescriptor() != null;
    }

    protected IEditorDescriptor getEditorDescriptor() {
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        if (this.uri.getPath() == null || this.uri.getPath().equals("/") || this.uri.getPath().trim().equals("")) {
            return null;
        }
        Path path = new Path(this.uri.getPath());
        return editorReg.getDefaultEditor(path.lastSegment());
    }

    public String getHyperlinkText() {
        if (this.wrapped) {
            return super.getHyperlinkText();
        }
        return MessageFormat.format(Messages.URIHyperlink_Open_In_Editor, this.getURLString());
    }

    public URI getUri() {
        return this.uri;
    }
}

