/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.scripting.commands;

import com.aptana.editor.common.scripting.commands.EnvironmentDialog;
import com.aptana.editor.common.scripting.commands.Messages;
import com.aptana.scripting.model.InputType;
import com.aptana.scripting.model.OutputType;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FilterThroughCommandDialog
extends Dialog {
    private Map<String, String> environment;
    private Combo commandCombo;
    private String command;
    private static List<String> lastCommands = new LinkedList<String>();
    private Button noneButton;
    private Button selectionButton;
    private Button selectedLinesButton;
    private Button documentButton;
    private Button lineButton;
    private Button wordButton;
    private Button clipboardButton;
    private Button inputFromConsoleButton;
    private InputType inputType;
    private static InputType lastInputType = InputType.NONE;
    private Button discardButton;
    private Button replaceSelectionButton;
    private Button replaceSelectedLinesButton;
    private Button replaceLineButton;
    private Button replaceWordButton;
    private Button replaceDocumentButton;
    private Button insertAsTextButton;
    private Button insertAsSnippetButton;
    private Button showAsHTMLButton;
    private Button showAsToolTipButton;
    private Button copyToClipboardButton;
    private Button createNewDocumentButton;
    private Button outputToConsoleButton;
    private OutputType outputType;
    private static OutputType lastOutputType = OutputType.OUTPUT_TO_CONSOLE;

    public FilterThroughCommandDialog(Shell parentShell, Map<String, String> environment) {
        super(parentShell);
        this.environment = environment;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout compositeGridLayout = new GridLayout(3, false);
        composite.setLayout((Layout)compositeGridLayout);
        Label commandLabel = new Label(composite, 131072);
        commandLabel.setText(Messages.FilterThroughCommandDialog_LBL_Command);
        GridData commandLabelGridData = new GridData(16384, 128, false, false);
        commandLabel.setLayoutData((Object)commandLabelGridData);
        this.commandCombo = new Combo(composite, 0);
        GridData commandComboGridData = new GridData(4, 128, true, false);
        commandComboGridData.horizontalSpan = 2;
        this.commandCombo.setLayoutData((Object)commandComboGridData);
        Label padding = new Label(composite, 0);
        GridData paddingGridData = new GridData(16384, 128, false, false);
        padding.setLayoutData((Object)paddingGridData);
        Group inputGroup = new Group(composite, 0);
        inputGroup.setText(Messages.FilterThroughCommandDialog_LBL_Input);
        GridData inputGroupGridData = new GridData(4, 4, true, true);
        inputGroup.setLayoutData((Object)inputGroupGridData);
        inputGroup.setLayout((Layout)new RowLayout(512));
        this.noneButton = new Button((Composite)inputGroup, 16);
        this.noneButton.setText(Messages.FilterThroughCommandDialog_LBL_None);
        this.selectionButton = new Button((Composite)inputGroup, 16);
        this.selectionButton.setText(Messages.FilterThroughCommandDialog_LBL_Selection);
        this.selectedLinesButton = new Button((Composite)inputGroup, 16);
        this.selectedLinesButton.setText(Messages.FilterThroughCommandDialog_LBL_SelectedLines);
        this.documentButton = new Button((Composite)inputGroup, 16);
        this.documentButton.setText(Messages.FilterThroughCommandDialog_LBL_Document);
        this.lineButton = new Button((Composite)inputGroup, 16);
        this.lineButton.setText(Messages.FilterThroughCommandDialog_LBL_Line);
        this.wordButton = new Button((Composite)inputGroup, 16);
        this.wordButton.setText(Messages.FilterThroughCommandDialog_LBL_Word);
        this.clipboardButton = new Button((Composite)inputGroup, 16);
        this.clipboardButton.setText(Messages.FilterThroughCommandDialog_LBL_Clipboard);
        this.inputFromConsoleButton = new Button((Composite)inputGroup, 16);
        this.inputFromConsoleButton.setText(Messages.FilterThroughCommandDialog_LBL_FromConsole);
        Group outputGroup = new Group(composite, 0);
        outputGroup.setText(Messages.FilterThroughCommandDialog_LBL_Output);
        GridData outputGroupGridData = new GridData(4, 4, true, true);
        outputGroupGridData.verticalSpan = 2;
        outputGroup.setLayoutData((Object)outputGroupGridData);
        outputGroup.setLayout((Layout)new RowLayout(512));
        this.discardButton = new Button((Composite)outputGroup, 16);
        this.discardButton.setText(Messages.FilterThroughCommandDialog_LBL_Discard);
        this.replaceSelectionButton = new Button((Composite)outputGroup, 16);
        this.replaceSelectionButton.setText(Messages.FilterThroughCommandDialog_LBL_ReplaceSelection);
        this.replaceSelectedLinesButton = new Button((Composite)outputGroup, 16);
        this.replaceSelectedLinesButton.setText(Messages.FilterThroughCommandDialog_LBL_ReplaceSelectedLines);
        this.replaceLineButton = new Button((Composite)outputGroup, 16);
        this.replaceLineButton.setText(Messages.FilterThroughCommandDialog_LBL_ReplaceLine);
        this.replaceWordButton = new Button((Composite)outputGroup, 16);
        this.replaceWordButton.setText(Messages.FilterThroughCommandDialog_LBL_ReplaceWord);
        this.replaceDocumentButton = new Button((Composite)outputGroup, 16);
        this.replaceDocumentButton.setText(Messages.FilterThroughCommandDialog_LBL_ReplaceDocument);
        this.insertAsTextButton = new Button((Composite)outputGroup, 16);
        this.insertAsTextButton.setText(Messages.FilterThroughCommandDialog_LBL_InsertAsText);
        this.insertAsSnippetButton = new Button((Composite)outputGroup, 16);
        this.insertAsSnippetButton.setText(Messages.FilterThroughCommandDialog_LBL_InsertAsSnippet);
        this.showAsHTMLButton = new Button((Composite)outputGroup, 16);
        this.showAsHTMLButton.setText(Messages.FilterThroughCommandDialog_LBL_ShowAsHTML);
        this.showAsToolTipButton = new Button((Composite)outputGroup, 16);
        this.showAsToolTipButton.setText(Messages.FilterThroughCommandDialog_LBL_ShowAsToolTip);
        this.copyToClipboardButton = new Button((Composite)outputGroup, 16);
        this.copyToClipboardButton.setText(Messages.FilterThroughCommandDialog_LBL_CopyToClipboard);
        this.createNewDocumentButton = new Button((Composite)outputGroup, 16);
        this.createNewDocumentButton.setText(Messages.FilterThroughCommandDialog_LBL_CreateNewDocument);
        this.outputToConsoleButton = new Button((Composite)outputGroup, 16);
        this.outputToConsoleButton.setText(Messages.FilterThroughCommandDialog_LBL_ToConsole);
        padding = new Label(composite, 0);
        paddingGridData = new GridData(16384, 128, false, false);
        padding.setLayoutData((Object)paddingGridData);
        Button showEnvironmentButton = new Button(composite, 8);
        showEnvironmentButton.setText(Messages.FilterThroughCommandDialog_LBL_ShowEnvironment);
        GridData showEnvironmentButtonGridData = new GridData(4, 128, true, false);
        showEnvironmentButton.setLayoutData((Object)showEnvironmentButtonGridData);
        showEnvironmentButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EnvironmentDialog environmentDialog = new EnvironmentDialog(FilterThroughCommandDialog.this.getShell(), FilterThroughCommandDialog.this.environment);
                environmentDialog.open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Label consoleLabel = new Label(composite, 0);
        consoleLabel.setText(Messages.FilterThroughCommandDialog_LBL_ConsoleName);
        GridData consoleLabelGridData = new GridData(16384, 0x1000000, false, false);
        consoleLabel.setLayoutData((Object)consoleLabelGridData);
        this.applyState();
        return composite;
    }

    public String getCommand() {
        return this.command;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public OutputType getOuputType() {
        return this.outputType;
    }

    protected void okPressed() {
        this.command = this.commandCombo.getText();
        if (this.command.trim().length() == 0) {
            this.getShell().getDisplay().beep();
            return;
        }
        lastCommands.add(0, this.command);
        if (this.noneButton.getSelection()) {
            this.inputType = InputType.NONE;
        } else if (this.selectionButton.getSelection()) {
            this.inputType = InputType.SELECTION;
        } else if (this.selectedLinesButton.getSelection()) {
            this.inputType = InputType.SELECTED_LINES;
        } else if (this.documentButton.getSelection()) {
            this.inputType = InputType.DOCUMENT;
        } else if (this.lineButton.getSelection()) {
            this.inputType = InputType.LINE;
        } else if (this.wordButton.getSelection()) {
            this.inputType = InputType.WORD;
        } else if (this.inputFromConsoleButton.getSelection()) {
            this.inputType = InputType.INPUT_FROM_CONSOLE;
        } else if (this.clipboardButton.getSelection()) {
            this.inputType = InputType.CLIPBOARD;
        }
        if (this.discardButton.getSelection()) {
            this.outputType = OutputType.DISCARD;
        } else if (this.replaceSelectionButton.getSelection()) {
            this.outputType = OutputType.REPLACE_SELECTION;
        } else if (this.replaceSelectedLinesButton.getSelection()) {
            this.outputType = OutputType.REPLACE_SELECTED_LINES;
        } else if (this.replaceDocumentButton.getSelection()) {
            this.outputType = OutputType.REPLACE_DOCUMENT;
        } else if (this.replaceLineButton.getSelection()) {
            this.outputType = OutputType.REPLACE_LINE;
        } else if (this.replaceWordButton.getSelection()) {
            this.outputType = OutputType.REPLACE_WORD;
        } else if (this.insertAsTextButton.getSelection()) {
            this.outputType = OutputType.INSERT_AS_TEXT;
        } else if (this.insertAsSnippetButton.getSelection()) {
            this.outputType = OutputType.INSERT_AS_SNIPPET;
        } else if (this.showAsHTMLButton.getSelection()) {
            this.outputType = OutputType.SHOW_AS_HTML;
        } else if (this.showAsToolTipButton.getSelection()) {
            this.outputType = OutputType.SHOW_AS_TOOLTIP;
        } else if (this.createNewDocumentButton.getSelection()) {
            this.outputType = OutputType.CREATE_NEW_DOCUMENT;
        } else if (this.outputToConsoleButton.getSelection()) {
            this.outputType = OutputType.OUTPUT_TO_CONSOLE;
        } else if (this.copyToClipboardButton.getSelection()) {
            this.outputType = OutputType.COPY_TO_CLIPBOARD;
        }
        this.saveState();
        super.okPressed();
    }

    private void applyState() {
        switch (lastInputType) {
            case NONE: {
                this.noneButton.setSelection(true);
                break;
            }
            case SELECTION: {
                this.selectionButton.setSelection(true);
                break;
            }
            case SELECTED_LINES: {
                this.selectedLinesButton.setSelection(true);
                break;
            }
            case DOCUMENT: {
                this.documentButton.setSelection(true);
                break;
            }
            case LINE: {
                this.lineButton.setSelection(true);
                break;
            }
            case WORD: {
                this.wordButton.setSelection(true);
                break;
            }
            case CLIPBOARD: {
                this.clipboardButton.setSelection(true);
                break;
            }
            case INPUT_FROM_CONSOLE: {
                this.inputFromConsoleButton.setSelection(true);
            }
        }
        switch (lastOutputType) {
            case DISCARD: {
                this.discardButton.setSelection(true);
                break;
            }
            case REPLACE_SELECTION: {
                this.replaceSelectionButton.setSelection(true);
                break;
            }
            case REPLACE_SELECTED_LINES: {
                this.replaceSelectedLinesButton.setSelection(true);
                break;
            }
            case REPLACE_DOCUMENT: {
                this.replaceDocumentButton.setSelection(true);
                break;
            }
            case REPLACE_LINE: {
                this.replaceLineButton.setSelection(true);
                break;
            }
            case REPLACE_WORD: {
                this.replaceWordButton.setSelection(true);
                break;
            }
            case CREATE_NEW_DOCUMENT: {
                this.createNewDocumentButton.setSelection(true);
                break;
            }
            case SHOW_AS_HTML: {
                this.showAsHTMLButton.setSelection(true);
                break;
            }
            case SHOW_AS_TOOLTIP: {
                this.showAsToolTipButton.setSelection(true);
                break;
            }
            case COPY_TO_CLIPBOARD: {
                this.copyToClipboardButton.setSelection(true);
                break;
            }
            case OUTPUT_TO_CONSOLE: {
                this.outputToConsoleButton.setSelection(true);
                break;
            }
            case INSERT_AS_TEXT: {
                this.insertAsTextButton.setSelection(true);
                break;
            }
            case INSERT_AS_SNIPPET: {
                this.insertAsSnippetButton.setSelection(true);
            }
        }
        if (lastCommands.size() > 0) {
            this.commandCombo.setItems(lastCommands.toArray(new String[lastCommands.size()]));
            this.commandCombo.select(0);
        }
    }

    private void saveState() {
        lastInputType = this.inputType;
        lastOutputType = this.outputType;
    }
}

