/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.properties;

import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.properties.AdaptableTextSelection;
import com.aptana.editor.common.properties.IEditorPropertyConstants;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.scope.IScopeSelector;
import com.aptana.scope.ScopeSelector;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import com.aptana.theme.ThemeRule;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class EditorPropertySource
implements IPropertySource {
    protected static IPropertyDescriptor[] propertyDescriptors;
    private final IAdaptable adaptableObject;

    static {
        PropertyDescriptor descriptor1 = new PropertyDescriptor((Object)"com.aptana.editor.common.content.type", IEditorPropertyConstants.CONTENT_TYPE_LABEL);
        descriptor1.setAlwaysIncompatible(true);
        descriptor1.setCategory(IEditorPropertyConstants.EDITOR_INFO_CATEGORY);
        PropertyDescriptor descriptor2 = new PropertyDescriptor((Object)"com.aptana.editor.common.scope", IEditorPropertyConstants.SCOPE_LABEL);
        descriptor2.setAlwaysIncompatible(true);
        descriptor2.setCategory(IEditorPropertyConstants.EDITOR_INFO_CATEGORY);
        PropertyDescriptor descriptor3 = new PropertyDescriptor((Object)"com.aptana.editor.common.key", IEditorPropertyConstants.TEXT_LABEL);
        descriptor3.setAlwaysIncompatible(true);
        descriptor3.setCategory(IEditorPropertyConstants.EDITOR_INFO_CATEGORY);
        PropertyDescriptor descriptor4 = new PropertyDescriptor((Object)"com.aptana.editor.common.offset.start", IEditorPropertyConstants.OFFSET_START_LABEL);
        descriptor4.setAlwaysIncompatible(true);
        descriptor4.setCategory(IEditorPropertyConstants.EDITOR_INFO_CATEGORY);
        PropertyDescriptor descriptor5 = new PropertyDescriptor((Object)"com.aptana.editor.common.offset.end", IEditorPropertyConstants.OFFSET_END_LABEL);
        descriptor5.setAlwaysIncompatible(true);
        descriptor5.setCategory(IEditorPropertyConstants.EDITOR_INFO_CATEGORY);
        PropertyDescriptor descriptor6 = new PropertyDescriptor((Object)"com.aptana.editor.common.length", IEditorPropertyConstants.LENGTH_LABEL);
        descriptor6.setAlwaysIncompatible(true);
        descriptor6.setCategory(IEditorPropertyConstants.EDITOR_INFO_CATEGORY);
        PropertyDescriptor descriptor7 = new PropertyDescriptor((Object)"com.aptana.editor.common.theme", IEditorPropertyConstants.THEME_LABEL);
        descriptor7.setAlwaysIncompatible(true);
        descriptor7.setCategory(IEditorPropertyConstants.EDITOR_INFO_CATEGORY);
        propertyDescriptors = new IPropertyDescriptor[]{descriptor1, descriptor2, descriptor3, descriptor4, descriptor5, descriptor6, descriptor7};
    }

    public EditorPropertySource(IAdaptable adaptableObject) {
        this.adaptableObject = adaptableObject;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return propertyDescriptors;
    }

    public Object getPropertyValue(Object key) {
        if (!(this.adaptableObject instanceof AdaptableTextSelection)) {
            return null;
        }
        try {
            ISourceViewer viewer = ((AdaptableTextSelection)this.adaptableObject).getViewer();
            IDocument document = viewer.getDocument();
            int offset = ((AdaptableTextSelection)this.adaptableObject).getOffset();
            int length = ((AdaptableTextSelection)this.adaptableObject).getLength();
            QualifiedContentType contentType = CommonEditorPlugin.getDefault().getDocumentScopeManager().getContentType(document, offset);
            String scope = CommonEditorPlugin.getDefault().getDocumentScopeManager().getScopeAtOffset((ITextViewer)viewer, offset);
            if (key.equals("com.aptana.editor.common.content.type") && contentType.getPartCount() > 0) {
                return contentType.getParts()[0];
            }
            if (key.equals("com.aptana.editor.common.scope")) {
                return scope;
            }
            if (key.equals("com.aptana.editor.common.key")) {
                return document.get(offset, length);
            }
            if (key.equals("com.aptana.editor.common.offset.start")) {
                return offset;
            }
            if (key.equals("com.aptana.editor.common.offset.end")) {
                return offset + length;
            }
            if (key.equals("com.aptana.editor.common.length")) {
                return length;
            }
            if (key.equals("com.aptana.editor.common.theme")) {
                Theme theme = ThemePlugin.getDefault().getThemeManager().getCurrentTheme();
                ArrayList<IScopeSelector> selectors = new ArrayList<IScopeSelector>();
                List rules = theme.getTokens();
                if (rules != null) {
                    for (ThemeRule rule : rules) {
                        if (rule.isSeparator()) continue;
                        selectors.add(rule.getScopeSelector());
                    }
                    IScopeSelector matchingSelector = ScopeSelector.bestMatch(selectors, (String)scope);
                    for (ThemeRule rule : rules) {
                        if (!matchingSelector.equals(rule.getScopeSelector())) continue;
                        return rule;
                    }
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public Object getEditableValue() {
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

