/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.preferences;

import com.aptana.core.resources.TaskTag;
import com.aptana.editor.common.preferences.Messages;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class TaskTagInputDialog
extends StatusDialog {
    private Text fTagNameText;
    private Combo fPriorityCombo;
    private String fPriority;
    private String fTagName;
    private List<TaskTag> existingTags;

    public TaskTagInputDialog(TaskTag tag, List<TaskTag> existingTags, Shell parent) {
        super(parent);
        this.existingTags = existingTags;
        this.fTagName = tag.getName();
        this.fPriority = tag.getPriorityName();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        ((GridLayout)composite.getLayout()).makeColumnsEqualWidth = false;
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.TaskTagInputDialog_NameLabel);
        this.fTagNameText = new Text(composite, 2052);
        this.fTagNameText.setText(this.fTagName);
        this.fTagNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TaskTagInputDialog.this.fTagName = TaskTagInputDialog.this.fTagNameText.getText().trim();
                TaskTagInputDialog.this.verifyUniqueTagName();
            }
        });
        this.fTagNameText.setLayoutData((Object)new GridData(768));
        Label priorityLabel = new Label(composite, 0);
        priorityLabel.setText(Messages.TaskTagInputDialog_PriorityLabel);
        this.fPriorityCombo = new Combo(composite, 12);
        this.fPriorityCombo.add("High");
        this.fPriorityCombo.add("Normal");
        this.fPriorityCombo.add("Low");
        this.fPriorityCombo.setText(this.fPriority);
        this.fPriorityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskTagInputDialog.this.fPriority = TaskTagInputDialog.this.fPriorityCombo.getText();
                TaskTagInputDialog.this.verifyUniqueTagName();
            }
        });
        this.fPriorityCombo.setLayoutData((Object)new GridData(768));
        return composite;
    }

    public void create() {
        super.create();
        this.updateButtonsEnableState((IStatus)new Status(4, "com.aptana.editor.common", ""));
    }

    public TaskTag getTaskTag() {
        return new TaskTag(this.fTagName, this.fPriority);
    }

    protected void verifyUniqueTagName() {
        if (this.fTagName.length() == 0) {
            this.updateStatus((IStatus)new Status(4, "com.aptana.editor.common", Messages.TaskTagInputDialog_NonEmptyNameError));
            return;
        }
        for (TaskTag existingTag : this.existingTags) {
            if (!existingTag.getName().equals(this.fTagName)) continue;
            this.updateStatus((IStatus)new Status(4, "com.aptana.editor.common", Messages.TaskTagInputDialog_UniqueNameError));
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }
}

