/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.contentassist.ContentAssistant;
import com.pandora.core.utils.PlatformUtil;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        String modName = Action.findModifierString((int)SWT.MOD3);
        try {
            IEclipsePreferences node = EclipseUtil.defaultScope().getNode("org.eclipse.ui.editors");
            node.put("hyperlinkKeyModifier", modName);
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        IEclipsePreferences prefs = EclipseUtil.defaultScope().getNode("com.aptana.editor.common");
        prefs.put("hyperlinkKeyModifier", modName);
        prefs.putBoolean("com.aptana.editor.common.enableCharacterPairColoring", true);
        prefs.put("com.aptana.editor.common.characterPairColor", "128,128,128");
        prefs.putBoolean("com.aptana.editor.common.linkOutlineWithEditor", true);
        prefs.putBoolean("com.aptana.editor.common.showIndentGuide", true);
        if (PlatformUtil.isMac()) {
            prefs.putBoolean("com.aptana.editor.common.showIndentGuide", false);
        }
        prefs.put("com.aptana.editor.common.taskTagNames", "TODO,FIXME,XXX");
        prefs.put("com.aptana.editor.common.taskTagPriorities", "NORMAL,HIGH,NORMAL");
        prefs.putBoolean("com.aptana.editor.common.taskTagsCaseSensitive", true);
        prefs.putBoolean("com.aptana.editor.common.editorMarkOccurrences", false);
        prefs.putInt("CONTENT_ASSIST_DELAY", 0);
        prefs.putBoolean("CONTENT_ASSIST_AUTO_INSERT", true);
        prefs.putBoolean("SELECT_CONTENT_ASSIST_BY_NUMBER", false);
        prefs.putInt("SPEC_FILE_NUMBER", ContentAssistant.SPEC_FILE_MAX_COUNT);
        prefs.putBoolean("com.aptana.editor.common.contentAssistHover", false);
        prefs.putBoolean("com.aptana.editor.common.editorPeerCharacterClose", true);
        prefs.putBoolean("com.aptana.editor.common.editorWrapSelection", true);
        prefs.putBoolean("com.aptana.editor.common.removeTrailingWhitespace", false);
        prefs.putBoolean("com.aptana.editor.common.enableFolding", true);
        prefs.putBoolean("com.aptana.editor.common.outlineAutoOpen", true);
        prefs.putBoolean("com.aptana.editor.common.firstOutlineAutoOpen", true);
        prefs.put("com.aptana.editor.common.enabledSpellingScopes", "comment.block.documentation,comment.line,comment.block");
        int maxCols = 200;
        try {
            String maxColsVal = System.getProperty("studio.maxColoredColumns");
            if (!StringUtil.isEmpty((String)maxColsVal)) {
                maxCols = Integer.parseInt(maxColsVal);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        prefs.putInt("studio.maxColoredColumns", maxCols);
        IEclipsePreferences emmetPrefs = EclipseUtil.defaultScope().getNode("io.emmet.eclipse");
        String htmls = "html,htm,xhtml,shtml,php,asa,aspx,phtml,inc,tmpl,tpl,ctp,yaws,tcl,vm,ejs,dwt,cshtml,ftl";
        try {
            String[] extensions;
            IContentType htmlContentType = Platform.getContentTypeManager().getContentType("com.aptana.contenttype.html");
            if (htmlContentType != null && (extensions = htmlContentType.getFileSpecs(8)) != null && extensions.length > 0) {
                htmls = StringUtil.join((String)",", (String[])extensions);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        emmetPrefs.put("tabExtensions", "rhtml,erb,xml,xsl,xsd,css,less,styl,scss,sass,jade,haml,hbs,asp,jsp," + htmls);
    }
}

