/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.preferences;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.preferences.Messages;
import com.aptana.ui.preferences.AptanaPreferencePage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.texteditor.HyperlinkDetectorDescriptor;

public class EditorsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private String GENERAL_TEXT_EDITOR_PREF_ID = "org.eclipse.ui.preferencePages.GeneralTextEditor";

    public EditorsPreferencePage() {
        super(1);
        this.setPreferenceStore(CommonEditorPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.EditorsPreferencePage_PreferenceDescription);
    }

    public void createFieldEditors() {
        Composite appearanceComposite = this.getFieldEditorParent();
        Composite group = AptanaPreferencePage.createGroup((Composite)appearanceComposite, (String)Messages.EditorsPreferencePage_Typing);
        this.addField((FieldEditor)new BooleanFieldEditor("com.aptana.editor.common.enableCharacterPairColoring", Messages.EditorsPreferencePage_Colorize_Matching_Character_Pairs, group));
        this.addField((FieldEditor)new BooleanFieldEditor("com.aptana.editor.common.editorPeerCharacterClose", Messages.EditorsPreferencePage_Close_Matching_Character_Pairs, group));
        this.addField((FieldEditor)new BooleanFieldEditor("com.aptana.editor.common.editorWrapSelection", Messages.EditorsPreferencePage_Wrap_Selection, group));
        group = AptanaPreferencePage.createGroup((Composite)appearanceComposite, (String)Messages.EditorsPreferencePage_saveActionsGroup);
        this.addField((FieldEditor)new BooleanFieldEditor("com.aptana.editor.common.removeTrailingWhitespace", Messages.EditorsPreferencePage_saveActionRemoveWhitespaceCharacters, group));
        group = AptanaPreferencePage.createGroup((Composite)appearanceComposite, (String)Messages.EditorsPreferencePage_SyntaxColoring);
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        IntegerFieldEditor colEditor = new IntegerFieldEditor("studio.maxColoredColumns", StringUtil.makeFormLabel((String)Messages.EditorsPreferencePage_MaxColumnsLabel), group);
        colEditor.setValidRange(-1, Integer.MAX_VALUE);
        this.addField((FieldEditor)colEditor);
        group = AptanaPreferencePage.createGroup((Composite)appearanceComposite, (String)"\u7f16\u8f91\u5668\u884c\u4e3a");
        this.addField((FieldEditor)new BooleanFieldEditor("com.aptana.editor.common.enableWordWrap", Messages.EditorsPreferencePage_Enable_WordWrap, group));
        this.addField((FieldEditor)new BooleanFieldEditor("com.aptana.editor.common.outlineAutoOpen", "\u6253\u5f00\u7f16\u8f91\u5668\u7684\u65f6\u5019\u81ea\u52a8\u6253\u5f00\u5927\u7eb2", group));
        RadioGroupFieldEditor radio = new RadioGroupFieldEditor("hyperlinkKeyModifier", "\u8f6c\u5230\u5b9a\u4e49\u8f85\u52a9\u952e\u8bbe\u7f6e", 1, new String[][]{{"\u4f7f\u7528Alt+\u9f20\u6807\u5de6\u952e\u8f6c\u5230\u5b9a\u4e49\u5904\uff0cCtrl+\u9f20\u6807\u5de6\u952e\u9009\u62e9\u76f8\u540c\u8bcd", "Alt"}, {"\u4f7f\u7528Ctrl+\u9f20\u6807\u5de6\u952e\u8f6c\u5230\u5b9a\u4e49\u5904\uff0cAlt+\u9f20\u6807\u5de6\u952e\u9009\u62e9\u76f8\u540c\u8bcd", "Ctrl"}}, appearanceComposite, true){

            protected void doLoadDefault() {
                super.doLoadDefault();
                this.doStore();
            }

            protected void doStore() {
                super.doStore();
                String modify = this.getPreferenceStore().getString(this.getPreferenceName());
                IPreferenceStore store = EditorsUI.getPreferenceStore();
                store.setValue(this.getPreferenceName(), modify);
                HyperlinkDetectorDescriptor[] descriptors = EditorsUI.getHyperlinkDetectorRegistry().getHyperlinkDetectorDescriptors();
                if (descriptors != null) {
                    HyperlinkDetectorDescriptor[] hyperlinkDetectorDescriptorArray = descriptors;
                    int n = descriptors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        HyperlinkDetectorDescriptor desc = hyperlinkDetectorDescriptorArray[n2];
                        String key = String.valueOf(desc.getId()) + "_stateMask";
                        if (Action.findModifierString((int)262144).equals(modify)) {
                            store.setValue(key, 262144);
                            store.setValue(desc.getId(), modify);
                        } else if (Action.findModifierString((int)65536).equals(modify)) {
                            store.setValue(key, 65536);
                            store.setValue(desc.getId(), modify);
                        }
                        ++n2;
                    }
                }
            }
        };
        this.addField((FieldEditor)radio);
        this.createTextEditorLink(appearanceComposite);
    }

    public void init(IWorkbench workbench) {
    }

    private void createTextEditorLink(Composite appearanceComposite) {
        Link link = new Link(appearanceComposite, 0);
        link.setText(Messages.EditorsPreferencePage_GeneralTextEditorPrefLink);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((IWorkbenchPreferenceContainer)EditorsPreferencePage.this.getContainer()).openPage(EditorsPreferencePage.this.GENERAL_TEXT_EDITOR_PREF_ID, null);
            }
        });
    }
}

