/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.preferences.Messages;
import com.aptana.ui.preferences.AptanaPreferencePage;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;

public abstract class CommonEditorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Composite appearanceComposite;
    private IntegerFieldEditor tabSize;
    protected BooleanFieldEditor enableFolding;
    private Combo tabSpaceCombo;
    private IPropertyChangeListener tabSizeListener;

    protected CommonEditorPreferencePage() {
        super(1);
        this.setDescription(Messages.CommonEditorPreferencePage_Editor_Preferences);
    }

    protected void createFieldEditors() {
        this.appearanceComposite = this.getFieldEditorParent();
        this.createMarkOccurrenceOptions(this.appearanceComposite);
        this.createTextEditingOptions(this.appearanceComposite, Messages.CommonEditorPreferencePage_Text_Editing_Label);
        Composite group = AptanaPreferencePage.createGroup((Composite)this.appearanceComposite, (String)Messages.CommonEditorPreferencePage_Folding);
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.createFoldingOptions(group);
        Composite caGroup = AptanaPreferencePage.createGroup((Composite)this.appearanceComposite, (String)Messages.CommonEditorPreferencePage_ContentAssist);
        caGroup.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        caGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Composite caOptions = this.createContentAssistOptions(caGroup);
        if (caOptions.getChildren().length == 1) {
            caGroup.getParent().setVisible(false);
        }
    }

    protected void createTextEditingOptions(Composite parent, String groupName) {
        Composite group = AptanaPreferencePage.createGroup((Composite)parent, (String)groupName);
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).create());
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Label label = new Label(group, 0);
        label.setText(Messages.CommonEditorPreferencePage_LBL_TabPolicy);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.tabSpaceCombo = new Combo(group, 12);
        this.tabSpaceCombo.add(Messages.CommonEditorPreferencePage_UseSpacesOption);
        this.tabSpaceCombo.add(Messages.CommonEditorPreferencePage_UseTabOption);
        this.tabSpaceCombo.add(Messages.CommonEditorPreferencePage_UseDefaultOption);
        this.tabSpaceCombo.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.setTabSpaceCombo();
        final Composite fieldEditorGroup = new Composite(group, 0);
        fieldEditorGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.tabSpaceCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object source = e.getSource();
                if (source == CommonEditorPreferencePage.this.tabSpaceCombo) {
                    CommonEditorPreferencePage.this.tabSize.setEnabled(!CommonEditorPreferencePage.this.tabSpaceCombo.getText().equals(Messages.CommonEditorPreferencePage_UseDefaultOption), fieldEditorGroup);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.tabSize = new IntegerFieldEditor("tabWidth", Messages.CommonEditorPreferencePage_Tab_Size_Label, fieldEditorGroup, 5){

            protected void doLoadDefault() {
                Text text = this.getTextControl();
                if (text != null) {
                    int value = CommonEditorPreferencePage.this.getChainedEditorPreferenceStore().getInt(this.getPreferenceName());
                    text.setText(Integer.toString(value));
                }
                this.valueChanged();
                this.setEnabled(!CommonEditorPreferencePage.this.tabSpaceCombo.getText().equals(Messages.CommonEditorPreferencePage_UseDefaultOption), fieldEditorGroup);
            }

            protected void doLoad() {
                Text text = this.getTextControl();
                if (text != null) {
                    int value = CommonEditorPreferencePage.this.getChainedEditorPreferenceStore().getInt(this.getPreferenceName());
                    text.setText(Integer.toString(value));
                    this.oldValue = Integer.toString(value);
                }
            }

            protected void doStore() {
                Text text = this.getTextControl();
                if (text != null) {
                    Integer i = new Integer(text.getText());
                    int globalEditorValue = new ChainedPreferenceStore(new IPreferenceStore[]{CommonEditorPlugin.getDefault().getPreferenceStore(), EditorsPlugin.getDefault().getPreferenceStore()}).getInt("tabWidth");
                    if (i == globalEditorValue || CommonEditorPreferencePage.this.tabSpaceCombo.getText().equals(Messages.CommonEditorPreferencePage_UseDefaultOption)) {
                        CommonEditorPreferencePage.this.removePluginDefaults();
                        CommonEditorPreferencePage.this.getPluginPreferenceStore().remove("tabWidth");
                    } else {
                        this.getPreferenceStore().setValue(this.getPreferenceName(), i.intValue());
                    }
                }
            }
        };
        this.tabSize.setEmptyStringAllowed(false);
        this.tabSize.setValidRange(1, 20);
        this.tabSize.setEnabled(!this.tabSpaceCombo.getText().equals(Messages.CommonEditorPreferencePage_UseDefaultOption), fieldEditorGroup);
        this.addField((FieldEditor)this.tabSize);
        this.createAutoIndentOptions(group);
        this.tabSizeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("tabWidth".equals(event.getProperty())) {
                    CommonEditorPreferencePage.this.setTabSpaceCombo();
                    CommonEditorPreferencePage.this.tabSize.load();
                }
            }
        };
        this.getPreferenceStore().addPropertyChangeListener(this.tabSizeListener);
    }

    public void dispose() {
        if (this.tabSizeListener != null) {
            this.getPreferenceStore().removePropertyChangeListener(this.tabSizeListener);
            this.tabSizeListener = null;
        }
        super.dispose();
    }

    private void setTabSpaceCombo() {
        IEclipsePreferences store = this.getPluginPreferenceStore();
        if (store.getBoolean("com.aptana.editor.common.useGlobalDefaults", true)) {
            this.tabSpaceCombo.setText(Messages.CommonEditorPreferencePage_UseDefaultOption);
        } else {
            boolean useSpaces = store.getBoolean("spacesForTabs", true);
            this.tabSpaceCombo.setText(useSpaces ? Messages.CommonEditorPreferencePage_UseSpacesOption : Messages.CommonEditorPreferencePage_UseTabOption);
        }
    }

    public boolean performOk() {
        IEclipsePreferences store = this.getPluginPreferenceStore();
        if (this.tabSpaceCombo.getText().equals(Messages.CommonEditorPreferencePage_UseSpacesOption)) {
            store.putBoolean("spacesForTabs", true);
            store.putBoolean("com.aptana.editor.common.useGlobalDefaults", false);
        } else if (this.tabSpaceCombo.getText().equals(Messages.CommonEditorPreferencePage_UseTabOption)) {
            store.putBoolean("spacesForTabs", false);
            store.putBoolean("com.aptana.editor.common.useGlobalDefaults", false);
        } else {
            this.removePluginDefaults();
            store.remove("spacesForTabs");
            store.remove("tabWidth");
            store.putBoolean("com.aptana.editor.common.useGlobalDefaults", true);
        }
        try {
            store.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        return super.performOk();
    }

    protected void performDefaults() {
        IEclipsePreferences store = this.getPluginPreferenceStore();
        store.remove("spacesForTabs");
        store.remove("tabWidth");
        this.setPluginDefaults();
        this.setTabSpaceCombo();
        super.performDefaults();
        try {
            store.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    protected void createAutoIndentOptions(Composite parent) {
        Composite autoIndentGroup = new Composite(parent, 0);
        autoIndentGroup.setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).create());
        this.addField((FieldEditor)new BooleanFieldEditor("com.aptana.editor.common.autoIndent", Messages.CommonEditorPreferencePage_auto_indent_label, autoIndentGroup));
    }

    protected Composite createFoldingOptions(Composite parent) {
        Composite foldingGroup = new Composite(parent, 0);
        foldingGroup.setLayoutData((Object)GridDataFactory.fillDefaults().span(1, 1).create());
        this.enableFolding = new BooleanFieldEditor("com.aptana.editor.common.enableFolding", Messages.CommonEditorPreferencePage_enable_folding_label, foldingGroup);
        this.addField((FieldEditor)this.enableFolding);
        return foldingGroup;
    }

    protected Composite createContentAssistOptions(Composite parent) {
        IPreferenceStore s = this.getChainedEditorPreferenceStore();
        Label label = new Label(parent, 0);
        label.setText(Messages.CommonEditorPreferencePage_OnTypingCharacters);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        if (s.contains("completionProposalActivationCharacters")) {
            this.addField((FieldEditor)new StringFieldEditor("completionProposalActivationCharacters", Messages.CommonEditorPreferencePage_DisplayProposals, parent));
        }
        if (s.contains("contextInformationActivationCharacters")) {
            this.addField((FieldEditor)new StringFieldEditor("contextInformationActivationCharacters", Messages.CommonEditorPreferencePage_DisplayContextualInfo, parent));
        }
        if (s.contains("proposalTriggerCharacters")) {
            this.addField((FieldEditor)new StringFieldEditor("proposalTriggerCharacters", Messages.CommonEditorPreferencePage_InsertProposal, parent));
        }
        return parent;
    }

    protected void setPluginDefaults() {
        IEclipsePreferences store = this.getDefaultPluginPreferenceStore();
        if (store == null) {
            return;
        }
        store.putBoolean("spacesForTabs", this.getDefaultSpacesForTabs());
        store.putInt("tabWidth", this.getDefaultTabWidth());
        try {
            store.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    protected void removePluginDefaults() {
        IEclipsePreferences store = this.getDefaultPluginPreferenceStore();
        if (store == null) {
            return;
        }
        store.remove("spacesForTabs");
        store.remove("tabWidth");
        try {
            store.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    protected IEclipsePreferences getDefaultPluginPreferenceStore() {
        return null;
    }

    protected boolean getDefaultSpacesForTabs() {
        return this.getChainedEditorPreferenceStore().getBoolean("spacesForTabs");
    }

    protected int getDefaultTabWidth() {
        return this.getChainedEditorPreferenceStore().getInt("tabWidth");
    }

    public void init(IWorkbench workbench) {
    }

    protected void createMarkOccurrenceOptions(Composite parent) {
        Composite group = AptanaPreferencePage.createGroup((Composite)parent, (String)"\u6807\u8bb0\u8bbe\u7f6e(Mark Occurrences)");
        this.addField((FieldEditor)new BooleanFieldEditor("com.aptana.editor.common.editorMarkOccurrences", Messages.EditorsPreferencePage_MarkOccurrences, group));
    }

    protected abstract IPreferenceStore getChainedEditorPreferenceStore();

    protected abstract IEclipsePreferences getPluginPreferenceStore();
}

