/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.parsing;

import beaver.Scanner;
import beaver.Symbol;
import com.aptana.core.util.ArrayUtil;
import com.aptana.editor.common.parsing.CompositeParserScanner;
import com.aptana.parsing.AbstractParser;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.ParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.WorkingParseResult;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.ast.ParseNode;
import java.io.IOException;
import java.util.ArrayList;

public class CompositeParser
extends AbstractParser {
    protected CompositeParserScanner fScanner;
    private String fParserLanguage;
    protected IParseNode fEmbeddedlanguageRoot;
    protected Symbol fCurrentSymbol;

    public CompositeParser(CompositeParserScanner defaultScanner, String primaryParserLanguage) {
        this.fScanner = defaultScanner;
        this.fParserLanguage = primaryParserLanguage;
    }

    protected void parse(IParseState parseState, WorkingParseResult working) throws Exception {
        this.fScanner.getTokenScanner().reset();
        this.fScanner.setSource(parseState.getSource());
        this.fCurrentSymbol = null;
        this.fEmbeddedlanguageRoot = this.processEmbeddedlanguage(parseState, working);
        IParseNode[] embeddedNodes = null;
        if (this.fEmbeddedlanguageRoot != null) {
            embeddedNodes = this.fEmbeddedlanguageRoot.getChildren();
            if (embeddedNodes.length == 0) {
                embeddedNodes = new IParseNode[]{this.fEmbeddedlanguageRoot};
            }
            ((ParseState)parseState).setSkippedRanges(embeddedNodes);
        }
        ParseResult parseResult = this.primaryParse(parseState);
        working.addAllErrors(parseResult.getErrors());
        IParseRootNode result = parseResult.getRootNode();
        if (embeddedNodes != null) {
            ((ParseState)parseState).setSkippedRanges(null);
        }
        if (this.fEmbeddedlanguageRoot != null) {
            this.mergeEmbeddedNodes(result, embeddedNodes);
        }
        working.setParseResult(result);
    }

    protected void mergeEmbeddedNodes(IParseRootNode ast, IParseNode[] embeddedNodes) {
        if (ArrayUtil.isEmpty((Object[])embeddedNodes) || ast == null) {
            return;
        }
        IParseNode[] iParseNodeArray = embeddedNodes;
        int n = embeddedNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode embeddedNode = iParseNodeArray[n2];
            IParseNode parent = ast.getNodeAtOffset(embeddedNode.getStartingOffset());
            while (!(parent == null || parent instanceof IParseRootNode || embeddedNode.getStartingOffset() > parent.getStartingOffset() && embeddedNode.getEndingOffset() < parent.getEndingOffset())) {
                parent = parent.getParent();
            }
            if (parent == null) {
                ast.addChild(embeddedNode);
            } else {
                ArrayList<IParseNode> newList = new ArrayList<IParseNode>();
                boolean found = false;
                int embeddedStart = embeddedNode.getStartingOffset();
                int embeddedEnd = embeddedNode.getEndingOffset();
                for (IParseNode primaryNodeChild : parent) {
                    if (!found && primaryNodeChild.getStartingOffset() > embeddedStart) {
                        found = true;
                        newList.add(embeddedNode);
                    }
                    if (primaryNodeChild.getStartingOffset() > embeddedEnd) {
                        newList.add(primaryNodeChild);
                        continue;
                    }
                    if (primaryNodeChild.getStartingOffset() >= embeddedStart || primaryNodeChild.getEndingOffset() >= embeddedStart && primaryNodeChild.getEndingOffset() <= embeddedEnd) continue;
                    newList.add(primaryNodeChild);
                }
                if (!found) {
                    newList.add(embeddedNode);
                }
                ((ParseNode)parent).setChildren(newList.toArray(new IParseNode[newList.size()]));
            }
            ++n2;
        }
    }

    private ParseResult primaryParse(IParseState parseState) throws Exception {
        return ParserPoolFactory.parse((String)this.fParserLanguage, (IParseState)parseState);
    }

    protected IParseNode processEmbeddedlanguage(IParseState parseState, WorkingParseResult working) throws Exception {
        return null;
    }

    protected void advance() throws IOException, Scanner.Exception {
        this.fCurrentSymbol = this.fScanner.nextToken();
    }

    protected Symbol getCurrentSymbol() {
        return this.fCurrentSymbol;
    }

    protected ParseResult getParseResult(String language, int start, int end) {
        try {
            String text = this.fScanner.getSource().get(start, end - start + 1);
            return ParserPoolFactory.parse((String)language, (String)text, (int)start);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

