/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.parsing;

import beaver.Scanner;
import beaver.Symbol;
import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.parsing.AbstractFlexTokenScanner;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public abstract class AbstractFlexPartitionScanner
extends AbstractFlexTokenScanner
implements IPartitionTokenScanner {
    private static final Token DEFAULT_CONTENT_TYPE_TOKEN = new Token((Object)"__dftl_partition_content_type");
    protected final Queue<TokenOffsetAndLen> preCalculatedTokenOffsetAndLen = new LinkedList<TokenOffsetAndLen>();

    protected AbstractFlexPartitionScanner(Scanner scanner) {
        super(scanner);
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        int delta;
        if (partitionOffset > -1 && (delta = offset - partitionOffset) > 0) {
            this.setRange(document, partitionOffset, length + delta);
            this.fOffset = partitionOffset;
            return;
        }
        this.setRange(document, offset, length);
    }

    @Override
    public IToken nextToken() {
        TokenOffsetAndLen next = this.preCalculatedTokenOffsetAndLen.poll();
        if (next != null) {
            this.fTokenOffset = next.offset;
            this.fTokenLen = next.len;
            return next.token;
        }
        try {
            Symbol symbol = (Symbol)this.fLookAheadQueue.poll();
            if (symbol == null) {
                symbol = this.fScanner.nextToken();
            }
            Symbol symbolStart = symbol;
            this.fTokenOffset = symbol.getStart();
            boolean returnDefaultContentType = false;
            while (true) {
                IToken token;
                if ((token = this.mapToken(symbol, symbolStart, returnDefaultContentType)) != null) {
                    return token;
                }
                returnDefaultContentType = true;
                symbol = (Symbol)this.fLookAheadQueue.poll();
                if (symbol != null) continue;
                symbol = this.fScanner.nextToken();
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            return DEFAULT_CONTENT_TYPE_TOKEN;
        }
    }

    protected abstract IToken mapToken(Symbol var1, Symbol var2, boolean var3);

    @Override
    protected IToken mapToken(Symbol token) throws IOException, Scanner.Exception {
        throw new AssertionError((Object)"Should not be called in this class.");
    }

    protected IToken returnToken(Symbol symbol, Symbol symbolStart, boolean returnDefaultContentType, int tokenLen, IToken matchedToken) {
        if (returnDefaultContentType) {
            this.preCalculatedTokenOffsetAndLen.add(new TokenOffsetAndLen(matchedToken, symbol.getStart(), tokenLen));
            this.fTokenLen = symbol.getStart() - symbolStart.getStart();
            return DEFAULT_CONTENT_TYPE_TOKEN;
        }
        this.fTokenLen = tokenLen;
        return matchedToken;
    }

    @Override
    public int getTokenOffset() {
        return this.fOffset + this.fTokenOffset;
    }

    @Override
    public int getTokenLength() {
        return this.fTokenLen;
    }

    @Override
    protected IToken getUndefinedToken() {
        return DEFAULT_CONTENT_TYPE_TOKEN;
    }

    private static final class TokenOffsetAndLen {
        public final int offset;
        public final int len;
        public final IToken token;

        public TokenOffsetAndLen(IToken token, int offset, int len) {
            this.token = token;
            this.offset = offset;
            this.len = len;
        }
    }
}

