/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.scripting;

import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.scripting.model.BundleManager;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;

class ExtendedDocumentInfo {
    private Map<String, String> contentTypesAssociation = new HashMap<String, String>();
    private String filename;
    private String defaultContentType;
    private String fTopLevelScope;
    private boolean calculatedTopLevelScope = false;

    protected ExtendedDocumentInfo(String defaultContentType, String filename) {
        this.defaultContentType = defaultContentType;
        this.filename = filename;
    }

    public QualifiedContentType getContentType(IDocument document, int offset) throws BadLocationException {
        QualifiedContentType result = new QualifiedContentType(this.defaultContentType);
        try {
            String contentType;
            String subdocContentType;
            ITypedRegion region;
            if (offset == document.getLength() && (region = document.getPartition(offset)).getLength() == 0 && offset > 0) {
                --offset;
            }
            if ((subdocContentType = this.contentTypesAssociation.get(contentType = document.getContentType(offset))) != null && !subdocContentType.equals(result.getLastPart())) {
                result = result.subtype(subdocContentType);
            }
            return result.subtype(contentType);
        }
        catch (Exception exception) {
            return result;
        }
    }

    public void associateContentType(String contentType, String documentContentType) {
        this.contentTypesAssociation.put(contentType, documentContentType);
    }

    public QualifiedContentType modify(QualifiedContentType translation) {
        if (this.filename == null) {
            return translation;
        }
        if (!this.calculatedTopLevelScope) {
            this.fTopLevelScope = BundleManager.getInstance().getTopLevelScope(this.filename);
            this.calculatedTopLevelScope = true;
        }
        if (this.fTopLevelScope == null) {
            return translation;
        }
        String[] parts = translation.getParts();
        String[] newParts = new String[parts.length];
        newParts[0] = this.fTopLevelScope;
        System.arraycopy(parts, 1, newParts, 1, parts.length - 1);
        return new QualifiedContentType(newParts);
    }
}

