/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.handlers;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.internal.handlers.Messages;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ToggleOutlineHandler
extends AbstractHandler {
    private static final String OUTLINE_VIEW_ID = "org.eclipse.ui.views.ContentOutline";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean toShow = !HandlerUtil.toggleCommandState((Command)event.getCommand());
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            if (toShow) {
                try {
                    page.showView(OUTLINE_VIEW_ID);
                }
                catch (PartInitException e) {
                    IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)Messages.ToggleOutlineHandler_ERR_OpeningOutline, (Throwable)e);
                }
            } else {
                IViewPart viewPart = page.findView(OUTLINE_VIEW_ID);
                if (viewPart != null) {
                    page.hideView(viewPart);
                }
            }
        }
        return null;
    }
}

