/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.commands;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;

public class ToggleWordWrapHandler
extends AbstractHandler {
    private static final String COMMAND_ID = "com.aptana.editor.toggleWordWrapCommand";
    private static final String V_COMMAND_ID = "com.aptana.view.toggleWordWrapCommand";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String commandId = event.getCommand().getId();
        IEditorReference[] editorReferences = CommonEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        boolean isWordWrapEnable = CommonEditorPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.editor.common.enableWordWrap");
        if (V_COMMAND_ID.equals(commandId)) {
            IEditorReference[] iEditorReferenceArray = editorReferences;
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference iEditorReference = iEditorReferenceArray[n2];
                IEditorPart editor = iEditorReference.getEditor(false);
                if (editor instanceof AbstractThemeableEditor) {
                    AbstractThemeableEditor activeEditor = (AbstractThemeableEditor)editor;
                    activeEditor.setWordWrapEnabled(!isWordWrapEnable);
                }
                ++n2;
            }
            CommonEditorPlugin.getDefault().getPreferenceStore().setValue("com.aptana.editor.common.enableWordWrap", !isWordWrapEnable);
            try {
                State state = event.getCommand().getState("org.eclipse.ui.commands.toggleState");
                if (state != null) {
                    state.setValue((Object)(!isWordWrapEnable ? 1 : 0));
                }
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            }
            return null;
        }
        IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editorPart instanceof AbstractThemeableEditor) {
            AbstractThemeableEditor activeEditor;
            activeEditor.setWordWrapEnabled(!(activeEditor = (AbstractThemeableEditor)editorPart).getWordWrapEnabled());
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        Object activeSite = ((IEvaluationContext)evaluationContext).getVariable("activeSite");
        Object activeEditor = ((IEvaluationContext)evaluationContext).getVariable("activeEditor");
        if (activeSite instanceof IWorkbenchSite && activeEditor instanceof AbstractThemeableEditor) {
            ICommandService commandService = (ICommandService)((IWorkbenchSite)activeSite).getService(ICommandService.class);
            Command command = commandService.getCommand(COMMAND_ID);
            State state = command.getState("org.eclipse.ui.commands.toggleState");
            state.setValue((Object)((AbstractThemeableEditor)activeEditor).getWordWrapEnabled());
        }
    }
}

