/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.commands;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.util.CommentHandlerUtil;
import com.aptana.ui.util.UIUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorPart;

public class CommentActionKeyCommandHandler
extends AbstractHandler {
    private static final String HTML_COMMENT = "__html_comment";
    private static final String CSS_COMMENT = "__css_multiline_comment";
    private static final String CSS_END_COMMENT_TAG = "*/";
    private static final String CSS_BEGIN_COMMENT_TAG = "/*";
    private static final String WRAP_TAG = "\r\n";
    public static final String HTML_START_COMMENT_TAG = "<!--";
    public static final String HTML_END_COMMENT_TAG = "-->";
    private static IDocument _document = null;
    private static String commentString = "//";
    private static String spaceString = "  ";
    private int startOffset;
    private int endOffset;
    private int replaceLength;
    private ITextSelection textSelection;
    private int selectionOffset = -1;
    private boolean isStarted = true;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.isStarted = CommentHandlerUtil.isStarted();
        commentString = this.isStarted ? "//" : "// ";
        try {
            this.selectionOffset = -1;
            IEditorPart activeEditor = UIUtils.getActiveEditor();
            if (activeEditor instanceof AbstractThemeableEditor) {
                AbstractThemeableEditor editor = (AbstractThemeableEditor)activeEditor;
                ISelectionProvider provider = editor.getSelectionProvider();
                ISelection selection = provider.getSelection();
                this.textSelection = (ITextSelection)selection;
                _document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                int startLineNum = this.textSelection.getStartLine();
                IRegion startInfo = _document.getLineInformation(startLineNum);
                this.startOffset = startInfo.getOffset();
                int endLineNum = this.textSelection.getEndLine();
                IRegion endInfo = _document.getLineInformation(endLineNum);
                this.endOffset = endInfo.getOffset() + endInfo.getLength();
                String contentType = editor.getContentType();
                StringBuilder buf = new StringBuilder();
                int offset = editor.getCaretOffset();
                boolean isSelectionInLine = startLineNum == endLineNum;
                this.getCommentContent(startLineNum, endLineNum, contentType, buf, offset, isSelectionInLine);
                String replaceContent = "";
                if (StringUtil.isNotBlank((String)buf.toString())) {
                    replaceContent = buf.toString();
                    while (replaceContent.endsWith(WRAP_TAG)) {
                        replaceContent = replaceContent.substring(0, replaceContent.length() - WRAP_TAG.length());
                    }
                    while (replaceContent.startsWith(WRAP_TAG)) {
                        replaceContent = replaceContent.substring(WRAP_TAG.length(), replaceContent.length());
                    }
                    _document.replace(this.startOffset, this.replaceLength, replaceContent);
                    if (this.selectionOffset > -1) {
                        editor.getISourceViewer().setSelectedRange(this.selectionOffset, 0);
                    }
                } else {
                    _document.replace(this.startOffset, this.replaceLength, buf.toString());
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void getCommentContent(int startLineNum, int endLineNum, String contentType, StringBuilder buf, int offset, boolean isSelectionInLine) throws BadLocationException {
        ITypedRegion region = _document.getPartition(offset);
        String regonType = region.getType();
        if ("__html_php".equals(regonType) || "__html_sp".equals(regonType)) {
            return;
        }
        if ((contentType.contains("html") || contentType.contains("xml") || regonType.contains("html") || regonType.contains("xml")) && !regonType.contains("js") && !regonType.contains("css")) {
            if (isSelectionInLine) {
                this.getHTMLCommentContent(buf);
            } else {
                this.getHTMLCommentContent(startLineNum, endLineNum, buf);
                this.replaceLength = this.endOffset - this.startOffset;
            }
        } else if (contentType.contains("css") || regonType.contains("css")) {
            if (isSelectionInLine) {
                this.getCSSCommentContent(buf);
            } else {
                this.getCSSCommentContent(startLineNum, endLineNum, buf);
                this.replaceLength = this.endOffset - this.startOffset;
            }
        } else {
            this.getJSCommentContent(startLineNum, endLineNum, buf);
        }
    }

    private void getCSSCommentContent(StringBuilder buf) throws BadLocationException {
        int offset = this.textSelection.getOffset();
        if (offset == _document.getLength()) {
            --offset;
        }
        ITypedRegion region = _document.getPartition(offset);
        String selectText = this.textSelection.getText();
        ITypedRegion region_ = null;
        if (offset > 0) {
            region_ = _document.getPartition(offset - 1);
        }
        if (this.textSelection.getLength() > 0) {
            if (region != null && region.getType().equals(CSS_COMMENT)) {
                selectText = _document.get(region.getOffset(), region.getLength());
                this.setCSSReplaceContent(buf, region, selectText);
            } else {
                buf.append(CSS_BEGIN_COMMENT_TAG);
                buf.append(selectText);
                buf.append(CSS_END_COMMENT_TAG);
                this.replaceLength = this.textSelection.getLength();
                this.startOffset = this.textSelection.getOffset();
            }
        } else {
            if (region != null && region.getType().equals(CSS_COMMENT)) {
                selectText = _document.get(region.getOffset(), region.getLength());
                this.setCSSReplaceContent(buf, region, selectText);
                return;
            }
            if (region_ != null && region_.getType().equals(CSS_COMMENT)) {
                selectText = _document.get(region_.getOffset(), region_.getLength());
                this.setCSSReplaceContent(buf, region_, selectText);
                return;
            }
            int lineNum = this.textSelection.getStartLine();
            IRegion lineInfo = _document.getLineInformation(lineNum);
            selectText = _document.get(lineInfo.getOffset(), lineInfo.getLength());
            String content = selectText.trim();
            if (StringUtil.isBlank((String)content)) {
                buf.append("/**/");
                this.startOffset = this.textSelection.getOffset();
                this.replaceLength = 0;
                this.selectionOffset = this.startOffset + CSS_BEGIN_COMMENT_TAG.length();
                return;
            }
            if (content.endsWith(CSS_END_COMMENT_TAG)) {
                int index = selectText.indexOf(CSS_END_COMMENT_TAG);
                region = _document.getPartition(this.textSelection.getOffset() - (selectText.length() - index));
                if (region != null && region.getType().equals(CSS_COMMENT)) {
                    selectText = _document.get(region.getOffset(), region.getLength());
                    this.setCSSReplaceContent(buf, region, selectText);
                    this.selectionOffset = lineInfo.getOffset() + lineInfo.getLength() + (buf.toString().length() - selectText.length());
                    return;
                }
            }
            String replaceContent = CSS_BEGIN_COMMENT_TAG + content + CSS_END_COMMENT_TAG;
            selectText = selectText.replace(content, replaceContent);
            buf.append(selectText);
            this.replaceLength = lineInfo.getLength();
            this.startOffset = lineInfo.getOffset();
        }
    }

    private void setCSSReplaceContent(StringBuilder buf, ITypedRegion region, String selectText) {
        selectText = selectText.substring(CSS_BEGIN_COMMENT_TAG.length());
        selectText = selectText.substring(0, selectText.length() - CSS_END_COMMENT_TAG.length());
        buf.append(selectText);
        this.replaceLength = region.getLength();
        this.startOffset = region.getOffset();
    }

    private void getHTMLCommentContent(StringBuilder buf) throws BadLocationException {
        int offset = this.textSelection.getOffset();
        if (offset == _document.getLength()) {
            --offset;
        }
        ITypedRegion region = _document.getPartition(offset);
        String selectText = this.textSelection.getText();
        ITypedRegion region_ = null;
        if (offset > 0) {
            region_ = _document.getPartition(offset - 1);
        }
        if (this.textSelection.getLength() > 0) {
            if (region != null && region.getType().equals(HTML_COMMENT)) {
                selectText = _document.get(region.getOffset(), region.getLength());
                this.setHtmlReplaceContent(buf, region, selectText);
            } else {
                buf.append(HTML_START_COMMENT_TAG);
                buf.append(selectText);
                buf.append(HTML_END_COMMENT_TAG);
                this.replaceLength = this.textSelection.getLength();
                this.startOffset = this.textSelection.getOffset();
            }
        } else {
            if (region != null && region.getType().equals(HTML_COMMENT)) {
                selectText = _document.get(region.getOffset(), region.getLength());
                this.setHtmlReplaceContent(buf, region, selectText);
                return;
            }
            if (region_ != null && region_.getType().equals(HTML_COMMENT)) {
                selectText = _document.get(region_.getOffset(), region_.getLength());
                this.setHtmlReplaceContent(buf, region_, selectText);
                return;
            }
            int lineNum = this.textSelection.getStartLine();
            IRegion lineInfo = _document.getLineInformation(lineNum);
            selectText = _document.get(lineInfo.getOffset(), lineInfo.getLength());
            String content = selectText.trim();
            if (StringUtil.isBlank((String)content)) {
                buf.append("<!---->");
                this.startOffset = this.textSelection.getOffset();
                this.replaceLength = 0;
                this.selectionOffset = this.startOffset + HTML_START_COMMENT_TAG.length();
                return;
            }
            if (content.endsWith(HTML_END_COMMENT_TAG)) {
                int index = selectText.indexOf(HTML_END_COMMENT_TAG);
                region = _document.getPartition(this.textSelection.getOffset() - (selectText.length() - index));
                if (region != null && region.getType().equals(HTML_COMMENT)) {
                    selectText = _document.get(region.getOffset(), region.getLength());
                    this.setHtmlReplaceContent(buf, region, selectText);
                    this.selectionOffset = lineInfo.getOffset() + lineInfo.getLength() + (buf.toString().length() - selectText.length());
                    return;
                }
            }
            String replaceContent = HTML_START_COMMENT_TAG + content + HTML_END_COMMENT_TAG;
            selectText = selectText.replace(content, replaceContent);
            buf.append(selectText);
            this.replaceLength = lineInfo.getLength();
            this.startOffset = lineInfo.getOffset();
        }
    }

    private void setHtmlReplaceContent(StringBuilder buf, ITypedRegion region, String selectText) {
        selectText = selectText.substring(HTML_START_COMMENT_TAG.length());
        selectText = selectText.substring(0, selectText.length() - HTML_END_COMMENT_TAG.length());
        buf.append(selectText);
        this.replaceLength = region.getLength();
        this.startOffset = region.getOffset();
    }

    private void getHTMLCommentContent(int startLineNum, int endLineNum, StringBuilder buf) throws BadLocationException {
        ITypedRegion region = _document.getPartition(this.textSelection.getOffset());
        ITypedRegion region_ = null;
        if (this.textSelection.getOffset() > 0) {
            region_ = _document.getPartition(this.textSelection.getOffset() - 1);
        }
        if (region != null && region.getType().equals(HTML_COMMENT)) {
            String content = _document.get(region.getOffset(), region.getLength());
            content = content.replace(HTML_START_COMMENT_TAG, "");
            content = content.replace(HTML_END_COMMENT_TAG, "");
            buf.append(content);
            this.startOffset = region.getOffset();
            this.endOffset = this.startOffset + region.getLength();
        } else if (region_ != null && region_.getType().equals(CSS_COMMENT)) {
            String content = _document.get(region_.getOffset(), region_.getLength());
            content = content.replace(HTML_START_COMMENT_TAG, "");
            content = content.replace(HTML_END_COMMENT_TAG, "");
            buf.append(content);
            this.startOffset = region_.getOffset();
            this.endOffset = this.startOffset + region_.getLength();
        } else {
            int lineNum = startLineNum;
            while (lineNum < endLineNum + 1) {
                IRegion info = _document.getLineInformation(lineNum);
                String line = _document.get(info.getOffset(), info.getLength());
                if (lineNum == startLineNum) {
                    String text = line.trim();
                    String replaceText = HTML_START_COMMENT_TAG + text;
                    line = line.replace(text, replaceText);
                }
                if (lineNum == endLineNum) {
                    buf.append(line);
                    buf.append(HTML_END_COMMENT_TAG);
                } else {
                    buf.append(line).append(WRAP_TAG);
                }
                ++lineNum;
            }
        }
    }

    private void getCSSCommentContent(int startLineNum, int endLineNum, StringBuilder buf) throws BadLocationException {
        ITypedRegion region = _document.getPartition(this.textSelection.getOffset());
        ITypedRegion region_ = null;
        if (this.textSelection.getOffset() > 0) {
            region_ = _document.getPartition(this.textSelection.getOffset() - 1);
        }
        if (region != null && region.getType().equals(CSS_COMMENT)) {
            String content = _document.get(region.getOffset(), region.getLength());
            content = content.replace(CSS_BEGIN_COMMENT_TAG, "");
            content = content.replace(CSS_END_COMMENT_TAG, "");
            buf.append(content);
            this.startOffset = region.getOffset();
            this.endOffset = this.startOffset + region.getLength();
        } else if (region_ != null && region_.getType().equals(CSS_COMMENT)) {
            String content = _document.get(region_.getOffset(), region_.getLength());
            content = content.replace(CSS_BEGIN_COMMENT_TAG, "");
            content = content.replace(CSS_END_COMMENT_TAG, "");
            buf.append(content);
            this.startOffset = region_.getOffset();
            this.endOffset = this.startOffset + region_.getLength();
        } else {
            int lineNum = startLineNum;
            while (lineNum < endLineNum + 1) {
                IRegion info = _document.getLineInformation(lineNum);
                String line = _document.get(info.getOffset(), info.getLength());
                if (lineNum == startLineNum) {
                    String text = line.trim();
                    String replaceText = CSS_BEGIN_COMMENT_TAG + text;
                    line = line.replace(text, replaceText);
                }
                if (lineNum == endLineNum) {
                    buf.append(line);
                    buf.append(CSS_END_COMMENT_TAG);
                } else {
                    buf.append(line).append(WRAP_TAG);
                }
                ++lineNum;
            }
        }
    }

    private void getJSCommentContent(int startLineNum, int endLineNum, StringBuilder buf) throws BadLocationException {
        int lineNum = startLineNum;
        boolean isCommented = this.checkJSCommented(startLineNum, endLineNum);
        while (lineNum < endLineNum + 1) {
            IRegion info = _document.getLineInformation(lineNum);
            if (info == null || info.getLength() < 0 || info.getOffset() < 0) continue;
            String line = _document.get(info.getOffset(), info.getLength());
            if (StringUtil.isBlank((String)line) && ++lineNum == endLineNum + 1 && startLineNum == endLineNum) {
                buf.append(commentString);
                this.startOffset = this.textSelection.getOffset();
                this.replaceLength = 0;
                this.selectionOffset = this.startOffset + commentString.length();
                return;
            }
            line = this.getReplaceLine(isCommented, line);
            if (lineNum == endLineNum + 1) {
                buf.append(line);
                continue;
            }
            buf.append(line).append(WRAP_TAG);
        }
        this.replaceLength = this.endOffset - this.startOffset;
    }

    private String getReplaceLine(boolean isCommented, String line) {
        if (isCommented) {
            if (this.isStarted) {
                if ((line = line.replaceFirst(commentString, "")).startsWith(" ")) {
                    line = String.valueOf(spaceString) + line;
                }
            } else {
                String cs = commentString.trim();
                int index = line.indexOf(cs);
                if (index > -1) {
                    String content = line.substring(index);
                    String replaceContent = content.replaceFirst(commentString.trim(), "").trim();
                    line = line.replace(content, replaceContent);
                }
            }
        } else {
            line = this.getCommentReplaceLine(line);
        }
        return line;
    }

    private String getCommentReplaceLine(String line) {
        if (this.isStarted) {
            line = line.startsWith(spaceString) ? line.replaceFirst(spaceString, commentString) : String.valueOf(commentString) + line;
        } else {
            String content = line.trim();
            if (StringUtil.isNotBlank((String)content)) {
                String replaceContent = String.valueOf(commentString) + content;
                line = line.replace(content, replaceContent);
            } else {
                line = String.valueOf(line) + commentString;
            }
        }
        return line;
    }

    private boolean checkJSCommented(int startLineNum, int endLineNum) throws BadLocationException {
        boolean isCommented = true;
        int lineNum = startLineNum;
        String cs = commentString.trim();
        while (lineNum < endLineNum + 1) {
            IRegion info = _document.getLineInformation(lineNum);
            String line = _document.get(info.getOffset(), info.getLength());
            if (StringUtil.isBlank((String)line)) {
                isCommented = false;
                break;
            }
            if (!line.trim().startsWith(cs)) {
                isCommented = false;
                break;
            }
            ++lineNum;
        }
        return isCommented;
    }
}

