/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.commands;

import com.aptana.editor.common.AbstractThemeableEditor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerRulerAction;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class BookmarkHandler
extends AbstractHandler {
    private static final String BUNDLE_FOR_CONSTRUCTED_KEYS = "org.eclipse.ui.texteditor.ConstructedTextEditorMessages";
    private static ResourceBundle fgBundleForConstructedKeys = ResourceBundle.getBundle("org.eclipse.ui.texteditor.ConstructedTextEditorMessages");

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IVerticalRulerInfo rulerInfo;
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor instanceof AbstractThemeableEditor && (rulerInfo = (IVerticalRulerInfo)editor.getAdapter(IVerticalRulerInfo.class)) != null) {
            MyMarkerRulerAction m = new MyMarkerRulerAction(fgBundleForConstructedKeys, "Editor.ManageBookmarks.", (ITextEditor)editor, rulerInfo, "org.eclipse.core.resources.bookmark", true);
            m.update();
            m.run();
        }
        return null;
    }

    private static class MyMarkerRulerAction
    extends MarkerRulerAction {
        private ITextEditor fTextEditor;
        private List fMarkers;
        private String fAddLabel;
        private String fRemoveLabel;

        public MyMarkerRulerAction(ResourceBundle bundle, String prefix, ITextEditor editor, IVerticalRulerInfo ruler, String markerType, boolean askForLabel) {
            super(bundle, prefix, editor, ruler, markerType, askForLabel);
            this.fTextEditor = editor;
            this.fAddLabel = MyMarkerRulerAction.getString((ResourceBundle)bundle, (String)(String.valueOf(prefix) + "add.label"), (String)(String.valueOf(prefix) + "add.label"));
            this.fRemoveLabel = MyMarkerRulerAction.getString((ResourceBundle)bundle, (String)(String.valueOf(prefix) + "remove.label"), (String)(String.valueOf(prefix) + "remove.label"));
        }

        public void run() {
            if (this.fMarkers.isEmpty()) {
                this.addMarker();
            } else {
                this.removeMarkers(this.fMarkers);
            }
        }

        protected Map getInitialAttributes() {
            HashMap attributes = new HashMap(11);
            IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
            IDocument document = provider.getDocument((Object)this.fTextEditor.getEditorInput());
            ITextSelection selection = (ITextSelection)this.fTextEditor.getSelectionProvider().getSelection();
            int line = selection.getStartLine();
            int start = -1;
            int end = -1;
            int length = 0;
            try {
                IRegion lineInformation = document.getLineInformation(line);
                start = lineInformation.getOffset();
                length = lineInformation.getLength();
                end = start + length;
            }
            catch (BadLocationException badLocationException) {}
            MarkerUtilities.setMessage(attributes, (String)this.getLabelProposal(document, start, length));
            MarkerUtilities.setLineNumber(attributes, (int)(line + 1));
            MarkerUtilities.setCharStart(attributes, (int)start);
            MarkerUtilities.setCharEnd(attributes, (int)end);
            return attributes;
        }

        public void update() {
            IDocument document = this.getDocument();
            if (document != null) {
                ITextSelection selection = (ITextSelection)this.fTextEditor.getSelectionProvider().getSelection();
                int line = selection.getStartLine();
                if (line > document.getNumberOfLines()) {
                    this.setEnabled(false);
                    this.setText(this.fAddLabel);
                } else {
                    this.fMarkers = this.getMarkers();
                    this.setEnabled(this.getResource() != null && (this.fMarkers.isEmpty() || this.markersUserEditable(this.fMarkers)));
                    this.setText(this.fMarkers.isEmpty() ? this.fAddLabel : this.fRemoveLabel);
                }
            }
        }

        private boolean markersUserEditable(List markers) {
            Iterator iter = markers.iterator();
            while (iter.hasNext()) {
                if (this.isUserEditable((IMarker)iter.next())) continue;
                return false;
            }
            return true;
        }

        private boolean isUserEditable(IMarker marker) {
            return marker != null && marker.exists() && marker.getAttribute("userEditable", true);
        }

        protected boolean includesRulerLine(Position position, IDocument document) {
            if (position != null) {
                try {
                    int markerLine = document.getLineOfOffset(position.getOffset());
                    ITextSelection selection = (ITextSelection)this.fTextEditor.getSelectionProvider().getSelection();
                    int line = selection.getStartLine();
                    if (line == markerLine) {
                        return true;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            return false;
        }
    }
}

