/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.IFoldingEditor;
import com.aptana.editor.common.internal.save.EditorSaveManager;
import com.aptana.index.core.IndexFilesOfProjectJob;
import com.aptana.index.core.RemoveIndexOfFilesOfProjectJob;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;

public class AbstractFoldingEditor
extends AbstractDecoratedTextEditor
implements IFoldingEditor {
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){
        private Runnable fRunnable = new Runnable(){

            @Override
            public void run() {
                ISourceViewer sourceViewer = AbstractFoldingEditor.this.getSourceViewer();
                if (sourceViewer != null && sourceViewer.getDocument() != null) {
                    AbstractFoldingEditor.this.updateSelectionDependentActions();
                }
            }
        };
        private Display fDisplay;

        public void selectionChanged(SelectionChangedEvent event) {
            Display current = Display.getCurrent();
            if (current != null) {
                this.fRunnable.run();
            } else {
                if (this.fDisplay == null) {
                    this.fDisplay = AbstractFoldingEditor.this.getSite().getShell().getDisplay();
                }
                this.fDisplay.asyncExec(this.fRunnable);
            }
            AbstractFoldingEditor.this.handleCursorPositionChanged();
        }
    };
    private static final Object lockUpdateFoldingStructure = new Object();

    public AbstractFoldingEditor() {
        try {
            Field field = AbstractTextEditor.class.getDeclaredField("fSelectionChangedListener");
            field.setAccessible(true);
            field.set(this, this.selectionChangedListener);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        ProjectionSupport projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        projectionSupport.install();
        viewer.doOperation(19);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFoldingStructure(Map<ProjectionAnnotation, Position> annotations) {
        ArrayList<Annotation> deletions = new ArrayList<Annotation>();
        Collection<Position> additions = annotations.values();
        Object object = lockUpdateFoldingStructure;
        synchronized (object) {
            ProjectionAnnotationModel currentModel = this.getAnnotationModel();
            if (currentModel == null) {
                return;
            }
            Iterator iter = currentModel.getAnnotationIterator();
            while (iter.hasNext()) {
                Object annotation = iter.next();
                if (!(annotation instanceof ProjectionAnnotation)) continue;
                Position position = currentModel.getPosition((Annotation)annotation);
                if (additions.contains(position)) {
                    additions.remove(position);
                    continue;
                }
                deletions.add((Annotation)annotation);
            }
            if (annotations.size() != 0 || deletions.size() != 0) {
                currentModel.modifyAnnotations(deletions.toArray(new Annotation[deletions.size()]), annotations, null);
            }
        }
    }

    protected ProjectionAnnotationModel getAnnotationModel() {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer instanceof ProjectionViewer) {
            return ((ProjectionViewer)viewer).getProjectionAnnotationModel();
        }
        return null;
    }

    protected void handleEditorInputChanged() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            this.close(false);
            return;
        }
        IEditorInput input = this.getEditorInput();
        boolean wasActivated = true;
        try {
            Field f = AbstractTextEditor.class.getDeclaredField("fHasBeenActivated");
            f.setAccessible(true);
            wasActivated = (Boolean)f.get(this);
        }
        catch (Exception exception) {}
        if (!wasActivated && !provider.isDeleted((Object)input)) {
            try {
                if (provider instanceof IDocumentProviderExtension) {
                    IDocumentProviderExtension extension = (IDocumentProviderExtension)provider;
                    extension.synchronize((Object)input);
                } else {
                    this.doSetInput(input);
                }
                return;
            }
            catch (Exception exception) {}
        }
        super.handleEditorInputChanged();
    }

    public void dispose() {
        try {
            IFile file;
            if (this.selectionChangedListener != null) {
                try {
                    this.getSelectionProvider().removeSelectionChangedListener(this.selectionChangedListener);
                    this.getSelectionProvider().removeSelectionChangedListener(this.getSelectionChangedListener());
                }
                catch (Throwable throwable) {}
            }
            if (this.isDirty() && (file = this.getFile()) != null) {
                new Job("Update index"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                            IProject project = file.getProject();
                            Set files = CollectionsUtil.newSet((Object[])new IFile[]{file});
                            if (sub.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            new RemoveIndexOfFilesOfProjectJob(project, files).run((IProgressMonitor)sub.newChild(10));
                            new IndexFilesOfProjectJob(project, files).run((IProgressMonitor)sub.newChild(90));
                            sub.done();
                        }
                        catch (Exception exception) {}
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
        catch (Throwable throwable) {
            try {
                super.dispose();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            super.dispose();
        }
        catch (Exception exception) {}
    }

    private IFile getFile() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return fileEditorInput.getFile();
        }
        return null;
    }

    protected void editorSaved() {
        super.editorSaved();
        EditorSaveManager.getInstance().postEditorSave((IEditorPart)this);
    }
}

