/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.contentassist;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ConfigurationElementDispatcher;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.ResourceUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.ui.epl.UIEplPlugin;
import com.aptana.ui.util.UIUtils;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class UserAgentManager {
    public static final UserAgent[] NO_USER_AGENTS = new UserAgent[0];
    private static UserAgentManager INSTANCE;
    private static final String OTHER_NATURE_ID = "<other>";
    private static final String[] LAST_RESORT_DEFAULT_USER_AGENT;
    private static final String USER_AGENT_DELIMITER = ",";
    private static final String ENTRY_DELIMITER = ";";
    private static final String NAME_VALUE_SEPARATOR = ":";
    private static final Map<String, UserAgent> USER_AGENTS_BY_ID;
    private static final Map<String, UserAgent> SDK_AGENTS_BY_ID;
    private static Map<String, Set<String>> DEFAULT_USER_AGENT_IDS;
    private static Map<String, String[]> ACTIVE_USER_AGENTS_BY_NATURE_ID;
    private static final String USERAGENT_ID = "userAgent";
    private static final String ELEMENT_USER_AGENT = "user-agent";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ID = "id";
    private static final String ATTR_ICON = "icon";
    private static final String ATTR_ICON_PARTIAL = "icon-partial";
    private static final String ATTR_ICON_DISABLED = "icon-disabled";
    private static final String ELEMENT_DEFAULT_USER_AGENTS = "default-user-agents";
    private static final String ELEMENT_USER_AGENT_REF = "user-agent-ref";
    private static final String ATTR_NATURE_ID = "nature-id";
    private static final String ATTR_USER_AGENT_ID = "user-agent-id";
    private ImageRegistry imageRegistry;

    static {
        LAST_RESORT_DEFAULT_USER_AGENT = new String[]{"IE", "Mozilla", "Chrome"};
        USER_AGENTS_BY_ID = new HashMap<String, UserAgent>();
        SDK_AGENTS_BY_ID = new HashMap<String, UserAgent>();
        DEFAULT_USER_AGENT_IDS = new HashMap<String, Set<String>>();
    }

    private static void addDefaultUserAgentID(String natureID, String userAgentID) {
        if (!DEFAULT_USER_AGENT_IDS.containsKey(natureID)) {
            DEFAULT_USER_AGENT_IDS.put(natureID, new HashSet());
        }
        DEFAULT_USER_AGENT_IDS.get(natureID).add(userAgentID);
    }

    public static synchronized UserAgentManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UserAgentManager();
            INSTANCE.loadExtension();
            INSTANCE.loadPreference();
        }
        return INSTANCE;
    }

    private UserAgentManager() {
    }

    public String[] getActiveUserAgentIDs(IProject project) {
        String agents;
        if (project == null) {
            return ArrayUtil.NO_STRINGS;
        }
        String[] natureIDs = UserAgentManager.getProjectNatures(project);
        ProjectScope scope = new ProjectScope(project);
        IEclipsePreferences node = scope.getNode("com.aptana.editor.common");
        if (node != null && (agents = node.get("selectUserAgents", null)) != null) {
            Map<String, String[]> userAgents = this.extractUserAgents(agents);
            return this.getActiveUserAgentIDs(userAgents, natureIDs);
        }
        return this.getActiveUserAgentIDs(natureIDs);
    }

    public static String[] getProjectNatures(IProject project) {
        String[] natureIDs = ArrayUtil.NO_STRINGS;
        try {
            natureIDs = ResourceUtil.getAptanaNatures((IProjectDescription)project.getDescription());
        }
        catch (CoreException e) {
            IdeLog.logWarning((Plugin)CommonEditorPlugin.getDefault(), (String)("Problem detecting the project's nature IDs for " + project.getName()), (Throwable)e, (String)"com.aptana.editor.common/debug/content_assist");
        }
        return natureIDs;
    }

    public String[] getActiveUserAgentIDs(String ... natureIDs) {
        return this.getActiveUserAgentIDs(ACTIVE_USER_AGENTS_BY_NATURE_ID, natureIDs);
    }

    private String[] getActiveUserAgentIDs(Map<String, String[]> userAgents, String ... natureIDs) {
        String[] result = ArrayUtil.NO_STRINGS;
        if (userAgents == null) {
            return result;
        }
        if (!ArrayUtil.isEmpty((Object[])natureIDs)) {
            HashSet<String> userAgentIDS = new HashSet<String>();
            String[] stringArray = natureIDs;
            int n = natureIDs.length;
            int n2 = 0;
            while (n2 < n) {
                String[] uaids;
                String natureID = stringArray[n2];
                if (!StringUtil.isBlank((String)natureID) && (uaids = userAgents.get(natureID)) != null && uaids.length >= 1) {
                    userAgentIDS.addAll(Arrays.asList(uaids));
                }
                ++n2;
            }
            result = new String[userAgentIDS.size()];
            result = userAgentIDS.toArray(result);
        } else {
            IdeLog.logWarning((Plugin)CommonEditorPlugin.getDefault(), (String)"UserAgentManager - Got empty natures list", (String)"com.aptana.editor.common/debug/content_assist");
        }
        return result;
    }

    public UserAgent[] getActiveUserAgents(IProject project) {
        return this.getUserAgentsByID(this.getActiveUserAgentIDs(project));
    }

    public UserAgent[] getActiveUserAgents(String ... natureIDs) {
        return this.getUserAgentsByID(this.getActiveUserAgentIDs(natureIDs));
    }

    public UserAgent[] getAllUserAgents() {
        ArrayList<UserAgent> all = new ArrayList<UserAgent>();
        all.addAll(USER_AGENTS_BY_ID.values());
        all.addAll(SDK_AGENTS_BY_ID.values());
        return all.toArray(new UserAgent[all.size()]);
    }

    public String[] getDefaultUserAgentIDs(String natureID) {
        String[] result;
        if (DEFAULT_USER_AGENT_IDS.containsKey(natureID)) {
            Set<String> userAgentIDs = DEFAULT_USER_AGENT_IDS.get(natureID);
            result = userAgentIDs.toArray(new String[userAgentIDs.size()]);
        } else if (DEFAULT_USER_AGENT_IDS.containsKey(OTHER_NATURE_ID)) {
            Set<String> userAgentIDs = DEFAULT_USER_AGENT_IDS.get(OTHER_NATURE_ID);
            result = userAgentIDs.toArray(new String[userAgentIDs.size()]);
        } else {
            result = LAST_RESORT_DEFAULT_USER_AGENT;
        }
        return result;
    }

    public UserAgent[] getDefaultUserAgents(String natureID) {
        UserAgent[] result = NO_USER_AGENTS;
        String[] userAgentIDs = this.getDefaultUserAgentIDs(natureID);
        if (userAgentIDs != null) {
            result = this.getUserAgentsByID(userAgentIDs);
        }
        return result;
    }

    public Image getImage(String iconPath) {
        Image result = null;
        if (iconPath != null) {
            String iconFilename;
            File file;
            if (this.imageRegistry == null) {
                this.imageRegistry = new ImageRegistry();
            }
            if ((file = new File(iconPath)).exists() && (result = this.imageRegistry.get(iconFilename = file.getAbsolutePath())) == null) {
                result = new Image((Device)UIUtils.getDisplay(), iconFilename);
                this.imageRegistry.put(iconFilename, result);
            }
        }
        return result;
    }

    public Image[] getAllUserAgentImagesWithoutSDK(IProject project) {
        ArrayList<Image> result = new ArrayList<Image>();
        UserAgent[] activeUserAgents = this.getActiveUserAgents(project);
        int i = 0;
        while (i < activeUserAgents.length) {
            UserAgent userAgent = activeUserAgents[i];
            if (userAgent != null && !this.isSDKAgents(userAgent.ID)) {
                result.add(this.getImage(userAgent.enabledIconPath));
            }
            ++i;
        }
        return result.toArray(new Image[result.size()]);
    }

    public Map<String, String> getAllUserAgentPathWithoutSDK(IProject project) {
        ArrayList<String> result = new ArrayList<String>();
        UserAgent[] activeUserAgents = this.getActiveUserAgents(project);
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < activeUserAgents.length) {
            UserAgent userAgent = activeUserAgents[i];
            if (userAgent != null && !this.isSDKAgents(userAgent.ID)) {
                result.add(userAgent.enabledIconPath);
                map.put(userAgent.enabledIconPath, "");
            }
            ++i;
        }
        return map;
    }

    public Image[] getUserAgentImages(IProject project, Map<String, String> userAgentsWithVersion) {
        if (userAgentsWithVersion == null || userAgentsWithVersion.size() == 0) {
            return null;
        }
        UserAgent[] activeUserAgents = this.getActiveUserAgents(project);
        Set<String> enabledAgents = userAgentsWithVersion.keySet();
        ArrayList<Image> result = new ArrayList<Image>();
        boolean isSDK = this.isSDKAgents(enabledAgents.toArray(new String[enabledAgents.size()]));
        int i = 0;
        while (i < activeUserAgents.length) {
            UserAgent userAgent = activeUserAgents[i];
            if (userAgent != null && (!isSDK && !this.isSDKAgents(userAgent.ID) || isSDK && this.isSDKAgents(userAgent.ID))) {
                result.add(enabledAgents.contains(userAgent.ID) ? (this.enabledAllVersion(userAgentsWithVersion.get(userAgent.ID), userAgent.ID) ? this.getImage(userAgent.enabledIconPath) : this.getImage(userAgent.enabledPartialIconPath)) : this.getImage(userAgent.disabledIconPath));
            }
            ++i;
        }
        return result.toArray(new Image[result.size()]);
    }

    public Map<String, String> getUserAgentPath(IProject project, Map<String, String> userAgentsWithVersion) {
        if (userAgentsWithVersion == null || userAgentsWithVersion.size() == 0) {
            return null;
        }
        UserAgent[] activeUserAgents = this.getActiveUserAgents(project);
        Set<String> enabledAgents = userAgentsWithVersion.keySet();
        HashMap<String, String> userAgents = new HashMap<String, String>();
        boolean isSDK = this.isSDKAgents(enabledAgents.toArray(new String[enabledAgents.size()]));
        int i = 0;
        while (i < activeUserAgents.length) {
            UserAgent userAgent = activeUserAgents[i];
            boolean isSDKA = this.isSDKAgents(userAgent.ID);
            if (userAgent != null && (!isSDK && !isSDKA || isSDK && isSDKA)) {
                if (enabledAgents.contains(userAgent.ID)) {
                    if (this.enabledAllVersion(userAgentsWithVersion.get(userAgent.ID), userAgent.ID)) {
                        userAgents.put(userAgent.enabledIconPath, "");
                    } else {
                        userAgents.put(userAgent.enabledPartialIconPath, userAgentsWithVersion.get(userAgent.ID));
                    }
                } else if (!isSDKA && !isSDK) {
                    userAgents.put(userAgent.disabledIconPath, "");
                }
            }
            ++i;
        }
        return userAgents;
    }

    private boolean enabledAllVersion(String version, String id) {
        if (StringUtil.isBlank((String)version) || StringUtil.isBlank((String)id)) {
            return false;
        }
        id = id.trim();
        if (!(version = version.trim()).endsWith("+")) {
            return false;
        }
        if ((version = version.substring(0, version.length() - 1)).indexOf(USER_AGENT_DELIMITER) > 0) {
            String[] vs = version.split(USER_AGENT_DELIMITER);
            version = vs[vs.length - 1];
        }
        int dIndex = version.indexOf(".");
        String v = "";
        if (dIndex > 0) {
            String[] vs = version.split("\\.");
            v = vs[0];
        } else {
            v = version;
        }
        if ("IE".equals(id)) {
            return this.compareVersion(v, "7");
        }
        if ("Chrome".equals(id)) {
            return true;
        }
        if ("Safari".equals(id)) {
            return this.compareVersion(v, "5");
        }
        if ("Safari/iOS".equals(id)) {
            return this.compareVersion(v, "5");
        }
        if ("Mozilla".equals(id)) {
            return true;
        }
        if ("Netscape".equals(id)) {
            return true;
        }
        if ("Android".equals(id)) {
            return this.compareVersion(v, "2.3");
        }
        if ("Opera".equals(id)) {
            return true;
        }
        if ("IOS-h5+".equals(id)) {
            return true;
        }
        if ("Android-h5+".equals(id)) {
            return true;
        }
        return "WP-h5+".equals(id);
    }

    private boolean compareVersion(String v, String compareVer) {
        block5: {
            block4: {
                try {
                    if (!StringUtil.isEmpty((String)v) && !StringUtil.isEmpty((String)compareVer)) break block4;
                    return false;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            if (v.indexOf("N/A") <= -1 && compareVer.indexOf("N/A") <= -1) break block5;
            return false;
        }
        Float vf = Float.valueOf(v);
        Float cf = Float.valueOf(compareVer);
        return vf.floatValue() <= cf.floatValue();
    }

    public UserAgent[] getUserAgentsByID(String ... ids) {
        ArrayList<UserAgent> result = new ArrayList<UserAgent>();
        if (ids != null && ids.length > 0) {
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                UserAgent userAgent = USER_AGENTS_BY_ID.get(id);
                UserAgent sdkAgent = SDK_AGENTS_BY_ID.get(id);
                if (userAgent != null || sdkAgent != null) {
                    result.add(userAgent != null ? userAgent : sdkAgent);
                }
                ++n2;
            }
        }
        return result.toArray(new UserAgent[result.size()]);
    }

    private void loadExtension() {
        ConfigurationElementDispatcher dispatcher = new ConfigurationElementDispatcher(new IConfigurationElementProcessor[]{new UserAgentProcessor(), new DefaultUserAgentsProcessor()});
        EclipseUtil.processConfigurationElements((String)"com.aptana.editor.common", (String)USERAGENT_ID, (IConfigurationElementProcessor)dispatcher);
    }

    public void loadPreference() {
        Map<String, String[]> result;
        ChainedPreferenceStore chainedStore = new ChainedPreferenceStore(new IPreferenceStore[]{CommonEditorPlugin.getDefault().getPreferenceStore(), UIEplPlugin.getDefault().getPreferenceStore()});
        String preferenceValue = chainedStore.getString("selectUserAgents");
        if (!StringUtil.isEmpty((String)preferenceValue)) {
            result = this.extractUserAgents(preferenceValue);
        } else {
            result = new HashMap<String, String[]>();
            for (String natureID : ResourceUtil.getAptanaNaturesMap().values()) {
                result.put(natureID, this.getDefaultUserAgentIDs(natureID));
            }
        }
        ACTIVE_USER_AGENTS_BY_NATURE_ID = result;
    }

    private Map<String, String[]> extractUserAgents(String preferenceValue) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        if (preferenceValue.contains(NAME_VALUE_SEPARATOR)) {
            String[] entries;
            String[] stringArray = entries = preferenceValue.split(ENTRY_DELIMITER);
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                String[] nameValue = entry.split(NAME_VALUE_SEPARATOR);
                String natureID = nameValue[0];
                if (nameValue.length > 1) {
                    String userAgentIDsString = nameValue[1];
                    String[] userAgentIDs = userAgentIDsString.split(USER_AGENT_DELIMITER);
                    result.put(natureID, userAgentIDs);
                } else {
                    result.put(natureID, ArrayUtil.NO_STRINGS);
                }
                ++n2;
            }
        } else {
            String[] userAgentIDs = preferenceValue.split(USER_AGENT_DELIMITER);
            for (String natureID : ResourceUtil.getAptanaNaturesMap().values()) {
                result.put(natureID, userAgentIDs);
            }
        }
        return result;
    }

    public void savePreference() {
        this.savePreference(null, ACTIVE_USER_AGENTS_BY_NATURE_ID);
    }

    public void savePreference(IProject project, Map<String, String[]> natureIdToUserAgents) {
        IEclipsePreferences preferences = null;
        preferences = project != null ? new ProjectScope(project).getNode("com.aptana.editor.common") : EclipseUtil.instanceScope().getNode("com.aptana.editor.common");
        ArrayList<String> natureEntries = new ArrayList<String>();
        for (Map.Entry<String, String[]> entry : natureIdToUserAgents.entrySet()) {
            String natureID = entry.getKey();
            String userAgentIDs = StringUtil.join((String)USER_AGENT_DELIMITER, (String[])entry.getValue());
            natureEntries.add(String.valueOf(natureID) + NAME_VALUE_SEPARATOR + userAgentIDs);
        }
        String value = StringUtil.join((String)ENTRY_DELIMITER, natureEntries);
        if (preferences != null) {
            preferences.put("selectUserAgents", value);
            try {
                preferences.flush();
            }
            catch (BackingStoreException e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)"Error saving the user-agent preferences.", (Throwable)e);
            }
        } else {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)"Error saving the user-agent preferences. Preferences node was null");
        }
    }

    public void clearPreferences(IProject project) {
        if (project != null) {
            IEclipsePreferences preferences = new ProjectScope(project).getNode("com.aptana.editor.common");
            preferences.remove("selectUserAgents");
            try {
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    public void setActiveUserAgents(String natureID, String[] userAgentIDs) {
        if (!StringUtil.isEmpty((String)natureID)) {
            String[] value = userAgentIDs != null ? userAgentIDs : ArrayUtil.NO_STRINGS;
            ACTIVE_USER_AGENTS_BY_NATURE_ID.put(natureID, value);
        }
    }

    public boolean isSDKAgents(String ... userAgentIDs) {
        String[] stringArray = userAgentIDs;
        int n = userAgentIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String userAgentID = stringArray[n2];
            if (userAgentID != null && !userAgentID.toLowerCase().endsWith("h5+")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private class DefaultUserAgentsProcessor
    implements IConfigurationElementProcessor {
        private DefaultUserAgentsProcessor() {
        }

        public void processElement(IConfigurationElement element) {
            String natureID = element.getAttribute(UserAgentManager.ATTR_NATURE_ID);
            IConfigurationElement[] iConfigurationElementArray = element.getChildren(UserAgentManager.ELEMENT_USER_AGENT_REF);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ref = iConfigurationElementArray[n2];
                String userAgentID = ref.getAttribute(UserAgentManager.ATTR_USER_AGENT_ID);
                UserAgentManager.addDefaultUserAgentID(natureID, userAgentID);
                ++n2;
            }
        }

        public Set<String> getSupportElementNames() {
            return CollectionsUtil.newSet((Object[])new String[]{UserAgentManager.ELEMENT_DEFAULT_USER_AGENTS});
        }
    }

    public static class UserAgent
    implements Comparable<UserAgent> {
        public static final String IE = "IE";
        public static final String FIREFOX = "Mozilla";
        public static final String NETSCAPE = "Netscape";
        public static final String OPERA = "Opera";
        public static final String SAFARI = "Safari";
        public static final String IOS = "Safari/iOS";
        public static final String CHROME = "Chrome";
        public static final String ANDROID = "Android";
        public static final String ANDROID_H5 = "Android-h5+";
        public static final String IOS_H5 = "IOS-h5+";
        public static final String WP_H5 = "WP-h5+";
        public final String ID;
        public final String name;
        public final String enabledIconPath;
        public final String enabledPartialIconPath;
        public final String disabledIconPath;

        public UserAgent(String ID, String name, String enabledIconPath, String enabledPartialIconPath, String disabledIconPath) {
            this.ID = ID;
            this.name = name;
            this.enabledIconPath = enabledIconPath;
            this.enabledPartialIconPath = enabledPartialIconPath;
            this.disabledIconPath = disabledIconPath;
        }

        @Override
        public int compareTo(UserAgent o) {
            String name = o != null ? o.name : "";
            return this.name.compareToIgnoreCase(name);
        }
    }

    private class UserAgentProcessor
    implements IConfigurationElementProcessor {
        private UserAgentProcessor() {
        }

        public void processElement(IConfigurationElement element) {
            String agentID = element.getAttribute(UserAgentManager.ATTR_ID);
            if (agentID != null) {
                String agentIconDisabledPath;
                String agentIconPartialPath;
                Bundle bundle = Platform.getBundle((String)element.getNamespaceIdentifier());
                String agentIconPath = element.getAttribute(UserAgentManager.ATTR_ICON);
                if (agentIconPath != null) {
                    URL url = bundle.getEntry(agentIconPath);
                    agentIconPath = ResourceUtil.resourcePathToString((URL)url);
                }
                if ((agentIconPartialPath = element.getAttribute(UserAgentManager.ATTR_ICON_PARTIAL)) != null) {
                    URL url = bundle.getEntry(agentIconPartialPath);
                    agentIconPartialPath = ResourceUtil.resourcePathToString((URL)url);
                }
                if ((agentIconDisabledPath = element.getAttribute(UserAgentManager.ATTR_ICON_DISABLED)) != null) {
                    URL url = bundle.getEntry(agentIconDisabledPath);
                    agentIconDisabledPath = ResourceUtil.resourcePathToString((URL)url);
                }
                String agentName = element.getAttribute(UserAgentManager.ATTR_NAME);
                UserAgent agent = new UserAgent(agentID, agentName, agentIconPath, agentIconPartialPath, agentIconDisabledPath);
                if (UserAgentManager.this.isSDKAgents(agentID)) {
                    SDK_AGENTS_BY_ID.put(agentID, agent);
                } else {
                    USER_AGENTS_BY_ID.put(agentID, agent);
                }
            }
        }

        public Set<String> getSupportElementNames() {
            return CollectionsUtil.newSet((Object[])new String[]{UserAgentManager.ELEMENT_USER_AGENT});
        }
    }
}

