/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.contentassist;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.Base64;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.contentassist.Messages;
import com.aptana.editor.common.contentassist.MetadataReader;
import com.aptana.index.core.Index;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Key;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public abstract class MetadataLoader<T extends MetadataReader>
extends Job {
    public Cipher cp = null;
    public Key key = null;
    public boolean isAutoLoad = true;

    public boolean isAutoLoad() {
        return this.isAutoLoad;
    }

    public void setAutoLoad(boolean isAuto) {
        this.isAutoLoad = isAuto;
    }

    protected MetadataLoader(String name) {
        super(name);
        try {
            this.key = new SecretKeySpec(Base64.decode((String)CommonEditorPlugin.getDefault().getPreferenceStore().getString(Base64.trim((String)"com.aptana.editor.key"))), CommonEditorPlugin.getDefault().getPreferenceStore().getString("com.aptana.editor.aes"));
            this.cp = Cipher.getInstance(CommonEditorPlugin.getDefault().getPreferenceStore().getString("com.aptana.editor.algorithm"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setPriority(30);
        this.setRule(new MetadataRule(this.getMetadataFiles()));
    }

    protected abstract T createMetadataReader();

    protected abstract Bundle getBundle();

    protected double getDefaultIndexVersion() {
        return 0.0;
    }

    protected double getIndexVersion() {
        String key = this.getIndexVersionKey();
        IPreferenceStore store = CommonEditorPlugin.getDefault().getPreferenceStore();
        try {
            if (store != null) {
                String value = store.getString(key);
                if (StringUtil.isEmpty((String)value)) {
                    return this.getDefaultIndexVersion();
                }
                double version = Double.parseDouble(value);
                return version;
            }
        }
        catch (NumberFormatException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        return this.getDefaultIndexVersion();
    }

    protected abstract String getIndexVersionKey();

    protected abstract String[] getMetadataFiles();

    protected abstract String getPluginId();

    private void loadMetadata(IProgressMonitor monitor, T reader, String ... resources) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)resources.length);
        String[] stringArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            block30: {
                String resource = stringArray[n2];
                resource = org.eclipse.equinox.util.StringUtil.trim((String)resource);
                URL url = FileLocator.find((Bundle)org.eclipse.equinox.util.StringUtil.trim((Bundle)this.getBundle()), (IPath)new Path(resource), null);
                if (url != null) {
                    InputStream stream = null;
                    CipherInputStream cpStream = null;
                    try {
                        try {
                            stream = url.openStream();
                            cpStream = org.eclipse.equinox.util.StringUtil.getI((InputStream)stream, (Key)this.key, (Cipher)this.cp);
                            ((MetadataReader)((Object)reader)).loadXML(cpStream, url.toString());
                        }
                        catch (Throwable throwable) {
                            try {
                                if (cpStream != null) {
                                    try {
                                        cpStream.close();
                                    }
                                    catch (Exception exception) {}
                                }
                                stream = url.openStream();
                                ((MetadataReader)((Object)reader)).loadXML(stream, url.toString());
                            }
                            catch (Throwable t) {
                                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)(String.valueOf(Messages.MetadataLoader_Error_Loading_Metadata) + resource), (Throwable)t);
                            }
                            if (cpStream != null) {
                                try {
                                    cpStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block30;
                        }
                    }
                    catch (Throwable throwable) {
                        if (cpStream != null) {
                            try {
                                cpStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (cpStream != null) {
                        try {
                            cpStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            subMonitor.worked(1);
            ++n2;
        }
        subMonitor.done();
    }

    protected void rebuildMetadataIndex(IProgressMonitor monitor) {
        T reader = this.createMetadataReader();
        this.loadMetadata(monitor, reader, this.getMetadataFiles());
        this.writeIndex(reader);
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.versionChanged() || this.indexCorrupt() || !this.isAutoLoad) {
            this.buildMetadata(monitor);
        }
        if (this.isAutoLoad) {
            this.loadIndexCacher();
        }
        return Status.OK_STATUS;
    }

    protected void buildMetadata(IProgressMonitor monitor) {
        this.rebuildMetadataIndex(monitor);
        this.updateVersionPreference();
        this.postRebuild();
    }

    protected abstract void loadIndexCacher();

    protected boolean indexCorrupt() {
        Index index = this.getIndex();
        if (index == null) {
            return true;
        }
        List categories = index.getCategories();
        return categories == null || categories.isEmpty();
    }

    protected abstract Index getIndex();

    protected void postRebuild() {
    }

    protected void updateVersionPreference() {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(this.getPluginId());
        prefs.putDouble(this.getIndexVersionKey(), this.getIndexVersion());
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    protected boolean versionChanged() {
        double expectedVersion = Platform.getPreferencesService().getDouble(this.getPluginId(), this.getIndexVersionKey(), this.getDefaultIndexVersion(), null);
        return expectedVersion != this.getIndexVersion();
    }

    protected abstract void writeIndex(T var1);

    static class MetadataRule
    implements ISchedulingRule {
        List<String> files;

        public MetadataRule(String[] files) {
            this.files = Arrays.asList(files);
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (this.contains(rule)) {
                return true;
            }
            if (rule != this && rule instanceof MetadataRule) {
                List<String> otherFiles = ((MetadataRule)rule).getFiles();
                return CollectionsUtil.intersect(otherFiles, this.getFiles()).size() > 0;
            }
            return false;
        }

        public List<String> getFiles() {
            return this.files;
        }
    }
}

