/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.actions;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.viewer.IndentGuidePainter;
import com.aptana.editor.common.viewer.MacIndentGuidePainter;
import com.pandora.core.utils.PlatformUtil;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class ShowIndentGuideAction
extends TextEditorAction {
    private IPreferenceStore fStore;
    private IPainter fShowIndentGuidePainter;

    public ShowIndentGuideAction(ResourceBundle bundle, String prefix, ITextEditor editor, IPreferenceStore fStore) {
        super(bundle, prefix, editor, 2);
        this.fStore = fStore;
        this.synchronizeWithPreference();
    }

    public void update() {
        this.setEnabled(this.getTextViewer() instanceof ITextViewerExtension2);
        this.synchronizeWithPreference();
    }

    private void synchronizeWithPreference() {
        boolean checked = false;
        if (this.fStore != null) {
            checked = this.fStore.getBoolean("com.aptana.editor.common.showIndentGuide");
        }
        if (checked != this.isChecked()) {
            this.setChecked(checked);
            this.togglePainterState(checked);
        } else if (checked) {
            this.uninstallPainter();
            this.installPainter();
        }
    }

    public void run() {
        this.togglePainterState(this.isChecked());
        if (this.fStore != null) {
            this.fStore.setValue("com.aptana.editor.common.showIndentGuide", this.isChecked());
        }
    }

    private void togglePainterState(boolean newState) {
        if (newState) {
            this.installPainter();
        } else {
            this.uninstallPainter();
        }
    }

    private void uninstallPainter() {
        if (this.fShowIndentGuidePainter == null) {
            return;
        }
        ITextViewer viewer = this.getTextViewer();
        if (viewer instanceof ITextViewerExtension2) {
            ((ITextViewerExtension2)viewer).removePainter(this.fShowIndentGuidePainter);
        }
        this.fShowIndentGuidePainter.deactivate(true);
        this.fShowIndentGuidePainter = null;
    }

    private void installPainter() {
        Assert.isTrue((this.fShowIndentGuidePainter == null ? 1 : 0) != 0);
        ITextViewer viewer = this.getTextViewer();
        if (viewer instanceof ITextViewerExtension2) {
            this.fShowIndentGuidePainter = PlatformUtil.isMac() ? new MacIndentGuidePainter(viewer) : new IndentGuidePainter(viewer);
            ((ITextViewerExtension2)viewer).addPainter(this.fShowIndentGuidePainter);
        }
    }

    private ITextViewer getTextViewer() {
        ITextEditor editor = this.getTextEditor();
        if (editor instanceof AbstractThemeableEditor) {
            return ((AbstractThemeableEditor)editor).getISourceViewer();
        }
        return null;
    }
}

