/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.IEditorCommandsMenuContributor;
import com.aptana.editor.common.Messages;
import com.aptana.editor.common.actions.FoldingActionsGroup;
import com.aptana.editor.common.actions.ToggleMarkOccurrencesAction;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.StatusLineContributionItem;

public class CommonTextEditorActionContributor
extends TextEditorActionContributor {
    private CommandsMenuContributionItem commandsMenuContributionItem;
    private StatusLineContributionItem inputPositionStatsContributionItem;
    private ToggleMarkOccurrencesAction markOccurrencesAction;

    public CommonTextEditorActionContributor() {
        ResourceBundle resourceBundle = Messages.getBundleForConstructedKeys();
        this.markOccurrencesAction = new ToggleMarkOccurrencesAction(resourceBundle);
    }

    public void contributeToStatusLine(IStatusLineManager statusLineManager) {
        IContributionItem[] contributionItems;
        super.contributeToStatusLine(statusLineManager);
        this.inputPositionStatsContributionItem = new StatusLineContributionItem("InputPosition", true, 24);
        IContributionItem[] iContributionItemArray = contributionItems = statusLineManager.getItems();
        int n = contributionItems.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem contributionItem = iContributionItemArray[n2];
            String id = contributionItem.getId();
            if ("InputPosition".equals(id)) {
                statusLineManager.remove(contributionItem);
                statusLineManager.add((IContributionItem)this.inputPositionStatsContributionItem);
            } else {
                statusLineManager.remove(contributionItem);
            }
            ++n2;
        }
    }

    private IEditorCommandsMenuContributor getEditorCommandsMenuContributor() {
        IEditorCommandsMenuContributor adapter = (IEditorCommandsMenuContributor)Platform.getAdapterManager().getAdapter((Object)this, IEditorCommandsMenuContributor.class);
        if (adapter == null && Platform.getAdapterManager().hasAdapter((Object)this, IEditorCommandsMenuContributor.class.getName())) {
            adapter = (IEditorCommandsMenuContributor)Platform.getAdapterManager().loadAdapter((Object)this, IEditorCommandsMenuContributor.class.getName());
        }
        return adapter;
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        bars.setGlobalActionHandler("com.aptana.editor.common.toggleMarkOccurrences", (IAction)this.markOccurrencesAction);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        if (part instanceof ITextEditor) {
            FoldingActionsGroup foldingActions;
            ITextEditor textEditor = (ITextEditor)part;
            if (this.commandsMenuContributionItem != null) {
                this.commandsMenuContributionItem.setTextEditor(textEditor);
            }
            if (this.inputPositionStatsContributionItem != null) {
                this.inputPositionStatsContributionItem.setActionHandler(this.getAction(textEditor, "GotoLine"));
                ITextEditorExtension extension = (ITextEditorExtension)textEditor;
                extension.setStatusField((IStatusField)this.inputPositionStatsContributionItem, "InputPosition");
            }
            if (part instanceof AbstractThemeableEditor && (foldingActions = ((AbstractThemeableEditor)part).getFoldingActionsGroup()) != null) {
                foldingActions.updateActionBars();
            }
            this.markOccurrencesAction.setEditor(textEditor);
        }
    }

    public void dispose() {
        this.markOccurrencesAction.setEditor(null);
        if (this.commandsMenuContributionItem != null) {
            this.commandsMenuContributionItem.setTextEditor(null);
        }
        super.dispose();
    }

    private class CommandsMenuContributionItem
    extends ContributionItem {
        private ITextEditor textEditor;
        private ToolItem menuToolItem;

        private CommandsMenuContributionItem() {
        }

        public void fill(Composite parent) {
            Label sep = new Label(parent, 2);
            StatusLineLayoutData data = new StatusLineLayoutData();
            data.heightHint = this.getHeightHint(parent);
            sep.setLayoutData((Object)data);
            ToolBarManager toolBarManager = new ToolBarManager(0x800100);
            ToolBar toolBar = toolBarManager.createControl(parent);
            data = new StatusLineLayoutData();
            toolBar.setLayoutData((Object)data);
            final Menu menu = new Menu((Control)toolBar);
            this.menuToolItem = new ToolItem(toolBar, 4);
            this.menuToolItem.setImage(CommonEditorPlugin.getDefault().getImageFromImageRegistry("/icons/command.png"));
            this.menuToolItem.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    MenuItem[] items;
                    if (menu.isDisposed()) {
                        return;
                    }
                    MenuItem[] menuItemArray = items = menu.getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem menuItem = menuItemArray[n2];
                        if (!menuItem.isDisposed()) {
                            menuItem.dispose();
                        }
                        ++n2;
                    }
                    IEditorCommandsMenuContributor contributor = CommonTextEditorActionContributor.this.getEditorCommandsMenuContributor();
                    if (contributor != null) {
                        contributor.fill(menu, CommandsMenuContributionItem.this.textEditor);
                    }
                    menu.setVisible(true);
                }
            });
            this.menuToolItem.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    CommandsMenuContributionItem.this.menuToolItem = null;
                }
            });
            this.updateState();
        }

        private int getHeightHint(Composite control) {
            GC gc = new GC((Drawable)control);
            gc.setFont(control.getFont());
            int height = gc.getFontMetrics().getHeight();
            gc.dispose();
            return height;
        }

        void setTextEditor(ITextEditor textEditor) {
            this.textEditor = textEditor;
            this.updateState();
        }

        private void updateState() {
            if (this.menuToolItem != null && !this.menuToolItem.isDisposed()) {
                this.menuToolItem.setEnabled(this.textEditor instanceof AbstractThemeableEditor);
            }
        }
    }
}

