/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.core.build.BuildFileManager;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.FilenameDifferentiator;
import com.aptana.editor.common.index.IReferIndexQueryHelper;
import com.aptana.editor.common.internal.scripting.ContentTypeTranslation;
import com.aptana.editor.common.internal.scripting.DocumentScopeManager;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.IDocumentScopeManager;
import com.aptana.editor.common.spelling.SpellingPreferences;
import com.aptana.index.core.IndexPlugin;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import com.aptana.ui.util.StatusLineUtils;
import com.pandora.core.stats.Stats;
import com.pandora.core.utils.RegistryUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditorExtension5;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class CommonEditorPlugin
extends AbstractUIPlugin {
    public static final String SNIPPET = "/icons/assistant/snippet.png";
    public static final String COMMAND = "/icons/command.png";
    public static final String QUICKFIXERROR = "/icons/quickfix_error.png";
    public static final String PLUGIN_ID = "com.aptana.editor.common";
    private static final String TEMPLATES = "com.aptana.editor.common.templates";
    private static final String OUTLINE_VIEW_ID = "org.eclipse.ui.views.ContentOutline";
    private static final String BINDINGS_VIEW_ID = "com.pandora.ui.views.Bindings";
    private static final String COMMAND_ID = "com.aptana.editor.common.commands.toggleOutline";
    private static final String COMMAND_STATE = "org.eclipse.ui.commands.toggleState";
    public static int VALIDATOR_BUILD_TYPE = 99;
    public static final int DOCUMENTLINELARGENUMBER = 4000;
    public static final String NEED_FILTER = "NEED_FILTER";
    public static final String NEED_FILTER_WINDOW = "NEED_FILTER_WINDOW";
    private static CommonEditorPlugin plugin;
    private Map<ContextTypeRegistry, ContributionTemplateStore> fTemplateStoreMap;
    private FilenameDifferentiator differentiator;
    private IReferIndexQueryHelper referIndexQueryHelper = null;
    private RGB occurrenceLightColor = new RGB(128, 64, 64);
    private RGB occurrenceDarkColor = new RGB(0, 191, 0);
    private final IPartListener fPartListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof ITextEditorExtension5) {
                ITextEditorExtension5 ext5 = (ITextEditorExtension5)part;
                ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                try {
                    Command command = commandService.getCommand("com.pandora.ui.toggleBlockSelectionMode");
                    if (command != null) {
                        command.getState(CommonEditorPlugin.COMMAND_STATE).setValue((Object)ext5.isBlockSelectionModeEnabled());
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part instanceof ContentOutline) {
                try {
                    IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(CommonEditorPlugin.PLUGIN_ID);
                    boolean first = prefs.getBoolean("com.aptana.editor.common.firstOutlineAutoOpen", true);
                    if (first && !PlatformUI.getWorkbench().isClosing()) {
                        prefs.putBoolean("com.aptana.editor.common.firstOutlineAutoOpen", false);
                        CommonEditorPlugin.this.showOutlineHelper();
                    }
                }
                catch (Exception e) {
                    Stats.addExceptionInfo((Throwable)e);
                }
            } else {
                boolean cfr_ignored_0 = part instanceof IEditorPart;
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
            IEclipsePreferences prefs;
            if (part instanceof IEditorPart) {
                prefs = EclipseUtil.defaultScope().getNode("io.emmet.eclipse");
                if (prefs != null) {
                    prefs.putBoolean("tabExpand", true);
                }
                BuildFileManager.getInstance().addProjectHighPriorityIFiles((IEditorPart)part);
            }
            if (part instanceof AbstractThemeableEditor) {
                try {
                    prefs = EclipseUtil.instanceScope().getNode(CommonEditorPlugin.PLUGIN_ID);
                    boolean firstBinding = prefs.getBoolean("com.aptana.editor.common.firstBindingViewAutoOpen", true);
                    if (firstBinding) {
                        CommonEditorPlugin.this.showBindingsView();
                        prefs.putBoolean("com.aptana.editor.common.firstBindingViewAutoOpen", false);
                    }
                    boolean outlineAutoOpen = prefs.getBoolean("com.aptana.editor.common.outlineAutoOpen", true);
                    boolean first = prefs.getBoolean("com.aptana.editor.common.firstOutlineAutoOpen", true);
                    if (outlineAutoOpen) {
                        CommonEditorPlugin.this.showOutlineView();
                        if (first) {
                            prefs.putBoolean("com.aptana.editor.common.outlineAutoOpen", false);
                        }
                    }
                }
                catch (Exception e) {
                    Stats.addExceptionInfo((Throwable)e);
                }
            }
        }
    };
    private final IPerspectiveListener fPerspectiveListener = new IPerspectiveListener(){

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            this.setCommandState(this.findView(page, CommonEditorPlugin.OUTLINE_VIEW_ID) != null);
        }

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            if (changeId.equals("viewHide")) {
                if (this.findView(page, CommonEditorPlugin.OUTLINE_VIEW_ID) == null) {
                    this.setCommandState(false);
                }
            } else if (changeId.equals("viewShow") && this.findView(page, CommonEditorPlugin.OUTLINE_VIEW_ID) != null) {
                this.setCommandState(true);
            }
        }

        private void setCommandState(boolean state) {
            ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command command = service.getCommand(CommonEditorPlugin.COMMAND_ID);
            State commandState = command.getState(CommonEditorPlugin.COMMAND_STATE);
            if ((Boolean)commandState.getValue() != state) {
                commandState.setValue((Object)state);
                service.refreshElements(CommonEditorPlugin.COMMAND_ID, null);
            }
        }

        protected IViewReference findView(IWorkbenchPage page, String viewId) {
            IViewReference[] iViewReferenceArray = page.getViewReferences();
            int n = iViewReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference ref = iViewReferenceArray[n2];
                if (viewId.equals(ref.getId())) {
                    return ref;
                }
                ++n2;
            }
            return null;
        }
    };
    private final IWindowListener fWindowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            IPartService partService = window.getPartService();
            if (partService != null) {
                partService.removePartListener(CommonEditorPlugin.this.fPartListener);
            }
            window.removePerspectiveListener(CommonEditorPlugin.this.fPerspectiveListener);
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
            IPartService partService = window.getPartService();
            if (partService != null) {
                partService.addPartListener(CommonEditorPlugin.this.fPartListener);
            }
            window.addPerspectiveListener(CommonEditorPlugin.this.fPerspectiveListener);
        }
    };
    private DocumentScopeManager fDocumentScopeManager;
    private IEclipsePreferences.IPreferenceChangeListener fThemeChangeListener;
    private SpellingPreferences spellingPreferences;

    protected void showOutlineHelper() {
        StatusLineUtils.showStatusMessage((String)"\u82e5\u9700\u518d\u6b21\u6253\u5f00\u5927\u7eb2\u89c6\u56fe\uff0c\u8bf7\u70b9\u51fb\u83dc\u5355\u89c6\u56fe->\u663e\u793a\u89c6\u56fe->\u5927\u7eb2\uff0c\u5feb\u6377\u952e\u662fF10\u3002", (long)5000L);
    }

    protected void showOutlineView() {
        try {
            IViewPart viewPart;
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage != null && (viewPart = activePage.findView(OUTLINE_VIEW_ID)) == null) {
                activePage.showView(OUTLINE_VIEW_ID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void showBindingsView() {
        try {
            IViewPart viewPart;
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage != null && (viewPart = activePage.findView(BINDINGS_VIEW_ID)) == null) {
                activePage.showView(BINDINGS_VIEW_ID, null, 3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void activateProjectExplorer(IWorkbenchPage page) {
        IViewPart view = page.findView("org.eclipse.ui.navigator.ProjectExplorer");
        if (view != null) {
            page.activate((IWorkbenchPart)view);
            view.setFocus();
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.listenForThemeChanges();
        IndexPlugin.getDefault();
        this.differentiator = new FilenameDifferentiator();
        this.differentiator.schedule();
        this.spellingPreferences = new SpellingPreferences();
        this.listenForPartState();
    }

    private void listenForPartState() {
        new UIJob("adding part listener"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                CommonEditorPlugin.this.addPartListener();
                return Status.OK_STATUS;
            }
        }.schedule(1000L);
    }

    private void listenForThemeChanges() {
        UIJob job = new UIJob("Set occurrence colors to theme"){

            private void setOccurrenceColors() {
                IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("org.eclipse.ui.editors");
                Theme theme = ThemePlugin.getDefault().getThemeManager().getCurrentTheme();
                if (theme.getName().contains("Monokai")) {
                    prefs.put("OccurrenceIndicationColor", StringConverter.asString((RGB)CommonEditorPlugin.this.occurrenceDarkColor));
                } else if (theme.getName().contains("\u7eff\u67d4")) {
                    prefs.put("OccurrenceIndicationColor", StringConverter.asString((RGB)CommonEditorPlugin.this.occurrenceLightColor));
                } else {
                    prefs.put("OccurrenceIndicationColor", StringConverter.asString((RGB)theme.getSearchResultColor()));
                }
                try {
                    prefs.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                CommonEditorPlugin.this.fThemeChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

                    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                        if (event.getKey().equals("THEME_CHANGED")) {
                            this.setOccurrenceColors();
                        }
                    }
                };
                this.setOccurrenceColors();
                EclipseUtil.instanceScope().getNode("com.aptana.theme").addPreferenceChangeListener(CommonEditorPlugin.this.fThemeChangeListener);
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule(2000L);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.fThemeChangeListener != null) {
                EclipseUtil.instanceScope().getNode("com.aptana.theme").removePreferenceChangeListener(this.fThemeChangeListener);
                this.fThemeChangeListener = null;
            }
            this.differentiator.dispose();
            this.removePartListener();
            if (this.fDocumentScopeManager != null) {
                this.fDocumentScopeManager.dispose();
            }
            if (this.spellingPreferences != null) {
                this.spellingPreferences.dispose();
                this.spellingPreferences = null;
            }
        }
        finally {
            this.fDocumentScopeManager = null;
            this.differentiator = null;
            plugin = null;
            super.stop(context);
        }
    }

    public static CommonEditorPlugin getDefault() {
        return plugin;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put(SNIPPET, CommonEditorPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)SNIPPET));
        reg.put(COMMAND, CommonEditorPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)COMMAND));
        reg.put(QUICKFIXERROR, CommonEditorPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)QUICKFIXERROR));
    }

    public Image getImageFromImageRegistry(String imageID) {
        return this.getImageRegistry().get(imageID);
    }

    public SpellingPreferences getSpellingPreferences() {
        return this.spellingPreferences;
    }

    public ContributionTemplateStore getTemplateStore(ContextTypeRegistry contextTypeRegistry) {
        ContributionTemplateStore store;
        if (this.fTemplateStoreMap == null) {
            this.fTemplateStoreMap = new HashMap<ContextTypeRegistry, ContributionTemplateStore>();
        }
        if ((store = this.fTemplateStoreMap.get(contextTypeRegistry)) == null) {
            store = new ContributionTemplateStore(contextTypeRegistry, this.getPreferenceStore(), TEMPLATES);
            try {
                store.load();
                this.fTemplateStoreMap.put(contextTypeRegistry, store);
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            }
        }
        return store;
    }

    public synchronized IDocumentScopeManager getDocumentScopeManager() {
        if (this.fDocumentScopeManager == null) {
            this.fDocumentScopeManager = new DocumentScopeManager();
        }
        return this.fDocumentScopeManager;
    }

    public IContentTypeTranslator getContentTypeTranslator() {
        return ContentTypeTranslation.getDefault();
    }

    private void addPartListener() {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null) {
                IWorkbenchWindow[] windows;
                IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IPartService partService = window.getPartService();
                    if (partService != null) {
                        partService.addPartListener(this.fPartListener);
                    }
                    window.addPerspectiveListener(this.fPerspectiveListener);
                    ++n2;
                }
                PlatformUI.getWorkbench().addWindowListener(this.fWindowListener);
            }
        }
        catch (Exception exception) {}
    }

    private void removePartListener() {
        IWorkbench workbench = null;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (Exception exception) {}
        if (workbench != null) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                IPartService partService = window.getPartService();
                if (partService != null) {
                    partService.removePartListener(this.fPartListener);
                }
                window.removePerspectiveListener(this.fPerspectiveListener);
                ++n2;
            }
            PlatformUI.getWorkbench().removeWindowListener(this.fWindowListener);
        }
    }

    public IReferIndexQueryHelper getReferIndexQueryHelper() {
        if (this.referIndexQueryHelper != null) {
            return this.referIndexQueryHelper;
        }
        try {
            List helpers = RegistryUtils.getEp(IReferIndexQueryHelper.class, (String)"com.pandora.core.index.IndexQueryHelper", (String)"IndexQueryHelper", (String)"class");
            if (!CollectionsUtil.isEmpty((Collection)helpers)) {
                this.referIndexQueryHelper = (IReferIndexQueryHelper)helpers.get(0);
                return this.referIndexQueryHelper;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }
}

