/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.core.build.IProblem;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.common.ICommonAnnotationModel;
import com.aptana.editor.common.ProblemAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class CommonAnnotationModel
extends ResourceMarkerAnnotationModel
implements ICommonAnnotationModel {
    private List<ProblemAnnotation> fGeneratedAnnotations = new ArrayList<ProblemAnnotation>();

    public CommonAnnotationModel(IResource resource) {
        super(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportProblems(Map<String, Collection<IProblem>> map, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        boolean temporaryProblemsChanged = false;
        try {
            Object[] markers = this.retrieveMarkers();
            if (!ArrayUtil.isEmpty((Object[])markers)) {
                Object[] objectArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    Object marker = objectArray[n2];
                    if (map.containsKey(marker.getType())) {
                        this.removeAnnotation((Annotation)this.getMarkerAnnotation((IMarker)marker));
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException coreException) {}
        Object object = this.getLockObject();
        synchronized (object) {
            if (!CollectionsUtil.isEmpty(this.fGeneratedAnnotations)) {
                temporaryProblemsChanged = true;
                this.removeAnnotations(this.fGeneratedAnnotations, false, true);
                this.fGeneratedAnnotations.clear();
            }
            if (!CollectionsUtil.isEmpty(map)) {
                block8: for (Collection<IProblem> problems : map.values()) {
                    if (CollectionsUtil.isEmpty(problems)) continue;
                    for (IProblem problem : problems) {
                        if (monitor != null && monitor.isCanceled()) continue block8;
                        Position position = this.generatePosition(problem);
                        if (position == null) continue;
                        try {
                            ProblemAnnotation annotation = new ProblemAnnotation(problem);
                            this.addAnnotation(annotation, position, false);
                            this.fGeneratedAnnotations.add(annotation);
                            temporaryProblemsChanged = true;
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                }
            }
        }
        if (temporaryProblemsChanged) {
            this.fireModelChanged();
        }
    }

    private Position generatePosition(IProblem problem) {
        int start = problem.getOffset();
        if (start < 0) {
            return new Position(0);
        }
        int length = problem.getLength();
        if (length < 0) {
            return null;
        }
        return new Position(start, length);
    }
}

