/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.pack.ui.wizard;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.StringUtil;
import com.pandora.core.httpclient.HttpClientUtils;
import com.pandora.core.httpclient.ResponseObj;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.utils.ProjectUtils;
import com.pandora.pack.core.download.DownloadDataManager;
import com.pandora.pack.core.download.DownloadStatus;
import com.pandora.pack.core.download.StartupDownloadPackage;
import com.pandora.pack.core.utils.ExploreFile;
import com.pandora.pack.core.viewpack.PackageStatus;
import com.pandora.pack.core.viewpack.ViewPackStatusManager;
import com.pandora.pack.ui.PackUiActivator;
import com.pandora.pack.ui.wizard.Messages;
import com.pandora.pack.ui.wizard.ViewPackStatusWizard;
import com.pandora.pack.ui.wizard.ViewPackStatusWizardDialog;
import java.awt.Desktop;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class ViewPackStatusWizardPage
extends WizardPage {
    private static ViewPackStatusWizardPage view;
    private Color downloadingColor = SWTResourceManager.getColor(15, 153, 227);
    protected Combo projectCombo;
    protected Table viewPackTable;
    protected String appid;

    protected ViewPackStatusWizardPage() {
        super("ViewPackStatusWizardPage");
        this.setTitle(Messages.ViewPackStatusWizardPage_Show_Status);
        this.setPageComplete(false);
        view = this;
    }

    public void createControl(Composite parent) {
        parent.getShell().setBackgroundMode(1);
        Font font = parent.getFont();
        Composite outerContainer = new Composite(parent, 0);
        outerContainer.setFont(font);
        this.setControl((Control)outerContainer);
        outerContainer.setLayout((Layout)new FormLayout());
        Link downloadlink = new Link(outerContainer, 0);
        FormData fd_downloadlink = new FormData();
        downloadlink.setLayoutData((Object)fd_downloadlink);
        downloadlink.setText(Messages.MakePackageWizardPage_Open_Download);
        this.projectCombo = new Combo(outerContainer, 8);
        fd_downloadlink.right = new FormAttachment(100, -36);
        FormData fd_projectCombo = new FormData();
        fd_projectCombo.right = new FormAttachment((Control)downloadlink, -20);
        this.projectCombo.setLayoutData((Object)fd_projectCombo);
        this.projectCombo.setFocus();
        Label projectLabel = new Label(outerContainer, 0);
        fd_downloadlink.top = new FormAttachment(0, 6);
        fd_projectCombo.top = new FormAttachment((Control)projectLabel, -4, 128);
        fd_projectCombo.left = new FormAttachment((Control)projectLabel, 20);
        FormData fd_projectLabel = new FormData();
        fd_projectLabel.top = new FormAttachment(0, 6);
        fd_projectLabel.left = new FormAttachment(0, 36);
        projectLabel.setLayoutData((Object)fd_projectLabel);
        projectLabel.setAlignment(0x1000000);
        projectLabel.setText(Messages.MakePackageWizardPage_Select_Project);
        Composite tableContainer = new Composite(outerContainer, 2048);
        FormData fd_tableContainer = new FormData();
        fd_tableContainer.bottom = new FormAttachment(100, 0);
        fd_tableContainer.top = new FormAttachment((Control)projectLabel, 10);
        fd_tableContainer.left = new FormAttachment(0, 0);
        fd_tableContainer.right = new FormAttachment(100, 0);
        tableContainer.setLayoutData((Object)fd_tableContainer);
        tableContainer.setLayout((Layout)new FillLayout(512));
        ViewPackStatusWizardDialog container = (ViewPackStatusWizardDialog)this.getWizard().getContainer();
        this.addListeners(downloadlink, container.getFlushButton(), container.getClearButton(), container.getCheckButton());
        this.initialize();
        this.viewPackTable = this.createTable(tableContainer, this.projectCombo);
        this.initTable();
    }

    private void addListeners(Link downloadlink, Button flushButton, final Button clearButton, final Button checkButton) {
        downloadlink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStatus result;
                String projectName = null;
                if (ViewPackStatusWizardPage.this.projectCombo.getItemCount() > 0) {
                    projectName = ViewPackStatusWizardPage.this.projectCombo.getText();
                }
                if (!(result = ExploreFile.exploreDownload(projectName)).isOK()) {
                    ViewPackStatusWizardPage.this.setErrorMessage(result.getMessage());
                }
            }
        });
        this.projectCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ViewPackStatusWizardPage.this.setAppid();
                ViewPackStatusWizardPage.this.flushStautsWithProgress();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ViewPackStatusWizardPage.this.setAppid();
                ViewPackStatusWizardPage.this.flushStautsWithProgress();
            }
        });
        flushButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewPackStatusWizardPage.this.flushStautsWithProgress();
            }
        });
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                clearButton.setEnabled(false);
                TableItem[] items = ViewPackStatusWizardPage.this.viewPackTable.getItems();
                if (items.length > 0) {
                    boolean enable;
                    ArrayList<String> ids = new ArrayList<String>();
                    TableItem[] tableItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String ticket;
                        TableItem item = tableItemArray[n2];
                        if (item.getChecked() && StringUtil.isNotBlank((String)(ticket = (String)item.getData("ticket")))) {
                            ids.add(ticket);
                        }
                        ++n2;
                    }
                    if (!ids.isEmpty() && (enable = MessageDialog.openConfirm((Shell)ViewPackStatusWizardPage.this.getShell(), (String)"\u63d0\u793a", (String)"\u6e05\u9664\u8bb0\u5f55\u540e\u65e0\u6cd5\u6062\u590d\uff0c\u662f\u5426\u786e\u8ba4\u6e05\u9664?"))) {
                        HttpClientUtils httpClientUtils = HttpClientUtils.getInstance((String)"ProjectAction!clearHistoryPackage");
                        HashMap<String, ArrayList<String>> request = new HashMap<String, ArrayList<String>>();
                        request.put("tickets", ids);
                        httpClientUtils.addRequestBody(request);
                        ResponseObj responseObj = httpClientUtils.excute();
                        if (!responseObj.isOk()) {
                            if (responseObj.getRspcode() == "999") {
                                ViewPackStatusWizardPage.this.setErrorMessage("\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc");
                            } else {
                                ViewPackStatusWizardPage.this.setErrorMessage(responseObj.getRspdesc());
                                ViewPackStatusWizardPage.this.flushStautsWithProgress();
                            }
                        } else {
                            ViewPackStatusWizardPage.this.flushStautsWithProgress();
                        }
                    }
                }
                clearButton.setEnabled(true);
            }
        });
        checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < ViewPackStatusWizardPage.this.viewPackTable.getItemCount()) {
                    ViewPackStatusWizardPage.this.viewPackTable.getItem(i).setChecked(checkButton.getSelection());
                    ++i;
                }
            }
        });
    }

    protected void initialize() {
        List projects = ProjectUtils.getHMobileProjects((boolean)false);
        for (HMobileProject project : projects) {
            this.projectCombo.add(project.getProject().getName());
            this.projectCombo.setData(project.getProject().getName(), (Object)project.getAppid());
        }
        if (projects.isEmpty()) {
            this.projectCombo.setEnabled(false);
            this.setErrorMessage(Messages.ViewPackStatusWizardPage_No_HMobileProject);
        } else {
            this.projectCombo.select(0);
            String projectName = ((ViewPackStatusWizardDialog)this.getContainer()).getProjectName();
            if (StringUtil.isBlank((String)projectName)) {
                IProject project = ProjectUtils.getCurrentProject();
                try {
                    if (project != null && project.hasNature("com.pandora.projects.ui.MKeyNature")) {
                        projectName = project.getName();
                    }
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)e);
                }
            }
            if (StringUtil.isNotBlank((String)projectName)) {
                this.projectCombo.setText(projectName);
                this.setAppid();
            }
        }
    }

    private void initTable() {
        Display.getCurrent().timerExec(100, new Runnable(){

            @Override
            public void run() {
                ViewPackStatusWizardPage.this.flushStautsWithProgress();
            }
        });
    }

    public static boolean flushStauts() {
        Set list;
        final String[] appids = new String[1];
        final boolean[] hasView = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (view != null && view.viewPackTable != null && !view.getControl().isDisposed()) {
                    appids[0] = view.getAppid();
                    hasView[0] = true;
                }
            }
        });
        if (StringUtil.isNotBlank((String)appids[0]) && (list = ViewPackStatusManager.generateAppPackageStatus((String)appids[0])) != null && !list.isEmpty()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (view != null && view.viewPackTable != null && !view.getControl().isDisposed()) {
                        view.createTableItem(list);
                    }
                }
            });
        }
        return hasView[0];
    }

    public void flushStautsWithProgress() {
        this.flushStautsWithProgressAndCancel(null);
    }

    public void flushStautsWithProgressAndCancel(final List<String> tickets2Cancel) {
        final String appid = this.getAppid();
        IWizardContainer dialog = this.getWizard().getContainer();
        if (dialog instanceof ViewPackStatusWizardDialog) {
            try {
                ((ViewPackStatusWizardDialog)dialog).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("", 3);
                        try {
                            monitor.worked(1);
                            if (tickets2Cancel != null && !tickets2Cancel.isEmpty()) {
                                ViewPackStatusManager.cancelAppPackage((List)tickets2Cancel);
                            }
                            monitor.worked(1);
                            Thread.sleep(100L);
                            final Set list = ViewPackStatusManager.generateAppPackageStatus((String)appid);
                            ViewPackStatusWizardPage.this.viewPackTable.getDisplay().syncExec((Runnable)new RunAction(ViewPackStatusWizardPage.this){

                                @Override
                                public void run() {
                                    try {
                                        if (list == null) {
                                            ViewPackStatusWizardPage.this.setErrorMessage(Messages.ViewPackStatusWizardPage_Request_Faild);
                                        } else {
                                            ViewPackStatusWizardPage.this.setErrorMessage(null);
                                            ViewPackStatusWizardPage.this.createTableItem(list);
                                            ((ViewPackStatusWizardDialog)ViewPackStatusWizardPage.this.getWizard().getContainer()).getCheckButton().setSelection(false);
                                            StartupDownloadPackage.setQuickPolling((boolean)true);
                                        }
                                    }
                                    catch (Exception e) {
                                        IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)e);
                                    }
                                }
                            });
                        }
                        finally {
                            monitor.worked(1);
                            Thread.sleep(100L);
                            monitor.done();
                        }
                    }
                });
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)e);
            }
        }
    }

    public void setProjectName(String projectName) {
        this.projectCombo.setText(projectName);
    }

    private Table createTable(Composite container, final Combo combo) {
        if (this.viewPackTable != null) {
            this.viewPackTable.dispose();
        }
        this.viewPackTable = new Table(container, 0x10010022);
        this.viewPackTable.setForeground(SWTResourceManager.getColor(28));
        this.viewPackTable.setHeaderVisible(true);
        this.viewPackTable.setLinesVisible(true);
        this.viewPackTable.setToolTipText("App\u6253\u5305\u72b6\u6001");
        final DefaultToolTip toolTip = new DefaultToolTip((Control)this.viewPackTable);
        toolTip.setBackgroundColor(ResourceManager.getColor(1));
        this.viewPackTable.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                int index = ViewPackStatusWizardPage.this.viewPackTable.getTopIndex();
                while (index < ViewPackStatusWizardPage.this.viewPackTable.getItemCount()) {
                    TableItem item = ViewPackStatusWizardPage.this.viewPackTable.getItem(index);
                    int i = 0;
                    while (i < ViewPackStatusWizardPage.this.viewPackTable.getColumnCount()) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt)) {
                            String msg = item.getText(i);
                            if (StringUtil.isNotBlank((String)msg)) {
                                toolTip.setText(item.getText(i));
                                toolTip.show(new Point(pt.x + 10, pt.y + 10));
                            } else {
                                toolTip.hide();
                                toolTip.setText(null);
                            }
                            return;
                        }
                        ++i;
                    }
                    ++index;
                }
                toolTip.hide();
            }
        });
        this.createTableColumn(this.viewPackTable, 90, Messages.ViewPackStatusWizardPage_Version, true);
        this.createTableColumn(this.viewPackTable, 180, Messages.ViewPackStatusWizardPage_PackageName, true);
        this.createTableColumn(this.viewPackTable, 140, Messages.ViewPackStatusWizardPage_PackageTime, true);
        this.createTableColumn(this.viewPackTable, 170, Messages.ViewPackStatusWizardPage_PackageStatus, true);
        this.createTableColumn(this.viewPackTable, 60, Messages.ViewPackStatusWizardPage_Options, false);
        this.viewPackTable.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                if (item == null || item.isDisposed()) {
                    return;
                }
                event.height = PlatformUtil.isWindowsXP() ? 21 : 30;
                ViewPackStatusWizardPage.this.createDownloadButton(item, combo.getText());
            }
        });
        return this.viewPackTable;
    }

    private void createTableColumn(Table table, int width, String columnName, boolean resize) {
        TableColumn tblclmn = new TableColumn(table, 0);
        tblclmn.setWidth(width);
        tblclmn.setText(columnName);
        tblclmn.setMoveable(true);
        tblclmn.setResizable(resize);
    }

    private void createTableItem(Set<PackageStatus> set) {
        boolean[] checkStatus = new boolean[this.viewPackTable.getItemCount()];
        int i = 0;
        while (i < this.viewPackTable.getItemCount()) {
            checkStatus[i] = this.viewPackTable.getItem(i).getChecked();
            ++i;
        }
        this.viewPackTable.clearAll();
        this.viewPackTable.removeAll();
        String projectName = this.projectCombo.getText();
        String appid = this.getAppid();
        if (StringUtil.isBlank((String)appid)) {
            IdeLog.logTrace((Plugin)PackUiActivator.getDefault(), (String)"APPID IS NULL");
            return;
        }
        if (set == null && ((set = ViewPackStatusManager.generateAppPackageStatus((String)appid)) == null || set.isEmpty())) {
            return;
        }
        TableItem item = null;
        SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
        ArrayList list = new ArrayList(set);
        int i2 = 0;
        while (i2 < list.size()) {
            PackageStatus packageStatus = (PackageStatus)list.get(i2);
            if (packageStatus != null) {
                item = new TableItem(this.viewPackTable, 0);
                if (i2 < checkStatus.length) {
                    item.setChecked(checkStatus[i2]);
                }
                item.setText(0, packageStatus.getVersion());
                item.setText(1, packageStatus.getPackageName());
                item.setText(2, packageStatus.getPackageTime() == null ? "" : f.format(packageStatus.getPackageTime()));
                String status = packageStatus.getStatus();
                boolean isSuspend = false;
                boolean canSuspend = false;
                if ("OK".equals(status)) {
                    status = Messages.ViewPackStatusWizardPage_Success;
                    DownloadStatus downloadStatus = DownloadDataManager.getInstance().getDownloadStatus(packageStatus, projectName);
                    if (DownloadStatus.DOWNLOADING == downloadStatus) {
                        status = Messages.ViewPackStatusWizardPage_Downloading;
                        item.setForeground(3, this.downloadingColor);
                    } else if (DownloadStatus.SUCCESS == downloadStatus) {
                        status = Messages.ViewPackStatusWizardPage_Downloaded;
                        item.setForeground(3, SWTResourceManager.getColor(6));
                    } else if (DownloadStatus.FAILED == downloadStatus) {
                        status = Messages.ViewPackStatusWizardPage_Download_Error;
                        item.setForeground(3, SWTResourceManager.getColor(4));
                    }
                } else if ("FAILED".equals(status)) {
                    String error = packageStatus.getErrorCode();
                    error = StringUtil.isNotBlank((String)error) ? "\u6253\u5305\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + error : "\u6253\u5305\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5";
                    status = error;
                    item.setForeground(3, SWTResourceManager.getColor(4));
                } else if ("INQUEUE".equals(status)) {
                    status = Messages.ViewPackStatusWizardPage_PACKAGE_STATUS_INQUEUE;
                    canSuspend = true;
                    item.setForeground(3, SWTResourceManager.getColor(8));
                } else if ("PREPARING".equals(status)) {
                    status = "\u6b63\u5728\u51c6\u5907";
                    canSuspend = true;
                    item.setForeground(3, SWTResourceManager.getColor(8));
                } else if ("PACKAGING".equals(status)) {
                    status = Messages.ViewPackStatusWizardPage_PACKAGE_STATUS_PACKAGING;
                    canSuspend = false;
                } else if ("USERCANCEL".equals(status)) {
                    status = "\u5df2\u53d6\u6d88";
                    canSuspend = false;
                    item.setForeground(3, SWTResourceManager.getColor(16));
                }
                item.setText(3, status);
                item.setData("url", (Object)packageStatus.getUrl());
                item.setData("packageName", (Object)packageStatus.getPackageName());
                item.setData("isSuspend", (Object)isSuspend);
                item.setData("canCancel", (Object)(isSuspend || canSuspend ? 1 : 0));
                item.setData("ticket", (Object)packageStatus.getTicket());
                item.setData("appid", (Object)appid);
                item.setData("buildlog", (Object)(StringUtil.isNotBlank((String)packageStatus.getBuildlog()) ? packageStatus.getBuildlog() : ""));
                item.setData("status", (Object)packageStatus.getStatus());
            }
            ++i2;
        }
    }

    private String getAppid() {
        if (this.appid == null) {
            this.setAppid();
        }
        return this.appid;
    }

    private void setAppid() {
        String projectName = this.projectCombo.getText();
        if (StringUtil.isNotBlank((String)projectName) && this.projectCombo.getData(projectName) != null) {
            this.appid = this.projectCombo.getData(projectName).toString();
        }
    }

    private void createDownloadButton(TableItem item, String projectName) {
        final String url = (String)item.getData("url");
        final String buildlog = (String)item.getData("buildlog");
        String status = (String)item.getData("status");
        String init = (String)item.getData("init");
        final String ticket = (String)item.getData("ticket");
        if (StringUtil.isBlank((String)init)) {
            boolean isOk = StringUtil.isNotBlank((String)url);
            boolean isFaild = !"OK".equals(status) && StringUtil.isNotBlank((String)buildlog);
            boolean canCancel = ViewPackStatusManager.canCancelAppPackage((String)status, (String)ticket);
            if (isOk || isFaild || canCancel) {
                int height = PlatformUtil.isMac() ? 30 : (PlatformUtil.isWindowsXP() ? 20 : 29);
                TableEditor te = new TableEditor(this.viewPackTable);
                te.grabHorizontal = true;
                te.grabVertical = true;
                te.horizontalAlignment = 16384;
                final Composite composite = new Composite((Composite)this.viewPackTable, 0);
                FillLayout filllayout = new FillLayout();
                filllayout.marginHeight = PlatformUtil.isMac() ? 3 : 1;
                filllayout.marginWidth = 1;
                filllayout.spacing = 1;
                composite.setLayout((Layout)filllayout);
                composite.setBackground(ResourceManager.getColor(1));
                Button button = new Button(composite, 8);
                if (isOk) {
                    button.setToolTipText("\u624b\u52a8\u4e0b\u8f7d: " + url);
                    button.setText("\u624b\u52a8\u4e0b\u8f7d");
                    button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            block12: {
                                Object clipboard = null;
                                try {
                                    try {
                                        Desktop.getDesktop().browse(URI.create(url));
                                    }
                                    catch (Exception ex) {
                                        IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)ex);
                                        if (clipboard == null) break block12;
                                        try {
                                            clipboard.dispose();
                                        }
                                        catch (Exception ex2) {
                                            IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)ex2);
                                        }
                                    }
                                }
                                finally {
                                    if (clipboard != null) {
                                        try {
                                            clipboard.dispose();
                                        }
                                        catch (Exception ex) {
                                            IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)ex);
                                        }
                                    }
                                }
                            }
                        }
                    });
                } else if (isFaild) {
                    button.setToolTipText("\u70b9\u51fb\u8be6\u60c5\u67e5\u770b\u9519\u8bef\u65e5\u5fd7");
                    button.setText("\u8be6\u60c5");
                    button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            Shell as = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            Shell shell = new Shell(as, 66800);
                            shell.setText("\u53d1\u884c\u65e5\u5fd7");
                            shell.setLayout((Layout)new FillLayout());
                            shell.setImage(Window.getDefaultImage());
                            shell.setSize(800, 600);
                            shell.setLocation(as.getLocation().x / 2 + as.getSize().x / 2 - 400, as.getLocation().y / 2 + as.getSize().y / 2 - 300);
                            Composite comp = new Composite((Composite)shell, 0);
                            comp.setLayout((Layout)new FillLayout());
                            Text text = new Text(comp, 527114);
                            text.setBackground(comp.getDisplay().getSystemColor(25));
                            text.setText(buildlog);
                            shell.open();
                        }
                    });
                } else if (canCancel) {
                    button.setToolTipText("\u53d6\u6d88\u4e91\u7aef\u961f\u91cc\u4e2d\u7684\u5236\u4f5c\u8bf7\u6c42");
                    button.setText("\u53d6\u6d88\u6253\u5305");
                    button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ViewPackStatusWizardPage.this.flushStautsWithProgressAndCancel(Arrays.asList(ticket));
                        }
                    });
                }
                te.setEditor((Control)composite, item, 4);
                composite.setBounds(composite.getBounds().x, item.getBounds().y, 60, height);
                te.minimumHeight = height;
                te.minimumWidth = 60;
                item.setData("init", (Object)"true");
                item.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        composite.dispose();
                    }
                });
            }
        }
    }

    public static void open(String projectName) {
        ViewPackStatusWizard wizard = new ViewPackStatusWizard();
        wizard.setForcePreviousAndNextButtons(false);
        wizard.setNeedsProgressMonitor(true);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ViewPackStatusWizardDialog dialog = new ViewPackStatusWizardDialog(shell, (IWizard)wizard);
        dialog.setMinimumPageSize(620, 350);
        dialog.setHelpAvailable(false);
        dialog.setProjectName(projectName);
        dialog.create();
        dialog.open();
    }

    public void dispose() {
        super.dispose();
        StartupDownloadPackage.setQuickPolling((boolean)false);
        view = null;
    }

    abstract class RunAction
    implements Runnable {
        protected String status;

        RunAction() {
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }
}

