/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.pack.ui.wizard;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.util.UIUtils;
import com.google.gson.JsonSyntaxException;
import com.pandora.core.auth.UserAuth;
import com.pandora.core.mobile.model.Distribute;
import com.pandora.core.mobile.model.ManifastConfiguration;
import com.pandora.core.mobile.model.Plus;
import com.pandora.core.mobile.model.android.GoogleProfile;
import com.pandora.core.mobile.model.ios.AppleProfile;
import com.pandora.core.mobile.verification.ManifastConfigurationVerification;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.utils.EclipseUtil;
import com.pandora.pack.core.MakePackage;
import com.pandora.pack.core.PackPlatform;
import com.pandora.pack.core.utils.PrimaryConfusionUtils;
import com.pandora.pack.core.viewpack.ViewPackStatusManager;
import com.pandora.pack.ui.PackUiActivator;
import com.pandora.pack.ui.wizard.AbstractAppDialog;
import com.pandora.pack.ui.wizard.RemindUserRunInDevicesDialog;
import com.pandora.pack.ui.wizard.ViewPackStatusWizardPage;
import com.pandora.ui.NewUserLoginDialog;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.progress.IProgressService;

public class MakePackageDialog
extends AbstractAppDialog {
    private static final String MAKE_PACKAGE_DIALOG_CLASS_NAME = "MakePackage";
    private static final String IPHONE_CHECK = "IPHONE_CHECK";
    private static final String IPAD_CHECK = "IPAD_CHECK";
    private static final String IOS_CHECK = "IOS_CHECK";
    private static final String IOS_TYPE_CHECK = "IOS_TYPE_CHECK";
    private static final String IOS_APPID = "IOS_APPID";
    private static final String IOS_PROFILE = "IOS_PROFILE";
    private static final String IOS_CERTFILE = "IOS_CERTFILE";
    private static final String ANDROID_CHECK = "ANDROID_CHECK";
    private static final String ANDROID_TYPE_CHECK = "ANDROID_TYPE_CHECK";
    private static final String ANDROID_PACKNAME = "ANDROID_PACKNAME";
    private static final String ANDROID_CERTNAME = "ANDROID_CERTNAME";
    private static final String ANDROID_CERTFILE = "ANDROID_CERTFILE";
    private boolean isReminded = false;
    private boolean manifestFileCorrupt = false;
    private Map<String, String> localInfoList = new HashMap<String, String>();
    private Map<String, String> webInfoList = new HashMap<String, String>();
    private Text iosAppIDText;
    private Text iosCertPasswordText;
    private Text iosProfileText;
    private Text iosCertFileText;
    private Button iosCheckButton;
    private Button iosIPhoneButton;
    private Button iosIPadButton;
    private Button iosJailbreakCheckButton;
    private Button iosLicenseCheckButton;
    private Button androidCheckButton;
    private Button androidDcloudCertCheckButton;
    private Button androidSeftCertCheckButton;
    private TabFolder certTabFolder;
    private TabItem iosCertTabItem;
    private TabItem androidCertTabItem;
    private Button iosProfileButton;
    private Button iosCertFileButton;
    private Text androidPackagenameText;
    private Text androidCertNameText;
    private Text androidCertPasswordText;
    private Text androidCertFileText;
    private Button androidCertFileButton;
    private Link confusionLink;
    private Link configLink;
    private Link optimizeLink;
    private Map<Text, ControlDecoration> textDecoration = new HashMap<Text, ControlDecoration>();

    public MakePackageDialog(Shell parentShell, HMobileProject hMobileProject) {
        super(parentShell);
        IDE.saveAllEditors((IResource[])new IResource[]{hMobileProject.getProject()}, (boolean)true);
        try {
            this.appConfig = hMobileProject.getAppConfigWithError();
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            this.appConfig = hMobileProject.getAppConfig();
            this.manifestFileCorrupt = true;
        }
        this.hmobileProject = hMobileProject;
        this.project = hMobileProject.getProject();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)this.superCreateDialogArea(parent);
        Composite baseComposite = new Composite(composite, 0);
        baseComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gl_baseComposite = new GridLayout(4, false);
        gl_baseComposite.marginTop = 0;
        gl_baseComposite.marginBottom = 15;
        gl_baseComposite.horizontalSpacing = 10;
        gl_baseComposite.verticalSpacing = 15;
        gl_baseComposite.marginWidth = 15;
        baseComposite.setLayout((Layout)gl_baseComposite);
        Composite linkContent = new Composite(baseComposite, 0);
        linkContent.setLayoutData((Object)GridDataFactory.fillDefaults().span(4, 1).align(131072, 0x1000000).create());
        linkContent.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).spacing(10, 0).create());
        this.optimizeLink = new Link(linkContent, 0);
        this.optimizeLink.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.optimizeLink.setText("<a>\u53d1\u884c\u5305\u4f53\u79ef\u4f18\u5316\u6307\u5357</a>");
        this.configLink = new Link(linkContent, 0);
        this.configLink.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.configLink.setText("<a>\u53c2\u6570\u914d\u7f6e</a>");
        Composite iosContent = new Composite(baseComposite, 0);
        iosContent.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(4, 1).create());
        iosContent.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(true).create());
        this.iosCheckButton = new Button(iosContent, 32);
        this.iosCheckButton.setAlignment(131072);
        this.iosCheckButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 1).span(1, 2).grab(true, false).create());
        this.iosCheckButton.setText("IOS\uff1a");
        this.iosIPhoneButton = new Button(iosContent, 32);
        this.iosIPhoneButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.iosIPhoneButton.setAlignment(131072);
        this.iosIPhoneButton.setSelection(true);
        this.iosIPhoneButton.setText("\u652f\u6301iPhone");
        this.iosIPadButton = new Button(iosContent, 32);
        this.iosIPadButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.iosIPadButton.setAlignment(131072);
        this.iosIPadButton.setSelection(true);
        this.iosIPadButton.setText("\u652f\u6301iPad");
        this.iosJailbreakCheckButton = new Button(iosContent, 16);
        this.iosJailbreakCheckButton.setAlignment(131072);
        this.iosJailbreakCheckButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.iosJailbreakCheckButton.setSelection(true);
        this.iosJailbreakCheckButton.setText("\u8d8a\u72f1\u5305");
        this.iosJailbreakCheckButton.setData("type", (Object)PackPlatform.IOS_PB.toString());
        this.iosLicenseCheckButton = new Button(iosContent, 16);
        this.iosLicenseCheckButton.setAlignment(131072);
        this.iosLicenseCheckButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.iosLicenseCheckButton.setText("\u4f7f\u7528\u82f9\u679c\u8bc1\u4e66");
        this.iosLicenseCheckButton.setData("type", (Object)PackPlatform.IOS_APPSTORE.toString());
        Composite androidContent = new Composite(baseComposite, 0);
        androidContent.setLayoutData((Object)GridDataFactory.fillDefaults().span(4, 1).create());
        androidContent.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(true).create());
        this.androidCheckButton = new Button(androidContent, 32);
        this.androidCheckButton.setAlignment(131072);
        this.androidCheckButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.androidCheckButton.setText("Android\uff1a");
        this.androidDcloudCertCheckButton = new Button(androidContent, 16);
        this.androidDcloudCertCheckButton.setAlignment(131072);
        this.androidDcloudCertCheckButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.androidDcloudCertCheckButton.setSelection(true);
        this.androidDcloudCertCheckButton.setText("\u4f7f\u7528DCloud\u516c\u7528\u8bc1\u4e66");
        this.androidDcloudCertCheckButton.setData("type", (Object)PackPlatform.ANDROID_PB.toString());
        this.androidSeftCertCheckButton = new Button(androidContent, 16);
        this.androidSeftCertCheckButton.setAlignment(131072);
        this.androidSeftCertCheckButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.androidSeftCertCheckButton.setText("\u4f7f\u7528\u81ea\u6709\u8bc1\u4e66");
        this.androidSeftCertCheckButton.setData("type", (Object)PackPlatform.ANDROID_GOOGLEPLAY.toString());
        new Label(baseComposite, 258).setLayoutData((Object)GridDataFactory.fillDefaults().span(4, 1).create());
        Composite certComposite = new Composite(composite, 0);
        GridLayout gl_certComposite = new GridLayout(1, false);
        gl_certComposite.verticalSpacing = 0;
        gl_certComposite.marginHeight = 0;
        gl_certComposite.marginBottom = 0;
        gl_certComposite.marginWidth = 15;
        certComposite.setLayout((Layout)gl_certComposite);
        certComposite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.certTabFolder = new TabFolder(certComposite, 0);
        this.certTabFolder.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.iosCertTabItem = new TabItem(this.certTabFolder, 0);
        this.iosCertTabItem.setText("IOS\u5f00\u53d1\u8005\u8bc1\u4e66");
        Composite iosCertTabItemComposite = new Composite((Composite)this.certTabFolder, 0);
        this.iosCertTabItem.setControl((Control)iosCertTabItemComposite);
        GridLayout gl_iosCertTabItemComposite = new GridLayout(3, false);
        gl_iosCertTabItemComposite.verticalSpacing = 15;
        gl_iosCertTabItemComposite.horizontalSpacing = 15;
        gl_iosCertTabItemComposite.marginWidth = 15;
        gl_iosCertTabItemComposite.marginHeight = 15;
        iosCertTabItemComposite.setLayout((Layout)gl_iosCertTabItemComposite);
        Label iosAppIDTextLabel = new Label(iosCertTabItemComposite, 0);
        GridData gd_iosAppIDTextLabel = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_iosAppIDTextLabel.minimumWidth = 80;
        iosAppIDTextLabel.setLayoutData((Object)gd_iosAppIDTextLabel);
        iosAppIDTextLabel.setText("AppID");
        this.iosAppIDText = this.createText(iosCertTabItemComposite, "manifest.plus.distribute.apple.appid", false, false);
        new Label(iosCertTabItemComposite, 0);
        Label iosCertPasswordLabel = new Label(iosCertTabItemComposite, 0);
        iosCertPasswordLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        iosCertPasswordLabel.setText("\u79c1\u94a5\u5bc6\u7801");
        this.iosCertPasswordText = this.createText(iosCertTabItemComposite, "manifest.plus.distribute.apple.password", true, false);
        new Label(iosCertTabItemComposite, 0);
        Label iosProfileLabel = new Label(iosCertTabItemComposite, 0);
        iosProfileLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        iosProfileLabel.setText("profile\u6587\u4ef6");
        this.iosProfileText = this.createText(iosCertTabItemComposite, "manifest.plus.distribute.apple.mobileprovision", false, true);
        this.iosProfileButton = new Button(iosCertTabItemComposite, 0);
        GridData gd_profileButton = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_profileButton.heightHint = 23;
        gd_profileButton.widthHint = 50;
        this.iosProfileButton.setLayoutData((Object)gd_profileButton);
        this.iosProfileButton.setText("\u6d4f\u89c8");
        Label iosCertFilelabel = new Label(iosCertTabItemComposite, 0);
        iosCertFilelabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        iosCertFilelabel.setText("\u79c1\u94a5\u8bc1\u4e66");
        this.iosCertFileText = this.createText(iosCertTabItemComposite, "manifest.plus.distribute.apple.p12", false, true);
        this.iosCertFileButton = new Button(iosCertTabItemComposite, 0);
        GridData gd_iosCertFileButton = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_iosCertFileButton.heightHint = 23;
        gd_iosCertFileButton.widthHint = 50;
        this.iosCertFileButton.setLayoutData((Object)gd_iosCertFileButton);
        this.iosCertFileButton.setText("\u6d4f\u89c8");
        this.androidCertTabItem = new TabItem(this.certTabFolder, 0);
        this.androidCertTabItem.setText("Google\u5f00\u53d1\u8005\u8bc1\u4e66");
        Composite androidCertTabItemComposite = new Composite((Composite)this.certTabFolder, 0);
        this.androidCertTabItem.setControl((Control)androidCertTabItemComposite);
        GridLayout gl_androidCertTabItemComposite = new GridLayout(3, false);
        gl_androidCertTabItemComposite.verticalSpacing = 15;
        gl_androidCertTabItemComposite.horizontalSpacing = 15;
        gl_androidCertTabItemComposite.marginWidth = 15;
        gl_androidCertTabItemComposite.marginHeight = 15;
        androidCertTabItemComposite.setLayout((Layout)gl_androidCertTabItemComposite);
        Label androidPackagenameLabel = new Label(androidCertTabItemComposite, 0);
        androidPackagenameLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        androidPackagenameLabel.setText("Android\u5305\u540d");
        this.androidPackagenameText = this.createText(androidCertTabItemComposite, "manifest.plus.distribute.google.packagename", false, false);
        new Label(androidCertTabItemComposite, 0);
        Label androidCertNameLabel = new Label(androidCertTabItemComposite, 0);
        androidCertNameLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        androidCertNameLabel.setText("\u8bc1\u4e66\u522b\u540d");
        this.androidCertNameText = this.createText(androidCertTabItemComposite, "manifest.plus.distribute.google.aliasname", false, false);
        new Label(androidCertTabItemComposite, 0);
        Label androidPasswordLabel = new Label(androidCertTabItemComposite, 0);
        androidPasswordLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        androidPasswordLabel.setText("\u79c1\u94a5\u5bc6\u7801");
        this.androidCertPasswordText = this.createText(androidCertTabItemComposite, "manifest.plus.distribute.google.password", true, false);
        new Label(androidCertTabItemComposite, 0);
        Label androidCertFileLabel = new Label(androidCertTabItemComposite, 0);
        androidCertFileLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        androidCertFileLabel.setText("\u8bc1\u4e66\u6587\u4ef6");
        this.androidCertFileText = this.createText(androidCertTabItemComposite, "manifest.plus.distribute.google.keystore", false, true);
        this.androidCertFileButton = new Button(androidCertTabItemComposite, 0);
        GridData gd_androidCertFileButton = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_androidCertFileButton.heightHint = 23;
        gd_androidCertFileButton.widthHint = 50;
        this.androidCertFileButton.setLayoutData((Object)gd_androidCertFileButton);
        this.androidCertFileButton.setText("\u6d4f\u89c8");
        Composite confusionComposite = new Composite(composite, 0);
        confusionComposite.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        confusionComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).margins(15, 5).create());
        if (PrimaryConfusionUtils.needConfusionFeature()) {
            this.needConfusionButton = new Button(confusionComposite, 32);
            this.needConfusionButton.setLayoutData((Object)GridDataFactory.fillDefaults().create());
            this.needConfusionButton.setText("\u542f\u7528js\u539f\u751f\u6df7\u6dc6");
            this.confusionLink = new Link(confusionComposite, 0);
            this.confusionLink.setLayoutData((Object)GridDataFactory.fillDefaults().create());
            this.confusionLink.setText("<a>js\u539f\u751f\u6df7\u6dc6\u914d\u7f6e</a>");
        } else {
            new Label(confusionComposite, 0);
        }
        Label titleBarSeparator = new Label(composite, 258);
        titleBarSeparator.setLayoutData((Object)new GridData(768));
        this.setTitle("App\u4e91\u7aef\u6253\u5305");
        this.setMessage(this.getInfoMessage());
        SelectionAdapter selectionListenser = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MakePackageDialog.this.updateEnable(e);
            }
        };
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MakePackageDialog.this.validation((TypedEvent)e);
            }
        };
        this.configLink.addSelectionListener((SelectionListener)new AbstractAppDialog.OpenEditorSelectionListener());
        this.optimizeLink.addSelectionListener((SelectionListener)new AbstractAppDialog.OpenEditorSelectionListener());
        this.iosCheckButton.addSelectionListener((SelectionListener)selectionListenser);
        this.iosIPhoneButton.addSelectionListener((SelectionListener)selectionListenser);
        this.iosIPadButton.addSelectionListener((SelectionListener)selectionListenser);
        this.iosJailbreakCheckButton.addSelectionListener((SelectionListener)selectionListenser);
        this.iosLicenseCheckButton.addSelectionListener((SelectionListener)selectionListenser);
        this.androidCheckButton.addSelectionListener((SelectionListener)selectionListenser);
        this.androidDcloudCertCheckButton.addSelectionListener((SelectionListener)selectionListenser);
        this.androidSeftCertCheckButton.addSelectionListener((SelectionListener)selectionListenser);
        this.iosProfileText.addModifyListener(modifyListener);
        this.iosAppIDText.addModifyListener(modifyListener);
        this.iosCertPasswordText.addModifyListener(modifyListener);
        this.iosCertFileText.addModifyListener(modifyListener);
        this.androidPackagenameText.addModifyListener(modifyListener);
        this.androidCertNameText.addModifyListener(modifyListener);
        this.androidCertPasswordText.addModifyListener(modifyListener);
        this.androidCertFileText.addModifyListener(modifyListener);
        this.iosProfileButton.addSelectionListener((SelectionListener)new AbstractAppDialog.FileListener(this.iosProfileText, "*.mobileprovision"));
        this.androidCertFileButton.addSelectionListener((SelectionListener)new AbstractAppDialog.FileListener(this.androidCertFileText, "*.keystore"));
        this.iosCertFileButton.addSelectionListener((SelectionListener)new AbstractAppDialog.FileListener(this.iosCertFileText, "*.p12"));
        MakePackageDialog.addConfusionButtonListenter(this.needConfusionButton, this.confusionLink, null, this.hmobileProject);
        return composite;
    }

    private Text createText(Composite parent, String id, boolean isPassword, boolean isFile) {
        Text text = new Text(parent, isPassword ? 0x400800 : 2048);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textDecoration.put(text, this.createDecorator(text, null));
        if (id != null) {
            text.setData("id", (Object)id);
        }
        if (isFile) {
            text.setData("file", (Object)"true");
        }
        return text;
    }

    protected Control createContents(Composite parent) {
        Control contents = this.superCreateContents(parent);
        this.init();
        return contents;
    }

    @Override
    protected IDialogSettings init() {
        String androidCertfile;
        String packageName;
        String iosCert;
        IDialogSettings setting = super.init();
        this.iosCheckButton.setSelection(setting.getBoolean(IOS_CHECK));
        if (this.appConfig.getPlus() == null) {
            this.appConfig.setPlus(new Plus());
        }
        if (this.appConfig.getPlus().getDistribute() == null) {
            this.appConfig.getPlus().setDistribute(new Distribute());
        }
        if (this.appConfig.getPlus().getDistribute().getApple() == null) {
            this.appConfig.getPlus().getDistribute().setApple(new AppleProfile());
        }
        String devices = this.appConfig.getPlus().getDistribute().getApple().getDevices();
        if (setting.get(IPHONE_CHECK) != null) {
            this.iosIPhoneButton.setSelection(setting.getBoolean(IPHONE_CHECK));
        } else if ("iphone".equals(devices) || "universal".equals(devices)) {
            this.iosIPhoneButton.setSelection(true);
        }
        if (setting.get(IPAD_CHECK) != null) {
            this.iosIPadButton.setSelection(setting.getBoolean(IPAD_CHECK));
        } else if ("ipad".equals(devices) || "universal".equals(devices)) {
            this.iosIPadButton.setSelection(true);
        }
        String iosType = setting.get(IOS_TYPE_CHECK);
        this.iosJailbreakCheckButton.setSelection(PackPlatform.IOS_PB.toString().equals(iosType));
        this.iosLicenseCheckButton.setSelection(PackPlatform.IOS_APPSTORE.toString().equals(iosType));
        if (setting.getBoolean(ANDROID_CHECK)) {
            this.androidCheckButton.setSelection(true);
        }
        String androidType = setting.get(ANDROID_TYPE_CHECK);
        this.androidDcloudCertCheckButton.setSelection(PackPlatform.ANDROID_PB.toString().equals(androidType));
        this.androidSeftCertCheckButton.setSelection(PackPlatform.ANDROID_GOOGLEPLAY.toString().equals(androidType));
        String defaultId = "io.dcloud." + this.appConfig.getAppid();
        String appid = setting.get(this.getSettingKey(IOS_APPID));
        if (StringUtil.isNotBlank((String)appid) && !appid.endsWith(".")) {
            this.iosAppIDText.setText(appid);
        } else {
            this.iosAppIDText.setText(defaultId);
        }
        String iosProfile = setting.get(this.getSettingKey(IOS_PROFILE));
        if (StringUtil.isNotBlank((String)iosProfile)) {
            this.iosProfileText.setText(iosProfile);
        }
        if (StringUtil.isNotBlank((String)(iosCert = setting.get(this.getSettingKey(IOS_CERTFILE))))) {
            this.iosCertFileText.setText(iosCert);
        }
        if (StringUtil.isNotBlank((String)(packageName = setting.get(this.getSettingKey(ANDROID_PACKNAME)))) && !packageName.endsWith(".")) {
            this.androidPackagenameText.setText(packageName);
        } else {
            this.androidPackagenameText.setText(defaultId);
        }
        String androidCertname = setting.get(this.getSettingKey(ANDROID_CERTNAME));
        if (StringUtil.isNotBlank((String)androidCertname)) {
            this.androidCertNameText.setText(androidCertname);
        }
        if (StringUtil.isNotBlank((String)(androidCertfile = setting.get(this.getSettingKey(ANDROID_CERTFILE))))) {
            this.androidCertFileText.setText(androidCertfile);
        }
        if (!this.iosJailbreakCheckButton.getSelection() && !this.iosLicenseCheckButton.getSelection()) {
            this.iosJailbreakCheckButton.setSelection(true);
        }
        if (!this.androidDcloudCertCheckButton.getSelection() && !this.androidSeftCertCheckButton.getSelection()) {
            this.androidDcloudCertCheckButton.setSelection(true);
        }
        this.updateEnable(null);
        return setting;
    }

    @Override
    protected void openManifastEditor(SelectionEvent e, String pageId) {
        this.saveDialogSettings();
        this.close();
        HashMap<String, String> errors = new HashMap<String, String>();
        errors.putAll(this.localInfoList);
        errors.putAll(this.webInfoList);
        MakePackageDialog.editWithErrorInfo(this.project, errors, null, pageId);
    }

    @Override
    protected String getInfoMessage() {
        return "\u4e91\u7aef\u5236\u4f5c\u7ec8\u7aef\u5b89\u88c5\u5305";
    }

    private String getSettingKey(String type) {
        if (this.project != null) {
            return String.valueOf(this.project.getLocation().toString()) + "_" + type;
        }
        return type;
    }

    @Override
    protected String getDialogSettingsName() {
        return MAKE_PACKAGE_DIALOG_CLASS_NAME;
    }

    private void updateRadio(SelectionEvent e) {
        Object source = e.getSource();
        if (e != null && source instanceof Button) {
            if (source == this.iosJailbreakCheckButton && this.iosJailbreakCheckButton.getSelection()) {
                this.iosLicenseCheckButton.setSelection(false);
                return;
            }
            if (source == this.iosLicenseCheckButton && this.iosLicenseCheckButton.getSelection()) {
                this.iosJailbreakCheckButton.setSelection(false);
                return;
            }
            if (source == this.androidDcloudCertCheckButton && this.androidDcloudCertCheckButton.getSelection()) {
                this.androidSeftCertCheckButton.setSelection(false);
                return;
            }
            if (source == this.androidSeftCertCheckButton && this.androidSeftCertCheckButton.getSelection()) {
                this.androidDcloudCertCheckButton.setSelection(false);
                return;
            }
            if (source == this.iosJailbreakCheckButton || source == this.iosLicenseCheckButton || source == this.androidDcloudCertCheckButton || source == this.androidSeftCertCheckButton) {
                ((Button)e.getSource()).setSelection(true);
            }
        }
    }

    private void updateEnable(SelectionEvent e) {
        boolean androidCertEnable;
        if (e != null) {
            this.updateRadio(e);
        }
        boolean isoEnable = this.iosCheckButton.getSelection();
        boolean androidEnable = this.androidCheckButton.getSelection();
        boolean isoCertEnable = isoEnable && this.iosLicenseCheckButton.getSelection();
        boolean bl = androidCertEnable = androidEnable && this.androidSeftCertCheckButton.getSelection();
        if (isoEnable && !androidEnable) {
            this.certTabFolder.setSelection(0);
        } else if (!isoEnable && androidEnable) {
            this.certTabFolder.setSelection(1);
        }
        this.iosIPhoneButton.setEnabled(isoEnable);
        this.iosIPadButton.setEnabled(isoEnable);
        this.iosJailbreakCheckButton.setEnabled(isoEnable);
        this.iosLicenseCheckButton.setEnabled(isoEnable);
        this.iosAppIDText.setEnabled(isoEnable);
        this.iosCertPasswordText.setEnabled(isoCertEnable);
        this.iosProfileText.setEnabled(isoCertEnable);
        this.iosCertFileText.setEnabled(isoCertEnable);
        this.iosProfileButton.setEnabled(isoCertEnable);
        this.iosCertFileButton.setEnabled(isoCertEnable);
        this.androidDcloudCertCheckButton.setEnabled(androidEnable);
        this.androidSeftCertCheckButton.setEnabled(androidEnable);
        this.androidPackagenameText.setEnabled(androidEnable);
        this.androidCertNameText.setEnabled(androidCertEnable);
        this.androidCertPasswordText.setEnabled(androidCertEnable);
        this.androidCertFileText.setEnabled(androidCertEnable);
        this.androidCertFileButton.setEnabled(androidCertEnable);
        this.validation((TypedEvent)e);
    }

    private void validation(TypedEvent e) {
        if (this.manifestFileCorrupt) {
            this.setErrorMessage("App\u6253\u5305\u53c2\u6570\u914d\u7f6e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u70b9\u51fb<a>\u53c2\u6570\u914d\u7f6e</a>\u8865\u5168\u76f8\u5173\u4fe1\u606f");
            return;
        }
        boolean iosEnable = this.iosCheckButton.getSelection();
        boolean androidEnable = this.androidCheckButton.getSelection();
        boolean iphone = this.iosIPhoneButton.getSelection();
        boolean ipad = this.iosIPadButton.getSelection();
        boolean isoCertEnable = iosEnable && this.iosLicenseCheckButton.getSelection();
        boolean androidCertEnable = androidEnable && this.androidSeftCertCheckButton.getSelection();
        this.showDescriptions(e);
        ManifastConfigurationVerification.VerificationPlatform type = null;
        if (iosEnable) {
            if (iphone && !ipad) {
                this.appConfig.getPlus().getDistribute().getApple().setDevices("iphone");
            } else if (!iphone && ipad) {
                this.appConfig.getPlus().getDistribute().getApple().setDevices("ipad");
            } else if (iphone && ipad) {
                this.appConfig.getPlus().getDistribute().getApple().setDevices("universal");
            }
        }
        File iosProfile = null;
        File iosCertFile = null;
        File androidCertFile = null;
        if (iosEnable && androidEnable) {
            type = ManifastConfigurationVerification.VerificationPlatform.ALL;
        } else if (iosEnable) {
            type = ManifastConfigurationVerification.VerificationPlatform.IOS;
        } else if (androidEnable) {
            type = ManifastConfigurationVerification.VerificationPlatform.ANDROID;
        }
        Map map = ManifastConfigurationVerification.verify((ManifastConfiguration)this.appConfig, (IProject)this.project, (ManifastConfigurationVerification.VerificationPlatform)type);
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.pandora.pack.ui");
        if (!(!map.isEmpty() && map.get("iconsplashchanged") != null || prefs.getBoolean("com.pandora.ui.remind_user_rundevices_selector", false) || this.isReminded)) {
            RemindUserRunInDevicesDialog remindUserRunInDevicesDialog = new RemindUserRunInDevicesDialog(UIUtils.getActiveShell());
            remindUserRunInDevicesDialog.open();
            this.isReminded = true;
            if (remindUserRunInDevicesDialog.isChecked()) {
                prefs.putBoolean("com.pandora.ui.remind_user_rundevices_selector", remindUserRunInDevicesDialog.isChecked());
            }
        }
        map.remove("iconsplashchanged");
        if (!iosEnable && !androidEnable) {
            this.setErrorMessage("\u8bf7\u9009\u62e9\u6253\u5305\u7684\u7ec8\u7aef\u5e73\u53f0");
        } else if (iosEnable && !iphone && !ipad) {
            this.setErrorMessage("\u8bf7\u9009\u62e9\u652f\u6301\u7684IOS\u5e73\u53f0(iPhone\u3001iPad)");
        } else if (type != null && !(this.localInfoList = map).isEmpty()) {
            this.setErrorMessage("App\u6253\u5305\u53c2\u6570\u914d\u7f6e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u70b9\u51fb<a>\u53c2\u6570\u914d\u7f6e</a>\u8865\u5168\u76f8\u5173\u4fe1\u606f");
        } else if (isoCertEnable && (StringUtil.isBlank((String)this.iosAppIDText.getText()) || StringUtil.isBlank((String)this.iosCertPasswordText.getText()) || StringUtil.isBlank((String)this.iosProfileText.getText()) || StringUtil.isBlank((String)this.iosCertFileText.getText()))) {
            this.setErrorMessage("\u8bf7\u5b8c\u6574\u586b\u5199 IOS\u5f00\u53d1\u8005\u8bc1\u4e66 \u76f8\u5173\u4fe1\u606f");
        } else if (androidEnable && StringUtil.isNotBlank((String)this.androidPackagenameText.getText()) && !this.androidPackagenameText.getText().matches("^[a-zA-Z_]\\w*(\\.[a-zA-Z_]\\w*)+")) {
            this.setErrorMessage("Google\u5f00\u53d1\u8005\u8bc1\u4e66\u7684 App\u5305\u540d\u5fc5\u987b\u4ee5_\u6216\u5b57\u6bcd\u5f00\u5934\uff0c\u7531\u6570\u5b57\u3001\u5b57\u6bcd\u3001_\u7ec4\u6210\uff0c\u4ee5.\u5206\u5272\uff0c\u8bf7\u53c2\u8003java\u5305\u540d\u547d\u540d\u89c4\u5219");
        } else if (androidCertEnable && (StringUtil.isBlank((String)this.androidCertNameText.getText()) || StringUtil.isBlank((String)this.androidPackagenameText.getText()) || StringUtil.isBlank((String)this.androidCertPasswordText.getText()) || StringUtil.isBlank((String)this.androidCertFileText.getText()))) {
            this.setErrorMessage("\u8bf7\u5b8c\u6574\u586b\u5199 Google\u5f00\u53d1\u8005\u8bc1\u4e66 \u76f8\u5173\u4fe1\u606f");
        } else if (isoCertEnable && (iosProfile = ManifastConfigurationVerification.getFileExists((IProject)this.project, (String)this.iosProfileText.getText())) == null) {
            this.setErrorMessage("iOS\u5f00\u53d1\u8005\u8bc1\u4e66\u7684profile\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        } else if (isoCertEnable && (iosCertFile = ManifastConfigurationVerification.getFileExists((IProject)this.project, (String)this.iosCertFileText.getText())) == null) {
            this.setErrorMessage("iOS\u5f00\u53d1\u8005\u8bc1\u4e66\u7684\u79c1\u94a5\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        } else if (androidCertEnable && (androidCertFile = ManifastConfigurationVerification.getFileExists((IProject)this.project, (String)this.androidCertFileText.getText())) == null) {
            this.setErrorMessage("Google\u5f00\u53d1\u8005\u8bc1\u4e66\u7684\u79c1\u94a5\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        } else {
            Set<Text> texts = this.textDecoration.keySet();
            boolean hasError = false;
            for (Text text : texts) {
                if (!this.textDecoration.get(text).isVisible()) continue;
                if (isoCertEnable && ((String)text.getData("id")).contains(".apple.")) {
                    this.setErrorMessage("IOS\u5f00\u53d1\u8005\u8bc1\u4e66\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u76f8\u5173\u4fe1\u606f");
                    hasError = true;
                    break;
                }
                if (!androidCertEnable || !((String)text.getData("id")).contains(".google.")) continue;
                this.setErrorMessage("Google\u5f00\u53d1\u8005\u8bc1\u4e66\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u76f8\u5173\u4fe1\u606f");
                hasError = true;
                break;
            }
            if (!hasError) {
                if (iosEnable) {
                    AppleProfile appleProfile = this.appConfig.getPlus().getDistribute().getApple();
                    if (appleProfile == null) {
                        appleProfile = new AppleProfile();
                        this.appConfig.getPlus().getDistribute().setApple(appleProfile);
                    }
                    appleProfile.setAppid(this.iosAppIDText.getText());
                    if (isoCertEnable) {
                        appleProfile.setPassword(this.iosCertPasswordText.getText());
                        appleProfile.setMobileprovision(iosProfile.getAbsolutePath());
                        appleProfile.setP12(iosCertFile.getAbsolutePath());
                    }
                }
                if (androidEnable) {
                    GoogleProfile googleProfile = this.appConfig.getPlus().getDistribute().getGoogle();
                    if (googleProfile == null) {
                        googleProfile = new GoogleProfile();
                        this.appConfig.getPlus().getDistribute().setGoogle(googleProfile);
                    }
                    googleProfile.setPackagename(this.androidPackagenameText.getText());
                    if (androidCertEnable) {
                        googleProfile.setAliasname(this.androidCertNameText.getText());
                        googleProfile.setPassword(this.androidCertPasswordText.getText());
                        googleProfile.setKeystore(androidCertFile.getAbsolutePath());
                    }
                }
                this.setErrorMessage(null);
                this.checkIdleResources();
            }
        }
    }

    private void showDescription(String id, String message) {
        Set<Text> texts = this.textDecoration.keySet();
        for (Text text : texts) {
            if (!text.isEnabled() || !id.equals(text.getData("id"))) continue;
            this.textDecoration.get(text).setDescriptionText(message);
            this.textDecoration.get(text).show();
            return;
        }
    }

    private void showDescriptions(TypedEvent e) {
        Set<Text> texts = this.textDecoration.keySet();
        for (Text text : texts) {
            ControlDecoration c = this.textDecoration.get(text);
            if (c == null) continue;
            if (text.isEnabled()) {
                if (StringUtil.isBlank((String)text.getText())) {
                    c.setDescriptionText("\u4e0d\u80fd\u4e3a\u7a7a");
                    c.show();
                    continue;
                }
                if (text.getData("file") != null && ManifastConfigurationVerification.getFileExists((IProject)this.project, (String)text.getText()) == null) {
                    c.setDescriptionText("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                    c.show();
                    continue;
                }
                if (c.isVisible() && "\u4e0d\u80fd\u4e3a\u7a7a".equals(c.getDescriptionText()) || e != null && text == e.getSource() && e instanceof ModifyEvent) {
                    c.setDescriptionText(null);
                    c.hide();
                    continue;
                }
                if (c.isVisible() || c.getDescriptionText() == null) continue;
                c.show();
                continue;
            }
            c.hide();
        }
    }

    protected Control createHelpControl(Composite parent) {
        Link link = new Link(parent, 8);
        ++((GridLayout)parent.getLayout()).numColumns;
        link.setLayoutData((Object)new GridData(64));
        link.setText("\u6ce8\uff1aAPP\u4e91\u7aef\u6253\u5305\u4f7f\u5f97\u4f60\u4e0d\u9700\u8981\u914d\u7f6eXcode\u548cAndroid SDK,\r\n      DCloud\u90d1\u91cd\u627f\u8bfa\u4e0d\u4fdd\u7559\u4efb\u4f55\u5f00\u53d1\u8005\u8bc1\u4e66\u53ca\u5f00\u53d1\u8005\u4fe1\u606f,\r\n      \u5982\u5e0c\u671b\u67e5\u770b\u5b8c\u6574App\u529f\u80fd\u6f14\u793a\uff0c\u8bf7\u70b9\u51fb<a>Hello HTML5+</a>\r\n      \u5982\u5e0c\u671b\u67e5\u770b\u5b8c\u6574UI\u6f14\u793a\uff0c\u8bf7\u70b9\u51fb<a>Hello mui</a>");
        link.setToolTipText(IDialogConstants.HELP_LABEL);
        link.setForeground(parent.getDisplay().getSystemColor(3));
        link.setBounds(153, 344, 130, 17);
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Desktop desk = Desktop.getDesktop();
                if ("Hello HTML5+".equals(e.text)) {
                    try {
                        desk.browse(URI.create("http://www.dcloud.io/helloh5/"));
                    }
                    catch (Exception exception) {}
                } else if ("Hello mui".equals(e.text)) {
                    try {
                        desk.browse(URI.create("http://www.dcloud.io/hellomui/"));
                    }
                    catch (Exception exception) {}
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return link;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "\u6253\u5305", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public int open() {
        if (UserAuth.isLoginSucess() != 1) {
            NewUserLoginDialog window = new NewUserLoginDialog(UIUtils.getActiveShell());
            window.open();
        }
        if (UserAuth.isLoginSucess() != 1) {
            return 0;
        }
        Job[] jobs = Job.getJobManager().find((Object)this.hmobileProject);
        if (jobs != null && jobs.length > 0) {
            Job[] jobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                Job job = jobArray[n2];
                if (job instanceof MakePackageJob) {
                    ((MakePackageJob)job).showJob();
                    return 0;
                }
                ++n2;
            }
        }
        return super.open();
    }

    protected void okPressed() {
        Map infos;
        if (this.openWarningDialog("\u5ffd\u7565\u5e76\u7ee7\u7eed\u6253\u5305")) {
            return;
        }
        final boolean needConfusion = this.needConfusionButton == null ? false : this.needConfusionButton.getSelection();
        boolean iosEnable = this.iosCheckButton.getSelection();
        boolean androidEnable = this.androidCheckButton.getSelection();
        final ArrayList<PackPlatform> phoneModules = new ArrayList<PackPlatform>();
        if (iosEnable && this.iosJailbreakCheckButton.getSelection()) {
            phoneModules.add(PackPlatform.IOS_PB);
        }
        if (iosEnable && this.iosLicenseCheckButton.getSelection()) {
            phoneModules.add(PackPlatform.IOS_APPSTORE);
        }
        if (androidEnable && this.androidDcloudCertCheckButton.getSelection()) {
            phoneModules.add(PackPlatform.ANDROID_PB);
        }
        if (androidEnable && this.androidSeftCertCheckButton.getSelection()) {
            phoneModules.add(PackPlatform.ANDROID_GOOGLEPLAY);
        }
        if (androidEnable && !(infos = ManifastConfigurationVerification.verifyPermission((ManifastConfiguration)this.appConfig, (IProject)this.project, (ManifastConfigurationVerification.VerificationPlatform)ManifastConfigurationVerification.VerificationPlatform.ALL)).isEmpty()) {
            int result = new MessageDialog(null, "\u63d0\u9192", null, "\u53ef\u80fd\u7f3a\u5c11\u5fc5\u8981\u7684android\u6743\u9650\uff0c\u662f\u5426\u73b0\u5728\u6dfb\u52a0\uff1f\n\u7f3a\u5c11Android\u6743\u9650\u53ef\u80fd\u4f1a\u5bfc\u81f4\u67d0\u4e9b\u529f\u80fd\u4e0d\u53ef\u7528\uff0c\u5982\u7f3a\u5c11android.hardware.camera\u6743\u9650\u4f1a\u5bfc\u81f4\u8c03\u7528\u6444\u50cf\u5934\u5931\u8d25\u3002\n\u8bf7\u786e\u8ba4manifest\u6a21\u5757\u6743\u9650\u914d\u7f6e\u4e2d\u6807\u9ec4\u7684\u6743\u9650\u662f\u5426\u771f\u7684\u4e0d\u9700\u8981\u3002", 2, new String[]{"\u786e\u8ba4\u6ca1\u6709\u7f3a\u5c11\u6743\u9650\uff0c\u7ee7\u7eed\u6253\u5305", "\u7acb\u5373\u6dfb\u52a0\u7f3a\u5c11\u7684\u6743\u9650"}, 0).open();
            if (result == 1) {
                this.saveDialogSettings();
                this.close();
                MakePackageDialog.editWithErrorInfo(this.project, null, infos, null);
                return;
            }
            if (result == -1) {
                return;
            }
        }
        this.saveDialogSettings();
        final Shell shell = this.getShell();
        shell.setVisible(false);
        final IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        final boolean[] cancelable = new boolean[]{true};
        MakePackageJob makePackageJob = new MakePackageJob("APP\u4e91\u7aef\u6253\u5305 - " + this.project.getName() + "\u9879\u76ee"){
            private ProgressMonitorDialog progressMonitorDialog;
            {
                super($anonymous0);
                this.progressMonitorDialog = null;
            }

            public boolean belongsTo(Object family) {
                if (family instanceof HMobileProject) {
                    return family.equals(MakePackageDialog.this.hmobileProject) || MakePackageDialog.this.project.equals((Object)((HMobileProject)family).getProject());
                }
                return false;
            }

            /*
             * Unable to fully structure code
             */
            public IStatus run(IProgressMonitor monitor) {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                MakePackageDialog.access$2(MakePackageDialog.this).clear();
                                infos = new LinkedHashMap<String, String>();
                                error = new String[1];
                                monitor.beginTask(this.getName(), 110);
                                monitor.subTask("\u68c0\u67e5\u4e91\u7aef\u6253\u5305\u72b6\u6001...");
                                if (ViewPackStatusManager.cancelAppPackage((String)MakePackageDialog.this.appConfig.getAppid(), (boolean)true)) break block14;
                                this.cancel();
                                var14_4 = Status.CANCEL_STATUS;
                                reshow = new boolean[]{monitor.isCanceled() != false && cancelable[0] != false};
                                monitor.done();
                                Display.getDefault().asyncExec(new Runnable(reshow, error, infos, shell){
                                    private final /* synthetic */ boolean[] val$reshow;
                                    private final /* synthetic */ String[] val$error;
                                    private final /* synthetic */ Map val$infos;
                                    private final /* synthetic */ Shell val$shell;
                                    {
                                        this.val$reshow = blArray;
                                        this.val$error = stringArray;
                                        this.val$infos = map;
                                        this.val$shell = shell;
                                    }

                                    @Override
                                    public void run() {
                                        boolean hasError = false;
                                        boolean fReshow = this.val$reshow[0];
                                        if (this.val$error.length > 0 && this.val$error[0] != null) {
                                            hasError = true;
                                            if (!this.val$infos.isEmpty() || MakePackageDialog.this.webInfoList.isEmpty()) {
                                                for (String path : this.val$infos.keySet()) {
                                                    MakePackageDialog.this.showDescription(path, (String)this.val$infos.get(path));
                                                }
                                                fReshow = true;
                                                MessageDialog.openError((Shell)UIUtils.getActiveWorkbenchWindow().getShell(), (String)"APP\u4e91\u7aef\u6253\u5305\u5931\u8d25", (String)this.val$error[0]);
                                            } else if (!MakePackageDialog.this.webInfoList.isEmpty()) {
                                                boolean bl = fReshow = !MessageDialog.openConfirm((Shell)UIUtils.getActiveWorkbenchWindow().getShell(), (String)"APP\u4e91\u7aef\u6253\u5305\u5931\u8d25", (String)this.val$error[0]);
                                                if (!fReshow) {
                                                    HashMap<String, String> errors = new HashMap<String, String>();
                                                    errors.putAll(MakePackageDialog.this.localInfoList);
                                                    errors.putAll(MakePackageDialog.this.webInfoList);
                                                    MakePackageDialog.editWithErrorInfo((this).MakePackageDialog.this.project, errors, null, null);
                                                }
                                            }
                                        }
                                        if (fReshow && !this.val$shell.isDisposed()) {
                                            this.val$shell.setVisible(true);
                                        } else {
                                            if (!hasError && MessageDialog.openConfirm((Shell)UIUtils.getActiveWorkbenchWindow().getShell(), (String)"APP\u4e91\u7aef\u6253\u5305\u6210\u529f", (String)(String.valueOf((this).MakePackageDialog.this.project.getName()) + "\u5df2\u6210\u529f\u63d0\u4ea4\u4e91\u7aef\uff0c\u662f\u5426\u67e5\u770b\u5f53\u524d\u6253\u5305\u72b6\u6001\uff1f"))) {
                                                ViewPackStatusWizardPage.open((this).MakePackageDialog.this.project.getName());
                                            }
                                            MakePackageDialog.this.superOkPressed();
                                        }
                                    }
                                });
                                return var14_4;
                            }
                            try {
                                monitor.worked(10);
                                makePackage = new MakePackage(MakePackageDialog.this.project, MakePackageDialog.this.appConfig, phoneModules);
                                makePackage.makePackage(new Runnable(){

                                    @Override
                                    public void run() {
                                        cancelable[0] = false;
                                        try {
                                            if (progressMonitorDialog != null) {
                                                progressMonitorDialog.setCancelable(false);
                                            }
                                        }
                                        catch (Throwable e) {
                                            IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)e);
                                        }
                                    }
                                }, needConfusion, monitor);
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                                if (e.getStatus().getCode() != 1004) break block15;
                                var9_14 = codes = e.getMessage().split(";");
                                var8_15 = codes.length;
                                var7_16 = 0;
                                ** while (var7_16 < var8_15)
                            }
lbl-1000:
                            // 1 sources

                            {
                                node = code = var9_14[var7_16];
                                desc = null;
                                index = code.indexOf("|");
                                if (index > 0) {
                                    node = code.substring(0, index);
                                    desc = code.substring(index + 1, code.length());
                                }
                                if (!(node.equals("manifest.plus.distribute.apple.devices") || node.indexOf("manifest.plus.distribute.apple.") < 0 && node.indexOf("manifest.plus.distribute.google.") < 0)) {
                                    infos.put(node, desc);
                                } else {
                                    MakePackageDialog.access$2(MakePackageDialog.this).put(node, desc);
                                }
                                ++var7_16;
                                continue;
                            }
lbl44:
                            // 1 sources

                            if (!infos.isEmpty()) {
                                id = (String)infos.keySet().iterator().next();
                                error[0] = id.indexOf(".apple.") > 0 ? "IOS\u5f00\u53d1\u8005\u8bc1\u4e66\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u76f8\u5173\u4fe1\u606f" : "Google\u5f00\u53d1\u8005\u8bc1\u4e66\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u76f8\u5173\u4fe1\u606f";
                            } else if (!MakePackageDialog.access$2(MakePackageDialog.this).isEmpty()) {
                                error[0] = "App\u6253\u5305\u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u662f\u5426\u91cd\u65b0\u914d\u7f6e?";
                            }
                            MakePackageDialog.access$6(MakePackageDialog.this, 1);
                            break block16;
                        }
                        error[0] = e.getMessage();
                        if (e.getStatus().getCode() == 0) break block16;
                        MakePackageDialog.access$6(MakePackageDialog.this, 1);
                    }
                    reshow = new boolean[]{monitor.isCanceled() != false && cancelable[0] != false};
                    monitor.done();
                    Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                    break block17;
                    {
                        catch (Exception e) {
                            try {
                                ErrorDialog.openError((Shell)MakePackageDialog.this.getShell(), (String)"APP\u4e91\u7aef\u6253\u5305\u5931\u8d25", (String)"APP\u4e91\u7aef\u6253\u5305\u65f6\u51fa\u73b0\u5f02\u5e38", (IStatus)StatusUtil.newStatus((int)4, (String)e.getMessage(), (Throwable)e));
                                IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)e);
                            }
                            catch (Throwable var13_21) {
                                reshow = new boolean[]{monitor.isCanceled() != false && cancelable[0] != false};
                                monitor.done();
                                Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                throw var13_21;
                            }
                            reshow = new boolean[]{monitor.isCanceled() != false && cancelable[0] != false};
                            monitor.done();
                            Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                            break block17;
                        }
                    }
                    reshow = new boolean[]{monitor.isCanceled() != false && cancelable[0] != false};
                    monitor.done();
                    Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                }
                return Status.OK_STATUS;
            }

            @Override
            public void showJob() {
                if (progressService instanceof ProgressManager) {
                    if (this.progressMonitorDialog == null || this.progressMonitorDialog.getShell() == null) {
                        this.progressMonitorDialog = ((ProgressManager)progressService).showInDialogAndReturnDialog(MakePackageDialog.this.getShell(), (Job)this);
                    } else if (this.progressMonitorDialog.getShell() != null && !this.progressMonitorDialog.getShell().isDisposed()) {
                        this.progressMonitorDialog.getShell().forceActive();
                    }
                }
            }
        };
        makePackageJob.showJob();
        makePackageJob.schedule();
    }

    private void superOkPressed() {
        super.okPressed();
    }

    protected IDialogSettings saveDialogSettings() {
        IDialogSettings setting = this.getDialogBoundsSettings();
        if (this.needConfusionButton != null && !this.needConfusionButton.isDisposed()) {
            setting.put("NEED_CONFUSION", this.needConfusionButton.getSelection());
        }
        setting.put(IOS_CHECK, this.iosCheckButton.getSelection());
        setting.put(IPHONE_CHECK, this.iosIPhoneButton.getSelection());
        setting.put(IPAD_CHECK, this.iosIPadButton.getSelection());
        setting.put(this.getSettingKey(IOS_APPID), this.iosAppIDText.getText());
        setting.put(this.getSettingKey(IOS_PROFILE), this.iosProfileText.getText());
        setting.put(this.getSettingKey(IOS_CERTFILE), this.iosCertFileText.getText());
        setting.put(this.getSettingKey(ANDROID_PACKNAME), this.androidPackagenameText.getText());
        setting.put(this.getSettingKey(ANDROID_CERTNAME), this.androidCertNameText.getText());
        setting.put(this.getSettingKey(ANDROID_CERTFILE), this.androidCertFileText.getText());
        if (this.iosJailbreakCheckButton.getSelection()) {
            setting.put(IOS_TYPE_CHECK, (String)this.iosJailbreakCheckButton.getData("type"));
        }
        if (this.iosLicenseCheckButton.getSelection()) {
            setting.put(IOS_TYPE_CHECK, (String)this.iosLicenseCheckButton.getData("type"));
        }
        setting.put(ANDROID_CHECK, this.androidCheckButton.getSelection());
        if (this.androidDcloudCertCheckButton.getSelection()) {
            setting.put(ANDROID_TYPE_CHECK, (String)this.androidDcloudCertCheckButton.getData("type"));
        }
        if (this.androidSeftCertCheckButton.getSelection()) {
            setting.put(ANDROID_TYPE_CHECK, (String)this.androidSeftCertCheckButton.getData("type"));
        }
        return setting;
    }

    private ControlDecoration createDecorator(Text text, String message) {
        ControlDecoration controlDecoration = new ControlDecoration((Control)text, 0x1020000);
        controlDecoration.setDescriptionText(message);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        controlDecoration.setImage(fieldDecoration.getImage());
        controlDecoration.setMarginWidth(2);
        controlDecoration.hide();
        return controlDecoration;
    }

    protected Point getInitialSize() {
        Point shellSize = super.getInitialSize();
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(350), shellSize.x), Math.max(this.convertVerticalDLUsToPixels(150), shellSize.y));
    }

    static /* synthetic */ void access$6(MakePackageDialog makePackageDialog, int n) {
        makePackageDialog.setReturnCode(n);
    }

    protected abstract class MakePackageJob
    extends Job {
        public MakePackageJob(String name) {
            super(name);
        }

        public abstract void showJob();
    }
}

