/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.pack.ui.wizard;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.FileUtil;
import com.aptana.ui.util.UIUtils;
import com.google.gson.JsonSyntaxException;
import com.pandora.core.auth.UserAuth;
import com.pandora.core.httpclient.HttpClientUtils;
import com.pandora.core.httpclient.ResponseObj;
import com.pandora.core.mobile.model.ManifastConfiguration;
import com.pandora.core.mobile.verification.ManifastConfigurationVerification;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.utils.ImageUtils;
import com.pandora.core.utils.QRCodeUtils;
import com.pandora.core.utils.ResourceUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.pack.ui.PackUiActivator;
import com.pandora.ui.NewUserLoginDialog;
import java.awt.Color;
import java.awt.Desktop;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ide.IDE;

public class KuaiMaDialog
extends TrayDialog {
    private final QualifiedName TIMESTAMP_QUALIFIED = new QualifiedName("com.pandora.core", "timestamp");
    private final QualifiedName LOGO_QUALIFIED = new QualifiedName("com.pandora.core", "logo");
    private final QualifiedName SIZE_QUALIFIED = new QualifiedName("com.pandora.core", "size");
    private final QualifiedName WEIBO_QUALIFIED = new QualifiedName("com.pandora.core", "weibo");
    private final QualifiedName WECHAT_QUALIFIED = new QualifiedName("com.pandora.core", "wechat");
    private final QualifiedName ANDROID_URL_QUALIFIED = new QualifiedName("com.pandora.core", "android_url");
    private final QualifiedName IOS_URL_QUALIFIED = new QualifiedName("com.pandora.core", "ios_url");
    private final QualifiedName ANDROID_SCHEME_QUALIFIED = new QualifiedName("com.pandora.core", "android_scheme");
    private final QualifiedName IOS_SCHEME_QUALIFIED = new QualifiedName("com.pandora.core", "ios_scheme");
    private final String LOGO_ICON_PREFIX = "logo.";
    private final String WECHAT_ICON_PREFIX = "wechat.";
    private final int QR_DOTSIZE = 6;
    private final int QR_VERSION = 4;
    private final int ICON_SIZE = 60;
    private final Color qrColoe = new Color(0, 88, 36);
    private org.eclipse.swt.graphics.Color COLOR_WARN = Display.getDefault().getSystemColor(8);
    private org.eclipse.swt.graphics.Color COLOR_ERROR = Display.getDefault().getSystemColor(3);
    private org.eclipse.swt.graphics.Color COLOR_OK = Display.getDefault().getSystemColor(6);
    private int serverKuaiMaPublishStatus = -1;
    private boolean hasChangeIcon = false;
    private File logoFile;
    private File wechatFile;
    private String appid;
    private IProject project;
    private HMobileProject hMobileProject;
    private ManifastConfiguration appConfig;
    private Label appidLabel;
    private Label kuaiMaPublishStatusLabel;
    private Label kuaiMaLabel;
    private Label logoIconLabel;
    private Label wechatIconLabel;
    private Combo sizeCombo;
    private Text weiboText;
    private Text androidURLText;
    private Text iosURLText;
    private Text androidSchemeText;
    private Text iosSchemeText;

    public KuaiMaDialog(Shell parentShell, HMobileProject hMobileProject) {
        super(parentShell);
        this.hMobileProject = hMobileProject;
        this.project = hMobileProject.getProject();
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite bodyComposite = new Composite(parent, 0);
        bodyComposite.setLayoutData((Object)new GridData(1808));
        bodyComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(15, this.convertHorizontalDLUsToPixels(7), 10, 10).create());
        KuaiMaDialog.applyDialogFont((Control)bodyComposite);
        Composite linkComposite = new Composite(bodyComposite, 0);
        linkComposite.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).create());
        linkComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        Link guideLink = new Link(linkComposite, 0);
        guideLink.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        guideLink.setText("<a>\u5feb\u7801\u5236\u4f5c\u6307\u5357</a>");
        Composite contentComposite = new Composite(bodyComposite, 0);
        contentComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        contentComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(5).spacing(15, 15).create());
        this.createLabel(contentComposite, "Appid", 1);
        new Label(contentComposite, 0);
        this.appidLabel = this.createLabel(contentComposite, "appid", 2);
        this.appidLabel.setText(this.appid);
        Composite rightComposite = new Composite(contentComposite, 0);
        rightComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).span(1, 9).create());
        rightComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(30, 0, 0, 0).spacing(0, 20).create());
        int width = QRCodeUtils.getQRSize((int)4, (int)6, (int)2);
        Composite statusComposite = new Composite(rightComposite, 0);
        statusComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        statusComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        this.createLabel(statusComposite, "\u5feb\u7801\u72b6\u6001\uff1a", 1);
        this.kuaiMaPublishStatusLabel = this.createLabel(statusComposite, "\u6b63\u5728\u4ece\u4e91\u7aef\u83b7\u53d6...", 1);
        Composite kuaiMaComposite = new Composite(rightComposite, 2048);
        kuaiMaComposite.setLayout((Layout)new FillLayout());
        kuaiMaComposite.setLayoutData((Object)GridDataFactory.swtDefaults().hint(width, width).create());
        this.kuaiMaLabel = new Label(kuaiMaComposite, 0);
        this.kuaiMaLabel.setBackground(Display.getDefault().getSystemColor(1));
        Link saveKuaiMaLink = new Link(rightComposite, 0);
        saveKuaiMaLink.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).create());
        saveKuaiMaLink.setText("<a>\u4fdd\u5b58\u5230\u672c\u5730</a>");
        Label hintLabel = new Label(rightComposite, 0);
        hintLabel.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        hintLabel.setText("\u6ce8:\r\n   \u5feb\u7801\u53ea\u6709\u5728\u63d0\u4ea4\u670d\u52a1\u5668\u540e\u624d\u751f\u6548");
        this.createLabel(contentComposite, "logo", 1);
        this.logoIconLabel = this.createIconLabel(contentComposite, "logo.", true);
        this.createLabel(contentComposite, "\u5206\u8fa8\u7387", 1);
        new Label(contentComposite, 0);
        this.sizeCombo = new Combo(contentComposite, 2060);
        this.sizeCombo.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).span(2, 1).hint(200, -1).create());
        int i = 1;
        while (i <= 10) {
            this.sizeCombo.add(String.format("%d00*%d00", i, i));
            ++i;
        }
        this.sizeCombo.select(1);
        this.createLabel(contentComposite, "\u5fae\u535a\u8d26\u6237", 1);
        this.weiboText = this.createText(contentComposite);
        this.createLabel(contentComposite, "\u5fae\u4fe1\u4e8c\u7ef4\u7801", 1);
        this.wechatIconLabel = this.createIconLabel(contentComposite, "wechat.", false);
        this.createLabel(contentComposite, "Android\u539f\u751fApp\u4e0b\u8f7d\u5730\u5740", 1);
        this.androidURLText = this.createText(contentComposite);
        this.createLabel(contentComposite, "iOS\u539f\u751fApp\u4e0b\u8f7d\u5730\u5740", 1);
        this.iosURLText = this.createText(contentComposite);
        this.createLabel(contentComposite, "Android\u539f\u751fApp Scheme", 1);
        this.androidSchemeText = this.createText(contentComposite);
        this.createLabel(contentComposite, "iOS\u539f\u751fApp Scheme", 1);
        this.iosSchemeText = this.createText(contentComposite);
        guideLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Desktop.getDesktop().browse(URI.create("http://ask.dcloud.net.cn/article/492"));
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)ex);
                }
            }
        });
        saveKuaiMaLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (KuaiMaDialog.this.kuaiMaLabel.getImage() != null) {
                    FileDialog dialog = new FileDialog(KuaiMaDialog.this.getShell());
                    dialog.setFilterExtensions(new String[]{"*.png"});
                    String result = dialog.open();
                    if (StringUtil.isNotEmpty((String)result)) {
                        File savepath = new File(result);
                        savepath.getParentFile().mkdirs();
                        try {
                            File file = QRCodeUtils.createQRCodeFileByUrl((String)KuaiMaDialog.this.createKuaiMaURL(), (Plugin)PackUiActivator.getDefault(), (int)4, (int)6, (int)2, (Color)KuaiMaDialog.this.qrColoe, (Color)Color.WHITE, (File)KuaiMaDialog.this.getIconProjectPath("logo."), (int)KuaiMaDialog.this.getKuaiMaSize());
                            FileUtils.copyFile((File)file, (File)savepath);
                            MessageDialog.openInformation((Shell)KuaiMaDialog.this.getShell(), (String)"\u6210\u529f", (String)"\u4fdd\u5b58\u4e8c\u7ef4\u7801\u6210\u529f");
                        }
                        catch (Exception ex) {
                            MessageDialog.openError((Shell)KuaiMaDialog.this.getShell(), (String)"\u9519\u8bef", (String)"\u4fdd\u5b58\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25");
                            IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)ex);
                        }
                    }
                }
            }
        });
        return bodyComposite;
    }

    private Label createLabel(Composite parent, String text, int hSpan) {
        Label label = new Label(parent, 64);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().span(hSpan, 1).create());
        label.setText(text == null ? "" : text);
        return label;
    }

    private Text createText(Composite parent) {
        new Label(parent, 0);
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).span(2, 1).hint(250, -1).create());
        this.createControlDecoration((Control)text, parent);
        return text;
    }

    private Label createIconLabel(Composite parent, String iconPrefix, final boolean flushKuaiMa) {
        new Label(parent, 0);
        final Label iconLabel = new Label(parent, 0);
        iconLabel.setLayoutData((Object)GridDataFactory.swtDefaults().hint(60, 60).create());
        iconLabel.setBackground(Display.getDefault().getSystemColor(1));
        this.createControlDecoration((Control)iconLabel, parent);
        Button button = new Button(parent, 0);
        button.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 0x1000008).create());
        button.setText("\u66f4\u6362");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell());
                dialog.setFilterExtensions(new String[]{"*.png;*.jpg;*.jpeg;*.bmp"});
                String path = (String)iconLabel.getData("lastselectfile");
                if (StringUtil.isNotBlank((String)path)) {
                    dialog.setFileName(path);
                } else {
                    dialog.setFilterPath(KuaiMaDialog.this.project.getLocation().toFile().getAbsolutePath());
                }
                String result = dialog.open();
                if (StringUtil.isNotEmpty((String)result)) {
                    iconLabel.setData("lastselectfile", (Object)result);
                    File oldFile = null;
                    try {
                        if (flushKuaiMa) {
                            oldFile = KuaiMaDialog.this.logoFile;
                            KuaiMaDialog.this.logoFile = new File(result);
                            KuaiMaDialog.this.updateIcons(KuaiMaDialog.this.LOGO_QUALIFIED);
                            KuaiMaDialog.this.updateKuaiMaImage();
                        } else {
                            oldFile = KuaiMaDialog.this.wechatFile;
                            KuaiMaDialog.this.wechatFile = new File(result);
                            KuaiMaDialog.this.updateIcons(KuaiMaDialog.this.WECHAT_QUALIFIED);
                        }
                        KuaiMaDialog.this.hasChangeIcon = true;
                        KuaiMaDialog.this.validation();
                    }
                    catch (Exception exception) {
                        if (flushKuaiMa) {
                            KuaiMaDialog.this.logoFile = oldFile;
                        } else {
                            KuaiMaDialog.this.wechatFile = oldFile;
                        }
                        MessageDialog.openError((Shell)KuaiMaDialog.this.getParentShell(), (String)"\u9519\u8bef", (String)"\u6587\u4ef6\u635f\u574f\u6216\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                }
            }
        });
        return iconLabel;
    }

    private void createControlDecoration(Control control, Composite parent) {
        ControlDecoration controlDecoration = new ControlDecoration(control, 16384, parent);
        controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED").getImage());
        controlDecoration.setMarginWidth(3);
        controlDecoration.hide();
        if (control instanceof Label) {
            controlDecoration.setDescriptionText("\u8bf7\u9009\u62e9\u4e00\u4e2a\u56fe\u7247");
        } else {
            controlDecoration.setDescriptionText("\u4e0d\u80fd\u4e3a\u7a7a");
        }
        control.setData("controlDecoration", (Object)controlDecoration);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            label = "\u53d1\u5e03\u5feb\u7801";
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getShell().setText("\u53d1\u5e03\u5feb\u7801");
        this.setPublishKuaiMaEnable(false);
        this.syncKuaimaPublishStatus();
        return control;
    }

    public int open() {
        NewUserLoginDialog window;
        if (UserAuth.isLoginSucess() != 1) {
            window = new NewUserLoginDialog(UIUtils.getActiveShell());
            window.open();
        }
        if (UserAuth.isLoginSucess() != 1) {
            return 0;
        }
        IDE.saveAllEditors((IResource[])new IResource[]{this.project}, (boolean)true);
        if (UserAuth.isLoginSucess() != 1) {
            window = new NewUserLoginDialog(UIUtils.getActiveShell());
            window.open();
        }
        try {
            this.appConfig = this.hMobileProject.getAppConfigWithError();
            this.appid = this.appConfig.getAppid();
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            MessageDialog.openError((Shell)this.getParentShell(), (String)"\u9519\u8bef", (String)"manifest.json\u6587\u4ef6\u635f\u574f\uff0c\u8bf7\u68c0\u67e5\uff01");
            return 1;
        }
        return super.open();
    }

    private int getKuaiMaSize() {
        return Integer.parseInt(this.sizeCombo.getText().split("\\*")[0]);
    }

    private File getIconProjectPath(final String iconName) {
        File kuaima = this.project.getFolder("unpackage").getFolder("kuaima").getLocation().toFile();
        if (iconName != null) {
            if (iconName.endsWith(".")) {
                File[] files = kuaima.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith(iconName);
                    }
                });
                if (files != null && files.length > 0) {
                    return files[0];
                }
                return null;
            }
            return new File(kuaima, iconName);
        }
        return kuaima;
    }

    private void updateIcons(QualifiedName iconQualifiedName) throws Exception {
        if (iconQualifiedName == null || iconQualifiedName == this.LOGO_QUALIFIED) {
            if (this.logoFile == null || !this.logoFile.exists()) {
                this.logoFile = this.getIconProjectPath("logo.");
                if (this.logoFile == null || !this.logoFile.exists()) {
                    try {
                        ManifastConfigurationVerification.setDefaultValues((ManifastConfiguration)this.appConfig, (File)new File(this.project.getLocation().makeAbsolute().toFile(), "manifest.json"), (IProject)this.project, (ManifastConfigurationVerification.VerificationPlatform)ManifastConfigurationVerification.VerificationPlatform.ANDROID, (boolean)false);
                        String defaultIcon = this.appConfig.getPlus().getDistribute().getIcons().getAndroid().getHdpi();
                        this.logoFile = ResourceUtil.getAbsoluteFileFormProjectOrSystemt((IProject)this.project, (String)defaultIcon);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.logoFile != null && this.logoFile.exists()) {
                if (this.logoIconLabel.getImage() != null) {
                    this.logoIconLabel.getImage().dispose();
                }
                this.logoIconLabel.setImage(ImageUtils.scaleImage((Image)new Image(null, this.logoFile.getAbsolutePath()), (double)60.0, (double)60.0, (boolean)true));
                this.logoIconLabel.setBackground(null);
            }
        }
        if (iconQualifiedName == null || iconQualifiedName == this.WECHAT_QUALIFIED) {
            if (this.wechatFile == null || !this.wechatFile.exists()) {
                this.wechatFile = this.getIconProjectPath("wechat.");
            }
            if (this.wechatFile != null && this.wechatFile.exists()) {
                if (this.wechatIconLabel.getImage() != null) {
                    this.wechatIconLabel.getImage().dispose();
                }
                this.wechatIconLabel.setImage(ImageUtils.scaleImage((Image)new Image(null, this.wechatFile.getAbsolutePath()), (double)60.0, (double)60.0, (boolean)true));
                this.wechatIconLabel.setBackground(null);
            }
        }
    }

    private void updateKuaiMaImage() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (KuaiMaDialog.this.logoFile != null && KuaiMaDialog.this.logoFile.exists()) {
                    KuaiMaDialog.this.kuaiMaLabel.setImage(QRCodeUtils.createQRCodeByUrl((String)KuaiMaDialog.this.createKuaiMaURL(), (int)4, (int)6, (int)2, (Color)KuaiMaDialog.this.qrColoe, (Color)Color.WHITE, (File)KuaiMaDialog.this.logoFile, (int)0));
                }
            }
        });
    }

    protected int getDialogBoundsStrategy() {
        return 1;
    }

    private String createKuaiMaURL() {
        return "http://m3w.cn/s/" + this.appid + "?__streamapp";
    }

    private void setPublishKuaiMaEnable(final boolean enable) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Button button = KuaiMaDialog.this.getButton(0);
                if (button != null) {
                    button.setEnabled(enable);
                }
            }
        });
    }

    private void validation() {
        if (this.serverKuaiMaPublishStatus == -1) {
            this.setPublishKuaiMaEnable(false);
        } else if (this.serverKuaiMaPublishStatus == 0 || this.serverKuaiMaPublishStatus == 1) {
            this.setPublishKuaiMaEnable(true);
        } else if (this.serverKuaiMaPublishStatus == 2) {
            if (this.hasChangeIcon) {
                this.setPublishKuaiMaEnable(true);
            } else if (!(this.equals(this.getData(this.WEIBO_QUALIFIED), this.weiboText.getText()) && this.equals(this.getData(this.SIZE_QUALIFIED), String.valueOf(this.getKuaiMaSize())) && this.equals(this.getData(this.ANDROID_URL_QUALIFIED), this.androidURLText.getText()) && this.equals(this.getData(this.ANDROID_SCHEME_QUALIFIED), this.androidSchemeText.getText()) && this.equals(this.getData(this.IOS_URL_QUALIFIED), this.iosURLText.getText()) && this.equals(this.getData(this.IOS_SCHEME_QUALIFIED), this.iosSchemeText.getText()))) {
                this.setPublishKuaiMaStatus(this.serverKuaiMaPublishStatus == 1 ? "\u672a\u53d1\u5e03" : "\u672a\u751f\u6548", this.COLOR_WARN);
                this.setPublishKuaiMaEnable(true);
            } else {
                this.setPublishKuaiMaStatus("\u5df2\u751f\u6548", this.COLOR_OK);
                this.setPublishKuaiMaEnable(false);
            }
        } else {
            this.setPublishKuaiMaEnable(false);
        }
    }

    private boolean changeControlDecorationStatus(Control control, boolean show) {
        ControlDecoration controlDecoration = (ControlDecoration)control.getData("controlDecoration");
        if (controlDecoration != null) {
            if (show) {
                controlDecoration.show();
            } else {
                controlDecoration.hide();
            }
        }
        return show;
    }

    private boolean equals(String str, String str2) {
        if (str == str2) {
            return true;
        }
        if (StringUtil.isBlank((String)str) && StringUtil.isBlank((String)str2)) {
            return true;
        }
        return !StringUtil.isBlank((String)str) && str.equals(str2);
    }

    private void setPublishKuaiMaStatus(final String text, final org.eclipse.swt.graphics.Color color) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                KuaiMaDialog.this.kuaiMaPublishStatusLabel.setText(text);
                KuaiMaDialog.this.kuaiMaPublishStatusLabel.setToolTipText(KuaiMaDialog.this.kuaiMaPublishStatusLabel.getText());
                KuaiMaDialog.this.kuaiMaPublishStatusLabel.setForeground(color);
            }
        });
    }

    private void initDatas() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    KuaiMaDialog.this.logoIconLabel.setData("lastselectfile", (Object)KuaiMaDialog.this.getData(KuaiMaDialog.this.LOGO_QUALIFIED));
                    try {
                        String size = KuaiMaDialog.this.getData(KuaiMaDialog.this.SIZE_QUALIFIED);
                        int sizeInt = Integer.parseInt(size);
                        KuaiMaDialog.this.sizeCombo.setText(String.valueOf(sizeInt) + "*" + sizeInt);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    KuaiMaDialog.this.weiboText.setText(KuaiMaDialog.this.getData(KuaiMaDialog.this.WEIBO_QUALIFIED));
                    KuaiMaDialog.this.wechatIconLabel.setData("lastselectfile", (Object)KuaiMaDialog.this.getData(KuaiMaDialog.this.WECHAT_QUALIFIED));
                    KuaiMaDialog.this.androidURLText.setText(KuaiMaDialog.this.getData(KuaiMaDialog.this.ANDROID_URL_QUALIFIED));
                    KuaiMaDialog.this.iosURLText.setText(KuaiMaDialog.this.getData(KuaiMaDialog.this.IOS_URL_QUALIFIED));
                    KuaiMaDialog.this.androidSchemeText.setText(KuaiMaDialog.this.getData(KuaiMaDialog.this.ANDROID_SCHEME_QUALIFIED));
                    KuaiMaDialog.this.iosSchemeText.setText(KuaiMaDialog.this.getData(KuaiMaDialog.this.IOS_SCHEME_QUALIFIED));
                }
                catch (Exception exception) {}
                ModifyListener modifyListener = new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        KuaiMaDialog.this.validation();
                    }
                };
                KuaiMaDialog.this.sizeCombo.addModifyListener(modifyListener);
                KuaiMaDialog.this.weiboText.addModifyListener(modifyListener);
                KuaiMaDialog.this.androidURLText.addModifyListener(modifyListener);
                KuaiMaDialog.this.iosURLText.addModifyListener(modifyListener);
                KuaiMaDialog.this.androidSchemeText.addModifyListener(modifyListener);
                KuaiMaDialog.this.iosSchemeText.addModifyListener(modifyListener);
                try {
                    KuaiMaDialog.this.updateIcons(null);
                }
                catch (Exception exception) {}
                try {
                    KuaiMaDialog.this.updateKuaiMaImage();
                }
                catch (Exception exception) {}
                try {
                    KuaiMaDialog.this.validation();
                }
                catch (Exception exception) {}
            }
        });
    }

    private void saveData() {
        this.setData((String)this.logoIconLabel.getData("lastselectfile"), this.LOGO_QUALIFIED);
        this.setData(String.valueOf(this.getKuaiMaSize()), this.SIZE_QUALIFIED);
        this.setData(this.weiboText.getText(), this.WEIBO_QUALIFIED);
        this.setData((String)this.wechatIconLabel.getData("lastselectfile"), this.WECHAT_QUALIFIED);
        this.setData(this.androidURLText.getText(), this.ANDROID_URL_QUALIFIED);
        this.setData(this.iosURLText.getText(), this.IOS_URL_QUALIFIED);
        this.setData(this.androidSchemeText.getText(), this.ANDROID_SCHEME_QUALIFIED);
        this.setData(this.iosSchemeText.getText(), this.IOS_SCHEME_QUALIFIED);
        try {
            File newFile;
            if (this.logoFile != null && this.logoFile.exists() && !this.logoFile.equals(newFile = this.getIconProjectPath("logo." + FileUtil.getExtension((String)this.logoFile.getName())))) {
                FileUtils.copyFile((File)this.logoFile, (File)this.getIconProjectPath("logo." + FileUtil.getExtension((String)this.logoFile.getName())));
            }
            if (this.wechatFile != null && this.wechatFile.exists() && !this.wechatFile.equals(newFile = this.getIconProjectPath("wechat." + FileUtil.getExtension((String)this.wechatFile.getName())))) {
                FileUtils.copyFile((File)this.wechatFile, (File)this.getIconProjectPath("wechat." + FileUtil.getExtension((String)this.wechatFile.getName())));
            }
        }
        catch (Exception ex) {
            IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)ex);
        }
    }

    private String getData(QualifiedName name) {
        String value = null;
        try {
            value = this.project.getPersistentProperty(name);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)e);
        }
        return StringUtil.isBlank((String)value) ? "" : value;
    }

    private void setData(String value, QualifiedName name) {
        try {
            if (StringUtil.isBlank((String)value)) {
                value = null;
            }
            this.project.setPersistentProperty(name, value);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)e);
        }
    }

    private void syncKuaimaPublishStatus() {
        Display.getDefault().timerExec(200, new Runnable(){

            @Override
            public void run() {
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(KuaiMaDialog.this.getShell());
                try {
                    progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask("\u83b7\u53d6\u670d\u52a1\u5668\u4e0a\u5feb\u7801\u72b6\u6001", 4);
                            HttpClientUtils httpClientUtils = HttpClientUtils.getInstance((String)"KuaiMa!get");
                            httpClientUtils.addRequestBody("appid", KuaiMaDialog.this.appid);
                            String lastTimestamp = KuaiMaDialog.this.getData(KuaiMaDialog.this.TIMESTAMP_QUALIFIED);
                            if (StringUtil.isNotBlank((String)lastTimestamp)) {
                                httpClientUtils.addRequestBody("timestamp", lastTimestamp);
                            }
                            ResponseObj responseObj = httpClientUtils.excuteGet();
                            monitor.worked(1);
                            Thread.sleep(150L);
                            monitor.worked(1);
                            Thread.sleep(150L);
                            if (responseObj.isConnectionError()) {
                                KuaiMaDialog.this.serverKuaiMaPublishStatus = 0;
                                KuaiMaDialog.this.setPublishKuaiMaStatus("\u65e0\u6cd5\u83b7\u53d6\u5feb\u7801\u72b6\u6001", KuaiMaDialog.this.COLOR_ERROR);
                            } else if (responseObj.isOk()) {
                                JSONObject json = responseObj.getBody();
                                int ret = json.optInt("ret");
                                if (ret == 6000) {
                                    KuaiMaDialog.this.serverKuaiMaPublishStatus = 1;
                                    KuaiMaDialog.this.setPublishKuaiMaStatus("\u672a\u53d1\u5e03", KuaiMaDialog.this.COLOR_WARN);
                                } else {
                                    if (ret == 2000) {
                                        KuaiMaDialog.this.setPublishKuaiMaStatus("\u8bf7\u5148\u53d1\u5e03\u6b64\u6d41\u5e94\u7528", KuaiMaDialog.this.COLOR_ERROR);
                                        monitor.done();
                                        Display.getDefault().asyncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                MessageDialog.openError((Shell)KuaiMaDialog.this.getShell(), (String)"\u63d0\u9192", (String)"\u53ea\u6709\u53d1\u5e03\u4e3a\u6d41\u5e94\u7528\u7684App\u9879\u76ee\u624d\u53ef\u4ee5\u53d1\u5e03\u5feb\u7801\uff0c\u8bf7\u5728\u83dc\u5355\"\u53d1\u884c\"-\"\u53d1\u884c\u4e3a\u6d41\u5e94\u7528\"\u4e2d\u5c06\u6b64\u9879\u76ee\u53d1\u5e03\u4e3a\u6d41\u5e94\u7528\u5e76\u518d\u6b21\u5c1d\u8bd5\uff01");
                                                KuaiMaDialog.this.close();
                                            }
                                        });
                                        return;
                                    }
                                    if (ret == 5000) {
                                        KuaiMaDialog.this.serverKuaiMaPublishStatus = 2;
                                        KuaiMaDialog.this.setPublishKuaiMaStatus("\u5df2\u751f\u6548", KuaiMaDialog.this.COLOR_OK);
                                    } else if (ret == 1000) {
                                        KuaiMaDialog.this.serverKuaiMaPublishStatus = 2;
                                        String newTimestamp = json.optString("timestamp");
                                        if (!(newTimestamp == null || lastTimestamp != null && lastTimestamp.equals(newTimestamp))) {
                                            String wechatStr;
                                            KuaiMaDialog.this.setData(json.optString("weibo"), KuaiMaDialog.this.WEIBO_QUALIFIED);
                                            KuaiMaDialog.this.setData(json.optString("ios_url"), KuaiMaDialog.this.IOS_URL_QUALIFIED);
                                            KuaiMaDialog.this.setData(json.optString("ios_scheme"), KuaiMaDialog.this.IOS_SCHEME_QUALIFIED);
                                            KuaiMaDialog.this.setData(json.optString("android_url"), KuaiMaDialog.this.ANDROID_URL_QUALIFIED);
                                            KuaiMaDialog.this.setData(json.optString("android_scheme"), KuaiMaDialog.this.ANDROID_SCHEME_QUALIFIED);
                                            KuaiMaDialog.this.setData(json.optString("size"), KuaiMaDialog.this.SIZE_QUALIFIED);
                                            String qrStr = json.optString("logo_url");
                                            if (StringUtil.isNotBlank((String)qrStr)) {
                                                try {
                                                    KuaiMaDialog.this.logoFile = this.downloadFile("logo.", qrStr);
                                                }
                                                catch (Exception e) {
                                                    IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)e);
                                                }
                                            }
                                            if (StringUtil.isNotBlank((String)(wechatStr = json.optString("wechat_url")))) {
                                                try {
                                                    KuaiMaDialog.this.wechatFile = this.downloadFile("wechat.", wechatStr);
                                                }
                                                catch (Exception e) {
                                                    IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)e);
                                                }
                                            }
                                            if (KuaiMaDialog.this.logoFile != null && KuaiMaDialog.this.logoFile.exists() && KuaiMaDialog.this.wechatFile != null && KuaiMaDialog.this.wechatFile.exists()) {
                                                KuaiMaDialog.this.setPublishKuaiMaStatus("\u5df2\u751f\u6548", KuaiMaDialog.this.COLOR_OK);
                                                KuaiMaDialog.this.setData(newTimestamp, KuaiMaDialog.this.TIMESTAMP_QUALIFIED);
                                            } else {
                                                KuaiMaDialog.this.setPublishKuaiMaStatus("\u672a\u751f\u6548", KuaiMaDialog.this.COLOR_WARN);
                                            }
                                        } else {
                                            KuaiMaDialog.this.setPublishKuaiMaStatus("\u5df2\u751f\u6548", KuaiMaDialog.this.COLOR_OK);
                                        }
                                    } else {
                                        KuaiMaDialog.this.serverKuaiMaPublishStatus = 0;
                                        KuaiMaDialog.this.setPublishKuaiMaStatus(json.optString("desc"), KuaiMaDialog.this.COLOR_ERROR);
                                    }
                                }
                            }
                            Thread.sleep(200L);
                            monitor.worked(1);
                            KuaiMaDialog.this.initDatas();
                            Thread.sleep(200L);
                            monitor.done();
                        }

                        private File downloadFile(String logoIconPrefix, String downloadStr) throws Exception {
                            File downloadDir = KuaiMaDialog.this.getIconProjectPath(null);
                            URI qrURI = new URI(downloadStr);
                            DefaultHttpClient httpclient = new DefaultHttpClient();
                            HttpClientUtils.initConfig((DefaultHttpClient)httpclient);
                            try {
                                HttpResponse httpResponse = httpclient.execute((HttpUriRequest)new HttpGet(qrURI));
                                ResponseObj docnloadResponseObj = HttpClientUtils.downloadFile((File)downloadDir, (HttpResponse)httpResponse, (boolean)true, (String)downloadStr);
                                File downloadFile = new File(downloadDir, docnloadResponseObj.getDownloadFilename());
                                if (downloadFile.exists()) {
                                    File targetFile = new File(downloadDir, String.valueOf(logoIconPrefix) + FileUtil.getExtension((String)downloadFile.getName()));
                                    if (!downloadFile.equals(targetFile)) {
                                        FileUtils.moveFile((File)downloadFile, (File)targetFile);
                                    }
                                    return targetFile;
                                }
                            }
                            catch (Exception exception) {}
                            return null;
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }
        });
    }

    private boolean publishKuaima() {
        final Boolean[] result = new Boolean[]{false};
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
        try {
            progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask("\u53d1\u5e03\u5feb\u7801", 4);
                        final HttpClientUtils httpClientUtils = HttpClientUtils.getInstance((String)"KuaiMa!generate");
                        httpClientUtils.addRequestBody("appid", KuaiMaDialog.this.appid);
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                httpClientUtils.addRequestBody("weibo", StringUtil.trimToEmpty((String)KuaiMaDialog.this.weiboText.getText()));
                                httpClientUtils.addRequestBody("ios_url", StringUtil.trimToEmpty((String)KuaiMaDialog.this.iosURLText.getText()));
                                httpClientUtils.addRequestBody("ios_scheme", StringUtil.trimToEmpty((String)KuaiMaDialog.this.iosSchemeText.getText()));
                                httpClientUtils.addRequestBody("android_url", StringUtil.trimToEmpty((String)KuaiMaDialog.this.androidURLText.getText()));
                                httpClientUtils.addRequestBody("android_scheme", StringUtil.trimToEmpty((String)KuaiMaDialog.this.androidSchemeText.getText()));
                                httpClientUtils.addRequestBody("size", (Object)KuaiMaDialog.this.getKuaiMaSize());
                            }
                        });
                        if (KuaiMaDialog.this.wechatFile != null && KuaiMaDialog.this.wechatFile.exists()) {
                            httpClientUtils.addFileBody("wechat", KuaiMaDialog.this.wechatFile);
                        } else {
                            httpClientUtils.addRequestBody("wechat", "");
                        }
                        httpClientUtils.addFileBody("logo", KuaiMaDialog.this.logoFile);
                        Thread.sleep(200L);
                        monitor.worked(1);
                        final File[] qrFiles = new File[1];
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                File qrFile = QRCodeUtils.createQRCodeFileByUrl((String)KuaiMaDialog.this.createKuaiMaURL(), (Plugin)PackUiActivator.getDefault(), (int)4, (int)6, (int)2, (Color)KuaiMaDialog.this.qrColoe, (Color)Color.WHITE, (File)KuaiMaDialog.this.getIconProjectPath("logo."), (int)KuaiMaDialog.this.getKuaiMaSize());
                                if (qrFile == null || !qrFile.exists()) {
                                    MessageDialog.openError((Shell)KuaiMaDialog.this.getShell(), (String)"\u5feb\u7801\u53d1\u5e03", (String)"\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25");
                                } else {
                                    qrFiles[0] = qrFile;
                                }
                            }
                        });
                        Thread.sleep(200L);
                        monitor.worked(1);
                        if (qrFiles[0] != null && qrFiles[0].exists()) {
                            httpClientUtils.addFileBody("qr", qrFiles[0]);
                            final ResponseObj responseObj = httpClientUtils.excute(null, null, false, false);
                            Thread.sleep(200L);
                            monitor.worked(1);
                            if (responseObj.isConnectionError()) {
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (responseObj.getHttpErrorCode() >= 500) {
                                            MessageDialog.openError((Shell)KuaiMaDialog.this.getShell(), (String)"\u5feb\u7801\u53d1\u5e03", (String)"\u5feb\u7801\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                                        } else {
                                            MessageDialog.openError((Shell)KuaiMaDialog.this.getShell(), (String)"\u5feb\u7801\u53d1\u5e03", (String)"\u65e0\u6cd5\u8fde\u63a5\u5feb\u7801\u670d\u52a1\u5668");
                                        }
                                    }
                                });
                            } else if (responseObj.isOk()) {
                                final JSONObject json = responseObj.getBody();
                                if (json == null) {
                                    Display.getDefault().syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            MessageDialog.openError((Shell)KuaiMaDialog.this.getShell(), (String)"\u5feb\u7801\u53d1\u5e03", (String)"\u5feb\u7801\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                                        }
                                    });
                                } else {
                                    String ret = json.optString("ret");
                                    if ("1000".equals(ret)) {
                                        KuaiMaDialog.this.setPublishKuaiMaStatus("\u5df2\u751f\u6548", KuaiMaDialog.this.COLOR_OK);
                                        KuaiMaDialog.this.setData(json.optString("timestamp"), KuaiMaDialog.this.TIMESTAMP_QUALIFIED);
                                        result[0] = true;
                                        Display.getDefault().syncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                KuaiMaDialog.this.saveData();
                                            }
                                        });
                                        KuaiMaDialog.this.setPublishKuaiMaEnable(false);
                                    } else {
                                        Display.getDefault().syncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                MessageDialog.openError((Shell)KuaiMaDialog.this.getShell(), (String)"\u5feb\u7801\u53d1\u5e03", (String)("\u53d1\u5e03\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + json.optString("desc")));
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)e);
                    }
                    Thread.sleep(200L);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return result[0];
    }

    protected void okPressed() {
        boolean result = this.publishKuaima();
        if (!result) {
            return;
        }
        this.saveData();
        MessageDialog.openInformation((Shell)this.getShell(), (String)"\u5feb\u7801\u53d1\u5e03", (String)"\u53d1\u5e03\u6210\u529f");
    }
}

