/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.pack.ui.wizard;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.pandora.core.CoreActivator;
import com.pandora.core.appstream.AppStreamFileBuilder;
import com.pandora.core.log.HBLog;
import com.pandora.core.mobile.IManifestEditorShower;
import com.pandora.core.mobile.model.ManifastConfiguration;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.utils.RegistryUtils;
import com.pandora.pack.core.utils.PrimaryConfusionUtils;
import com.pandora.pack.ui.PackUiActivator;
import com.pandora.pack.ui.wizard.ConfusionDialog;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractAppDialog
extends TrayDialog {
    public static final String OPEN_IDLE_DIALOG_MSG = "\u70b9\u6b64\u9009\u62e9\u4e0d\u6253\u5305\u7684\u6587\u4ef6";
    public static final String OPEN_OPTIMIZE_URL = "\u53d1\u884c\u5305\u4f53\u79ef\u4f18\u5316\u6307\u5357";
    public static final String NEED_CONFUSION = "NEED_CONFUSION";
    private static IManifestEditorShower showManifestEditor;
    protected ManifastConfiguration appConfig;
    protected HMobileProject hmobileProject;
    protected IProject project;
    protected Button needConfusionButton;
    protected AppStreamFileBuilder appStreamFileBuilder = new AppStreamFileBuilder();
    protected String warningMsg = "\u68c0\u6d4b\u5230\u9879\u76ee\u4e0b\u5b58\u5728\u672a\u7528\u5230\u7684\u6587\u4ef6\uff0c\u4f1a\u5bfc\u81f4\u53d1\u884c\u5305\u4f53\u79ef\u8fc7\u5927\u3002<a>\u70b9\u6b64\u9009\u62e9\u4e0d\u6253\u5305\u7684\u6587\u4ef6</a>\u3002";
    protected boolean fCheckIdle = true;
    public static final String DLG_IMG_TITLE_ERROR = "dialog_message_error_image";
    public static final String DLG_IMG_TITLE_BANNER = "dialog_title_banner_image";
    public static final String INFO_MESSAGE = "INFO_MESSAGE";
    public static final String WARNING_MESSAGE = "WARNING_MESSAGE";
    private static final int H_GAP_IMAGE = 5;
    protected static final int MIN_DIALOG_WIDTH = 350;
    protected static final int MIN_DIALOG_HEIGHT = 150;
    private Label titleLabel;
    private Label titleImageLabel;
    private Label bottomFillerLabel;
    private Label leftFillerLabel;
    private RGB titleAreaRGB;
    Color titleAreaColor;
    private String message = "";
    private String errorMessage;
    private Link messageLabel;
    protected Composite workArea;
    private Label messageImageLabel;
    private Image messageImage;
    private boolean showingError = false;
    private boolean titleImageLargest = true;
    private int messageLabelHeight;
    private Image titleAreaImage;
    private int xTrim;
    private int yTrim;

    protected AbstractAppDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    protected AbstractAppDialog(Shell parentShell) {
        super(parentShell);
    }

    protected boolean openWarningDialog(String buttonName) {
        if (this.warningMsg.equals(this.getMessage())) {
            IStatus status;
            MessageDialog dialog = new MessageDialog(this.getShell(), this.getInfoMessage(), this.getParentShell().getImage(), "\u68c0\u6d4b\u5230\u9879\u76ee\u4e0b\u5b58\u5728\u672a\u7528\u5230\u7684\u6587\u4ef6\uff0c\u4f1a\u5bfc\u81f4\u53d1\u884c\u5305\u8fc7\u5927\uff0c\u662f\u5426\u914d\u7f6eunpackage\u6587\u4ef6\u6e05\u5355\u4ee5\u51cf\u5c0f\u5305\u4f53\u79ef\uff1f", 4, new String[]{buttonName, "\u914d\u7f6eunpackage\u6587\u4ef6\u6e05\u5355"}, 0);
            int result = dialog.open();
            if (result == 0) {
                return false;
            }
            if (result == 1 && (status = this.appStreamFileBuilder.prePublishCheck(this.hmobileProject, (Dialog)this)).isOK()) {
                this.fCheckIdle = true;
                this.checkIdleResources();
            }
            return true;
        }
        return false;
    }

    protected void checkIdleResources() {
        if (!this.fCheckIdle) {
            return;
        }
        if (this.appStreamFileBuilder.hasIdleResources(this.hmobileProject)) {
            this.setMessage(this.warningMsg, 2);
        } else {
            this.setMessage(this.getInfoMessage());
        }
        this.fCheckIdle = false;
    }

    protected abstract void openManifastEditor(SelectionEvent var1, String var2);

    private static IManifestEditorShower getManifestEditShower() {
        if (showManifestEditor == null) {
            try {
                List list = RegistryUtils.getEp(IManifestEditorShower.class, (String)"com.pandora.core.manifestEditorShower", (String)"shower", (String)"class");
                if (list != null && !list.isEmpty()) {
                    showManifestEditor = (IManifestEditorShower)list.get(0);
                }
            }
            catch (Exception e) {
                HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
            }
        }
        return showManifestEditor;
    }

    public static final void editWithErrorInfo(IProject project, Map<String, String> errorMap, Map<String, String> permissionInfosMap, String pageId) {
        try {
            AbstractAppDialog.getManifestEditShower().showManifestEditor(project, errorMap, permissionInfosMap, pageId);
        }
        catch (Exception e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
        }
    }

    protected abstract String getDialogSettingsName();

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PackUiActivator.getDefault().getDialogSettings();
        IDialogSettings fDialogSettings = settings.getSection(this.getDialogSettingsName());
        if (fDialogSettings == null) {
            fDialogSettings = settings.addNewSection(this.getDialogSettingsName());
        }
        return fDialogSettings;
    }

    protected int getDialogBoundsStrategy() {
        return 1;
    }

    protected IDialogSettings init() {
        IDialogSettings setting = this.getDialogBoundsSettings();
        AbstractAppDialog.initConfusionButtonSelect(this.needConfusionButton, setting, this.hmobileProject);
        return setting;
    }

    public static void addConfusionButtonListenter(final Button confusionButton, final Link confusionLink, final IDialogSettings setting, final HMobileProject hmobileProject) {
        if (hmobileProject == null) {
            return;
        }
        if (confusionButton != null && !confusionButton.isDisposed()) {
            confusionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (confusionButton.getSelection()) {
                        MessageDialog.openWarning((Shell)confusionButton.getShell(), (String)"\u63d0\u9192", (String)"\u6d4b\u8bd5\u529f\u80fd\uff0c\u52a0\u5bc6\u540e\u7684\u6587\u4ef6\u65e0\u6cd5\u8fd0\u884c\u5728Android4.0\uff08\u4e0d\u542b4.0\uff09\u4ee5\u4e0b\u8bbe\u5907\u4e0a\uff01");
                        if (PrimaryConfusionUtils.getConfusionFiles((HMobileProject)hmobileProject).isEmpty()) {
                            ConfusionDialog confusionDialog = new ConfusionDialog(confusionButton.getShell(), hmobileProject);
                            confusionDialog.open();
                            if (PrimaryConfusionUtils.getConfusionFiles((HMobileProject)hmobileProject).isEmpty()) {
                                confusionButton.setSelection(false);
                            }
                        }
                    }
                    if (setting != null) {
                        setting.put(AbstractAppDialog.NEED_CONFUSION, confusionButton.getSelection());
                    }
                }
            });
        }
        if (confusionLink != null && !confusionLink.isDisposed()) {
            confusionLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConfusionDialog confusionDialog = new ConfusionDialog(confusionLink.getShell(), hmobileProject);
                    confusionDialog.open();
                    if (confusionButton != null && !confusionButton.isDisposed() && PrimaryConfusionUtils.getConfusionFiles((HMobileProject)hmobileProject).isEmpty()) {
                        confusionButton.setSelection(false);
                    }
                }
            });
        }
    }

    public static void initConfusionButtonSelect(Button confusionButton, IDialogSettings setting, HMobileProject hmobileProject) {
        if (hmobileProject == null || confusionButton == null || confusionButton.isDisposed()) {
            return;
        }
        confusionButton.setSelection(false);
        if (!PrimaryConfusionUtils.needConfusionFeature()) {
            return;
        }
        if (setting.getBoolean(NEED_CONFUSION) && !PrimaryConfusionUtils.getConfusionFiles((HMobileProject)hmobileProject).isEmpty()) {
            confusionButton.setSelection(true);
        }
    }

    protected Control superCreateContents(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(1808));
        this.initializeDialogUnits((Control)contents);
        FormLayout layout = new FormLayout();
        contents.setLayout((Layout)layout);
        this.workArea = new Composite(contents, 0);
        GridLayout childLayout = new GridLayout();
        childLayout.marginHeight = 0;
        childLayout.marginWidth = 0;
        childLayout.verticalSpacing = 0;
        this.workArea.setLayout((Layout)childLayout);
        Control top = this.createTitleArea(contents);
        this.resetWorkAreaAttachments(top);
        this.workArea.setFont(JFaceResources.getDialogFont());
        this.initializeDialogUnits((Control)this.workArea);
        this.dialogArea = this.createDialogArea(this.workArea);
        this.buttonBar = this.createButtonBar(this.workArea);
        this.getShell().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                AbstractAppDialog.this.layoutForNewMessage(true);
            }
        });
        return contents;
    }

    protected Control superCreateDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label titleBarSeparator = new Label(composite, 258);
        titleBarSeparator.setLayoutData((Object)new GridData(768));
        return composite;
    }

    protected Control createTitleArea(Composite parent) {
        Color foreground;
        Color background;
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AbstractAppDialog.this.titleAreaColor != null) {
                    AbstractAppDialog.this.titleAreaColor.dispose();
                }
            }
        });
        Display display = parent.getDisplay();
        if (this.titleAreaRGB != null) {
            background = this.titleAreaColor = new Color((Device)display, this.titleAreaRGB);
            foreground = null;
        } else {
            background = JFaceColors.getBannerBackground((Display)display);
            foreground = JFaceColors.getBannerForeground((Display)display);
        }
        parent.setBackground(background);
        int verticalSpacing = this.convertVerticalDLUsToPixels(4);
        int horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.titleImageLabel = new Label(parent, 0x1000000);
        this.titleImageLabel.setBackground(background);
        if (this.titleAreaImage == null) {
            this.titleImageLabel.setImage(JFaceResources.getImage((String)DLG_IMG_TITLE_BANNER));
        } else {
            this.titleImageLabel.setImage(this.titleAreaImage);
        }
        FormData imageData = new FormData();
        imageData.top = new FormAttachment(0, 0);
        imageData.right = new FormAttachment(100, 0);
        this.titleImageLabel.setLayoutData((Object)imageData);
        this.titleLabel = new Label(parent, 16384);
        JFaceColors.setColors((Control)this.titleLabel, (Color)foreground, (Color)background);
        this.titleLabel.setFont(JFaceResources.getBannerFont());
        this.titleLabel.setText(" ");
        FormData titleData = new FormData();
        titleData.top = new FormAttachment(0, verticalSpacing);
        titleData.right = new FormAttachment((Control)this.titleImageLabel);
        titleData.left = new FormAttachment(0, horizontalSpacing);
        this.titleLabel.setLayoutData((Object)titleData);
        this.messageImageLabel = new Label(parent, 0x1000000);
        this.messageImageLabel.setBackground(background);
        this.messageLabel = new Link(parent, 72);
        JFaceColors.setColors((Control)this.messageLabel, (Color)foreground, (Color)background);
        this.messageLabel.setText(" \n ");
        this.messageLabel.setFont(JFaceResources.getDialogFont());
        this.messageLabel.addSelectionListener((SelectionListener)new OpenEditorSelectionListener());
        this.messageLabelHeight = this.messageLabel.computeSize((int)-1, (int)-1).y;
        this.leftFillerLabel = new Label(parent, 0x1000000);
        this.leftFillerLabel.setBackground(background);
        this.bottomFillerLabel = new Label(parent, 0x1000000);
        this.bottomFillerLabel.setBackground(background);
        this.setLayoutsForNormalMessage(verticalSpacing, horizontalSpacing);
        this.determineTitleImageLargest();
        if (this.titleImageLargest) {
            return this.titleImageLabel;
        }
        return this.messageLabel;
    }

    private void determineTitleImageLargest() {
        int titleY = this.titleImageLabel.computeSize((int)-1, (int)-1).y;
        int verticalSpacing = this.convertVerticalDLUsToPixels(4);
        int labelY = this.titleLabel.computeSize((int)-1, (int)-1).y;
        labelY += verticalSpacing;
        labelY += this.messageLabelHeight;
        this.titleImageLargest = titleY > (labelY += verticalSpacing);
    }

    private void setLayoutsForNormalMessage(int verticalSpacing, int horizontalSpacing) {
        FormData messageImageData = new FormData();
        messageImageData.top = new FormAttachment((Control)this.titleLabel, verticalSpacing);
        messageImageData.left = new FormAttachment(0, 5);
        this.messageImageLabel.setLayoutData((Object)messageImageData);
        FormData messageLabelData = new FormData();
        messageLabelData.top = new FormAttachment((Control)this.titleLabel, verticalSpacing);
        messageLabelData.right = new FormAttachment((Control)this.titleImageLabel);
        messageLabelData.left = new FormAttachment((Control)this.messageImageLabel, horizontalSpacing);
        messageLabelData.height = this.messageLabelHeight;
        if (this.titleImageLargest) {
            messageLabelData.bottom = new FormAttachment((Control)this.titleImageLabel, 0, 1024);
        }
        this.messageLabel.setLayoutData((Object)messageLabelData);
        FormData fillerData = new FormData();
        fillerData.left = new FormAttachment(0, horizontalSpacing);
        fillerData.top = new FormAttachment((Control)this.messageImageLabel, 0);
        fillerData.bottom = new FormAttachment((Control)this.messageLabel, 0, 1024);
        this.bottomFillerLabel.setLayoutData((Object)fillerData);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.messageImageLabel, 0, 128);
        data.left = new FormAttachment(0, 0);
        data.bottom = new FormAttachment((Control)this.messageImageLabel, 0, 1024);
        data.right = new FormAttachment((Control)this.messageImageLabel, 0);
        this.leftFillerLabel.setLayoutData((Object)data);
    }

    protected Composite getTitleArea() {
        return this.getShell();
    }

    protected Label getTitleImageLabel() {
        return this.titleImageLabel;
    }

    public void setErrorMessage(String newErrorMessage) {
        if (this.errorMessage == null ? newErrorMessage == null : this.errorMessage.equals(newErrorMessage)) {
            return;
        }
        this.errorMessage = newErrorMessage;
        if (this.errorMessage == null) {
            if (this.showingError) {
                this.showingError = false;
            }
            if (this.message == null) {
                this.message = "";
            }
            this.updateMessage(this.message);
            this.messageImageLabel.setImage(this.messageImage);
            this.setImageLabelVisible(this.messageImage != null);
        } else {
            String displayedErrorMessage = " " + this.errorMessage;
            this.updateMessage(displayedErrorMessage);
            if (!this.showingError) {
                this.showingError = true;
                this.messageImageLabel.setImage(JFaceResources.getImage((String)DLG_IMG_TITLE_ERROR));
                this.setImageLabelVisible(true);
            }
        }
        this.layoutForNewMessage(false);
        Button ok = this.getButton(0);
        if (ok != null) {
            ok.setEnabled(StringUtil.isBlank((String)this.getErrorMessage()));
        }
    }

    protected void layoutForNewMessage(boolean forceLayout) {
        boolean messageLabelClipped;
        int verticalSpacing = this.convertVerticalDLUsToPixels(4);
        int horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        if (this.errorMessage == null && this.messageImage == null) {
            this.setImageLabelVisible(false);
            this.setLayoutsForNormalMessage(verticalSpacing, horizontalSpacing);
        } else {
            this.messageImageLabel.setVisible(true);
            this.bottomFillerLabel.setVisible(true);
            this.leftFillerLabel.setVisible(true);
            FormData data = new FormData();
            data.left = new FormAttachment(0, 5);
            data.top = new FormAttachment((Control)this.titleLabel, verticalSpacing);
            this.messageImageLabel.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)this.messageImageLabel, 0);
            data.left = new FormAttachment(0, 0);
            data.bottom = new FormAttachment((Control)this.messageLabel, 0, 1024);
            data.right = new FormAttachment((Control)this.messageImageLabel, 0, 131072);
            this.bottomFillerLabel.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)this.messageImageLabel, 0, 128);
            data.left = new FormAttachment(0, 0);
            data.bottom = new FormAttachment((Control)this.messageImageLabel, 0, 1024);
            data.right = new FormAttachment((Control)this.messageImageLabel, 0);
            this.leftFillerLabel.setLayoutData((Object)data);
            FormData messageLabelData = new FormData();
            messageLabelData.top = new FormAttachment((Control)this.titleLabel, verticalSpacing);
            messageLabelData.right = new FormAttachment((Control)this.titleImageLabel);
            messageLabelData.left = new FormAttachment((Control)this.messageImageLabel, 0);
            messageLabelData.height = this.messageLabelHeight;
            if (this.titleImageLargest) {
                messageLabelData.bottom = new FormAttachment((Control)this.titleImageLabel, 0, 1024);
            }
            this.messageLabel.setLayoutData((Object)messageLabelData);
        }
        if (forceLayout) {
            this.getShell().layout();
        } else if (this.dialogArea != null) {
            this.workArea.getParent().layout(true);
        }
        int messageLabelUnclippedHeight = this.messageLabel.computeSize((int)(this.messageLabel.getSize().x - this.xTrim), (int)-1, (boolean)true).y;
        boolean bl = messageLabelClipped = messageLabelUnclippedHeight > this.messageLabel.getSize().y - this.yTrim;
        if (this.messageLabel.getData() instanceof ToolTip) {
            ToolTip toolTip = (ToolTip)this.messageLabel.getData();
            toolTip.hide();
            toolTip.deactivate();
            this.messageLabel.setData(null);
        }
        if (messageLabelClipped) {
            ToolTip tooltip = new ToolTip((Control)this.messageLabel, 2, false){

                protected Composite createToolTipContentArea(Event event, Composite parent) {
                    Composite result = new Composite(parent, 0);
                    result.setBackground(parent.getDisplay().getSystemColor(29));
                    result.setLayout((Layout)new GridLayout());
                    Text text = new Text(result, 64);
                    text.setBackground(parent.getDisplay().getSystemColor(29));
                    text.setForeground(parent.getDisplay().getSystemColor(28));
                    text.setText(AbstractAppDialog.this.messageLabel.getText());
                    GridData gridData = new GridData();
                    gridData.widthHint = ((AbstractAppDialog)AbstractAppDialog.this).messageLabel.getSize().x;
                    text.setLayoutData((Object)gridData);
                    Dialog.applyDialogFont((Control)result);
                    return result;
                }

                public Point getLocation(Point tipSize, Event event) {
                    return AbstractAppDialog.this.messageLabel.getShell().toDisplay(AbstractAppDialog.this.messageLabel.getLocation());
                }
            };
            this.messageLabel.setData((Object)tooltip);
            tooltip.setPopupDelay(0);
            tooltip.activate();
        }
    }

    protected abstract String getInfoMessage();

    public void setMessage(String newMessage) {
        this.setMessage(newMessage, 0);
    }

    public void setMessage(String newMessage, int newType) {
        Image newImage = null;
        if (newMessage != null) {
            switch (newType) {
                case 0: {
                    break;
                }
                case 1: {
                    newImage = JFaceResources.getImage((String)"dialog_messasge_info_image");
                    break;
                }
                case 2: {
                    newImage = JFaceResources.getImage((String)"dialog_messasge_warning_image");
                    break;
                }
                case 3: {
                    newImage = JFaceResources.getImage((String)DLG_IMG_TITLE_ERROR);
                }
            }
        }
        this.showMessage(newMessage, newImage);
    }

    private void showMessage(String newMessage, Image newImage) {
        if (newMessage == null) {
            newMessage = "";
        }
        if (this.message.equals(newMessage) && this.messageImage == newImage) {
            return;
        }
        this.message = newMessage;
        String shownMessage = newImage == null ? this.message : " " + this.message;
        this.messageImage = newImage;
        if (!this.showingError) {
            this.updateMessage(shownMessage);
            this.messageImageLabel.setImage(this.messageImage);
            this.setImageLabelVisible(this.messageImage != null);
            this.layoutForNewMessage(false);
        }
    }

    private void updateMessage(String newMessage) {
        this.messageLabel.setText(newMessage);
    }

    public void setTitle(String newTitle) {
        if (this.titleLabel == null) {
            return;
        }
        String title = newTitle;
        if (title == null) {
            title = "";
        }
        this.titleLabel.setText(title);
    }

    public void setTitleAreaColor(RGB color) {
        this.titleAreaRGB = color;
    }

    public void setTitleImage(Image newTitleImage) {
        this.titleAreaImage = newTitleImage;
        if (this.titleImageLabel != null) {
            this.titleImageLabel.setImage(newTitleImage);
            this.determineTitleImageLargest();
            Object top = this.titleImageLargest ? this.titleImageLabel : this.messageLabel;
            this.resetWorkAreaAttachments((Control)top);
        }
    }

    private void setImageLabelVisible(boolean visible) {
        this.messageImageLabel.setVisible(visible);
        this.bottomFillerLabel.setVisible(visible);
        this.leftFillerLabel.setVisible(visible);
    }

    protected void resetWorkAreaAttachments(Control top) {
        FormData childData = new FormData();
        childData.top = new FormAttachment(top);
        childData.right = new FormAttachment(100, 0);
        childData.left = new FormAttachment(0, 0);
        childData.bottom = new FormAttachment(100, 0);
        this.workArea.setLayoutData((Object)childData);
    }

    public String getMessage() {
        return this.message;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static class FileListener
    extends SelectionAdapter {
        private Text file;
        private String filterExtensions;

        public FileListener(Text file, String filterExtensions) {
            this.file = file;
            this.filterExtensions = filterExtensions;
        }

        public void widgetSelected(SelectionEvent e) {
            String result;
            FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell());
            dialog.setFilterExtensions(new String[]{this.filterExtensions});
            String path = this.file.getText();
            if (StringUtil.isNotBlank((String)path) && new File(path).exists()) {
                dialog.setFileName(path);
            }
            if (StringUtil.isNotEmpty((String)(result = dialog.open()))) {
                this.file.setText(result);
            }
        }
    }

    protected class OpenEditorSelectionListener
    implements SelectionListener {
        protected OpenEditorSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (AbstractAppDialog.OPEN_IDLE_DIALOG_MSG.equals(e.text)) {
                IStatus status = AbstractAppDialog.this.appStreamFileBuilder.prePublishCheck(AbstractAppDialog.this.hmobileProject, (Dialog)AbstractAppDialog.this);
                if (status.isOK()) {
                    AbstractAppDialog.this.fCheckIdle = true;
                    AbstractAppDialog.this.checkIdleResources();
                }
            } else if (AbstractAppDialog.OPEN_OPTIMIZE_URL.equals(e.text)) {
                try {
                    Desktop.getDesktop().browse(URI.create("http://ask.dcloud.net.cn/article/491"));
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)ex);
                }
            } else {
                AbstractAppDialog.this.openManifastEditor(e, null);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

