/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.pack.ui.handlers;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.core.projects.templates.TemplateType;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.projects.ProjectsPlugin;
import com.aptana.ui.epl.UIEplPlugin;
import com.aptana.ui.properties.EplMessages;
import com.pandora.core.auth.UserAuth;
import com.pandora.projects.service.ProjectService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.progress.UIJob;

public class TOMobileHandler
extends AbstractHandler {
    protected ProjectService service = new ProjectService();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object obj;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null && selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IProject) {
            final IProject fProject = (IProject)obj;
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        IProjectDescription description = fProject.getDescription();
                        LinkedHashSet<String> natureIds = new LinkedHashSet<String>();
                        natureIds.add("com.pandora.projects.ui.MKeyNature");
                        natureIds.add("com.aptana.projects.webnature");
                        natureIds.addAll(Arrays.asList(description.getNatureIds()));
                        description.setNatureIds(natureIds.toArray(new String[natureIds.size()]));
                        fProject.setDescription(description, monitor);
                        try {
                            monitor.setTaskName("\u751f\u6210manifest.json\u6587\u4ef6...");
                            TOMobileHandler.this.createManifestResource(fProject, monitor);
                            fProject.refreshLocal(1, monitor);
                        }
                        catch (Exception e) {
                            IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
                    }
                }
            };
            try {
                new ProgressMonitorJobsDialog(HandlerUtil.getActiveShell((ExecutionEvent)event)).run(true, true, runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                IdeLog.logError((Plugin)UIEplPlugin.getDefault(), (String)EplMessages.ProjectNaturesPage_ERR_SetNatures, (Throwable)e);
                return false;
            }
        }
        return null;
    }

    protected void resetProject(final ExecutionEvent event, final IProject fProject) {
        IRunnableWithProgress close = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                UIJob job = new UIJob("\u6b63\u5728\u8f6c\u6362\u9879\u76ee..."){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        IShellProvider shellProvider = new IShellProvider(){

                            public Shell getShell() {
                                return HandlerUtil.getActiveShell((ExecutionEvent)event);
                            }
                        };
                        CloseResourceAction closeAction = new CloseResourceAction(shellProvider);
                        closeAction.selectionChanged((IStructuredSelection)new StructuredSelection(new Object[]{fProject}));
                        closeAction.run();
                        OpenResourceAction openAction = new OpenResourceAction(shellProvider);
                        openAction.selectionChanged((IStructuredSelection)new StructuredSelection(new Object[]{fProject}));
                        openAction.run();
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
                try {
                    job.join();
                }
                catch (InterruptedException interruptedException) {}
                monitor.done();
            }
        };
        try {
            new ProgressMonitorJobsDialog(HandlerUtil.getActiveShell((ExecutionEvent)event)).run(true, true, close);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            IdeLog.logError((Plugin)UIEplPlugin.getDefault(), (String)EplMessages.ProjectNaturesPage_ERR_CloseProject, (Throwable)e);
        }
    }

    protected void createManifestResource(IProject fProject, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        IFile file = fProject.getFile("manifest.json");
        if (file.exists()) {
            return;
        }
        List templates = ProjectsPlugin.getDefault().getTemplatesManager().getTemplates(new TemplateType[]{TemplateType.APP});
        if (CollectionsUtil.isNotEmpty((Collection)templates)) {
            for (IProjectTemplate tpl : templates) {
                if (!"com.pandora.templates.ui.templateInfo.default".equals(tpl.getId())) continue;
                String path = tpl.getPath();
                ZipInputStream zis = null;
                StringBuilder sb = new StringBuilder();
                try {
                    zis = new ZipInputStream(new FileInputStream(path));
                    ZipEntry entry = null;
                    while ((entry = zis.getNextEntry()) != null) {
                        if (!"manifest.json".equals(entry.getName())) continue;
                        byte[] cache = new byte[1024];
                        int len = -1;
                        while ((len = zis.read(cache)) > 0) {
                            sb.append(new String(cache, 0, len));
                        }
                        break;
                    }
                }
                finally {
                    if (zis != null) {
                        zis.close();
                    }
                }
                if (sb.length() == 0) {
                    return;
                }
                String appid = "nologin";
                if (UserAuth.isLoginSucess() == 1) {
                    appid = this.service.applyProject(fProject.getName());
                }
                String content = sb.toString();
                content = content.replace("\"id\": \"default\"", "\"id\": \"" + (appid.equals("nologin") ? "" : appid) + "\"");
                content = content.replace("\"name\": \"default\"", "\"name\": \"" + fProject.getName() + "\"");
                File configFile = fProject.getFile("manifest.json").getLocation().makeAbsolute().toFile();
                FileUtils.write((File)configFile, (CharSequence)content);
                break;
            }
        }
    }
}

