/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.pack.ui.handlers;

import com.aptana.core.logging.IdeLog;
import com.pandora.core.project.HMobileConvertor;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.utils.ProjectUtils;
import com.pandora.pack.ui.PackUiActivator;
import com.pandora.pack.ui.wizard.MakePackageDialog;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class MakePackageHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            HMobileProject hMobileProject = MakePackageHandler.getCurrentProject(event);
            if (hMobileProject != null) {
                Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
                if (shell == null) {
                    shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                }
                MakePackageDialog dialog = new MakePackageDialog(shell, hMobileProject);
                dialog.open();
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)e);
        }
        return null;
    }

    public static HMobileProject getCurrentProject(ExecutionEvent event) {
        IProject project = null;
        try {
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (selection instanceof IStructuredSelection && !((IStructuredSelection)selection).isEmpty()) {
                Object object = ((IStructuredSelection)selection).getFirstElement();
                if (object instanceof IResource) {
                    project = ((IResource)object).getProject();
                }
            } else {
                IFile file;
                IEditorInput input;
                IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
                if (part != null && (input = part.getEditorInput()) != null && (file = (IFile)input.getAdapter(IFile.class)) != null) {
                    project = file.getProject();
                }
            }
            if (project == null) {
                project = ProjectUtils.getCurrentProject();
            }
            if (project != null && project.hasNature("com.pandora.projects.ui.MKeyNature")) {
                return HMobileConvertor.convert((IProject)project);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)e);
        }
        return null;
    }
}

