/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.pack.ui;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.util.UIUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pandora.core.auth.UserAuth;
import com.pandora.core.mobile.model.ManifastConfiguration;
import com.pandora.core.mobile.verification.ManifastConfigurationVerification;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.utils.ZipUtils;
import com.pandora.pack.core.MakePackage;
import com.pandora.pack.core.PackActivator;
import com.pandora.pack.core.utils.ExploreFile;
import com.pandora.pack.core.utils.PrimaryConfusionUtils;
import com.pandora.pack.ui.PackUiActivator;
import com.pandora.pack.ui.wizard.AbstractAppDialog;
import com.pandora.ui.NewUserLoginDialog;
import java.awt.Desktop;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class ExportWGTDialog
extends Dialog {
    private static final String EXTEND = ".wgt";
    private Text exportDirText;
    private Label warnLabel;
    private HMobileProject project;
    private ManifastConfiguration config;
    private boolean isExportWgt = true;
    private Image image;
    protected Button needConfusionButton;

    public ExportWGTDialog(Shell parentShell, HMobileProject project, ExecutionEvent event) {
        super(parentShell);
        this.project = project;
        if (project != null) {
            this.config = project.getAppConfig();
        }
        try {
            String cId;
            if (event != null && event.getCommand() != null && StringUtil.isNotBlank((String)(cId = event.getCommand().getId())) && !cId.contains("exportwgt")) {
                this.isExportWgt = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!this.isExportWgt) {
            this.image = PackUiActivator.getImage("icons/help.png");
        }
    }

    protected Control createDialogArea(Composite parent) {
        if (this.isExportWgt) {
            parent.getShell().setText("\u5236\u4f5c\u79fb\u52a8App\u8d44\u6e90\u5347\u7ea7\u5305");
        } else {
            parent.getShell().setText("\u751f\u6210\u672c\u5730\u6253\u5305App\u8d44\u6e90");
        }
        Composite container = new Composite(parent, 0);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String text = e.text;
                if (StringUtil.isBlank((String)text)) {
                    return;
                }
                text = text.toLowerCase();
                String url = "";
                if (text.contains("app")) {
                    url = "http://ask.dcloud.net.cn/article/182";
                } else if (text.contains("ios")) {
                    url = "http://ask.dcloud.net.cn/article/41";
                } else if (text.contains("android")) {
                    url = "http://ask.dcloud.net.cn/article/38";
                }
                if (StringUtil.isNotBlank((String)url)) {
                    try {
                        Desktop.getDesktop().browse(URI.create(url));
                    }
                    catch (Exception ex) {
                        IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)ex);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        int numColumns = 2;
        if (this.isExportWgt) {
            container.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(10, 10, 20, 0).numColumns(numColumns).create());
            Label showLabel = new Label(container, 64);
            showLabel.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
            showLabel.setText("\u79fb\u52a8App\u8d44\u6e90\u5347\u7ea7\u65e0\u9700\u6253\u5305\u751f\u6210apk/ipa\uff0c\u76f4\u63a5\u514d\u5b89\u88c5\u66f4\u65b0App\u8d44\u6e90\uff0c\u8be6\u60c5\u53c2\u8003\uff1a");
            Link showLabel1 = new Link(container, 0);
            showLabel1.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
            showLabel1.setText("<a>App\u8d44\u6e90\u5728\u7ebf\u5347\u7ea7</a>");
            showLabel1.addSelectionListener(listener);
        } else {
            numColumns = 3;
            container.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(10, 25, 20, 0).numColumns(numColumns).create());
            Label icon = new Label(container, 0);
            icon.setLayoutData((Object)GridDataFactory.swtDefaults().create());
            icon.setImage(this.image);
            String m1 = "\u5982\u4f55\u8fdb\u884c\u672c\u5730\u6253\u5305\uff1f";
            Label showLabel1 = new Label(container, 0);
            showLabel1.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
            showLabel1.setText(m1);
            new Label(container, 0).setLayoutData((Object)GridDataFactory.swtDefaults().create());
            Link l1 = new Link(container, 64);
            l1.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
            l1.setText("<a>Android\u672c\u5730\u6253\u5305\u6307\u5357</a>");
            l1.addSelectionListener(listener);
            new Label(container, 0).setLayoutData((Object)GridDataFactory.swtDefaults().create());
            Link l2 = new Link(container, 64);
            l2.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
            l2.setText("<a>iOS\u672c\u5730\u6253\u5305\u6307\u5357</a>");
            l2.addSelectionListener(listener);
            icon = new Label(container, 0);
            icon.setLayoutData((Object)GridDataFactory.swtDefaults().create());
            icon.setImage(this.image);
            String m2 = "\u4e3a\u4f55\u8981\u751f\u6210\u672c\u5730\u6253\u5305App\u8d44\u6e90\uff1f";
            Label showLabel3 = new Label(container, 0);
            showLabel3.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
            showLabel3.setText(m2);
            new Label(container, 0).setLayoutData((Object)GridDataFactory.swtDefaults().create());
            String m3 = "1\u3001\u8f6c\u6362\u672c\u5730\u6253\u5305App\u8def\u5f84\uff1a\u672c\u5730\u6253\u5305\u662f\u6709\u76ee\u5f55\u89c4\u8303\u7684\uff0c\u9700\u8981\u8f6c\u6362\u6210/%APPID%/www/\u76ee\u5f55\u4e0b\u653e\u7f6e\u5e94\u7528\u8d44\u6e90 ";
            Link showLabel4 = new Link(container, 64);
            showLabel4.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).hint(450, -1).create());
            showLabel4.setText(m3);
            showLabel4.addSelectionListener(listener);
            new Label(container, 0).setLayoutData((Object)GridDataFactory.swtDefaults().create());
            m3 = "2\u3001\u5220\u9664\u4e91\u7aef\u6253\u5305\u914d\u7f6e\u4fe1\u606f\uff1a\u4e91\u7aef\u6253\u5305\u7684\u56fe\u6807\u3001splash\u3001\u7b2c\u4e09\u65b9SDK\u914d\u7f6e\u4fe1\u606f";
            showLabel4 = new Link(container, 64);
            showLabel4.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).hint(450, -1).create());
            showLabel4.setText(m3);
            showLabel4.addSelectionListener(listener);
            new Label(container, 0).setLayoutData((Object)GridDataFactory.swtDefaults().create());
            m3 = "3\u3001\u5220\u9664manifest.json\u7684\u6ce8\u91ca\u4fe1\u606f\uff1a\u5728iOS\u5e73\u53f0manifest.json\u4e0d\u652f\u6301\u9ed8\u8ba4\u751f\u6210\u7684\u6ce8\u91ca\u4fe1\u606f\uff0c\u4f1a\u5bfc\u81f4\u65e0\u6cd5\u8fdb\u5165\u5e94\u7528";
            showLabel4 = new Link(container, 64);
            showLabel4.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).hint(450, -1).create());
            showLabel4.setText(m3);
            showLabel4.addSelectionListener(listener);
            new Label(container, 0).setLayoutData((Object)GridDataFactory.swtDefaults().create());
        }
        this.exportDirText = new Text(container, 2048);
        this.exportDirText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        String defaultEwPath = "";
        try {
            if (this.isExportWgt) {
                defaultEwPath = PackUiActivator.getDefault().getPreferenceStore().getString(this.config.getAppid());
                if (StringUtil.isBlank((String)defaultEwPath)) {
                    File f = ExploreFile.getDownloadPathFile((String)this.project.getProject().getName(), null);
                    defaultEwPath = String.valueOf(f.getAbsolutePath()) + File.separator + this.config.getAppid() + EXTEND;
                }
            } else {
                defaultEwPath = PackUiActivator.getDefault().getPreferenceStore().getString(String.valueOf(this.config.getAppid()) + "_codedir");
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.exportDirText.setText(defaultEwPath);
        this.exportDirText.setFocus();
        this.exportDirText.setSelection(defaultEwPath.length());
        this.exportDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String dir = ExportWGTDialog.this.exportDirText.getText();
                String errorMessage = "\u8bf7\u8f93\u5165\u5408\u6cd5\u7684\u76ee\u5f55\u8def\u5f84\uff01";
                try {
                    File dirFile = new File(dir);
                    if (!dirFile.isAbsolute()) {
                        ExportWGTDialog.this.warnLabel.setText(errorMessage);
                        ExportWGTDialog.this.getButton(0).setEnabled(false);
                        return;
                    }
                    ArrayList<String> roots = new ArrayList<String>();
                    File[] fileArray = File.listRoots();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File root = fileArray[n2];
                        roots.add(root.getAbsolutePath());
                        ++n2;
                    }
                    boolean isRightRoot = false;
                    for (String root : roots) {
                        if (!dir.replace("/", File.separator).startsWith(root)) continue;
                        isRightRoot = true;
                        break;
                    }
                    if (!isRightRoot) {
                        ExportWGTDialog.this.warnLabel.setText(errorMessage);
                        ExportWGTDialog.this.getButton(0).setEnabled(false);
                        return;
                    }
                    if (ExportWGTDialog.this.isExportWgt && !dir.trim().toLowerCase().endsWith(ExportWGTDialog.EXTEND)) {
                        ExportWGTDialog.this.warnLabel.setText("\u751f\u6210\u7684\u6587\u4ef6\u540d\u5fc5\u987b\u4e3a.wgt\u683c\u5f0f\uff01");
                        ExportWGTDialog.this.getButton(0).setEnabled(false);
                        return;
                    }
                    ExportWGTDialog.this.warnLabel.setText("");
                    ExportWGTDialog.this.getButton(0).setEnabled(true);
                }
                catch (Exception exception) {
                    ExportWGTDialog.this.warnLabel.setText(errorMessage);
                    ExportWGTDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        final Button fileButton = new Button(container, 0);
        fileButton.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        fileButton.setText("\u6d4f\u89c8(&B)...");
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(fileButton.getShell());
                dialog.setText("\u9009\u62e9\u76ee\u5f55");
                dialog.setMessage("\u9009\u62e9\u76ee\u5f55");
                String result = dialog.open();
                if (StringUtil.isNotEmpty((String)result)) {
                    if (ExportWGTDialog.this.config != null) {
                        if (ExportWGTDialog.this.isExportWgt) {
                            ExportWGTDialog.this.exportDirText.setText(String.valueOf(result) + File.separator + ExportWGTDialog.this.config.getAppid() + ExportWGTDialog.EXTEND);
                        } else {
                            ExportWGTDialog.this.exportDirText.setText(String.valueOf(result) + File.separator + ExportWGTDialog.this.config.getAppid() + File.separator + "www");
                        }
                    } else {
                        ExportWGTDialog.this.exportDirText.setText(result);
                    }
                }
            }
        });
        if (PrimaryConfusionUtils.needConfusionFeature()) {
            if (!this.isExportWgt) {
                new Label(container, 0).setLayoutData((Object)GridDataFactory.swtDefaults().create());
            }
            Composite confusionButtonComposite = new Composite(container, 0);
            confusionButtonComposite.setLayoutData((Object)GridDataFactory.swtDefaults().create());
            confusionButtonComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
            this.needConfusionButton = new Button(confusionButtonComposite, 32);
            this.needConfusionButton.setLayoutData((Object)GridDataFactory.swtDefaults().create());
            this.needConfusionButton.setText("\u542f\u7528\u4e91\u7aefjs\u539f\u751f\u6df7\u6dc6");
            this.needConfusionButton.setToolTipText("\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668\u8fdb\u884cjs\u539f\u751f\u6df7\u6dc6");
            Link confusioninLink = new Link(confusionButtonComposite, 0);
            confusioninLink.setLayoutData((Object)GridDataFactory.swtDefaults().create());
            confusioninLink.setText("<a>js\u539f\u751f\u6df7\u6dc6\u914d\u7f6e</a>");
            AbstractAppDialog.addConfusionButtonListenter(this.needConfusionButton, confusioninLink, this.getDialogBoundsSettings(), this.project);
        }
        this.warnLabel = new Label(container, 0);
        this.warnLabel.setLayoutData((Object)GridDataFactory.fillDefaults().span(numColumns, 1).create());
        this.warnLabel.setForeground(SWTResourceManager.getColor(3));
        this.warnLabel.setText("");
        this.exportDirText.forceFocus();
        this.init();
        return container;
    }

    private void init() {
        IDialogSettings setting = this.getDialogBoundsSettings();
        AbstractAppDialog.initConfusionButtonSelect(this.needConfusionButton, setting, this.project);
    }

    protected void okPressed() {
        File exportCodeDirFile;
        boolean needConfusion;
        this.getButton(0).setEnabled(false);
        if (this.project == null && !this.warnLabel.isDisposed()) {
            this.warnLabel.setText("\u8bf7\u9009\u62e9\u79fb\u52a8App\u9879\u76ee\uff01");
            this.getButton(0).setEnabled(true);
            return;
        }
        String exportCodeDir = this.exportDirText.getText();
        if (StringUtil.isBlank((String)(exportCodeDir = exportCodeDir.trim()))) {
            if (!this.warnLabel.isDisposed()) {
                this.warnLabel.setText("\u5bfc\u51fa\u76ee\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            this.getButton(0).setEnabled(true);
            return;
        }
        if (this.isExportWgt && !exportCodeDir.toLowerCase().endsWith(EXTEND)) {
            if (!this.warnLabel.isDisposed()) {
                this.warnLabel.setText("\u751f\u6210wgt\u5305\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5fc5\u987b\u4e3a.wgt\u683c\u5f0f\uff01");
            }
            this.getButton(0).setEnabled(true);
            return;
        }
        boolean bl = needConfusion = this.needConfusionButton == null ? false : this.needConfusionButton.getSelection();
        if (needConfusion && UserAuth.isLoginSucess() != 1) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    NewUserLoginDialog window = new NewUserLoginDialog(UIUtils.getActiveShell());
                    window.open();
                }
            });
            if (UserAuth.isLoginSucess() != 1) {
                this.getButton(0).setEnabled(true);
                return;
            }
        }
        if ((exportCodeDirFile = new File(exportCodeDir)).exists()) {
            boolean b;
            String message = "\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6\uff1f";
            if (!this.isExportWgt) {
                message = "\u6587\u4ef6\u5939\u5df2\u7ecf\u5b58\u5728\uff0c\u662f\u5426\u5220\u9664\u5e76\u91cd\u65b0\u751f\u6210\uff1f";
            }
            if (!(b = MessageDialog.openConfirm((Shell)this.getShell(), (String)"\u63d0\u793a", (String)(String.valueOf(exportCodeDirFile.getName()) + message)))) {
                this.getButton(0).setEnabled(true);
                return;
            }
            FileUtils.deleteQuietly((File)exportCodeDirFile);
        }
        if (this.isExportWgt) {
            if (!exportCodeDirFile.getParentFile().exists() || !exportCodeDirFile.getParentFile().isDirectory()) {
                exportCodeDirFile.getParentFile().mkdirs();
            }
        } else if (!exportCodeDirFile.exists() || !exportCodeDirFile.isDirectory()) {
            exportCodeDirFile.mkdirs();
        }
        try {
            File tempAppidDir;
            File tempDir;
            File eFile;
            block43: {
                IEclipsePreferences prefs;
                if (needConfusion && UserAuth.isLoginSucess() != 1) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            NewUserLoginDialog window = new NewUserLoginDialog(UIUtils.getActiveShell());
                            window.open();
                        }
                    });
                    if (UserAuth.isLoginSucess() != 1) {
                        this.getButton(0).setEnabled(true);
                        return;
                    }
                }
                MakePackage makePackage = new MakePackage(this.project.getProject(), this.config, null);
                eFile = null;
                if (this.isExportWgt) {
                    try {
                        prefs = EclipseUtil.instanceScope().getNode("com.pandora.pack.ui");
                        prefs.put(this.config.getAppid(), exportCodeDir);
                        prefs.flush();
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)e);
                    }
                } else {
                    try {
                        prefs = EclipseUtil.instanceScope().getNode("com.pandora.pack.ui");
                        prefs.put(String.valueOf(this.config.getAppid()) + "_codedir", exportCodeDir);
                        prefs.flush();
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)PackUiActivator.getDefault(), (Throwable)e);
                    }
                }
                tempDir = null;
                try {
                    tempDir = PackActivator.getDefault().getBundle().getDataFile(".export");
                    tempAppidDir = new File(tempDir, this.project.getAppid());
                    if (tempAppidDir.exists()) {
                        try {
                            FileUtils.deleteDirectory((File)tempAppidDir);
                        }
                        catch (Exception exception) {}
                    }
                    tempAppidDir.mkdirs();
                    File projectDir = new File(this.project.getProject().getLocationURI());
                    JsonObject appConfigJson = ManifastConfigurationVerification.setDefaultValues((ManifastConfiguration)this.config, (File)new File(projectDir, "manifest.json"), (IProject)this.project.getProject(), (ManifastConfigurationVerification.VerificationPlatform)ManifastConfigurationVerification.VerificationPlatform.ALL, (boolean)true);
                    eFile = makePackage.copyPackAgeResources(false, projectDir, tempAppidDir, appConfigJson);
                    if (appConfigJson.has("plus")) {
                        appConfigJson.getAsJsonObject("plus").remove("distribute");
                    }
                    Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                    String configJson = gson.toJson((JsonElement)appConfigJson);
                    FileUtils.write((File)new File(tempAppidDir, "manifest.json"), (CharSequence)configJson, (String)"utf-8");
                    if (!needConfusion) break block43;
                    ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
                    final Boolean[] result = new Boolean[]{false};
                    progressMonitorDialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            block2: {
                                try {
                                    PrimaryConfusionUtils.sent2CloudForConfusion((HMobileProject)ExportWGTDialog.this.project, (File)tempAppidDir, (IProgressMonitor)monitor);
                                    result[0] = !monitor.isCanceled();
                                }
                                catch (CoreException e) {
                                    if (ExportWGTDialog.this.warnLabel.isDisposed()) break block2;
                                    ExportWGTDialog.this.warnLabel.setText("\u751f\u6210\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
                                }
                            }
                        }
                    });
                    if (result[0].booleanValue()) break block43;
                    this.getButton(0).setEnabled(true);
                }
                catch (Throwable throwable) {
                    try {
                        FileUtils.deleteDirectory((File)tempDir);
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    FileUtils.deleteDirectory((File)tempDir);
                }
                catch (Exception exception) {}
                return;
            }
            if (this.isExportWgt) {
                ZipUtils.zip((String)tempAppidDir.getAbsolutePath(), (String)exportCodeDirFile.getAbsolutePath());
            } else {
                FileUtils.copyDirectory((File)tempAppidDir, (File)exportCodeDirFile);
            }
            try {
                FileUtils.deleteDirectory((File)tempDir);
            }
            catch (Exception exception) {}
            if (eFile != null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"\u63d0\u793a", (String)(this.isExportWgt ? "\u5236\u4f5c\u6210\u529f\uff01" : "\u751f\u6210\u6210\u529f\uff01"));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (!this.warnLabel.isDisposed()) {
                this.warnLabel.setText("\u9879\u76ee\u4e2d\u6587\u4ef6\u540d\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\uff0c\u8bf7\u786e\u8ba4!");
            }
            this.getButton(0).setEnabled(true);
            return;
        }
        catch (Exception e) {
            if (!this.warnLabel.isDisposed()) {
                this.warnLabel.setText("\u751f\u6210\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            }
            this.getButton(0).setEnabled(true);
            return;
        }
        super.okPressed();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String name;
        IDialogSettings settings = PackUiActivator.getDefault().getDialogSettings();
        IDialogSettings fDialogSettings = settings.getSection(name = this.isExportWgt ? "ExportWgtDialog" : "ExportLDDialog");
        if (fDialogSettings == null) {
            fDialogSettings = settings.addNewSection(name);
        }
        return fDialogSettings;
    }
}

